/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BitExpression;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;

final class BitAndExpression
extends BitExpression {
    BitAndExpression(int n, Expression expression, Expression expression2) {
        super((byte)21, n, expression, expression2);
    }

    Expression foldExpression() {
        Expression expression = this.leftOperand;
        Expression expression2 = this.rightOperand;
        if (expression.kind == 2 && expression2.kind == 2) {
            switch (expression.getType().typeClass) {
                case 2: {
                    return new BooleanConstantExpression(this.pos, ((BooleanConstantExpression)expression).bval & ((BooleanConstantExpression)expression2).bval);
                }
                case 4: {
                    return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)expression).getIntConstValue() & ((ConstantExpression)expression2).getIntConstValue());
                }
                case 8: {
                    return new LongConstantExpression(this.pos, ((LongConstantExpression)expression).lval & ((LongConstantExpression)expression2).lval);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.generateByteCode(byteCodeGenerator, (byte)126, (byte)127);
    }

    public String toString() {
        return "&";
    }
}

