/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class BooleanConstantExpression
extends ConstantExpression {
    boolean bval;

    BooleanConstantExpression(int n, boolean bl) {
        super(n, TypeSymbol.booleanSymbol);
        this.bval = bl;
    }

    boolean isConstantBooleanExpression() {
        return true;
    }

    boolean getConstantBooleanExpressionValue() {
        return this.bval;
    }

    Expression copyConstantExpression() {
        return new BooleanConstantExpression(this.pos, this.bval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.generate_8(this.bval ? (byte)4 : 3);
        byteCodeGenerator.incOpStackHeight(1);
    }
}

