/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

abstract class BoxingExpression
extends UnaryExpression {
    TypeSymbol toType;
    static final /* synthetic */ boolean $assertionsDisabled;

    BoxingExpression(byte by, Expression expression, TypeSymbol typeSymbol) {
        super(by, expression.pos, expression);
        this.toType = typeSymbol;
        this.setType(typeSymbol);
    }

    static TypeSymbol getPrimitiveType(Parser parser, TypeSymbol typeSymbol) {
        if (typeSymbol.isTypeParameter()) {
            return null;
        }
        if (typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
            return TypeSymbol.booleanSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangByteSymbol)) {
            return TypeSymbol.byteSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangCharacterSymbol)) {
            return TypeSymbol.charSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangShortSymbol)) {
            return TypeSymbol.shortSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangIntegerSymbol)) {
            return TypeSymbol.intSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangLongSymbol)) {
            return TypeSymbol.longSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangFloatSymbol)) {
            return TypeSymbol.floatSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangDoubleSymbol)) {
            return TypeSymbol.doubleSymbol;
        }
        if (typeSymbol.equalTo(parser.javaLangNumberSymbol) || typeSymbol.equalTo(parser.javaLangObjectSymbol)) {
            return typeSymbol;
        }
        return null;
    }

    static TypeSymbol getBoxedType(Parser parser, TypeSymbol typeSymbol) {
        switch (typeSymbol.typeKind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 2: {
                return parser.javaLangBooleanSymbol;
            }
            case 3: {
                return parser.javaLangByteSymbol;
            }
            case 4: {
                return parser.javaLangCharacterSymbol;
            }
            case 5: {
                return parser.javaLangShortSymbol;
            }
            case 6: {
                return parser.javaLangIntegerSymbol;
            }
            case 7: {
                return parser.javaLangLongSymbol;
            }
            case 8: {
                return parser.javaLangFloatSymbol;
            }
            case 9: 
        }
        return parser.javaLangDoubleSymbol;
    }

    static {
        $assertionsDisabled = !BoxingExpression.class.desiredAssertionStatus();
    }
}

