/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CodeGenerator;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.EnumMapClassSymbol;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Fixup;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;

final class ByteCodeGenerator
extends CodeGenerator {
    static final byte opc_nop = 0;
    static final byte opc_aconst_null = 1;
    static final byte opc_iconst_m1 = 2;
    static final byte opc_iconst_0 = 3;
    static final byte opc_iconst_1 = 4;
    static final byte opc_iconst_2 = 5;
    static final byte opc_iconst_3 = 6;
    static final byte opc_iconst_4 = 7;
    static final byte opc_iconst_5 = 8;
    static final byte opc_lconst_0 = 9;
    static final byte opc_lconst_1 = 10;
    static final byte opc_fconst_0 = 11;
    static final byte opc_fconst_1 = 12;
    static final byte opc_fconst_2 = 13;
    static final byte opc_dconst_0 = 14;
    static final byte opc_dconst_1 = 15;
    static final byte opc_bipush = 16;
    static final byte opc_sipush = 17;
    static final byte opc_ldc = 18;
    static final byte opc_ldc_w = 19;
    static final byte opc_ldc2_w = 20;
    static final byte opc_iload = 21;
    static final byte opc_lload = 22;
    static final byte opc_fload = 23;
    static final byte opc_dload = 24;
    static final byte opc_aload = 25;
    static final byte opc_iload_0 = 26;
    static final byte opc_iload_1 = 27;
    static final byte opc_iload_2 = 28;
    static final byte opc_iload_3 = 29;
    static final byte opc_lload_0 = 30;
    static final byte opc_lload_1 = 31;
    static final byte opc_lload_2 = 32;
    static final byte opc_lload_3 = 33;
    static final byte opc_fload_0 = 34;
    static final byte opc_fload_1 = 35;
    static final byte opc_fload_2 = 36;
    static final byte opc_fload_3 = 37;
    static final byte opc_dload_0 = 38;
    static final byte opc_dload_1 = 39;
    static final byte opc_dload_2 = 40;
    static final byte opc_dload_3 = 41;
    static final byte opc_aload_0 = 42;
    static final byte opc_aload_1 = 43;
    static final byte opc_aload_2 = 44;
    static final byte opc_aload_3 = 45;
    static final byte opc_iaload = 46;
    static final byte opc_laload = 47;
    static final byte opc_faload = 48;
    static final byte opc_daload = 49;
    static final byte opc_aaload = 50;
    static final byte opc_baload = 51;
    static final byte opc_caload = 52;
    static final byte opc_saload = 53;
    static final byte opc_istore = 54;
    static final byte opc_lstore = 55;
    static final byte opc_fstore = 56;
    static final byte opc_dstore = 57;
    static final byte opc_astore = 58;
    static final byte opc_istore_0 = 59;
    static final byte opc_istore_1 = 60;
    static final byte opc_istore_2 = 61;
    static final byte opc_istore_3 = 62;
    static final byte opc_lstore_0 = 63;
    static final byte opc_lstore_1 = 64;
    static final byte opc_lstore_2 = 65;
    static final byte opc_lstore_3 = 66;
    static final byte opc_fstore_0 = 67;
    static final byte opc_fstore_1 = 68;
    static final byte opc_fstore_2 = 69;
    static final byte opc_fstore_3 = 70;
    static final byte opc_dstore_0 = 71;
    static final byte opc_dstore_1 = 72;
    static final byte opc_dstore_2 = 73;
    static final byte opc_dstore_3 = 74;
    static final byte opc_astore_0 = 75;
    static final byte opc_astore_1 = 76;
    static final byte opc_astore_2 = 77;
    static final byte opc_astore_3 = 78;
    static final byte opc_iastore = 79;
    static final byte opc_lastore = 80;
    static final byte opc_fastore = 81;
    static final byte opc_dastore = 82;
    static final byte opc_aastore = 83;
    static final byte opc_bastore = 84;
    static final byte opc_castore = 85;
    static final byte opc_sastore = 86;
    static final byte opc_pop = 87;
    static final byte opc_pop2 = 88;
    static final byte opc_dup = 89;
    static final byte opc_dup_x1 = 90;
    static final byte opc_dup_x2 = 91;
    static final byte opc_dup2 = 92;
    static final byte opc_dup2_x1 = 93;
    static final byte opc_dup2_x2 = 94;
    static final byte opc_swap = 95;
    static final byte opc_iadd = 96;
    static final byte opc_ladd = 97;
    static final byte opc_fadd = 98;
    static final byte opc_dadd = 99;
    static final byte opc_isub = 100;
    static final byte opc_lsub = 101;
    static final byte opc_fsub = 102;
    static final byte opc_dsub = 103;
    static final byte opc_imul = 104;
    static final byte opc_lmul = 105;
    static final byte opc_fmul = 106;
    static final byte opc_dmul = 107;
    static final byte opc_idiv = 108;
    static final byte opc_ldiv = 109;
    static final byte opc_fdiv = 110;
    static final byte opc_ddiv = 111;
    static final byte opc_irem = 112;
    static final byte opc_lrem = 113;
    static final byte opc_frem = 114;
    static final byte opc_drem = 115;
    static final byte opc_ineg = 116;
    static final byte opc_lneg = 117;
    static final byte opc_fneg = 118;
    static final byte opc_dneg = 119;
    static final byte opc_ishl = 120;
    static final byte opc_lshl = 121;
    static final byte opc_ishr = 122;
    static final byte opc_lshr = 123;
    static final byte opc_iushr = 124;
    static final byte opc_lushr = 125;
    static final byte opc_iand = 126;
    static final byte opc_land = 127;
    static final byte opc_ior = -128;
    static final byte opc_lor = -127;
    static final byte opc_ixor = -126;
    static final byte opc_lxor = -125;
    static final byte opc_iinc = -124;
    static final byte opc_i2l = -123;
    static final byte opc_i2f = -122;
    static final byte opc_i2d = -121;
    static final byte opc_l2i = -120;
    static final byte opc_l2f = -119;
    static final byte opc_l2d = -118;
    static final byte opc_f2i = -117;
    static final byte opc_f2l = -116;
    static final byte opc_f2d = -115;
    static final byte opc_d2i = -114;
    static final byte opc_d2l = -113;
    static final byte opc_d2f = -112;
    static final byte opc_i2b = -111;
    static final byte opc_i2c = -110;
    static final byte opc_i2s = -109;
    static final byte opc_lcmp = -108;
    static final byte opc_fcmpl = -107;
    static final byte opc_fcmpg = -106;
    static final byte opc_dcmpl = -105;
    static final byte opc_dcmpg = -104;
    static final byte opc_ifeq = -103;
    static final byte opc_ifne = -102;
    static final byte opc_iflt = -101;
    static final byte opc_ifge = -100;
    static final byte opc_ifgt = -99;
    static final byte opc_ifle = -98;
    static final byte opc_if_icmpeq = -97;
    static final byte opc_if_icmpne = -96;
    static final byte opc_if_icmplt = -95;
    static final byte opc_if_icmpge = -94;
    static final byte opc_if_icmpgt = -93;
    static final byte opc_if_icmple = -92;
    static final byte opc_if_acmpeq = -91;
    static final byte opc_if_acmpne = -90;
    static final byte opc_goto = -89;
    static final byte opc_jsr = -88;
    static final byte opc_ret = -87;
    static final byte opc_tableswitch = -86;
    static final byte opc_lookupswitch = -85;
    static final byte opc_ireturn = -84;
    static final byte opc_lreturn = -83;
    static final byte opc_freturn = -82;
    static final byte opc_dreturn = -81;
    static final byte opc_areturn = -80;
    static final byte opc_return = -79;
    static final byte opc_getstatic = -78;
    static final byte opc_putstatic = -77;
    static final byte opc_getfield = -76;
    static final byte opc_putfield = -75;
    static final byte opc_invokevirtual = -74;
    static final byte opc_invokespecial = -73;
    static final byte opc_invokestatic = -72;
    static final byte opc_invokeinterface = -71;
    static final byte opc_new = -69;
    static final byte opc_newarray = -68;
    static final byte opc_anewarray = -67;
    static final byte opc_arraylength = -66;
    static final byte opc_athrow = -65;
    static final byte opc_checkcast = -64;
    static final byte opc_instanceof = -63;
    static final byte opc_monitorenter = -62;
    static final byte opc_monitorexit = -61;
    static final byte opc_wide = -60;
    static final byte opc_multianewarray = -59;
    static final byte opc_ifnull = -58;
    static final byte opc_ifnonnull = -57;
    static final byte opc_goto_w = -56;
    static final byte opc_jsr_w = -55;
    static final int INITIAL_CODE_BUFFER_SIZE = 4096;
    private static final byte[] short_load_opcode;
    private static final byte[] load_opcode;
    private static final byte[] short_store_opcode;
    private static final byte[] store_opcode;
    Parser parser;
    ConstantPool constantPool;
    MethodSymbol methodSymbol;
    private byte[] codeBuffer;
    private int codeBufferStartOffset;
    private int codeBufferIndex;
    private int prevLineOffset;
    private int prevLine;
    short lineNumberCount;
    byte[] lineNumberTable;
    private int opStackHeight;
    private int maxOpStackHeight;
    short assertionLoaderStartPC;
    Fixup fixupList;
    boolean wideFlag;
    boolean doingStringConcatonation;
    static final /* synthetic */ boolean $assertionsDisabled;

    ByteCodeGenerator(Parser parser, MethodSymbol methodSymbol) {
        this.parser = parser;
        this.constantPool = methodSymbol.definingClass.cd.ccd.constantPool;
        this.methodSymbol = methodSymbol;
        int n = methodSymbol.cmd.estimatedLineCount;
        if (n > 0) {
            this.lineNumberTable = new byte[n * 4];
        }
        this.prevLineOffset = -1;
        this.codeBuffer = new byte[4096];
    }

    byte[] flushCodeBuffer(boolean bl) {
        MethodSymbol methodSymbol = this.methodSymbol;
        int n = this.codeBufferStartOffset;
        int n2 = this.codeBufferIndex;
        int n3 = n + n2;
        byte[] byArray = new byte[n3];
        if (n != 0) {
            System.arraycopy(methodSymbol.cmd.codeBuffer, 0, byArray, 0, n);
        }
        System.arraycopy(this.codeBuffer, 0, byArray, n, n2);
        methodSymbol.cmd.codeBuffer = byArray;
        this.codeBufferStartOffset = n + n2;
        this.codeBufferIndex = 0;
        if (this.codeBufferStartOffset >= 65534) {
            this.parser.error(Message.errorCodeSegmentTooLarge, methodSymbol.pos, false, methodSymbol.errorName());
            this.codeBufferStartOffset = 0;
        } else if (bl && this.codeBuffer.length < 32768) {
            this.codeBuffer = new byte[this.codeBuffer.length * 2];
        }
        return this.codeBuffer;
    }

    private void generateFixup(boolean bl, Label label) {
        int n = this.codeBufferIndex;
        Fixup fixup = new Fixup(bl, label, this.codeBufferStartOffset + n);
        if ((n += bl ? 4 : 2) > this.codeBuffer.length) {
            this.flushCodeBuffer(true);
            n = bl ? 4 : 2;
        }
        this.codeBufferIndex = n;
        fixup.next = this.fixupList;
        this.fixupList = fixup;
    }

    void setOpStackHeight(int n) {
        this.opStackHeight = n;
        if (this.opStackHeight > this.maxOpStackHeight) {
            this.maxOpStackHeight = this.opStackHeight;
        }
    }

    int getOpStackHeight() {
        return this.opStackHeight;
    }

    void incOpStackHeight(int n) {
        this.opStackHeight += n;
        if (this.opStackHeight > this.maxOpStackHeight) {
            this.maxOpStackHeight = this.opStackHeight;
        }
    }

    void decOpStackHeight(int n) {
        this.opStackHeight -= n;
        if (!$assertionsDisabled && this.opStackHeight < 0) {
            throw new AssertionError();
        }
    }

    void generateTableFixup(short s, Label label) {
        int n = this.codeBufferIndex;
        int n2 = this.codeBufferStartOffset + n;
        Fixup fixup = new Fixup(true, label, n2);
        fixup.baseAdjustment = (short)(n2 - s);
        if ((n += 4) > this.codeBuffer.length) {
            this.flushCodeBuffer(true);
            n = 4;
        }
        this.codeBufferIndex = n;
        fixup.next = this.fixupList;
        this.fixupList = fixup;
    }

    void setLabel(Label label) {
        label.offset = this.codeBufferStartOffset + this.codeBufferIndex;
    }

    void generate_8(byte by) {
        int n = this.codeBufferIndex;
        try {
            this.codeBuffer[n] = by;
            this.codeBufferIndex = n + 1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.flushCodeBuffer(true);
            this.codeBuffer[0] = by;
            this.codeBufferIndex = 1;
        }
    }

    void generate_8_8(byte by, byte by2) {
        int n = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n + 1] = by2;
            byArray[n] = by;
            this.codeBufferIndex = n + 2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[1] = by2;
            byArray[0] = by;
            this.codeBufferIndex = 2;
        }
    }

    void generate_8_8_8(byte by, byte by2, byte by3) {
        int n = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n + 2] = by3;
            byArray[n + 1] = by2;
            byArray[n] = by;
            this.codeBufferIndex = n + 3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[2] = by3;
            byArray[1] = by2;
            byArray[0] = by;
            this.codeBufferIndex = 3;
        }
    }

    void generate_8_16(byte by, short s) {
        int n = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n + 2] = (byte)s;
            byArray[n + 1] = (byte)(s >> 8);
            byArray[n] = by;
            this.codeBufferIndex = n + 3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[2] = (byte)s;
            byArray[1] = (byte)(s >> 8);
            byArray[0] = by;
            this.codeBufferIndex = 3;
        }
    }

    void generate_8_8_16(byte by, byte by2, short s) {
        int n = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n + 3] = (byte)s;
            byArray[n + 2] = (byte)(s >> 8);
            byArray[n + 1] = by2;
            byArray[n] = by;
            this.codeBufferIndex = n + 4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[3] = (byte)s;
            byArray[2] = (byte)(s >> 8);
            byArray[1] = by2;
            byArray[0] = by;
            this.codeBufferIndex = 4;
        }
    }

    void generate_16_16(short s, short s2) {
        int n = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n + 3] = (byte)s2;
            byArray[n + 2] = (byte)(s2 >> 8);
            byArray[n + 1] = (byte)s;
            byArray[n] = (byte)(s >> 8);
            this.codeBufferIndex = n + 4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[3] = (byte)s2;
            byArray[2] = (byte)(s2 >> 8);
            byArray[1] = (byte)s;
            byArray[0] = (byte)(s >> 8);
            this.codeBufferIndex = 4;
        }
    }

    void generate_8_16_8(byte by, short s, byte by2) {
        int n = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n + 3] = by2;
            byArray[n + 2] = (byte)s;
            byArray[n + 1] = (byte)(s >> 8);
            byArray[n] = by;
            this.codeBufferIndex = n + 4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[3] = by2;
            byArray[2] = (byte)s;
            byArray[1] = (byte)(s >> 8);
            byArray[0] = by;
            this.codeBufferIndex = 4;
        }
    }

    void generate_32(int n) {
        int n2 = this.codeBufferIndex;
        byte[] byArray = this.codeBuffer;
        try {
            byArray[n2 + 3] = (byte)n;
            byArray[n2 + 2] = (byte)(n >> 8);
            byArray[n2 + 1] = (byte)(n >> 16);
            byArray[n2] = (byte)(n >> 24);
            this.codeBufferIndex = n2 + 4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byArray = this.flushCodeBuffer(true);
            byArray[3] = (byte)n;
            byArray[2] = (byte)(n >> 8);
            byArray[1] = (byte)(n >> 16);
            byArray[0] = (byte)(n >> 24);
            this.codeBufferIndex = 4;
        }
    }

    void generateIntConst(int n) {
        switch (n) {
            default: {
                if (-128 <= n && n <= 127) {
                    this.generate_8_8((byte)16, (byte)n);
                    break;
                }
                if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                    this.generate_8_16((byte)17, (short)n);
                    break;
                }
                short s = this.constantPool.enterConstantPoolInteger(n);
                if ((s & 0xFF00) != 0) {
                    this.generate_8_16((byte)19, s);
                    break;
                }
                this.generate_8_8((byte)18, (byte)s);
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.generate_8((byte)(3 + n));
            }
        }
    }

    void generateStringConst(char[] cArray) {
        short s = this.constantPool.enterConstantPoolString(cArray);
        if ((s & 0xFF00) != 0) {
            this.generate_8_16((byte)19, s);
        } else {
            this.generate_8_8((byte)18, (byte)s);
        }
    }

    void generateWideningPrimitiveConversion(byte by, byte by2) {
        switch (by) {
            default: {
                break;
            }
            case 4: {
                switch (by2) {
                    case 8: {
                        this.generate_8((byte)-123);
                        this.incOpStackHeight(1);
                        break;
                    }
                    case 16: {
                        this.generate_8((byte)-122);
                        break;
                    }
                    case 32: {
                        this.generate_8((byte)-121);
                        this.incOpStackHeight(1);
                    }
                }
                break;
            }
            case 8: {
                switch (by2) {
                    case 16: {
                        this.generate_8((byte)-119);
                        this.decOpStackHeight(1);
                        break;
                    }
                    case 32: {
                        this.generate_8((byte)-118);
                    }
                }
                break;
            }
            case 16: {
                if (by2 != 32) break;
                this.generate_8((byte)-115);
                this.incOpStackHeight(1);
            }
        }
    }

    void generateNarrowingPrimitiveConversion(byte by, byte by2) {
        switch (by) {
            default: {
                break;
            }
            case 32: {
                switch (by2) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.generate_8((byte)-114);
                        this.decOpStackHeight(1);
                        break;
                    }
                    case 7: {
                        this.generate_8((byte)-113);
                        break;
                    }
                    case 8: {
                        this.generate_8((byte)-112);
                        this.decOpStackHeight(1);
                    }
                }
                break;
            }
            case 16: {
                switch (by2) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.generate_8((byte)-117);
                        break;
                    }
                    case 7: {
                        this.generate_8((byte)-116);
                        this.incOpStackHeight(1);
                    }
                }
                break;
            }
            case 8: {
                switch (by2) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.generate_8((byte)-120);
                        this.decOpStackHeight(1);
                    }
                }
            }
        }
        if (by2 == 3) {
            this.generate_8((byte)-111);
        } else if (by2 == 5) {
            this.generate_8((byte)-109);
        } else if (by2 == 4) {
            this.generate_8((byte)-110);
        }
    }

    void loadLocalVariable(TypeSymbol typeSymbol, short s) {
        byte by = typeSymbol.typeKind;
        if (s <= 3) {
            this.generate_8((byte)(short_load_opcode[by] + s));
        } else if (s < 256) {
            this.generate_8_8(load_opcode[by], (byte)s);
        } else {
            this.generate_8_8_16((byte)-60, load_opcode[by], s);
        }
        this.incOpStackHeight((typeSymbol.typeClass & 0x28) != 0 ? 2 : 1);
    }

    void storeLocalVariable(TypeSymbol typeSymbol, short s) {
        byte by = typeSymbol.typeKind;
        if (s <= 3) {
            this.generate_8((byte)(short_store_opcode[by] + s));
        } else if (s < 256) {
            this.generate_8_8(store_opcode[by], (byte)s);
        } else {
            this.generate_8_8_16((byte)-60, store_opcode[by], s);
        }
        this.decOpStackHeight((typeSymbol.typeClass & 0x28) != 0 ? 2 : 1);
    }

    void generateBranch_ifeq(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-102, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-103);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifne(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-103, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-102);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_iflt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-100, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-101);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifge(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-101, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-100);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifgt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-98, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-99);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifle(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-99, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-98);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpeq(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-96, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-97);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpne(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-97, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-96);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmplt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-94, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-95);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpge(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-95, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-94);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmpgt(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-92, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-93);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_icmple(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-93, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-92);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_acmpeq(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-90, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-91);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_if_acmpne(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-91, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-90);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifnonnull(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-58, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-57);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_ifnull(Label label) {
        if (this.wideFlag) {
            this.generate_8_16((byte)-57, (short)8);
            this.generate_8((byte)-56);
            this.generateFixup(true, label);
        } else {
            this.generate_8((byte)-58);
            this.generateFixup(false, label);
        }
    }

    void generateBranch_goto(Label label) {
        this.generate_8(this.wideFlag ? (byte)-56 : -89);
        this.generateFixup(this.wideFlag, label);
    }

    void generateBranch_jsr(Label label) {
        this.generate_8(this.wideFlag ? (byte)-55 : -88);
        this.generateFixup(this.wideFlag, label);
    }

    RawClassSymbol generateOuterClassFieldAccessor(RawClassSymbol rawClassSymbol, RawClassSymbol rawClassSymbol2, boolean bl) {
        RawClassSymbol rawClassSymbol3;
        short s;
        FieldSymbol fieldSymbol = this.parser.getThisDollarSymbol(rawClassSymbol2);
        if (this.parser.currentMethodSymbol.isConstructor()) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)rawClassSymbol2;
            InnerClassSymbol.HiddenArgumentList hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
            while (hiddenArgumentList != null) {
                if (hiddenArgumentList.fieldSymbol == fieldSymbol) {
                    this.loadLocalVariable(hiddenArgumentList.type, hiddenArgumentList.stackVarIndex);
                    break;
                }
                hiddenArgumentList = hiddenArgumentList.next;
            }
        } else {
            s = this.constantPool.enterConstantPoolFieldRef(rawClassSymbol2.getInternalName(), fieldSymbol.identifier.name, ((Symbol)fieldSymbol).getSignature());
            this.generate_8_16((byte)-76, s);
        }
        while (rawClassSymbol != (rawClassSymbol3 = rawClassSymbol2.getOuterClass()) && !(rawClassSymbol.isInterface() ? rawClassSymbol3.implementsInterface(rawClassSymbol) : !bl && rawClassSymbol.isSuperclass(rawClassSymbol3))) {
            rawClassSymbol2 = rawClassSymbol3;
            fieldSymbol = this.parser.getThisDollarSymbol(rawClassSymbol2);
            s = this.constantPool.enterConstantPoolFieldRef(rawClassSymbol2.getInternalName(), fieldSymbol.identifier.name, ((Symbol)fieldSymbol).getSignature());
            this.generate_8_16((byte)-76, s);
        }
        return rawClassSymbol3;
    }

    MethodSymbol generateReadAccessor(FieldSymbol fieldSymbol) {
        int n;
        byte[] byArray;
        Identifier identifier;
        MethodSymbol methodSymbol;
        RawClassSymbol rawClassSymbol;
        String string;
        String string2 = string = Identifier.dollarString;
        RawClassSymbol rawClassSymbol2 = fieldSymbol.definingClass;
        RawClassSymbol rawClassSymbol3 = this.parser.currentClassSymbol;
        while (rawClassSymbol3.isInnerClass() && rawClassSymbol2 != (rawClassSymbol = rawClassSymbol3.getOuterClass())) {
            if (rawClassSymbol2.isSuperclass(rawClassSymbol)) {
                rawClassSymbol2 = rawClassSymbol;
                break;
            }
            rawClassSymbol3 = rawClassSymbol;
        }
        while ((methodSymbol = (MethodSymbol)rawClassSymbol2.classScope.lookupSpecificSymbolInScope(identifier = Identifier.getIdentifier("ra" + string2 + fieldSymbol.identifier.toString()), 8, true)) != null) {
            if ((methodSymbol.flags & 1) != 0) {
                return methodSymbol;
            }
            string2 = string2 + string;
        }
        methodSymbol = new MethodSymbol(0, rawClassSymbol2, identifier, fieldSymbol.type, 0, 8, null, true);
        methodSymbol.flags = (short)(methodSymbol.flags | 0x21);
        if (!$assertionsDisabled && !rawClassSymbol2.isCompiled()) {
            throw new AssertionError();
        }
        rawClassSymbol2.classScope.enterSymbol(methodSymbol);
        methodSymbol.nextInClass = rawClassSymbol2.cd.methodList;
        rawClassSymbol2.cd.methodList = methodSymbol;
        if ((fieldSymbol.access & 8) != 0) {
            byArray = new byte[4];
            byArray[0] = -78;
            n = 1;
        } else {
            ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, rawClassSymbol2, 0, 0, null, 0);
            methodSymbol.cmd.localVariables.add(argumentVariableSymbol);
            methodSymbol.argumentList = new ArgumentVariableList(argumentVariableSymbol);
            methodSymbol.localVarCount = 1;
            methodSymbol.actualArgCount = 1;
            methodSymbol.argCount = 1;
            byArray = new byte[5];
            byArray[0] = 42;
            byArray[1] = -76;
            n = 2;
        }
        switch (fieldSymbol.type.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 2: 
            case 4: {
                byArray[n + 2] = -84;
                methodSymbol.cmd.maxOpStackDepth = 1;
                break;
            }
            case -128: 
            case 64: {
                byArray[n + 2] = -80;
                methodSymbol.cmd.maxOpStackDepth = 1;
                break;
            }
            case 8: {
                byArray[n + 2] = -83;
                methodSymbol.cmd.maxOpStackDepth = 2;
                break;
            }
            case 16: {
                byArray[n + 2] = -82;
                methodSymbol.cmd.maxOpStackDepth = 1;
                break;
            }
            case 32: {
                byArray[n + 2] = -81;
                methodSymbol.cmd.maxOpStackDepth = 2;
            }
        }
        if (rawClassSymbol2.cd.ccd.constantPool == null) {
            rawClassSymbol2.cd.ccd.constantPool = new ConstantPool(this.parser);
        }
        short s = rawClassSymbol2.cd.ccd.constantPool.enterConstantPoolFieldRef(rawClassSymbol2.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
        byArray[n + 1] = (byte)s;
        byArray[n] = (byte)(s >> 8);
        methodSymbol.cmd.codeBuffer = byArray;
        return methodSymbol;
    }

    MethodSymbol generateWriteAccessor(FieldSymbol fieldSymbol) {
        byte[] byArray;
        Identifier identifier;
        MethodSymbol methodSymbol;
        RawClassSymbol rawClassSymbol;
        String string;
        String string2 = string = Identifier.dollarString;
        RawClassSymbol rawClassSymbol2 = fieldSymbol.definingClass;
        RawClassSymbol rawClassSymbol3 = this.parser.currentClassSymbol;
        while (rawClassSymbol3.isInnerClass() && rawClassSymbol2 != (rawClassSymbol = rawClassSymbol3.getOuterClass())) {
            if (rawClassSymbol2.isSuperclass(rawClassSymbol)) {
                rawClassSymbol2 = rawClassSymbol;
                break;
            }
            rawClassSymbol3 = rawClassSymbol;
        }
        while ((methodSymbol = (MethodSymbol)rawClassSymbol2.classScope.lookupSpecificSymbolInScope(identifier = Identifier.getIdentifier("wa" + string2 + fieldSymbol.identifier.toString()), 8, true)) != null) {
            if ((methodSymbol.flags & 1) != 0) {
                return methodSymbol;
            }
            string2 = string2 + string;
        }
        methodSymbol = new MethodSymbol(0, rawClassSymbol2, identifier, TypeSymbol.voidSymbol, 0, 8, null, true);
        methodSymbol.flags = (short)(methodSymbol.flags | 0x21);
        if (!$assertionsDisabled && !rawClassSymbol2.isCompiled()) {
            throw new AssertionError();
        }
        rawClassSymbol2.classScope.enterSymbol(methodSymbol);
        methodSymbol.nextInClass = rawClassSymbol2.cd.methodList;
        rawClassSymbol2.cd.methodList = methodSymbol;
        if (rawClassSymbol2.cd.ccd.constantPool == null) {
            rawClassSymbol2.cd.ccd.constantPool = new ConstantPool(this.parser);
        }
        short s = rawClassSymbol2.cd.ccd.constantPool.enterConstantPoolFieldRef(rawClassSymbol2.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
        int n = 0;
        if ((fieldSymbol.access & 8) != 0) {
            byte by;
            switch (fieldSymbol.type.typeClass) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 2: 
                case 4: {
                    by = 26;
                    methodSymbol.cmd.maxOpStackDepth = 1;
                    break;
                }
                case -128: 
                case 64: {
                    by = 42;
                    methodSymbol.cmd.maxOpStackDepth = 1;
                    break;
                }
                case 8: {
                    by = 30;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case 16: {
                    by = 34;
                    methodSymbol.cmd.maxOpStackDepth = 1;
                    break;
                }
                case 32: {
                    by = 38;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                }
            }
            short s2 = methodSymbol.localVarCount;
            methodSymbol.localVarCount = (short)(s2 + 1);
            ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, fieldSymbol.type, 0, 0, null, s2);
            methodSymbol.cmd.localVariables.add(argumentVariableSymbol);
            methodSymbol.argumentList = new ArgumentVariableList(argumentVariableSymbol);
            n = (short)(n + 1);
            byArray = new byte[]{by, -77, (byte)(s >> 8), (byte)s, -79};
        } else {
            byte by;
            switch (fieldSymbol.type.typeClass) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 2: 
                case 4: {
                    by = 27;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case -128: 
                case 64: {
                    by = 43;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case 8: {
                    by = 31;
                    methodSymbol.cmd.maxOpStackDepth = 3;
                    methodSymbol.localVarCount = (short)(methodSymbol.localVarCount + 1);
                    break;
                }
                case 16: {
                    by = 35;
                    methodSymbol.cmd.maxOpStackDepth = 2;
                    break;
                }
                case 32: {
                    by = 39;
                    methodSymbol.cmd.maxOpStackDepth = 3;
                    methodSymbol.localVarCount = (short)(methodSymbol.localVarCount + 1);
                }
            }
            short s3 = methodSymbol.localVarCount;
            methodSymbol.localVarCount = (short)(s3 + 1);
            ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, rawClassSymbol2, 0, 0, null, s3);
            methodSymbol.cmd.localVariables.add(argumentVariableSymbol);
            methodSymbol.argumentList = new ArgumentVariableList(argumentVariableSymbol);
            n = (short)(n + 1);
            short s4 = methodSymbol.localVarCount;
            methodSymbol.localVarCount = (short)(s4 + 1);
            argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, fieldSymbol.type, 0, 0, null, s4);
            methodSymbol.cmd.localVariables.add(argumentVariableSymbol);
            methodSymbol.argumentList.next = new ArgumentVariableList(argumentVariableSymbol);
            n = (short)(n + 1);
            byArray = new byte[]{42, by, -75, (byte)(s >> 8), (byte)s, -79};
        }
        methodSymbol.argCount = (short)n;
        methodSymbol.actualArgCount = methodSymbol.localVarCount;
        methodSymbol.cmd.codeBuffer = byArray;
        return methodSymbol;
    }

    private int generateArgumentLoadForMethodAccessor(byte[] byArray, int n, int n2, byte by, byte by2) {
        if (n2 <= 3) {
            byArray[n++] = (byte)(by + n2);
        } else if (n2 < 256) {
            byArray[n++] = by2;
            byArray[n++] = (byte)n2;
        } else {
            byArray[n++] = -60;
            byArray[n++] = by2;
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n++] = (byte)n2;
        }
        return n;
    }

    private MethodSymbol generateMethodAccessor(MethodSymbol methodSymbol, MethodSymbol methodSymbol2, byte by) {
        int n;
        int n2;
        RawClassSymbol rawClassSymbol = methodSymbol2.definingClass;
        if (!$assertionsDisabled && !rawClassSymbol.isCompiled()) {
            throw new AssertionError();
        }
        if (rawClassSymbol.cd.ccd.constantPool == null) {
            rawClassSymbol.cd.ccd.constantPool = new ConstantPool(this.parser);
        }
        short s = rawClassSymbol.cd.ccd.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
        int n3 = methodSymbol2.actualArgCount * 4 + 1 + 2 + 1;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = methodSymbol2.actualArgCount;
        if ((methodSymbol2.access & 8) == 0) {
            --n6;
            n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4++, (byte)42, (byte)25);
        }
        if (methodSymbol.isConstructor() && methodSymbol.definingClass.isInnerClass()) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)methodSymbol.definingClass;
            InnerClassSymbol.HiddenArgumentList hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
            while (hiddenArgumentList != null) {
                switch (hiddenArgumentList.type.typeClass) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 2: 
                    case 4: {
                        n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)26, (byte)21);
                        break;
                    }
                    case -128: 
                    case 64: {
                        n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)42, (byte)25);
                        break;
                    }
                    case 8: {
                        n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)30, (byte)22);
                        ++n4;
                        break;
                    }
                    case 16: {
                        n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)34, (byte)23);
                        break;
                    }
                    case 32: {
                        n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)38, (byte)24);
                        ++n4;
                    }
                }
                hiddenArgumentList = hiddenArgumentList.next;
                ++n4;
            }
        }
        ArgumentVariableList argumentVariableList = methodSymbol2.argumentList;
        while (n4 < n6) {
            ArgumentVariableSymbol argumentVariableSymbol = argumentVariableList.argSymbol;
            methodSymbol2.cmd.localVariables.add(argumentVariableSymbol);
            switch (argumentVariableSymbol.type.typeClass) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 2: 
                case 4: {
                    n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)26, (byte)21);
                    break;
                }
                case -128: 
                case 64: {
                    n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)42, (byte)25);
                    break;
                }
                case 8: {
                    n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)30, (byte)22);
                    ++n4;
                    break;
                }
                case 16: {
                    n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)34, (byte)23);
                    break;
                }
                case 32: {
                    n5 = this.generateArgumentLoadForMethodAccessor(byArray, n5, n4, (byte)38, (byte)24);
                    ++n4;
                }
            }
            argumentVariableList = argumentVariableList.next;
            ++n4;
        }
        byArray[n5++] = by;
        byArray[n5++] = (byte)(s >> 8);
        byArray[n5++] = (byte)s;
        switch (methodSymbol2.resultType.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 1: {
                n2 = -79;
                n = 0;
                break;
            }
            case 2: 
            case 4: {
                n2 = -84;
                n = 1;
                break;
            }
            case -128: 
            case 64: {
                n2 = -80;
                n = 1;
                break;
            }
            case 8: {
                n2 = -83;
                n = 2;
                break;
            }
            case 16: {
                n2 = -82;
                n = 1;
                break;
            }
            case 32: {
                n2 = -81;
                n = 2;
            }
        }
        byArray[n5++] = n2;
        if (methodSymbol2.cmd.maxOpStackDepth < n) {
            methodSymbol2.cmd.maxOpStackDepth = n;
        }
        methodSymbol2.cmd.codeBuffer = new byte[n5];
        System.arraycopy(byArray, 0, methodSymbol2.cmd.codeBuffer, 0, n5);
        return methodSymbol2;
    }

    MethodSymbol generateMethodAccessor(MethodSymbol methodSymbol, byte by) {
        MethodSymbol methodSymbol2;
        Identifier identifier;
        String string;
        byte by2;
        RawClassSymbol rawClassSymbol;
        RawClassSymbol rawClassSymbol2 = methodSymbol.definingClass;
        RawClassSymbol rawClassSymbol3 = this.parser.currentClassSymbol;
        while (rawClassSymbol3.isInnerClass() && rawClassSymbol2 != (rawClassSymbol = rawClassSymbol3.getOuterClass())) {
            if (rawClassSymbol2.isSuperclass(rawClassSymbol)) {
                rawClassSymbol2 = rawClassSymbol;
                break;
            }
            rawClassSymbol3 = rawClassSymbol;
        }
        switch (by) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 1: {
                by2 = -73;
                string = "s";
                break;
            }
            case 3: {
                by2 = -74;
                string = "v";
                break;
            }
            case 4: {
                by2 = -72;
                string = "S";
            }
        }
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        if ((methodSymbol.access & 8) == 0) {
            ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, rawClassSymbol2, 0, 0, null, 0);
            argumentVariableList = new ArgumentVariableList(argumentVariableSymbol);
            argumentVariableList.next = methodSymbol.argumentList;
        }
        String string2 = Identifier.dollarString;
        block6: while (true) {
            string = string + string2;
            identifier = Identifier.getIdentifier("ma" + string + methodSymbol.identifier.toString());
            MethodSymbol methodSymbol3 = methodSymbol2 = (MethodSymbol)rawClassSymbol2.classScope.lookupSpecificSymbolInScope(identifier, 8, true);
            while (methodSymbol3 != null) {
                if (methodSymbol3.actualArgCount == methodSymbol.actualArgCount && (methodSymbol3.argumentList == null || methodSymbol3.argumentList.equals(argumentVariableList))) {
                    if ((methodSymbol3.flags & 1) == 0) continue block6;
                    return methodSymbol3;
                }
                methodSymbol3 = methodSymbol3.nextWithSameName;
            }
            break;
        }
        MethodSymbol methodSymbol4 = new MethodSymbol(0, rawClassSymbol2, identifier, methodSymbol.resultType, 0, 8, null, true);
        methodSymbol4.flags = (short)(methodSymbol4.flags | 0x21);
        methodSymbol4.argumentList = argumentVariableList;
        methodSymbol4.localVarCount = methodSymbol4.actualArgCount = methodSymbol.actualArgCount;
        methodSymbol4.cmd.maxOpStackDepth = methodSymbol4.actualArgCount;
        methodSymbol4.argCount = methodSymbol.argCount;
        if ((methodSymbol.access & 8) == 0) {
            methodSymbol4.argCount = (short)(methodSymbol4.argCount + 1);
        }
        methodSymbol4.nextInClass = rawClassSymbol2.cd.methodList;
        rawClassSymbol2.cd.methodList = methodSymbol4;
        if (methodSymbol2 == null) {
            rawClassSymbol2.classScope.enterSymbol(methodSymbol4);
        } else {
            methodSymbol4.nextWithSameName = methodSymbol2.nextWithSameName;
            methodSymbol2.nextWithSameName = methodSymbol4;
        }
        return this.generateMethodAccessor(methodSymbol, methodSymbol4, by2);
    }

    MethodSymbol generateConstructorAccessor(MethodSymbol methodSymbol, RawClassSymbol rawClassSymbol) {
        RawClassSymbol rawClassSymbol2;
        RawClassSymbol rawClassSymbol3 = methodSymbol.definingClass;
        MethodSymbol methodSymbol2 = (MethodSymbol)rawClassSymbol3.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        ArgumentVariableList argumentVariableList2 = null;
        ArgumentVariableList argumentVariableList3 = null;
        while (argumentVariableList != null) {
            ArgumentVariableList argumentVariableList4 = new ArgumentVariableList(argumentVariableList.argSymbol);
            if (argumentVariableList3 == null) {
                argumentVariableList2 = argumentVariableList3 = argumentVariableList4;
            } else {
                argumentVariableList2.next = argumentVariableList4;
            }
            argumentVariableList = argumentVariableList.next;
            argumentVariableList2 = argumentVariableList4;
        }
        if (rawClassSymbol.isAnonymousInnerClass()) {
            rawClassSymbol2 = rawClassSymbol;
        } else {
            rawClassSymbol2 = null;
            TypeSymbolList typeSymbolList = rawClassSymbol3.cd.innerClassList;
            while (typeSymbolList != null) {
                if (typeSymbolList.typeSymbol.isAnonymousInnerClass()) {
                    rawClassSymbol2 = (RawClassSymbol)typeSymbolList.typeSymbol;
                    break;
                }
                typeSymbolList = typeSymbolList.next;
            }
            if (rawClassSymbol2 == null) {
                rawClassSymbol2 = AnonymousClassSymbol.createDummyClass(this.parser, rawClassSymbol3);
            }
        }
        ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, rawClassSymbol2, 0, 0, null, methodSymbol.actualArgCount);
        if (argumentVariableList3 == null) {
            argumentVariableList3 = new ArgumentVariableList(argumentVariableSymbol);
        } else {
            argumentVariableList2.next = new ArgumentVariableList(argumentVariableSymbol);
        }
        MethodSymbol methodSymbol3 = methodSymbol2;
        while (methodSymbol3 != null) {
            if (methodSymbol3.actualArgCount == methodSymbol.actualArgCount + 1 && (methodSymbol3.argumentList == null || methodSymbol3.argumentList.equals(argumentVariableList3))) {
                return methodSymbol3;
            }
            methodSymbol3 = methodSymbol3.nextWithSameName;
        }
        MethodSymbol methodSymbol4 = new MethodSymbol(0, rawClassSymbol3, Identifier.initializerIdentifier, methodSymbol.resultType, 0, 0, null, true);
        methodSymbol4.flags = (short)(methodSymbol4.flags | 0x21);
        methodSymbol4.argumentList = argumentVariableList3;
        methodSymbol4.argCount = (short)(methodSymbol.argCount + 1);
        methodSymbol4.localVarCount = methodSymbol4.actualArgCount = (short)(methodSymbol.actualArgCount + 1);
        methodSymbol4.cmd.maxOpStackDepth = methodSymbol4.actualArgCount;
        methodSymbol4.nextInClass = rawClassSymbol3.cd.methodList;
        rawClassSymbol3.cd.methodList = methodSymbol4;
        if (methodSymbol2 == null) {
            rawClassSymbol3.classScope.enterSymbol(methodSymbol4);
        } else {
            methodSymbol4.nextWithSameName = methodSymbol2.nextWithSameName;
            methodSymbol2.nextWithSameName = methodSymbol4;
        }
        return this.generateMethodAccessor(methodSymbol, methodSymbol4, (byte)-73);
    }

    short generateGetPC() {
        return (short)(this.codeBufferStartOffset + this.codeBufferIndex);
    }

    void generateLineNumber(int n) {
        if (n != 0 && n != this.prevLine) {
            this.prevLine = n;
            byte[] byArray = this.lineNumberTable;
            int n2 = this.codeBufferStartOffset + this.codeBufferIndex;
            if (n2 == this.prevLineOffset) {
                int n3 = (this.lineNumberCount - 1) * 4;
                byArray[n3 + 3] = (byte)n;
                byArray[n3 + 2] = (byte)(n >> 8);
            } else {
                this.prevLineOffset = n2;
                short s = this.lineNumberCount;
                this.lineNumberCount = (short)(s + 1);
                int n4 = s * 4;
                byArray[n4 + 3] = (byte)n;
                byArray[n4 + 2] = (byte)(n >> 8);
                byArray[n4 + 1] = (byte)n2;
                byArray[n4] = (byte)(n2 >> 8);
            }
        }
    }

    void generateExceptionHandler(short s, short s2, short s3, short s4) {
        if (!$assertionsDisabled && s == s2) {
            throw new AssertionError();
        }
        short s5 = this.methodSymbol.cmd.exceptionTableLen;
        byte[] byArray = this.methodSymbol.cmd.exceptionTable;
        if (byArray == null) {
            this.methodSymbol.cmd.exceptionTable = byArray = new byte[40];
        } else if (s5 + 8 < byArray.length) {
            byte[] byArray2 = new byte[byArray.length + 40];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.methodSymbol.cmd.exceptionTable = byArray = byArray2;
        }
        byArray[s5 + 7] = (byte)s4;
        byArray[s5 + 6] = (byte)(s4 >> 8);
        byArray[s5 + 5] = (byte)s3;
        byArray[s5 + 4] = (byte)(s3 >> 8);
        byArray[s5 + 3] = (byte)s2;
        byArray[s5 + 2] = (byte)(s2 >> 8);
        byArray[s5 + 1] = (byte)s;
        byArray[s5 + 0] = (byte)(s >> 8);
        this.methodSymbol.cmd.exceptionTableLen = (short)(s5 + 8);
    }

    private void generateLocalVariableTable(MethodSymbol methodSymbol) {
        MethodVariableSymbol methodVariableSymbol;
        int n = 0;
        int n2 = 0;
        int n3 = methodSymbol.localVarCount;
        while (--n3 >= 0) {
            methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
            if (methodVariableSymbol == null || methodVariableSymbol.identifier == null || methodVariableSymbol.startPC == -1) continue;
            ++n;
            if (!methodVariableSymbol.type.involvesGenerics()) continue;
            ++n2;
        }
        ArgumentVariableSymbol argumentVariableSymbol = null;
        if ((methodSymbol.access & 8) == 0) {
            ++n;
            if (methodSymbol.definingClass.involvesGenerics()) {
                ++n2;
            }
            argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, Identifier.thisIdentifier, methodSymbol.definingClass, 0, 16, null, 0);
            argumentVariableSymbol.endPC = (short)methodSymbol.cmd.codeBuffer.length;
        }
        methodSymbol.cmd.localVarTableLen = (short)n;
        byte[] byArray = new byte[n * 10];
        byte[] byArray2 = null;
        if (this.parser.options.codecoach) {
            byArray2 = new byte[n * 2];
        }
        methodSymbol.cmd.localVarTypeTableLen = (short)n2;
        byte[] byArray3 = null;
        if (n2 > 0) {
            byArray3 = new byte[n2 * 10];
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < methodSymbol.localVarCount; ++n3) {
            methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
            if (methodVariableSymbol == null && n3 == 0 && argumentVariableSymbol != null) {
                methodVariableSymbol = argumentVariableSymbol;
            }
            if (methodVariableSymbol == null || methodVariableSymbol.identifier == null || methodVariableSymbol.startPC == -1) continue;
            short s = this.constantPool.enterConstantPoolUtf8(methodVariableSymbol.identifier.name);
            short s2 = this.constantPool.enterConstantPoolUtf8(methodVariableSymbol.type.getSignature());
            byArray[n4 + 9] = (byte)methodVariableSymbol.varStackIndex;
            byArray[n4 + 8] = (byte)(methodVariableSymbol.varStackIndex >> 8);
            byArray[n4 + 7] = (byte)s2;
            byArray[n4 + 6] = (byte)(s2 >> 8);
            byArray[n4 + 5] = (byte)s;
            byArray[n4 + 4] = (byte)(s >> 8);
            byArray[n4 + 3] = (byte)(methodVariableSymbol.endPC - methodVariableSymbol.startPC);
            byArray[n4 + 2] = (byte)(methodVariableSymbol.endPC - methodVariableSymbol.startPC >> 8);
            byArray[n4 + 1] = (byte)methodVariableSymbol.startPC;
            byArray[n4 + 0] = (byte)(methodVariableSymbol.startPC >> 8);
            if (methodVariableSymbol.type.involvesGenerics()) {
                s2 = this.constantPool.enterConstantPoolUtf8(methodVariableSymbol.type.getGenericSignature());
                byArray3[n5 + 9] = byArray[n4 + 9];
                byArray3[n5 + 8] = byArray[n4 + 8];
                byArray3[n5 + 7] = (byte)s2;
                byArray3[n5 + 6] = (byte)(s2 >> 8);
                byArray3[n5 + 5] = byArray[n4 + 5];
                byArray3[n5 + 4] = byArray[n4 + 4];
                byArray3[n5 + 3] = byArray[n4 + 3];
                byArray3[n5 + 2] = byArray[n4 + 2];
                byArray3[n5 + 1] = byArray[n4 + 1];
                byArray3[n5 + 0] = byArray[n4 + 0];
                n5 += 10;
            }
            n4 += 10;
            if (!this.parser.options.codecoach) continue;
            int n7 = Scanner.positionToLine(methodVariableSymbol.pos);
            if (n7 == 0) {
                n7 = Scanner.positionToLine(methodSymbol.pos);
            }
            byArray2[n6 + 1] = (byte)n7;
            byArray2[n6 + 0] = (byte)(n7 >> 8);
            n6 += 2;
        }
        methodSymbol.cmd.localVarTable = byArray;
        methodSymbol.cmd.localVarTypeTable = byArray3;
        if (this.parser.options.codecoach) {
            methodSymbol.cmd.ccLocalVarTable = byArray2;
        }
    }

    void generateClassDollarMethod() {
        this.generate_8((byte)42);
        short s = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
        short s2 = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangClassInternal.name, Identifier.forNameIdentifier.name, Identifier.javaLangClassMethodStringSignature.name);
        this.generate_8_16_8((byte)-72, s2, (byte)-80);
        short s3 = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
        s2 = this.constantPool.enterConstantPoolClass(Identifier.javaLangNoClassDefFoundErrorInternal.name);
        this.generate_8_16_8((byte)-69, s2, (byte)90);
        this.generate_8((byte)95);
        s2 = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangClassNotFoundExceptionInternal.name, Identifier.getMessageIdentifier.name, Identifier.javaLangStringMethodSignature.name);
        this.generate_8_16((byte)-74, s2);
        s2 = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangNoClassDefFoundErrorInternal.name, Identifier.initializerIdentifier.name, Identifier.voidMethodStringSignature.name);
        this.generate_8_16_8((byte)-73, s2, (byte)-65);
        s2 = this.constantPool.enterConstantPoolClass(Identifier.javaLangClassNotFoundExceptionInternal.name);
        this.generateExceptionHandler(s, (short)(s + 3), s3, s2);
        this.maxOpStackHeight = 3;
    }

    void generateEnumValuesMethod() {
        char[] cArray = ArraySymbol.getArrayType(this.methodSymbol.definingClass, 1).getSignature();
        short s = this.constantPool.enterConstantPoolFieldRef(this.methodSymbol.definingClass.getInternalName(), Identifier.enumValuesInternal.name, cArray);
        this.generate_8_16((byte)-78, s);
        s = this.constantPool.enterConstantPoolMethodRef(cArray, Identifier.cloneIdentifier.name, Identifier.javaLangObjectMethodSignature.name);
        this.generate_8_16((byte)-74, s);
        s = this.constantPool.enterConstantPoolClass(cArray);
        this.generate_8_16_8((byte)-64, s, (byte)-80);
        this.maxOpStackHeight = 1;
    }

    void generateEnumValueOfMethod() {
        RawClassSymbol rawClassSymbol = this.methodSymbol.definingClass;
        String string = new String(((ClassSymbol)rawClassSymbol).getInternalName());
        short s = this.constantPool.enterConstantPoolClass(string.toCharArray());
        if ((s & 0xFF00) != 0) {
            this.generate_8_16_8((byte)19, s, (byte)42);
        } else {
            this.generate_8_8_8((byte)18, (byte)s, (byte)42);
        }
        s = this.constantPool.enterConstantPoolMethodRef(this.parser.javaLangEnumSymbol.getInternalName(), Identifier.valueOfIdentifier.name, Identifier.javaLangEnumMethodClassStringSignature.name);
        this.generate_8_16((byte)-72, s);
        s = this.constantPool.enterConstantPoolClass(((ClassSymbol)rawClassSymbol).getInternalName());
        this.generate_8_16_8((byte)-64, s, (byte)-80);
        this.maxOpStackHeight = 2;
        this.methodSymbol.localVarCount = 1;
    }

    void generateBridgeMethod(MethodSymbol methodSymbol) {
        byte by;
        short s;
        this.generate_8((byte)42);
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        ArgumentVariableList argumentVariableList2 = this.methodSymbol.argumentList;
        while (argumentVariableList2 != null) {
            this.loadLocalVariable(argumentVariableList.argSymbol.type, argumentVariableList.argSymbol.varStackIndex);
            if (argumentVariableList.argSymbol.type != argumentVariableList2.argSymbol.type) {
                s = this.constantPool.enterConstantPoolClass(((ClassSymbol)argumentVariableList.argSymbol.type).getInternalName());
                this.generate_8_16((byte)-64, s);
            }
            argumentVariableList2 = argumentVariableList2.next;
            argumentVariableList = argumentVariableList.next;
        }
        switch (methodSymbol.resultType.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 1: {
                by = -79;
                break;
            }
            case 2: 
            case 4: {
                by = -84;
                break;
            }
            case -128: 
            case 64: {
                by = -80;
                break;
            }
            case 8: {
                by = -83;
                break;
            }
            case 16: {
                by = -82;
                break;
            }
            case 32: {
                by = -81;
            }
        }
        s = this.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
        this.generate_8_16_8((byte)-74, s, by);
        this.methodSymbol.localVarCount = this.methodSymbol.actualArgCount;
        this.maxOpStackHeight = this.methodSymbol.localVarCount;
    }

    void generateClassInitalizerPrologue() {
        RawClassSymbol rawClassSymbol = this.parser.currentClassSymbol;
        char[] cArray = rawClassSymbol.getInternalName();
        if (rawClassSymbol instanceof EnumMapClassSymbol) {
            EnumMapClassSymbol enumMapClassSymbol = (EnumMapClassSymbol)rawClassSymbol;
            short s = this.constantPool.enterConstantPoolClass(Identifier.javaLangNoSuchFieldErrorInternal.name);
            EnumMapClassSymbol.EnumDescriptor enumDescriptor = enumMapClassSymbol.enumList;
            while (enumDescriptor != null) {
                String string = "()" + new String(ArraySymbol.getArrayType(enumDescriptor.enumClassSymbol, 1).getSignature());
                short s2 = this.constantPool.enterConstantPoolMethodRef(enumDescriptor.enumClassSymbol.getInternalName(), Identifier.valuesIdentifier.name, string.toCharArray());
                this.generate_8_16_8((byte)-72, s2, (byte)-66);
                this.generate_8_8((byte)-68, (byte)10);
                int n = enumDescriptor.enumConstList.size();
                if (n > 0) {
                    this.generate_8((byte)89);
                }
                short s3 = this.constantPool.enterConstantPoolFieldRef(cArray, enumDescriptor.enumMapField.identifier.name, Identifier.intArraySignature.name);
                this.generate_8_16((byte)-77, s3);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        this.generate_8_16((byte)-78, s3);
                    }
                    short s4 = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    FieldSymbol fieldSymbol = (FieldSymbol)enumDescriptor.enumConstList.get(i);
                    s2 = this.constantPool.enterConstantPoolFieldRef(enumDescriptor.enumClassSymbol.getInternalName(), fieldSymbol.identifier.name, enumDescriptor.enumClassSymbol.getSignature());
                    this.generate_8_16((byte)-78, s2);
                    short s5 = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    s2 = this.constantPool.enterConstantPoolMethodRef(enumDescriptor.enumClassSymbol.getInternalName(), Identifier.ordinalIdentifier.name, Identifier.intMethodSignature.name);
                    this.generate_8_16((byte)-74, s2);
                    this.generateIntConst(i + 1);
                    this.generate_8((byte)79);
                    Label label = new Label();
                    this.generate_8((byte)-89);
                    this.generateFixup(false, label);
                    short s6 = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    this.generateExceptionHandler(s4, s5, s6, s);
                    this.generate_8((byte)87);
                    this.setLabel(label);
                }
                enumDescriptor = enumDescriptor.next;
            }
            this.generate_8((byte)-79);
            this.maxOpStackHeight = 4;
        } else {
            short s;
            short s7;
            if ((rawClassSymbol.flags & 1) != 0) {
                if (this.parser.options.targetJDKVersion < 150) {
                    s7 = this.constantPool.enterConstantPoolFieldRef(cArray, Identifier.classObjectInternal.name, Identifier.javaLangClassSignature.name);
                    this.generate_8_16_8((byte)-78, s7, (byte)89);
                    String string = new String(rawClassSymbol.getInternalName());
                    string = string.replace('/', '.');
                    s = this.constantPool.enterConstantPoolString(string.toCharArray());
                    if ((s & 0xFF00) != 0) {
                        this.generate_8_16_8((byte)-57, (short)14, (byte)87);
                        this.generate_8_16((byte)19, s);
                    } else {
                        this.generate_8_16_8((byte)-57, (short)13, (byte)87);
                        this.generate_8_8((byte)18, (byte)s);
                    }
                    this.assertionLoaderStartPC = (short)(this.codeBufferStartOffset + this.codeBufferIndex);
                    MethodSymbol methodSymbol = rawClassSymbol.cd.ccd.classLoaderMethod;
                    s = this.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
                    this.generate_8_16_8((byte)-72, s, (byte)89);
                    this.generate_8_16((byte)-77, s7);
                } else {
                    s = this.constantPool.enterConstantPoolClass(cArray);
                    if ((s & 0xFF00) != 0) {
                        this.generate_8_16((byte)19, s);
                    } else {
                        this.generate_8_8((byte)18, (byte)s);
                    }
                }
                s = this.constantPool.enterConstantPoolMethodRef(Identifier.javaLangClassInternal.name, Identifier.desiredAssertionStatusIdentifier.name, Identifier.booleanMethodSignature.name);
                this.generate_8_16((byte)-74, s);
                this.generate_8_8((byte)4, (byte)-126);
                s = this.constantPool.enterConstantPoolFieldRef(cArray, Identifier.assertionsDisabledInternal.name, Identifier.booleanSignature.name);
                this.generate_8_16((byte)-77, s);
                this.maxOpStackHeight = 2;
            }
            if (rawClassSymbol.isEnum()) {
                int n = 0;
                FieldSymbol fieldSymbol = rawClassSymbol.cd.fieldList;
                while (fieldSymbol != null) {
                    if ((fieldSymbol.access & 0x4000) != 0) {
                        ++n;
                    }
                    fieldSymbol = fieldSymbol.nextInClass;
                }
                if (n > 0) {
                    this.generateIntConst(n);
                    s7 = this.constantPool.enterConstantPoolClass(cArray);
                    this.generate_8_16_8((byte)-67, s7, (byte)89);
                    this.incOpStackHeight(2);
                    fieldSymbol = rawClassSymbol.cd.fieldList;
                    while (true) {
                        if ((fieldSymbol.access & 0x4000) != 0) {
                            fieldSymbol.initializer.generateByteCode(this);
                            s = this.constantPool.enterConstantPoolFieldRef(cArray, fieldSymbol.identifier.name, rawClassSymbol.getSignature());
                            this.generate_8((byte)89);
                            this.incOpStackHeight(1);
                            this.generate_8_16((byte)-77, s);
                            this.decOpStackHeight(1);
                            this.generateIntConst(--n);
                            this.incOpStackHeight(1);
                            this.generate_8_8((byte)95, (byte)83);
                            this.decOpStackHeight(3);
                            if (n == 0) break;
                            this.generate_8((byte)89);
                            this.incOpStackHeight(1);
                        }
                        fieldSymbol = fieldSymbol.nextInClass;
                    }
                    s = this.constantPool.enterConstantPoolFieldRef(cArray, Identifier.enumValuesInternal.name, ArraySymbol.getArrayType(rawClassSymbol, 1).getSignature());
                    this.generate_8_16((byte)-77, s);
                    this.decOpStackHeight(1);
                    if (!$assertionsDisabled && this.opStackHeight != 0) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    boolean finish() {
        this.flushCodeBuffer(false);
        byte[] byArray = this.methodSymbol.cmd.codeBuffer;
        Fixup fixup = this.fixupList;
        while (fixup != null) {
            int n = fixup.offset;
            int n2 = fixup.label.offset - (n - fixup.baseAdjustment);
            if (fixup.wideFlag) {
                byArray[n + 3] = (byte)n2;
                byArray[n + 2] = (byte)(n2 >> 8);
                byArray[n + 1] = (byte)(n2 >> 16);
                byArray[n] = (byte)(n2 >> 24);
            } else {
                if (n2 < Short.MIN_VALUE || Short.MAX_VALUE < n2) {
                    this.lineNumberCount = 0;
                    this.maxOpStackHeight = 0;
                    this.opStackHeight = 0;
                    this.codeBufferStartOffset = 0;
                    this.codeBufferIndex = 0;
                    this.prevLineOffset = -1;
                    this.fixupList = null;
                    this.wideFlag = true;
                    return false;
                }
                byArray[n + 1] = (byte)n2;
                byArray[n] = (byte)(n2 >> 8);
            }
            fixup = fixup.next;
        }
        if (!(!this.parser.options.localVariables || this.methodSymbol.isSynthetic() || this.methodSymbol.isGenerated() || this.methodSymbol.isDefaultConstructor() || this.methodSymbol.isBridgeMethod())) {
            this.generateLocalVariableTable(this.methodSymbol);
        }
        this.methodSymbol.cmd.maxOpStackDepth = this.maxOpStackHeight;
        if (this.lineNumberCount != 0) {
            this.methodSymbol.cmd.lineNumberTable = this.lineNumberTable;
            this.methodSymbol.cmd.lineNumberCount = this.lineNumberCount;
        }
        return true;
    }

    static {
        $assertionsDisabled = !ByteCodeGenerator.class.desiredAssertionStatus();
        short_load_opcode = new byte[12];
        ByteCodeGenerator.short_load_opcode[10] = 42;
        ByteCodeGenerator.short_load_opcode[11] = 42;
        ByteCodeGenerator.short_load_opcode[2] = 26;
        ByteCodeGenerator.short_load_opcode[3] = 26;
        ByteCodeGenerator.short_load_opcode[4] = 26;
        ByteCodeGenerator.short_load_opcode[5] = 26;
        ByteCodeGenerator.short_load_opcode[6] = 26;
        ByteCodeGenerator.short_load_opcode[7] = 30;
        ByteCodeGenerator.short_load_opcode[8] = 34;
        ByteCodeGenerator.short_load_opcode[9] = 38;
        load_opcode = new byte[12];
        ByteCodeGenerator.load_opcode[10] = 25;
        ByteCodeGenerator.load_opcode[11] = 25;
        ByteCodeGenerator.load_opcode[2] = 21;
        ByteCodeGenerator.load_opcode[3] = 21;
        ByteCodeGenerator.load_opcode[4] = 21;
        ByteCodeGenerator.load_opcode[5] = 21;
        ByteCodeGenerator.load_opcode[6] = 21;
        ByteCodeGenerator.load_opcode[7] = 22;
        ByteCodeGenerator.load_opcode[8] = 23;
        ByteCodeGenerator.load_opcode[9] = 24;
        short_store_opcode = new byte[12];
        ByteCodeGenerator.short_store_opcode[10] = 75;
        ByteCodeGenerator.short_store_opcode[11] = 75;
        ByteCodeGenerator.short_store_opcode[2] = 59;
        ByteCodeGenerator.short_store_opcode[3] = 59;
        ByteCodeGenerator.short_store_opcode[4] = 59;
        ByteCodeGenerator.short_store_opcode[5] = 59;
        ByteCodeGenerator.short_store_opcode[6] = 59;
        ByteCodeGenerator.short_store_opcode[7] = 63;
        ByteCodeGenerator.short_store_opcode[8] = 67;
        ByteCodeGenerator.short_store_opcode[9] = 71;
        store_opcode = new byte[12];
        ByteCodeGenerator.store_opcode[10] = 58;
        ByteCodeGenerator.store_opcode[11] = 58;
        ByteCodeGenerator.store_opcode[2] = 54;
        ByteCodeGenerator.store_opcode[3] = 54;
        ByteCodeGenerator.store_opcode[4] = 54;
        ByteCodeGenerator.store_opcode[5] = 54;
        ByteCodeGenerator.store_opcode[6] = 54;
        ByteCodeGenerator.store_opcode[7] = 55;
        ByteCodeGenerator.store_opcode[8] = 56;
        ByteCodeGenerator.store_opcode[9] = 57;
    }
}

