/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SwitchStatement;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class CaseStatement
extends LabelStatement {
    Expression caseExpr;
    int caseValue;

    CaseStatement(StatementList statementList, int n, Expression expression) {
        super(statementList, n, (byte)5, new Label());
        this.caseExpr = expression;
    }

    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        while (switchLoopList != null && switchLoopList.switchStmt == null) {
            switchLoopList = switchLoopList.outerSwitchLoop;
        }
        if (switchLoopList == null) {
            parser.error(Message.errorOrphanedSymbol, this.pos, false, "case");
        } else {
            Expression expression = this.caseExpr;
            this.caseExpr = null;
            if (expression != null) {
                ClassSymbol classSymbol;
                FieldExpression fieldExpression;
                int n = expression.pos;
                Expression expression2 = expression;
                TypeSymbol typeSymbol = switchLoopList.switchStmt.switchExpr.getType();
                if (typeSymbol.isEnum() && expression instanceof FieldExpression) {
                    fieldExpression = (FieldExpression)expression;
                    if (fieldExpression.qualification == null && fieldExpression.thisArgument == null && fieldExpression.field instanceof UnresolvedSymbol && ((UnresolvedSymbol)fieldExpression.field).qualifierList == null) {
                        classSymbol = (ClassSymbol)typeSymbol;
                        Symbol symbol = classSymbol.getClassScope().lookupSpecificSymbolInScope(fieldExpression.field.identifier, 2, true);
                        if (symbol != null) {
                            fieldExpression.field = symbol;
                            fieldExpression.setType(typeSymbol);
                        } else {
                            expression = expression.resolveAndCheck(parser);
                        }
                    } else {
                        parser.error(Message.errorQualifiedEnumCaseLabel, n, false);
                        expression = ErrorExpression.errorExpression;
                    }
                } else {
                    expression = expression.resolveAndCheck(parser);
                }
                TypeSymbol typeSymbol2 = expression.getType();
                byte by = typeSymbol2.typeClass;
                if ((by & 4) == 0) {
                    if (typeSymbol2.isEnum()) {
                        if (!typeSymbol2.equalTo(typeSymbol)) {
                            parser.error(Message.errorIncompatibleTypes, n, false, typeSymbol2.errorName(), typeSymbol.errorName());
                            return;
                        }
                    } else {
                        parser.error(Message.errorIncompatibleTypes, n, typeSymbol2.isErroneous(), typeSymbol2.errorName(), "int");
                        return;
                    }
                }
                if (typeSymbol2.isEnum()) {
                    if (!(expression instanceof FieldExpression)) {
                        parser.error(Message.errorConstantRequired, this.pos, false);
                    } else {
                        fieldExpression = (FieldExpression)expression;
                        FieldSymbol fieldSymbol = (FieldSymbol)fieldExpression.field;
                        if ((fieldSymbol.access & 0x4000) == 0) {
                            parser.error(Message.errorConstantRequired, this.pos, false);
                        } else {
                            classSymbol = (ClassSymbol)typeSymbol2;
                            this.caseValue = switchLoopList.switchStmt.emc.getEnumConst(classSymbol.getClassSymbol(), fieldSymbol);
                        }
                    }
                } else {
                    if (expression.kind != 2 || expression2 instanceof FieldExpression && ((FieldExpression)expression2).thisArgument != null) {
                        if (expression.kind != 0) {
                            parser.error(Message.errorConstantRequired, this.pos, false);
                        }
                        return;
                    }
                    if (expression.getType().typeKind == 4) {
                        CharConstantExpression charConstantExpression = (CharConstantExpression)expression;
                        this.caseValue = charConstantExpression.cval;
                    } else {
                        IntConstantExpression intConstantExpression = (IntConstantExpression)expression;
                        this.caseValue = intConstantExpression.ival;
                    }
                    switch (typeSymbol.typeKind) {
                        case 3: {
                            if (this.caseValue >= -128 && 127 >= this.caseValue) break;
                            parser.error(Message.errorIncompatibleTypes, n, false, typeSymbol2.errorName(), typeSymbol.errorName());
                            break;
                        }
                        case 5: {
                            if (this.caseValue >= Short.MIN_VALUE && Short.MAX_VALUE >= this.caseValue) break;
                            parser.error(Message.errorIncompatibleTypes, n, false, typeSymbol2.errorName(), typeSymbol.errorName());
                            break;
                        }
                        case 4: {
                            if (this.caseValue >= 0 && 65535 >= this.caseValue) break;
                            parser.error(Message.errorIncompatibleTypes, n, false, typeSymbol2.errorName(), typeSymbol.errorName());
                        }
                    }
                }
                switchLoopList.caseStmts.add(this);
                SwitchStatement switchStatement = switchLoopList.switchStmt;
                if (switchStatement.bodyStatements != this.parent) {
                    parser.error(Message.errorOrphanedSymbol, this.pos, false, "case");
                }
            }
            parser.defSet = (BitSet)switchLoopList.defSet.clone();
            if (this.prev != null) {
                if (!this.prev.canReachNextStatement(false)) {
                    parser.posSet = (BitSet)switchLoopList.posSet.clone();
                } else if (this.prev.kind != 5 && this.prev.kind != 6) {
                    parser.warning(null, Message.warningFallThrough, this.prev.pos);
                }
            }
        }
    }
}

