/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;

final class ClassExpression
extends Expression {
    TypeSymbol classType;

    ClassExpression(int n, TypeSymbol typeSymbol, Parser parser) {
        super((byte)48, n);
        this.classType = typeSymbol;
        if (parser.options.targetJDKVersion < 150) {
            parser.currentClassSymbol.flags = (short)(parser.currentClassSymbol.flags | 8);
        }
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        this.classType = typeSymbol = this.classType.resolveType(parser, this.pos, true, true);
        if (typeSymbol.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        typeSymbol.checkDeprecated(parser, this.pos);
        if (typeSymbol.isArrayType()) {
            typeSymbol = ((ArraySymbol)typeSymbol).baseType;
        }
        if (typeSymbol.isTypeParameter()) {
            parser.error(Message.errorIllegalTypeParameterOperator, this.pos, false, this.toString());
        }
        if (typeSymbol.isClass()) {
            DepInfo.addReference(parser.currentClassSymbol, ((ClassSymbol)typeSymbol).getClassSymbol());
        }
        TypeVariableList typeVariableList = null;
        if (parser.options.sourceJDKVersion >= 150 && typeSymbol.isReferenceType()) {
            typeVariableList = new TypeVariableList(new TypeVariableSymbol(0, 1, (ReferenceTypeSymbol)typeSymbol));
        }
        this.setType(ParameterizedClassSymbol.getParameterizedClassSymbol(parser.javaLangClassSymbol, typeVariableList, null));
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.classType.isPrimitiveType()) {
            short s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(TypeSymbol.classInternalName[this.classType.typeKind], Identifier.typeIdentifier.name, Identifier.javaLangClassSignature.name);
            byteCodeGenerator.generate_8_16((byte)-78, s);
        } else {
            TypeSymbol typeSymbol;
            if (byteCodeGenerator.parser.options.targetJDKVersion < 150) {
                String string;
                String string2;
                if (this.classType.isArrayType()) {
                    StringBuffer stringBuffer = new StringBuffer("[");
                    StringBuffer stringBuffer2 = new StringBuffer("array$");
                    int n = ((ArraySymbol)this.classType).dimension;
                    while (--n > 0) {
                        stringBuffer.append('[');
                        stringBuffer2.append('$');
                    }
                    typeSymbol = ((ArraySymbol)this.classType).baseType;
                    if (typeSymbol.isPrimitiveType()) {
                        char c = TypeSymbol.typeKindToSignature[typeSymbol.typeKind][0];
                        stringBuffer.append(c);
                        stringBuffer2.append(c);
                    } else {
                        String string3 = new String(typeSymbol.getInternalName());
                        stringBuffer.append('L');
                        stringBuffer.append(string3.replace('/', '.'));
                        stringBuffer.append(';');
                        stringBuffer2.append('L');
                        stringBuffer2.append(string3.replace('/', '$'));
                    }
                    string2 = stringBuffer.toString();
                    string = stringBuffer2.toString();
                } else {
                    string2 = new String(this.classType.getInternalName()).replace('/', '.');
                    string = "class$" + string2.replace('.', '$');
                }
                MethodSymbol methodSymbol = byteCodeGenerator.parser.currentClassSymbol.cd.ccd.classLoaderMethod;
                FieldSymbol fieldSymbol = methodSymbol.definingClass.getClassFieldSymbol(byteCodeGenerator.parser, string);
                short s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(methodSymbol.definingClass.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
                byteCodeGenerator.generate_8_16_8((byte)-78, s, (byte)89);
                byteCodeGenerator.incOpStackHeight(2);
                Label label = new Label();
                byteCodeGenerator.generateBranch_ifnonnull(label);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(2);
                short s2 = byteCodeGenerator.constantPool.enterConstantPoolString(string2.toCharArray());
                if (s2 > 255) {
                    byteCodeGenerator.generate_8_16((byte)19, s2);
                } else {
                    byteCodeGenerator.generate_8_8((byte)18, (byte)s2);
                }
                s2 = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
                byteCodeGenerator.generate_8_16_8((byte)-72, s2, (byte)89);
                byteCodeGenerator.generate_8_16((byte)-77, s);
                byteCodeGenerator.setLabel(label);
            } else {
                short s = byteCodeGenerator.constantPool.enterConstantPoolClass(this.classType.getInternalName());
                if (s > 255) {
                    byteCodeGenerator.generate_8_16((byte)19, s);
                } else {
                    byteCodeGenerator.generate_8_8((byte)18, (byte)s);
                }
            }
            RawClassSymbol rawClassSymbol = null;
            if (this.classType.isArrayType()) {
                typeSymbol = ((ArraySymbol)this.classType).baseType;
                if (typeSymbol.isClass()) {
                    rawClassSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                }
            } else {
                rawClassSymbol = ((ClassSymbol)this.classType).getClassSymbol();
            }
            if (rawClassSymbol != null) {
                byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(byteCodeGenerator.parser.currentClassSymbol, rawClassSymbol);
            }
        }
        byteCodeGenerator.incOpStackHeight(1);
    }

    public String toString() {
        return ".class";
    }
}

