/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPoolClass;
import oracle.ojc.compiler.ConstantPoolDouble;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.ConstantPoolFloat;
import oracle.ojc.compiler.ConstantPoolInteger;
import oracle.ojc.compiler.ConstantPoolLong;
import oracle.ojc.compiler.ConstantPoolString;
import oracle.ojc.compiler.ConstantPoolUtf8;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.interfaces.Storage;

final class ClassFileReader {
    private static final char[] syntheticName;
    private static final char[] constantValueName;
    private static final char[] exceptionsName;
    private static final char[] innerClassesName;
    private static final char[] deprecatedName;
    private static final char[] annotationDefaultName;
    private static final char[] runtimeVisibleAnnotationsName;
    private static final char[] runtimeInvisibleAnnotationsName;
    private static final char[] signatureName;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassFileReader() {
    }

    private static void signatureToArgumentList(Parser parser, MethodSymbol methodSymbol, char[] cArray, StorageScope storageScope) {
        short s = 0;
        short s2 = 0;
        int n = 0;
        int n2 = 1;
        ArgumentVariableList argumentVariableList = null;
        ArgumentVariableList argumentVariableList2 = null;
        if ((methodSymbol.access & 8) == 0) {
            s = 1;
        }
        try {
            block15: while (true) {
                TypeSymbol typeSymbol;
                char c = cArray[n2++];
                switch (c) {
                    default: {
                        return;
                    }
                    case ')': {
                        methodSymbol.actualArgCount = s;
                        methodSymbol.argCount = s2;
                        methodSymbol.argumentList = argumentVariableList;
                        return;
                    }
                    case 'L': {
                        int n3 = n2 - 1;
                        while ((c = cArray[n2++]) != ';') {
                        }
                        typeSymbol = storageScope.lookupSignature(cArray, n3);
                        if (typeSymbol != null) break;
                        typeSymbol = TypeSymbol.errorSymbol;
                        break;
                    }
                    case '[': {
                        while (true) {
                            ++n;
                            c = cArray[n2];
                            if (c != '[') continue block15;
                            ++n2;
                        }
                    }
                    case 'Z': {
                        typeSymbol = TypeSymbol.booleanSymbol;
                        break;
                    }
                    case 'B': {
                        typeSymbol = TypeSymbol.byteSymbol;
                        break;
                    }
                    case 'C': {
                        typeSymbol = TypeSymbol.charSymbol;
                        break;
                    }
                    case 'S': {
                        typeSymbol = TypeSymbol.shortSymbol;
                        break;
                    }
                    case 'I': {
                        typeSymbol = TypeSymbol.intSymbol;
                        break;
                    }
                    case 'J': {
                        typeSymbol = TypeSymbol.longSymbol;
                        break;
                    }
                    case 'F': {
                        typeSymbol = TypeSymbol.floatSymbol;
                        break;
                    }
                    case 'D': {
                        typeSymbol = TypeSymbol.doubleSymbol;
                    }
                }
                if (n > 0) {
                    typeSymbol = ArraySymbol.getArrayType(typeSymbol, n);
                    n = 0;
                }
                short s3 = s;
                s = (short)(s + 1);
                ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, methodSymbol, null, typeSymbol, 0, 0, null, s3);
                s2 = (short)(s2 + 1);
                if ((typeSymbol.typeClass & 0x28) != 0) {
                    s = (short)(s + 1);
                }
                ArgumentVariableList argumentVariableList3 = new ArgumentVariableList(argumentVariableSymbol);
                if (argumentVariableList == null) {
                    argumentVariableList = argumentVariableList2 = argumentVariableList3;
                    continue;
                }
                argumentVariableList2.next = argumentVariableList3;
                argumentVariableList2 = argumentVariableList3;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static TypeVariableList parseTypeArguments(Parser parser, CharBuffer charBuffer) {
        TypeVariableList typeVariableList = null;
        TypeVariableList typeVariableList2 = null;
        do {
            TypeVariableSymbol typeVariableSymbol;
            char c;
            if ((c = charBuffer.getChar()) == '*') {
                typeVariableSymbol = new TypeVariableSymbol(0, 0, null);
                charBuffer.skipChar();
            } else {
                byte by;
                if (c == '+') {
                    by = 2;
                    charBuffer.skipChar();
                } else if (c == '-') {
                    by = 3;
                    charBuffer.skipChar();
                } else {
                    by = 1;
                }
                typeVariableSymbol = new TypeVariableSymbol(0, by, (ReferenceTypeSymbol)ClassFileReader.parseFieldTypeSignature(parser, charBuffer));
            }
            TypeVariableList typeVariableList3 = new TypeVariableList(typeVariableSymbol);
            if (typeVariableList == null) {
                typeVariableList2 = typeVariableList = typeVariableList3;
                continue;
            }
            typeVariableList.next = typeVariableList3;
            typeVariableList = typeVariableList3;
        } while (charBuffer.getChar() != '>');
        charBuffer.skipChar();
        return typeVariableList2;
    }

    private static ClassSymbol parseClassTypeSignature(Parser parser, CharBuffer charBuffer) {
        UnresolvedClassSymbol unresolvedClassSymbol;
        block8: {
            IdentifierList identifierList;
            char c;
            Identifier identifier;
            StorageScope storageScope = parser.globalScope;
            charBuffer.skipChar();
            IdentifierList identifierList2 = null;
            IdentifierList identifierList3 = null;
            while (true) {
                identifier = charBuffer.nextIdentifier(false);
                c = charBuffer.nextChar();
                if (c != '/') {
                    if (identifierList3 != null) break;
                    storageScope = parser.unnamedPackageScope;
                    break;
                }
                identifierList = new IdentifierList(0, identifier);
                if (identifierList3 == null) {
                    identifierList3 = identifierList2 = identifierList;
                    continue;
                }
                identifierList2.next = identifierList;
                identifierList2 = identifierList;
            }
            TypeVariableList typeVariableList = null;
            if (c == '<') {
                typeVariableList = ClassFileReader.parseTypeArguments(parser, charBuffer);
                c = charBuffer.nextChar();
            }
            unresolvedClassSymbol = new UnresolvedClassSymbol(identifierList3, identifier, typeVariableList, storageScope);
            if (c != '$') break block8;
            identifierList2 = null;
            identifierList3 = null;
            while (true) {
                identifier = charBuffer.nextIdentifier(true);
                c = charBuffer.nextChar();
                if (c == '<') {
                    typeVariableList = ClassFileReader.parseTypeArguments(parser, charBuffer);
                    unresolvedClassSymbol = new UnresolvedClassSymbol(unresolvedClassSymbol, identifierList3, identifier, typeVariableList);
                    identifier = null;
                    c = charBuffer.nextChar();
                }
                if (c != '.') break;
                identifierList = new IdentifierList(0, identifier);
                if (identifierList3 == null) {
                    identifierList3 = identifierList2 = identifierList;
                    continue;
                }
                identifierList2.next = identifierList;
                identifierList2 = identifierList;
            }
            if (identifier != null) {
                unresolvedClassSymbol = new UnresolvedClassSymbol(unresolvedClassSymbol, identifierList3, identifier, null);
            }
        }
        return unresolvedClassSymbol;
    }

    private static TypeSymbol parseTypeSignature(Parser parser, CharBuffer charBuffer) {
        TypeSymbol typeSymbol;
        switch (charBuffer.getChar()) {
            default: {
                return ClassFileReader.parseFieldTypeSignature(parser, charBuffer);
            }
            case 'V': {
                typeSymbol = TypeSymbol.voidSymbol;
                break;
            }
            case 'Z': {
                typeSymbol = TypeSymbol.booleanSymbol;
                break;
            }
            case 'B': {
                typeSymbol = TypeSymbol.byteSymbol;
                break;
            }
            case 'S': {
                typeSymbol = TypeSymbol.shortSymbol;
                break;
            }
            case 'C': {
                typeSymbol = TypeSymbol.charSymbol;
                break;
            }
            case 'I': {
                typeSymbol = TypeSymbol.intSymbol;
                break;
            }
            case 'J': {
                typeSymbol = TypeSymbol.longSymbol;
                break;
            }
            case 'F': {
                typeSymbol = TypeSymbol.floatSymbol;
                break;
            }
            case 'D': {
                typeSymbol = TypeSymbol.doubleSymbol;
            }
        }
        charBuffer.skipChar();
        return typeSymbol;
    }

    private static TypeSymbol parseFieldTypeSignature(Parser parser, CharBuffer charBuffer) {
        switch (charBuffer.getChar()) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case '[': {
                int n = 1;
                while (true) {
                    charBuffer.skipChar();
                    if (charBuffer.getChar() != '[') break;
                    ++n;
                }
                TypeSymbol typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
                return ArraySymbol.getArrayType(typeSymbol, n);
            }
            case 'T': {
                charBuffer.skipChar();
                Identifier identifier = charBuffer.nextIdentifier(true);
                charBuffer.skipChar();
                return new TypeParameterSymbol(0, identifier, parser.javaLangObjectSymbol, 0, null);
            }
            case 'L': 
        }
        return ClassFileReader.parseClassTypeSignature(parser, charBuffer);
    }

    private static TypeParameterList parseFormalTypeParameters(Parser parser, CharBuffer charBuffer) {
        TypeParameterList typeParameterList;
        block4: {
            typeParameterList = null;
            char c = charBuffer.getChar();
            if (c != '<') break block4;
            charBuffer.skipChar();
            TypeParameterList typeParameterList2 = null;
            do {
                Identifier identifier = charBuffer.nextIdentifier(true);
                charBuffer.skipChar();
                c = charBuffer.getChar();
                if (c == ':') {
                    charBuffer.skipChar();
                }
                ClassSymbol classSymbol = (ClassSymbol)ClassFileReader.parseFieldTypeSignature(parser, charBuffer);
                ClassSymbolList classSymbolList = null;
                c = charBuffer.getChar();
                while (c == ':') {
                    charBuffer.skipChar();
                    ClassSymbolList classSymbolList2 = new ClassSymbolList((ClassSymbol)ClassFileReader.parseFieldTypeSignature(parser, charBuffer));
                    classSymbolList2.next = classSymbolList;
                    classSymbolList = classSymbolList2;
                    c = charBuffer.getChar();
                }
                TypeParameterSymbol typeParameterSymbol = new TypeParameterSymbol(0, identifier, classSymbol, 0, classSymbolList);
                TypeParameterList typeParameterList3 = new TypeParameterList(typeParameterSymbol);
                if (typeParameterList2 == null) {
                    typeParameterList = typeParameterList2 = typeParameterList3;
                    continue;
                }
                typeParameterList2.next = typeParameterList3;
                typeParameterList2 = typeParameterList3;
            } while (c != '>');
            charBuffer.skipChar();
        }
        return typeParameterList;
    }

    private static void parseFieldSignature(Parser parser, FieldSymbol fieldSymbol, char[] cArray) {
        fieldSymbol.type = ClassFileReader.parseFieldTypeSignature(parser, new CharBuffer(cArray));
    }

    private static void parseMethodSignature(Parser parser, MethodSymbol methodSymbol, char[] cArray) {
        TypeSymbol typeSymbol;
        TypeParameterList typeParameterList;
        CharBuffer charBuffer = new CharBuffer(cArray);
        methodSymbol.typeParameterList = typeParameterList = ClassFileReader.parseFormalTypeParameters(parser, charBuffer);
        TypeParameterList typeParameterList2 = typeParameterList;
        while (typeParameterList2 != null) {
            typeParameterList2.typeParameter.definingSymbol = methodSymbol;
            typeParameterList2 = typeParameterList2.next;
        }
        if (!$assertionsDisabled && charBuffer.getChar() != '(') {
            throw new AssertionError();
        }
        charBuffer.skipChar();
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        while (charBuffer.getChar() != ')') {
            if (!$assertionsDisabled && argumentVariableList == null) {
                throw new AssertionError();
            }
            typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
            argumentVariableList.argSymbol.type = typeSymbol.replaceTypeParameters(typeParameterList);
            argumentVariableList = argumentVariableList.next;
        }
        charBuffer.skipChar();
        typeSymbol = ClassFileReader.parseTypeSignature(parser, charBuffer);
        methodSymbol.resultType = typeSymbol.replaceTypeParameters(typeParameterList);
        while (charBuffer.more()) {
            if (!$assertionsDisabled && charBuffer.getChar() != '^') {
                throw new AssertionError();
            }
            charBuffer.skipChar();
            typeSymbol = ClassFileReader.parseFieldTypeSignature(parser, charBuffer);
            MethodSymbol.ThrowsList throwsList = new MethodSymbol.ThrowsList((ClassSymbol)typeSymbol.replaceTypeParameters(typeParameterList));
            throwsList.next = methodSymbol.throwsList;
            methodSymbol.throwsList = throwsList;
        }
    }

    private static TypeParameterList removeHiddenTypeParameters(TypeParameterList typeParameterList, TypeParameterList typeParameterList2) {
        TypeParameterList typeParameterList3 = typeParameterList;
        TypeParameterList typeParameterList4 = typeParameterList;
        while (typeParameterList4 != null) {
            TypeParameterList typeParameterList5 = typeParameterList2;
            while (typeParameterList5 != null) {
                if (typeParameterList4.typeParameter.identifier == typeParameterList5.typeParameter.identifier && typeParameterList3 == typeParameterList && typeParameterList4 == typeParameterList) {
                    typeParameterList3 = null;
                    break;
                }
                typeParameterList5 = typeParameterList5.next;
            }
            if (typeParameterList5 == null && typeParameterList3 != typeParameterList) {
                TypeParameterList typeParameterList6 = new TypeParameterList(typeParameterList4.typeParameter);
                typeParameterList6.next = typeParameterList3;
                typeParameterList3 = typeParameterList6;
            }
            typeParameterList4 = typeParameterList4.next;
        }
        return typeParameterList3;
    }

    private static void parseClassSignature(Parser parser, RawClassSymbol rawClassSymbol, char[] cArray) {
        TypeParameterList typeParameterList;
        CharBuffer charBuffer = new CharBuffer(cArray);
        rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x4000);
        RawClassSymbol.GenericClassData genericClassData = new RawClassSymbol.GenericClassData(rawClassSymbol.cd);
        rawClassSymbol.cd = genericClassData;
        genericClassData.typeParameterList = typeParameterList = ClassFileReader.parseFormalTypeParameters(parser, charBuffer);
        TypeParameterList typeParameterList2 = typeParameterList;
        while (typeParameterList2 != null) {
            typeParameterList2.typeParameter.definingSymbol = rawClassSymbol;
            typeParameterList2 = typeParameterList2.next;
        }
        MethodSymbol methodSymbol = genericClassData.methodList;
        while (methodSymbol != null) {
            typeParameterList2 = typeParameterList;
            if (methodSymbol.typeParameterList == null || (typeParameterList2 = ClassFileReader.removeHiddenTypeParameters(typeParameterList, methodSymbol.typeParameterList)) != null) {
                ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
                while (argumentVariableList != null) {
                    argumentVariableList.argSymbol.type = argumentVariableList.argSymbol.type.replaceTypeParameters(typeParameterList2);
                    argumentVariableList = argumentVariableList.next;
                }
                methodSymbol.resultType = methodSymbol.resultType.replaceTypeParameters(typeParameterList2);
                MethodSymbol.ThrowsList throwsList = methodSymbol.throwsList;
                while (throwsList != null) {
                    throwsList.throwsType = throwsList.throwsType.replaceTypeParameters(typeParameterList);
                    throwsList = throwsList.next;
                }
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        FieldSymbol fieldSymbol = genericClassData.fieldList;
        while (fieldSymbol != null) {
            fieldSymbol.type = fieldSymbol.type.replaceTypeParameters(typeParameterList2);
            fieldSymbol = fieldSymbol.nextInClass;
        }
        rawClassSymbol.superClass = ClassFileReader.parseClassTypeSignature(parser, charBuffer);
        rawClassSymbol.superClass.replaceTypeParameters(typeParameterList);
        if (charBuffer.more()) {
            ImplementationList implementationList = null;
            do {
                ClassSymbol classSymbol = ClassFileReader.parseClassTypeSignature(parser, charBuffer);
                classSymbol.replaceTypeParameters(typeParameterList);
                ImplementationList implementationList2 = new ImplementationList(classSymbol);
                implementationList2.next = implementationList;
                implementationList = implementationList2;
            } while (charBuffer.more());
            rawClassSymbol.setImplementationList(implementationList);
        }
    }

    private static boolean isSyntheticUtf8(char[] cArray) {
        return Identifier.compare(cArray, syntheticName);
    }

    private static boolean isConstantValueUtf8(char[] cArray) {
        return Identifier.compare(cArray, constantValueName);
    }

    private static boolean isExceptionsUtf8(char[] cArray) {
        return Identifier.compare(cArray, exceptionsName);
    }

    private static boolean isInnerClassesUtf8(char[] cArray) {
        return Identifier.compare(cArray, innerClassesName);
    }

    private static boolean isDeprecatedUtf8(char[] cArray) {
        return Identifier.compare(cArray, deprecatedName);
    }

    private static boolean isAnnotationDefaultUtf8(char[] cArray) {
        return Identifier.compare(cArray, annotationDefaultName);
    }

    private static boolean isRuntimeVisibleAnnotationsUtf8(char[] cArray) {
        return Identifier.compare(cArray, runtimeVisibleAnnotationsName);
    }

    private static boolean isRuntimeInvisibleAnnotationsUtf8(char[] cArray) {
        return Identifier.compare(cArray, runtimeInvisibleAnnotationsName);
    }

    private static boolean isSignatureUtf8(char[] cArray) {
        return Identifier.compare(cArray, signatureName);
    }

    private static int skipElementValue(byte[] byArray, int n) {
        switch (byArray[n]) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                n += 3;
                break;
            }
            case 101: {
                n += 5;
                break;
            }
            case 64: {
                n = ClassFileReader.skipAnnotation(byArray, n + 1);
                break;
            }
            case 91: {
                int n2 = byArray[n + 2] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
                n += 3;
                while (--n2 >= 0) {
                    n = ClassFileReader.skipElementValue(byArray, n);
                }
                break block0;
            }
        }
        return n;
    }

    private static int skipAnnotation(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8;
        n += 4;
        while (--n2 >= 0) {
            n = ClassFileReader.skipElementValue(byArray, n + 2);
        }
        return n;
    }

    static void readClassFile(Parser parser, int n, RawClassSymbol rawClassSymbol) {
        InnerClassSymbol innerClassSymbol;
        MethodSymbol methodSymbol;
        ImplementationList implementationList;
        ClassSymbol classSymbol;
        ClassSymbol classSymbol2;
        byte[] byArray;
        ClassScope classScope = new ClassScope(rawClassSymbol, rawClassSymbol.scope, parser);
        StorageScope storageScope = (StorageScope)rawClassSymbol.getTopLevelClass().scope;
        long l = System.currentTimeMillis();
        Storage storage = parser.options.findStorageOfClass(rawClassSymbol);
        if (storage == null) {
            return;
        }
        try {
            storage.open();
            byArray = storage.read();
            storage.close();
        }
        catch (IOException iOException) {
            parser.error(Message.errorCannotReadClass, 0, false, storage.getName(), storage.getCanonicalPath());
            return;
        }
        try {
            int n2;
            int n3;
            boolean bl;
            TypeSymbol typeSymbol;
            short s;
            int n4;
            int n5;
            String string;
            ConstantPoolUtf8 constantPoolUtf8;
            ConstantPoolClass constantPoolClass;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (byArray[3] != -66 || byArray[2] != -70 || byArray[1] != -2 || byArray[0] != -54) {
                parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                return;
            }
            switch (byArray[7]) {
                default: {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                    return;
                }
                case 45: {
                    if (byArray[6] != 0 || byArray[5] != 3 || byArray[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                        return;
                    }
                    n10 = 110;
                    break;
                }
                case 46: {
                    if (byArray[6] != 0 || byArray[5] != 0 || byArray[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                        return;
                    }
                    n10 = 120;
                    break;
                }
                case 47: {
                    if (byArray[6] != 0 || byArray[5] != 0 || byArray[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                        return;
                    }
                    n10 = 130;
                    break;
                }
                case 48: {
                    if (byArray[6] != 0 || byArray[5] != 0 || byArray[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                        return;
                    }
                    n10 = 140;
                    break;
                }
                case 49: {
                    if (byArray[6] != 0 || byArray[5] != 0 || byArray[4] != 0) {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                        return;
                    }
                    n10 = 150;
                }
            }
            boolean bl2 = parser.options.targetJDKVersion >= 150 && n10 >= 150;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = byArray[9] & 0xFF | (byArray[8] & 0xFF) << 8;
            ArrayList<ConstantPoolEntry> arrayList = new ArrayList<ConstantPoolEntry>(n20 + 1);
            arrayList.add(null);
            int n21 = 10;
            block35: for (n9 = 1; n9 < n20; ++n9) {
                switch (byArray[n21]) {
                    default: {
                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                        return;
                    }
                    case 7: {
                        arrayList.add(new ConstantPoolClass((short)(byArray[n21 + 2] & 0xFF | (byArray[n21 + 1] & 0xFF) << 8)));
                        n21 += 3;
                        continue block35;
                    }
                    case 8: {
                        arrayList.add(new ConstantPoolString((short)(byArray[n21 + 2] & 0xFF | (byArray[n21 + 1] & 0xFF) << 8)));
                        n21 += 3;
                        continue block35;
                    }
                    case 3: {
                        arrayList.add(new ConstantPoolInteger(byArray[n21 + 4] & 0xFF | (byArray[n21 + 3] & 0xFF) << 8 | (byArray[n21 + 2] & 0xFF) << 16 | (byArray[n21 + 1] & 0xFF) << 24));
                        n21 += 5;
                        continue block35;
                    }
                    case 4: {
                        arrayList.add(new ConstantPoolFloat(byArray[n21 + 4] & 0xFF | (byArray[n21 + 3] & 0xFF) << 8 | (byArray[n21 + 2] & 0xFF) << 16 | (byArray[n21 + 1] & 0xFF) << 24));
                        n21 += 5;
                        continue block35;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        arrayList.add(null);
                        n21 += 5;
                        continue block35;
                    }
                    case 5: {
                        arrayList.add(new ConstantPoolLong((long)byArray[n21 + 8] & 0xFFL | ((long)byArray[n21 + 7] & 0xFFL) << 8 | ((long)byArray[n21 + 6] & 0xFFL) << 16 | ((long)byArray[n21 + 5] & 0xFFL) << 24 | ((long)byArray[n21 + 4] & 0xFFL) << 32 | ((long)byArray[n21 + 3] & 0xFFL) << 40 | ((long)byArray[n21 + 2] & 0xFFL) << 48 | ((long)byArray[n21 + 1] & 0xFFL) << 56));
                        ++n9;
                        arrayList.add(null);
                        n21 += 9;
                        continue block35;
                    }
                    case 6: {
                        arrayList.add(new ConstantPoolDouble((long)byArray[n21 + 8] & 0xFFL | ((long)byArray[n21 + 7] & 0xFFL) << 8 | ((long)byArray[n21 + 6] & 0xFFL) << 16 | ((long)byArray[n21 + 5] & 0xFFL) << 24 | ((long)byArray[n21 + 4] & 0xFFL) << 32 | ((long)byArray[n21 + 3] & 0xFFL) << 40 | ((long)byArray[n21 + 2] & 0xFFL) << 48 | ((long)byArray[n21 + 1] & 0xFFL) << 56));
                        ++n9;
                        arrayList.add(null);
                        n21 += 9;
                        continue block35;
                    }
                    case 1: {
                        n8 = byArray[n21 + 2] & 0xFF | (byArray[n21 + 1] & 0xFF) << 8;
                        char[] cArray = new char[n8];
                        n21 += 3;
                        n7 = 0;
                        n6 = 0;
                        while (n6 < n8) {
                            byte by;
                            if (((by = byArray[n21 + n6++]) & 0x80) != 0) {
                                byte by2 = byArray[n21 + n6++];
                                if ((by & 0xE0) == 192) {
                                    cArray[n7++] = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                                    continue;
                                }
                                byte by3 = byArray[n21 + n6++];
                                cArray[n7++] = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                                continue;
                            }
                            cArray[n7++] = (char)(by & 0xFF);
                        }
                        if (n8 > n7) {
                            char[] cArray2 = new char[n7];
                            System.arraycopy(cArray, 0, cArray2, 0, n7);
                            cArray = cArray2;
                        }
                        if (ClassFileReader.isConstantValueUtf8(cArray)) {
                            n14 = n9;
                        } else if (ClassFileReader.isSyntheticUtf8(cArray)) {
                            n13 = n9;
                        } else if (ClassFileReader.isExceptionsUtf8(cArray)) {
                            n15 = n9;
                        } else if (ClassFileReader.isInnerClassesUtf8(cArray)) {
                            n12 = n9;
                        } else if (ClassFileReader.isDeprecatedUtf8(cArray)) {
                            n11 = n9;
                        }
                        if (bl2) {
                            if (ClassFileReader.isAnnotationDefaultUtf8(cArray)) {
                                n16 = n9;
                            } else if (ClassFileReader.isRuntimeVisibleAnnotationsUtf8(cArray)) {
                                n17 = n9;
                            } else if (ClassFileReader.isRuntimeInvisibleAnnotationsUtf8(cArray)) {
                                n18 = n9;
                            } else if (ClassFileReader.isSignatureUtf8(cArray)) {
                                n19 = n9;
                            }
                        }
                        arrayList.add(new ConstantPoolUtf8(cArray));
                        n21 += n8;
                    }
                }
            }
            classSymbol2 = null;
            n7 = byArray[n21 + 5] & 0xFF | (byArray[n21 + 4] & 0xFF) << 8;
            if (n7 == 0) {
                if (parser.javaLangObjectSymbol != null && rawClassSymbol != parser.javaLangObjectSymbol) {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                    return;
                }
                parser.options.javaLangObjectJDKVersion = n10;
            } else {
                constantPoolClass = (ConstantPoolClass)arrayList.get(n7);
                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(constantPoolClass.nameIndex);
                string = new String(constantPoolUtf8.string);
                classSymbol2 = storageScope.lookupClass(string);
                if (classSymbol2 == null) {
                    classSymbol2 = storageScope.enterClass(string);
                }
                rawClassSymbol.superClass = classSymbol2;
            }
            int n22 = byArray[n21 + 3] & 0xFF | (byArray[n21 + 2] & 0xFF) << 8;
            constantPoolClass = (ConstantPoolClass)arrayList.get(n22);
            constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(constantPoolClass.nameIndex);
            string = new String(constantPoolUtf8.string);
            if (!rawClassSymbol.equalTo(storageScope.lookupClass(string))) {
                parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                return;
            }
            rawClassSymbol.access = (short)(byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8);
            if ((rawClassSymbol.access & 0x2000) != 0) {
                rawClassSymbol.cd = new RawClassSymbol.AnnotationClassData();
            }
            ParameterizedClassSymbol.updateAccessOfExistingParameterizedClasses(rawClassSymbol);
            n8 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
            n21 += 8;
            ImplementationList implementationList2 = null;
            for (n9 = 0; n9 < n8; ++n9) {
                n7 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
                n21 += 2;
                constantPoolClass = (ConstantPoolClass)arrayList.get(n7);
                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(constantPoolClass.nameIndex);
                string = new String(constantPoolUtf8.string);
                classSymbol = storageScope.lookupClass(string);
                if (classSymbol == null) {
                    classSymbol = storageScope.enterClass(string);
                }
                implementationList = new ImplementationList(classSymbol);
                implementationList.next = implementationList2;
                implementationList2 = implementationList;
            }
            rawClassSymbol.setImplementationList(implementationList2);
            n8 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
            n21 += 2;
            for (n9 = 0; n9 < n8; ++n9) {
                n20 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                n5 = byArray[n21 + 5] & 0xFF | (byArray[n21 + 4] & 0xFF) << 8;
                n4 = byArray[n21 + 3] & 0xFF | (byArray[n21 + 2] & 0xFF) << 8;
                s = (short)(byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8);
                n21 += 8;
                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n5);
                typeSymbol = storageScope.lookupSignature(constantPoolUtf8.string, 0);
                if (typeSymbol == null) {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                    return;
                }
                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n4);
                FieldSymbol fieldSymbol = new FieldSymbol(0, rawClassSymbol, Identifier.getIdentifier(constantPoolUtf8.string), typeSymbol, 0, s, null);
                bl = true;
                if ((fieldSymbol.access & 0x1000) != 0) {
                    fieldSymbol.flags = (short)(fieldSymbol.flags | 1);
                    bl = false;
                }
                classScope.enterSymbol(fieldSymbol);
                while (--n20 >= 0) {
                    n7 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
                    if (n7 == n13) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 1);
                        bl = false;
                    } else if (n7 == n11) {
                        fieldSymbol.deprecate();
                    } else if (n7 == n14) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 2);
                        n7 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                        ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)arrayList.get(n7);
                        block19 : switch (constantPoolEntry.tag) {
                            default: {
                                parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                return;
                            }
                            case 3: {
                                ConstantPoolInteger constantPoolInteger = (ConstantPoolInteger)constantPoolEntry;
                                switch (typeSymbol.typeKind) {
                                    default: {
                                        parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                        return;
                                    }
                                    case 2: {
                                        fieldSymbol.initializer = new BooleanConstantExpression(0, constantPoolInteger.ival == 1);
                                        break block19;
                                    }
                                    case 4: {
                                        fieldSymbol.initializer = new CharConstantExpression(0, (char)constantPoolInteger.ival);
                                        break block19;
                                    }
                                    case 3: {
                                        IntConstantExpression intConstantExpression = new IntConstantExpression(0, TypeSymbol.byteSymbol, constantPoolInteger.ival);
                                        ((Expression)intConstantExpression).setType(TypeSymbol.byteSymbol);
                                        fieldSymbol.initializer = intConstantExpression;
                                        break block19;
                                    }
                                    case 5: {
                                        IntConstantExpression intConstantExpression = new IntConstantExpression(0, TypeSymbol.shortSymbol, constantPoolInteger.ival);
                                        ((Expression)intConstantExpression).setType(TypeSymbol.shortSymbol);
                                        fieldSymbol.initializer = intConstantExpression;
                                        break block19;
                                    }
                                    case 6: 
                                }
                                fieldSymbol.initializer = new IntConstantExpression(0, TypeSymbol.intSymbol, constantPoolInteger.ival);
                                break;
                            }
                            case 5: {
                                if (typeSymbol.typeKind != 7) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                    return;
                                }
                                ConstantPoolLong constantPoolLong = (ConstantPoolLong)constantPoolEntry;
                                fieldSymbol.initializer = new LongConstantExpression(0, constantPoolLong.lval);
                                break;
                            }
                            case 4: {
                                if (typeSymbol.typeKind != 8) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                    return;
                                }
                                ConstantPoolFloat constantPoolFloat = (ConstantPoolFloat)constantPoolEntry;
                                fieldSymbol.initializer = new FloatConstantExpression(0, Float.intBitsToFloat(constantPoolFloat.bits));
                                break;
                            }
                            case 6: {
                                if (typeSymbol.typeKind != 9) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                    return;
                                }
                                ConstantPoolDouble constantPoolDouble = (ConstantPoolDouble)constantPoolEntry;
                                fieldSymbol.initializer = new DoubleConstantExpression(0, Double.longBitsToDouble(constantPoolDouble.bits));
                                break;
                            }
                            case 8: {
                                if (typeSymbol.typeKind != 10) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                    return;
                                }
                                classSymbol = (ClassSymbol)typeSymbol;
                                if (classSymbol != parser.javaLangStringPcs && classSymbol != parser.javaLangObjectPcs) {
                                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                                    return;
                                }
                                ConstantPoolString constantPoolString = (ConstantPoolString)constantPoolEntry;
                                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(constantPoolString.strIndex);
                                fieldSymbol.initializer = new StringConstantExpression(0, parser.javaLangStringPcs, constantPoolUtf8.string);
                                break;
                            }
                        }
                    } else if (n7 == n19) {
                        n7 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                        constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                        ClassFileReader.parseFieldSignature(parser, fieldSymbol, constantPoolUtf8.string);
                    }
                    n3 = byArray[n21 + 5] & 0xFF | (byArray[n21 + 4] & 0xFF) << 8 | (byArray[n21 + 3] & 0xFF) << 16 | (byArray[n21 + 2] & 0xFF) << 24;
                    n21 += 2 + n3 + 4;
                }
                if (!bl) continue;
                rawClassSymbol.addField(fieldSymbol);
            }
            n8 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
            n21 += 2;
            for (n9 = 0; n9 < n8; ++n9) {
                n20 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                n5 = byArray[n21 + 5] & 0xFF | (byArray[n21 + 4] & 0xFF) << 8;
                n4 = byArray[n21 + 3] & 0xFF | (byArray[n21 + 2] & 0xFF) << 8;
                s = (short)(byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8);
                n21 += 8;
                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n5);
                char[] cArray = constantPoolUtf8.string;
                n7 = Identifier.lastIndexOf(cArray, ')') + 1;
                typeSymbol = storageScope.lookupSignature(cArray, n7);
                if (typeSymbol == null) {
                    parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
                    return;
                }
                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n4);
                Identifier identifier = Identifier.getIdentifier(constantPoolUtf8.string);
                methodSymbol = new MethodSymbol(0, rawClassSymbol, identifier, typeSymbol, 0, s, null, false);
                ClassFileReader.signatureToArgumentList(parser, methodSymbol, cArray, storageScope);
                bl = bl2 ? (methodSymbol.access & 0x1040) != 4096 : (methodSymbol.access & 0x1000) == 0;
                Symbol symbol = classScope.lookupSpecificSymbolInScope(identifier, 8, true);
                if (symbol == null) {
                    classScope.enterSymbol(methodSymbol);
                } else {
                    MethodSymbol methodSymbol2 = (MethodSymbol)symbol;
                    methodSymbol.nextWithSameName = methodSymbol2.nextWithSameName;
                    methodSymbol2.nextWithSameName = methodSymbol;
                }
                while (--n20 >= 0) {
                    n7 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
                    if (n7 == n13) {
                        bl = false;
                    } else if (n7 == n11) {
                        methodSymbol.deprecate();
                    } else if (n7 == n15) {
                        n2 = (byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8) * 2;
                        for (n6 = 0; n6 < n2; n6 += 2) {
                            n7 = byArray[n21 + n6 + 9] & 0xFF | (byArray[n21 + n6 + 8] & 0xFF) << 8;
                            constantPoolClass = (ConstantPoolClass)arrayList.get(n7);
                            constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(constantPoolClass.nameIndex);
                            string = new String(constantPoolUtf8.string);
                            classSymbol = storageScope.lookupClass(string);
                            if (classSymbol == null) {
                                classSymbol = storageScope.enterClass(string);
                            }
                            MethodSymbol.ThrowsList throwsList = new MethodSymbol.ThrowsList(classSymbol);
                            throwsList.next = methodSymbol.throwsList;
                            methodSymbol.throwsList = throwsList;
                        }
                    } else if (n7 == n19) {
                        n7 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                        constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                        ClassFileReader.parseMethodSignature(parser, methodSymbol, constantPoolUtf8.string);
                    } else if (n7 == n16) {
                        methodSymbol.flags = (short)(methodSymbol.flags | 0x40);
                    }
                    n3 = byArray[n21 + 5] & 0xFF | (byArray[n21 + 4] & 0xFF) << 8 | (byArray[n21 + 3] & 0xFF) << 16 | (byArray[n21 + 2] & 0xFF) << 24;
                    n21 += 2 + n3 + 4;
                }
                if (!bl) continue;
                methodSymbol.nextInClass = rawClassSymbol.cd.methodList;
                rawClassSymbol.cd.methodList = methodSymbol;
            }
            n20 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
            n21 += 2;
            while (--n20 >= 0) {
                n7 = byArray[n21 + 1] & 0xFF | (byArray[n21] & 0xFF) << 8;
                if (n7 == n11) {
                    rawClassSymbol.deprecate();
                } else if (n7 == n12) {
                    n2 = (byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8) * 8;
                    for (n6 = 0; n6 < n2; n6 += 8) {
                        n7 = byArray[n21 + n6 + 9] & 0xFF | (byArray[n21 + n6 + 8] & 0xFF) << 8;
                        if (n7 == n22) {
                            s = (short)(byArray[n21 + n6 + 15] & 0xFF | (byArray[n21 + n6 + 14] & 0xFF) << 8);
                            rawClassSymbol.access = (short)(rawClassSymbol.access & 0xFFFFFFF8);
                            rawClassSymbol.access = (short)(rawClassSymbol.access | s);
                            continue;
                        }
                        constantPoolClass = (ConstantPoolClass)arrayList.get(n7);
                        constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(constantPoolClass.nameIndex);
                        string = new String(constantPoolUtf8.string);
                        n7 = string.lastIndexOf(36);
                        String string2 = string.substring(n7 + 1);
                        n7 = byArray[n21 + n6 + 11] & 0xFF | (byArray[n21 + n6 + 10] & 0xFF) << 8;
                        if (n7 != n22 || (n7 = byArray[n21 + n6 + 13] & 0xFF | (byArray[n21 + n6 + 12] & 0xFF) << 8) == 0) continue;
                        constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                        string = new String(constantPoolUtf8.string);
                        if (string.equals("") || !string.equals(string2)) continue;
                        s = (short)(byArray[n21 + n6 + 15] & 0xFF | (byArray[n21 + n6 + 14] & 0xFF) << 8);
                        innerClassSymbol = new InnerClassSymbol(0, Identifier.getIdentifier(string), s, null, null, false);
                        classScope.enterSymbol(innerClassSymbol);
                        rawClassSymbol.addInnerClass(innerClassSymbol);
                    }
                } else if (n7 == n19) {
                    n7 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                    constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                    ClassFileReader.parseClassSignature(parser, rawClassSymbol, constantPoolUtf8.string);
                } else if (rawClassSymbol.isAnnotation()) {
                    RawClassSymbol.AnnotationClassData annotationClassData = (RawClassSymbol.AnnotationClassData)rawClassSymbol.cd;
                    if (n7 == n17 || n7 == n18) {
                        n2 = byArray[n21 + 7] & 0xFF | (byArray[n21 + 6] & 0xFF) << 8;
                        int n23 = n21 + 8;
                        while (--n2 >= 0) {
                            n7 = byArray[n23 + 1] & 0xFF | (byArray[n23] & 0xFF) << 8;
                            constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                            string = new String(constantPoolUtf8.string);
                            if (string.equals("Ljava/lang/annotation/Retention;")) {
                                n7 = byArray[n23 + 10] & 0xFF | (byArray[n23 + 9] & 0xFF) << 8;
                                constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                                string = new String(constantPoolUtf8.string);
                                if (string.equals("SOURCE")) {
                                    annotationClassData.retention = 0;
                                } else if (string.equals("CLASS")) {
                                    annotationClassData.retention = 1;
                                } else {
                                    if (!$assertionsDisabled && !string.equals("RUNTIME")) {
                                        throw new AssertionError();
                                    }
                                    annotationClassData.retention = (byte)2;
                                }
                                n23 += 11;
                                continue;
                            }
                            if (string.equals("Ljava/lang/annotation/Target;")) {
                                int n24 = byArray[n23 + 8] & 0xFF | (byArray[n23 + 7] & 0xFF) << 8;
                                n23 += 9;
                                while (--n24 >= 0) {
                                    n7 = byArray[n23 + 4] & 0xFF | (byArray[n23 + 3] & 0xFF) << 8;
                                    constantPoolUtf8 = (ConstantPoolUtf8)arrayList.get(n7);
                                    string = new String(constantPoolUtf8.string);
                                    if (string.equals("TYPE")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 1);
                                    } else if (string.equals("FIELD")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 2);
                                    } else if (string.equals("METHOD")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 4);
                                    } else if (string.equals("PARAMETER")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 8);
                                    } else if (string.equals("CONSTRUCTOR")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 0x10);
                                    } else if (string.equals("LOCAL_VARIABLE")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 0x20);
                                    } else if (string.equals("ANNOTATION_TYPE")) {
                                        annotationClassData.target = (byte)(annotationClassData.target | 0x40);
                                    } else {
                                        if (!$assertionsDisabled && !string.equals("PACKAGE")) {
                                            throw new AssertionError();
                                        }
                                        annotationClassData.target = (byte)(annotationClassData.target | 0xFFFFFF80);
                                    }
                                    n23 += 5;
                                }
                                continue;
                            }
                            n23 = ClassFileReader.skipAnnotation(byArray, n23);
                        }
                    }
                }
                n3 = byArray[n21 + 5] & 0xFF | (byArray[n21 + 4] & 0xFF) << 8 | (byArray[n21 + 3] & 0xFF) << 16 | (byArray[n21 + 2] & 0xFF) << 24;
                n21 += 2 + n3 + 4;
            }
        }
        catch (Exception exception) {
            parser.error(Message.errorClassFormatError, 0, false, storage.getName(), storage.getCanonicalPath());
            return;
        }
        rawClassSymbol.classScope = classScope;
        classSymbol2 = rawClassSymbol.superClass;
        if (classSymbol2 != null) {
            if (classSymbol2 instanceof UnresolvedClassSymbol) {
                rawClassSymbol.superClass = classSymbol2 = (ClassSymbol)classSymbol2.resolveType(parser, 0, false, false);
            }
            classSymbol2.getClassSymbol().loadType(parser, n, rawClassSymbol);
            rawClassSymbol.flags = (short)(rawClassSymbol.flags | classSymbol2.getClassSymbol().flags & 0xC00);
            if (rawClassSymbol.hasCompiledSuperclasses()) {
                parser.loadedClassesWithCompiledSuperclassesList.add(rawClassSymbol);
            }
        }
        if ((implementationList = rawClassSymbol.getImplementationList()) != null) {
            rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x400);
            do {
                if ((classSymbol = implementationList.interfaceSymbol) instanceof UnresolvedClassSymbol) {
                    implementationList.interfaceSymbol = classSymbol = (ClassSymbol)classSymbol.resolveType(parser, 0, false, false);
                }
                if (parser.javaIoSerializableSymbol != null && classSymbol.equalTo(parser.javaIoSerializableSymbol)) {
                    rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x800);
                }
                classSymbol.getClassSymbol().loadType(parser, n, rawClassSymbol);
            } while ((implementationList = implementationList.next) != null);
        }
        TypeParameterList typeParameterList = rawClassSymbol.cd.getTypeParameterList();
        while (typeParameterList != null) {
            classSymbol = typeParameterList.typeParameter.bound;
            if (classSymbol instanceof UnresolvedClassSymbol) {
                typeParameterList.typeParameter.bound = (ClassSymbol)classSymbol.resolveType(parser, 0, false, false);
            }
            ClassSymbolList classSymbolList = typeParameterList.typeParameter.interfaceBounds;
            while (classSymbolList != null) {
                classSymbol = classSymbolList.classSymbol;
                if (classSymbol instanceof UnresolvedClassSymbol) {
                    classSymbolList.classSymbol = (ClassSymbol)classSymbol.resolveType(parser, 0, false, false);
                }
                classSymbolList = classSymbolList.next;
            }
            typeParameterList = typeParameterList.next;
        }
        if (rawClassSymbol.isNonStaticInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)rawClassSymbol;
            methodSymbol = (MethodSymbol)rawClassSymbol.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
            while (methodSymbol != null) {
                if (!$assertionsDisabled && methodSymbol.argumentList == null) {
                    throw new AssertionError();
                }
                methodSymbol.argumentList = methodSymbol.argumentList.next;
                methodSymbol.argCount = (short)(methodSymbol.argCount - 1);
                innerClassSymbol.addHiddenOuterThisArgument(innerClassSymbol.getOuterClass(), null);
                methodSymbol = methodSymbol.nextWithSameName;
            }
        }
        rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x40);
        if (parser.options.verbose) {
            parser.options.log.println("[" + Message.loadingString + " " + storage.getCanonicalPath() + " " + (System.currentTimeMillis() - l) + "ms ]");
        }
    }

    static {
        $assertionsDisabled = !ClassFileReader.class.desiredAssertionStatus();
        syntheticName = new char[]{'S', 'y', 'n', 't', 'h', 'e', 't', 'i', 'c'};
        constantValueName = new char[]{'C', 'o', 'n', 's', 't', 'a', 'n', 't', 'V', 'a', 'l', 'u', 'e'};
        exceptionsName = new char[]{'E', 'x', 'c', 'e', 'p', 't', 'i', 'o', 'n', 's'};
        innerClassesName = new char[]{'I', 'n', 'n', 'e', 'r', 'C', 'l', 'a', 's', 's', 'e', 's'};
        deprecatedName = new char[]{'D', 'e', 'p', 'r', 'e', 'c', 'a', 't', 'e', 'd'};
        annotationDefaultName = new char[]{'A', 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', 'D', 'e', 'f', 'a', 'u', 'l', 't'};
        runtimeVisibleAnnotationsName = new char[]{'R', 'u', 'n', 't', 'i', 'm', 'e', 'V', 'i', 's', 'i', 'b', 'l', 'e', 'A', 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', 's'};
        runtimeInvisibleAnnotationsName = new char[]{'R', 'u', 'n', 't', 'i', 'm', 'e', 'I', 'n', 'v', 'i', 's', 'i', 'b', 'l', 'e', 'A', 'n', 'n', 'o', 't', 'a', 't', 'i', 'o', 'n', 's'};
        signatureName = new char[]{'S', 'i', 'g', 'n', 'a', 't', 'u', 'r', 'e'};
    }

    private static class CharBuffer {
        char[] array;
        int start;

        CharBuffer(char[] cArray) {
            this.array = cArray;
        }

        boolean more() {
            return this.start < this.array.length;
        }

        char getChar() {
            return this.array[this.start];
        }

        void skipChar() {
            ++this.start;
        }

        char nextChar() {
            return this.array[this.start++];
        }

        Identifier nextIdentifier(boolean bl) {
            int n;
            int n2 = n = this.start;
            block4: while (true) {
                switch (this.array[n]) {
                    default: {
                        ++n;
                        continue block4;
                    }
                    case '$': {
                        if (!bl) break block4;
                        ++n;
                        continue block4;
                    }
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '<': 
                }
                break;
            }
            this.start = n;
            return Identifier.getIdentifier(this.array, n2, n);
        }
    }
}

