/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;

final class ClassScope
extends Scope {
    private static final int CLASS_SYMBOLTABLE_SIZE = 32;
    Scope outerScope;
    RawClassSymbol classSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassScope(RawClassSymbol rawClassSymbol, Scope scope, Parser parser) {
        super((byte)2, 32, parser);
        this.classSymbol = rawClassSymbol;
        this.outerScope = scope;
    }

    Symbol lookupSymbol(Identifier identifier, boolean bl) {
        Symbol symbol;
        ClassScope classScope;
        ClassSymbol classSymbol = this.classSymbol;
        do {
            classScope = classSymbol.getClassScope();
            if (!$assertionsDisabled && classScope == null) {
                throw new AssertionError();
            }
            symbol = classScope.lookupSymbolInScope(identifier, bl);
            if (symbol == null) continue;
            return symbol;
        } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
        ImplementationList implementationList = this.classSymbol.getImplementationList();
        while (implementationList != null) {
            classScope = implementationList.interfaceSymbol.getClassScope();
            if (!$assertionsDisabled && classScope == null) {
                throw new AssertionError();
            }
            symbol = classScope.lookupSymbol(identifier, bl);
            if (symbol != null) {
                return symbol;
            }
            implementationList = implementationList.next;
        }
        classSymbol = this.classSymbol;
        block2: do {
            if (!classSymbol.isInnerClass()) continue;
            RawClassSymbol rawClassSymbol = classSymbol.getOuterClass();
            while (true) {
                if ((symbol = (classScope = rawClassSymbol.getClassScope()).lookupSymbolInScope(identifier, bl)) != null) {
                    return symbol;
                }
                if (!rawClassSymbol.isInnerClass()) continue block2;
                rawClassSymbol = ((ClassSymbol)rawClassSymbol).getOuterClass();
            }
        } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
        Scope scope = this.outerScope;
        if (scope.kind == 2) {
            classScope = (ClassScope)scope;
            if (classScope.classSymbol.isAnonymousInnerClass()) {
                scope = classScope.outerScope;
            }
        }
        return scope.lookupSymbol(identifier, bl);
    }

    Symbol lookupSpecificSymbol(Identifier identifier, int n, boolean bl) {
        Symbol symbol;
        ClassScope classScope;
        ClassSymbol classSymbol = this.classSymbol;
        do {
            if (classSymbol.isUnresolvedType()) {
                if (this.classSymbol.isAnonymousInnerClass()) {
                    return null;
                }
                throw new UnresolvedSuperClassException();
            }
            classScope = classSymbol.getClassScope();
            symbol = classScope.lookupSpecificSymbolInScope(identifier, n, bl);
            if (symbol == null) continue;
            return symbol;
        } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
        ImplementationList implementationList = this.classSymbol.getImplementationList();
        while (implementationList != null) {
            if (implementationList.interfaceSymbol instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException();
            }
            RawClassSymbol rawClassSymbol = implementationList.interfaceSymbol.getClassSymbol();
            symbol = rawClassSymbol.lookupSpecificSymbolInClass(this.parser, identifier, n, false);
            if (symbol != null) {
                return symbol;
            }
            implementationList = implementationList.next;
        }
        classSymbol = this.classSymbol;
        block2: do {
            if (!classSymbol.isInnerClass()) continue;
            RawClassSymbol rawClassSymbol = classSymbol.getOuterClass();
            while (true) {
                if ((symbol = (classScope = rawClassSymbol.getClassScope()).lookupSpecificSymbolInScope(identifier, n, bl)) != null) {
                    return symbol;
                }
                if (!rawClassSymbol.isInnerClass()) continue block2;
                rawClassSymbol = ((ClassSymbol)rawClassSymbol).getOuterClass();
            }
        } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
        Scope scope = this.outerScope;
        if (scope.kind == 2) {
            classScope = (ClassScope)scope;
            if (classScope.classSymbol.isAnonymousInnerClass()) {
                scope = classScope.outerScope;
            }
        }
        return scope.lookupSpecificSymbol(identifier, n, bl);
    }

    String errorName() {
        return this.classSymbol.errorName();
    }

    boolean isSubScopeOf(Scope scope) {
        if (this == scope) {
            return true;
        }
        return this.outerScope.isSubScopeOf(scope);
    }

    Scope getOuterScope() {
        return this.outerScope;
    }

    static {
        $assertionsDisabled = !ClassScope.class.desiredAssertionStatus();
    }
}

