/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class ConditionalExpression
extends Expression {
    Expression condition;
    Expression trueExpr;
    Expression falseExpr;
    BitSet trueDefSet;
    BitSet falseDefSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConditionalExpression(int n, Expression expression, Expression expression2, Expression expression3) {
        super((byte)29, n);
        this.condition = expression;
        this.trueExpr = expression2;
        this.falseExpr = expression3;
    }

    boolean takeAssignmentContext() {
        return true;
    }

    Expression foldExpression() {
        if (this.condition.kind == 2) {
            Expression expression = ((BooleanConstantExpression)this.condition).bval ? this.trueExpr : this.falseExpr;
            TypeSymbol typeSymbol = this.getType();
            if (expression.getType().equalTo(typeSymbol)) {
                return expression;
            }
            expression = new CastExpression(this.pos, expression, typeSymbol);
            expression.setType(typeSymbol);
            return expression;
        }
        return this;
    }

    Expression constantFolding() {
        this.condition = this.condition.constantFolding();
        return this.foldExpression();
    }

    private Expression findAndSetCommonType(Parser parser, Expression expression, Expression expression2) {
        TypeSymbol typeSymbol;
        TypeSymbol typeSymbol2 = expression.getType();
        if (typeSymbol2.equalTo(typeSymbol = expression2.getType())) {
            this.setType(typeSymbol2);
            this.trueExpr = expression;
            this.falseExpr = expression2;
            return this.foldExpression();
        }
        if ((typeSymbol2.typeClass & 0x3C) != 0) {
            if ((typeSymbol.typeClass & 0x3C) != 0) {
                byte by = typeSymbol2.typeKind;
                byte by2 = typeSymbol.typeKind;
                if (by == 3 && by2 == 5) {
                    this.trueExpr = expression.promoteType(parser, typeSymbol);
                    this.falseExpr = expression2;
                    this.setType(typeSymbol);
                    return this.foldExpression();
                }
                if (by == 5 && by2 == 3) {
                    this.trueExpr = expression;
                    this.falseExpr = expression2.promoteType(parser, typeSymbol2);
                    this.setType(typeSymbol2);
                    return this.foldExpression();
                }
                if (expression.kind == 2 && (typeSymbol2.typeClass & 4) != 0) {
                    int n = ((ConstantExpression)expression).getIntConstValue();
                    if (by2 == 3 && -128 <= n && n <= 127 || by2 == 5 && Short.MIN_VALUE <= n && n <= Short.MAX_VALUE || by2 == 4 && 0 <= n && n <= 65535) {
                        this.trueExpr = expression.promoteType(parser, typeSymbol);
                        this.falseExpr = expression2;
                        this.setType(typeSymbol);
                        return this.foldExpression();
                    }
                } else if (expression2.kind == 2 && (typeSymbol.typeClass & 4) != 0) {
                    int n = ((ConstantExpression)expression2).getIntConstValue();
                    if (by == 3 && -128 <= n && n <= 127 || by == 5 && Short.MIN_VALUE <= n && n <= Short.MAX_VALUE || by == 4 && 0 <= n && n <= 65535) {
                        this.trueExpr = expression;
                        this.falseExpr = expression2.promoteType(parser, typeSymbol2);
                        this.setType(typeSymbol2);
                        return this.foldExpression();
                    }
                }
                TypeSymbol typeSymbol3 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol2, typeSymbol);
                this.setType(typeSymbol3);
                this.trueExpr = expression.promoteType(parser, typeSymbol3);
                this.falseExpr = expression2.promoteType(parser, typeSymbol3);
                return this.foldExpression();
            }
        } else if ((typeSymbol2.typeClass & 0xFFFFFFC0) != 0 && (typeSymbol.typeClass & 0xFFFFFFC0) != 0) {
            ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol;
            ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol2;
            TypeSymbol typeSymbol4 = null;
            if (referenceTypeSymbol == ReferenceTypeSymbol.nullTypeSymbol) {
                typeSymbol4 = typeSymbol2;
            } else if (referenceTypeSymbol2 == ReferenceTypeSymbol.nullTypeSymbol) {
                typeSymbol4 = typeSymbol;
            } else if (referenceTypeSymbol.isAssignmentCompatible(parser, referenceTypeSymbol2)) {
                typeSymbol4 = typeSymbol2;
            } else if (referenceTypeSymbol2.isAssignmentCompatible(parser, referenceTypeSymbol)) {
                typeSymbol4 = typeSymbol;
            }
            if (typeSymbol4 == null && parser.options.sourceJDKVersion >= 150) {
                if (typeSymbol.involvesGenerics() && typeSymbol2.involvesGenerics()) {
                    typeSymbol4 = InvokeExpression.computeLeastUpperBound(parser, (ClassSymbol)typeSymbol, (ClassSymbol)typeSymbol2);
                }
                if (typeSymbol4 == null && !typeSymbol.isInterface() && !typeSymbol2.isInterface()) {
                    typeSymbol4 = ConditionalExpression.findCommonSuperclass(parser, typeSymbol, typeSymbol2);
                }
            }
            if (typeSymbol4 != null) {
                this.setType(typeSymbol4);
                this.trueExpr = expression.promoteType(parser, typeSymbol4);
                this.falseExpr = expression2.promoteType(parser, typeSymbol4);
                return this.foldExpression();
            }
        }
        return null;
    }

    Expression resolveAndCheck(Parser parser) {
        Error error;
        TypeSymbol typeSymbol = parser.assignmentContext;
        parser.assignmentContext = null;
        Expression expression = this.condition.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        byte by = typeSymbol2.typeKind;
        if (by != 2) {
            if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.equalTo(parser.javaLangBooleanSymbol)) {
                typeSymbol2 = TypeSymbol.booleanSymbol;
                expression = expression.promoteType(parser, typeSymbol2);
            } else {
                error = parser.error(Message.errorIncompatibleTypes, expression.pos, typeSymbol2.isErroneous(), typeSymbol2.errorName(), "boolean");
                expression = new ErrorExpression(error);
            }
        }
        this.condition = expression;
        BitSet bitSet = (BitSet)parser.defSet.clone();
        BitSet bitSet2 = (BitSet)parser.posSet.clone();
        BitSet bitSet3 = (BitSet)parser.useSet.clone();
        if (expression.isLogicalExpression()) {
            parser.defSet = expression.getLogicalExpressionTrueDefSet();
        }
        boolean bl = parser.suspendDataFlowChecking;
        if (expression.isConstantBooleanExpression() && !expression.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        if (this.trueExpr.takeAssignmentContext()) {
            parser.assignmentContext = typeSymbol;
        }
        Expression expression2 = this.trueExpr.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = bl;
        BitSet bitSet4 = parser.defSet;
        BitSet bitSet5 = parser.posSet;
        BitSet bitSet6 = parser.useSet;
        parser.posSet = bitSet2;
        parser.useSet = bitSet3;
        parser.defSet = expression.isLogicalExpression() ? expression.getLogicalExpressionFalseDefSet() : bitSet;
        if (expression.isConstantBooleanExpression() && expression.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        if (this.falseExpr.takeAssignmentContext()) {
            parser.assignmentContext = typeSymbol;
        }
        Expression expression3 = this.falseExpr.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = bl;
        TypeSymbol typeSymbol3 = expression2.getType();
        TypeSymbol typeSymbol4 = expression3.getType();
        if (typeSymbol3.isErroneous() || typeSymbol4.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        if (expression2.isLogicalExpression()) {
            this.trueDefSet = expression2.getLogicalExpressionTrueDefSet();
            this.falseDefSet = expression2.getLogicalExpressionFalseDefSet();
        } else {
            this.trueDefSet = (BitSet)bitSet4.clone();
            this.falseDefSet = (BitSet)bitSet4.clone();
        }
        if (expression3.isLogicalExpression()) {
            this.trueDefSet.and(expression3.getLogicalExpressionTrueDefSet());
            this.falseDefSet.and(expression3.getLogicalExpressionFalseDefSet());
        } else {
            this.trueDefSet.and(parser.defSet);
            this.falseDefSet.and(parser.defSet);
        }
        if (expression.isConstantBooleanExpression()) {
            if (expression.getConstantBooleanExpressionValue()) {
                parser.defSet = bitSet4;
                parser.useSet = bitSet6;
            }
        } else {
            parser.defSet.and(bitSet4);
            parser.posSet.or(bitSet5);
            parser.useSet.or(bitSet6);
        }
        if (typeSymbol3.equalTo(typeSymbol4)) {
            this.setType(typeSymbol3);
            this.trueExpr = expression2;
            this.falseExpr = expression3;
            return this.foldExpression();
        }
        if (parser.options.sourceJDKVersion >= 150) {
            TypeSymbol typeSymbol5;
            Expression expression4 = expression2;
            if (typeSymbol3.isReferenceType() && (typeSymbol5 = BoxingExpression.getPrimitiveType(parser, typeSymbol3)) != null) {
                expression4 = expression2.promoteType(parser, typeSymbol5);
            }
            Expression expression5 = expression3;
            if (typeSymbol4.isReferenceType() && (typeSymbol5 = BoxingExpression.getPrimitiveType(parser, typeSymbol4)) != null) {
                expression5 = expression3.promoteType(parser, typeSymbol5);
            }
            if ((expression2 != expression4 || expression3 != expression5) && (expression = this.findAndSetCommonType(parser, expression4, expression5)) != null) {
                return expression;
            }
        }
        if ((expression = this.findAndSetCommonType(parser, expression2, expression3)) != null) {
            return expression;
        }
        error = parser.error(Message.errorIncompatibleTypes, expression2.pos, typeSymbol4.isErroneous() | typeSymbol3.isErroneous(), typeSymbol3.errorName(), typeSymbol4.errorName());
        return new ErrorExpression(error);
    }

    boolean isConstantBooleanExpression() {
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.getConstantBooleanExpressionValue()) {
                return this.trueExpr.isConstantBooleanExpression();
            }
            return this.falseExpr.isConstantBooleanExpression();
        }
        if (this.trueExpr.isConstantBooleanExpression() && this.falseExpr.isConstantBooleanExpression()) {
            return this.trueExpr.getConstantBooleanExpressionValue() == this.falseExpr.getConstantBooleanExpressionValue();
        }
        return false;
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$assertionsDisabled && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.getConstantBooleanExpressionValue()) {
                return this.trueExpr.getConstantBooleanExpressionValue();
            }
            return this.falseExpr.getConstantBooleanExpressionValue();
        }
        return this.trueExpr.getConstantBooleanExpressionValue();
    }

    boolean isLogicalExpression() {
        return true;
    }

    BitSet getLogicalExpressionTrueDefSet() {
        return this.trueDefSet;
    }

    BitSet getLogicalExpressionFalseDefSet() {
        return this.falseDefSet;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.kind != 2) {
                this.condition.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (this.condition.getConstantBooleanExpressionValue()) {
                this.trueExpr.generateByteCode(byteCodeGenerator);
            } else {
                this.falseExpr.generateByteCode(byteCodeGenerator);
            }
        } else {
            Label label = new Label();
            this.condition.generateByteCodeBranch(byteCodeGenerator, label, true);
            int n = byteCodeGenerator.getOpStackHeight();
            boolean bl = byteCodeGenerator.doingStringConcatonation;
            byteCodeGenerator.doingStringConcatonation = false;
            this.trueExpr.generateByteCode(byteCodeGenerator);
            Label label2 = new Label();
            byteCodeGenerator.generateBranch_goto(label2);
            byteCodeGenerator.setLabel(label);
            byteCodeGenerator.setOpStackHeight(n);
            byteCodeGenerator.doingStringConcatonation = false;
            this.falseExpr.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.doingStringConcatonation = bl;
            byteCodeGenerator.setLabel(label2);
        }
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean bl) {
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.kind != 2) {
                this.condition.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (this.condition.getConstantBooleanExpressionValue()) {
                this.trueExpr.generateByteCodeBranch(byteCodeGenerator, label, bl);
            } else {
                this.falseExpr.generateByteCodeBranch(byteCodeGenerator, label, bl);
            }
        } else {
            Label label2 = new Label();
            this.condition.generateByteCodeBranch(byteCodeGenerator, label2, true);
            int n = byteCodeGenerator.getOpStackHeight();
            this.trueExpr.generateByteCodeBranch(byteCodeGenerator, label, bl);
            Label label3 = new Label();
            byteCodeGenerator.generateBranch_goto(label3);
            byteCodeGenerator.setLabel(label2);
            byteCodeGenerator.setOpStackHeight(n);
            this.falseExpr.generateByteCodeBranch(byteCodeGenerator, label, bl);
            byteCodeGenerator.setLabel(label3);
        }
    }

    public String toString() {
        return "?:";
    }

    static {
        $assertionsDisabled = !ConditionalExpression.class.desiredAssertionStatus();
    }
}

