/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolEntry;

final class ConstantPoolFloat
extends ConstantPoolEntry {
    ConstantPoolFloat nextHashed;
    int bits;

    ConstantPoolFloat(int n) {
        super((byte)4);
        this.bits = n;
    }

    int write(ClassFileWriter classFileWriter) throws IOException {
        int n = classFileWriter.ensureWriteBufferCapacity(5);
        byte[] byArray = classFileWriter.writeBuffer;
        byArray[n + 4] = (byte)this.bits;
        byArray[n + 3] = (byte)(this.bits >> 8);
        byArray[n + 2] = (byte)(this.bits >> 16);
        byArray[n + 1] = (byte)(this.bits >> 24);
        byArray[n] = 4;
        classFileWriter.writeBufferIndex = n + 5;
        return 0;
    }

    static int hashCode(int n) {
        return n;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ConstantPoolFloat.hashCode(this.bits);
        }
        return this.hash;
    }
}

