/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.Identifier;

abstract class ConstantPoolRef
extends ConstantPoolEntry {
    char[] className;
    char[] name;
    char[] signature;
    short classIndex;
    short nameAndTypeIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConstantPoolRef(byte by, ConstantPool constantPool, char[] cArray, char[] cArray2, char[] cArray3) {
        super(by);
        this.className = cArray;
        this.name = cArray2;
        this.signature = cArray3;
        this.classIndex = constantPool.enterConstantPoolClass(cArray);
        this.nameAndTypeIndex = constantPool.enterConstantPoolNameAndType(cArray2, cArray3);
    }

    int write(ClassFileWriter classFileWriter) throws IOException {
        int n = classFileWriter.ensureWriteBufferCapacity(5);
        byte[] byArray = classFileWriter.writeBuffer;
        byArray[n + 4] = (byte)this.nameAndTypeIndex;
        byArray[n + 3] = (byte)(this.nameAndTypeIndex >> 8);
        byArray[n + 2] = (byte)this.classIndex;
        byArray[n + 1] = (byte)(this.classIndex >> 8);
        byArray[n] = this.tag;
        classFileWriter.writeBufferIndex = n + 5;
        return 0;
    }

    public int hashCode() {
        if (!($assertionsDisabled || this.className != null && this.name != null && this.signature != null)) {
            throw new AssertionError();
        }
        if (this.hash == 0) {
            this.hash = Identifier.hashCode(this.className) + Identifier.hashCode(this.name) + Identifier.hashCode(this.signature);
        }
        return this.hash;
    }

    static {
        $assertionsDisabled = !ConstantPoolRef.class.desiredAssertionStatus();
    }
}

