/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SwitchStatement;

final class DefaultStatement
extends LabelStatement {
    DefaultStatement(StatementList statementList, int n) {
        super(statementList, n, (byte)6, new Label());
    }

    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        while (switchLoopList != null && switchLoopList.switchStmt == null) {
            switchLoopList = switchLoopList.outerSwitchLoop;
        }
        if (switchLoopList == null) {
            parser.error(Message.errorOrphanedSymbol, this.pos, false, "default");
        } else {
            SwitchStatement switchStatement = switchLoopList.switchStmt;
            if (switchStatement.bodyStatements != this.parent) {
                parser.error(Message.errorOrphanedSymbol, this.pos, false, "default");
            }
            if (switchStatement.defaultStmt != this) {
                if (switchStatement.defaultStmt != null) {
                    parser.error(Message.errorDuplicateDefault, this.pos, false);
                }
                switchStatement.defaultStmt = this;
            }
            parser.defSet = (BitSet)switchLoopList.defSet.clone();
            if (this.prev != null) {
                if (!this.prev.canReachNextStatement(false)) {
                    parser.posSet = (BitSet)switchLoopList.posSet.clone();
                } else if (this.prev.kind != 5 && this.prev.kind != 6) {
                    parser.warning(null, Message.warningFallThrough, this.prev.pos);
                }
            }
        }
    }
}

