/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.ojc.compiler.ClassFileInfo;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ConstantPoolClass;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.SourceFileInfo;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

class DepInfo {
    static boolean rebaseCdi;
    static Hashtable sources;
    private static Hashtable classes;
    private static ArrayList newAddedClasses;
    private static HashMap references;
    private static final int MAGIC_HEADER = 305419897;
    private static final int MAGIC_HEADER_9_0_2 = 0x9000200;
    private static final int MAGIC_HEADER_9_0_5 = 0x9000500;
    private static byte[] buffer;
    private static int bufidx;
    static final /* synthetic */ boolean $assertionsDisabled;

    DepInfo() {
    }

    private static String lowerCase(String string) {
        char[] cArray = string.toCharArray();
        block28: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case 'A': {
                    cArray[i] = 97;
                    continue block28;
                }
                case 'B': {
                    cArray[i] = 98;
                    continue block28;
                }
                case 'C': {
                    cArray[i] = 99;
                    continue block28;
                }
                case 'D': {
                    cArray[i] = 100;
                    continue block28;
                }
                case 'E': {
                    cArray[i] = 101;
                    continue block28;
                }
                case 'F': {
                    cArray[i] = 102;
                    continue block28;
                }
                case 'G': {
                    cArray[i] = 103;
                    continue block28;
                }
                case 'H': {
                    cArray[i] = 104;
                    continue block28;
                }
                case 'I': {
                    cArray[i] = 105;
                    continue block28;
                }
                case 'J': {
                    cArray[i] = 106;
                    continue block28;
                }
                case 'K': {
                    cArray[i] = 107;
                    continue block28;
                }
                case 'L': {
                    cArray[i] = 108;
                    continue block28;
                }
                case 'M': {
                    cArray[i] = 109;
                    continue block28;
                }
                case 'N': {
                    cArray[i] = 110;
                    continue block28;
                }
                case 'O': {
                    cArray[i] = 111;
                    continue block28;
                }
                case 'P': {
                    cArray[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    cArray[i] = 113;
                    continue block28;
                }
                case 'R': {
                    cArray[i] = 114;
                    continue block28;
                }
                case 'S': {
                    cArray[i] = 115;
                    continue block28;
                }
                case 'T': {
                    cArray[i] = 116;
                    continue block28;
                }
                case 'U': {
                    cArray[i] = 117;
                    continue block28;
                }
                case 'V': {
                    cArray[i] = 118;
                    continue block28;
                }
                case 'W': {
                    cArray[i] = 119;
                    continue block28;
                }
                case 'X': {
                    cArray[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    cArray[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    cArray[i] = 122;
                    continue block28;
                }
                default: {
                    if (cArray[i] < '\u0080') continue block28;
                    return string.toLowerCase();
                }
            }
        }
        return new String(cArray);
    }

    public static String fixKey(String string) {
        if (File.separatorChar == '\\') {
            return DepInfo.lowerCase(string);
        }
        return string;
    }

    public static void addReference(RawClassSymbol rawClassSymbol, RawClassSymbol rawClassSymbol2) {
        if (rawClassSymbol != rawClassSymbol2) {
            boolean bl;
            HashSet<RawClassSymbol> hashSet = (HashSet<RawClassSymbol>)references.get(rawClassSymbol);
            boolean bl2 = bl = hashSet == null;
            if (bl) {
                hashSet = new HashSet<RawClassSymbol>();
            }
            if (!hashSet.contains(rawClassSymbol2)) {
                hashSet.add(rawClassSymbol2);
            }
            if (bl) {
                references.put(rawClassSymbol, hashSet);
            }
        }
    }

    private static String qualName(RawClassSymbol rawClassSymbol) {
        if (rawClassSymbol == null) {
            return "";
        }
        return new String(rawClassSymbol.getInternalName()).replace('/', '.');
    }

    public static void addClass(RawClassSymbol rawClassSymbol, ConstantPool constantPool, Parser parser) {
        if (rawClassSymbol != null) {
            String string = DepInfo.qualName(rawClassSymbol);
            ClassFileInfo classFileInfo = (ClassFileInfo)classes.get(string);
            if (classFileInfo == null) {
                classFileInfo = new ClassFileInfo(string, rawClassSymbol, -1L);
                classes.put(string, classFileInfo);
            } else {
                classFileInfo.depClasses.clear();
                classFileInfo.pos = 0;
                classFileInfo.modDate = -1L;
                classFileInfo.rcs = rawClassSymbol;
            }
            newAddedClasses.add(classFileInfo);
            HashSet hashSet = (HashSet)references.get(rawClassSymbol);
            references.remove(rawClassSymbol);
            for (int i = 0; i < constantPool.constantPoolClassHashTable.length; ++i) {
                ConstantPoolClass constantPoolClass = constantPool.constantPoolClassHashTable[i];
                while (constantPoolClass != null) {
                    String string2;
                    String string3 = new String(constantPoolClass.className);
                    int n = string3.indexOf(36);
                    if (n >= 0) {
                        string3 = string3.substring(0, n);
                    }
                    if ((rawClassSymbol = parser.globalScope.lookupClass(string3).getClassSymbol()) == null) {
                        System.out.println("error in DepInfo.addClass(): can't lookup " + string3 + " outerClassName is " + classFileInfo.className);
                        if (!$assertionsDisabled && rawClassSymbol == null) {
                            throw new AssertionError();
                        }
                    }
                    if (!(string2 = DepInfo.qualName(rawClassSymbol)).equals(classFileInfo.className) && rawClassSymbol != null) {
                        classFileInfo.addClassFileInfo(string2, rawClassSymbol, classes);
                        if (hashSet != null && hashSet.contains(rawClassSymbol)) {
                            hashSet.remove(rawClassSymbol);
                        }
                    }
                    constantPoolClass = constantPoolClass.nextHashed;
                }
            }
            if (hashSet != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    rawClassSymbol = (RawClassSymbol)iterator.next();
                    classFileInfo.addClassFileInfo(DepInfo.qualName(rawClassSymbol), rawClassSymbol, classes);
                }
            }
        }
    }

    public static void addClassDate(RawClassSymbol rawClassSymbol, long l) {
        for (int i = newAddedClasses.size() - 1; i >= 0; --i) {
            ClassFileInfo classFileInfo = (ClassFileInfo)newAddedClasses.get(i);
            if (classFileInfo.rcs != rawClassSymbol) continue;
            classFileInfo.modDate = l;
            break;
        }
    }

    public static ArrayList analyzeSources(ArrayList arrayList, Options options) {
        Object object;
        Object object2;
        Iterator iterator;
        try {
            DepInfo.read(options.makeFile);
        }
        catch (IOException iOException) {
            DepInfo.clear();
        }
        if (options.rebuild) {
            return arrayList;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(arrayList.size());
        HashMap hashMap2 = new HashMap(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            iterator = (Storage)arrayList.get(i);
            object2 = DepInfo.fixKey(iterator.getPath());
            hashMap2.put((String)object2, iterator);
            if (i >= arrayList.size() || hashMap.get(object2) != null || !DepInfo.needToMake(iterator, options)) continue;
            hashMap.put(object2, iterator);
        }
        HashMap hashMap3 = new HashMap();
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            DepInfo.findUsedByAndDepSources((Storage)iterator.next(), hashMap3, options);
        }
        iterator = hashMap3.values().iterator();
        while (iterator.hasNext()) {
            File file;
            object2 = (String)iterator.next();
            object = DepInfo.fixKey((String)object2);
            Storage storage = (Storage)hashMap2.get(object);
            if (storage == null && (file = new File((String)object2)).exists()) {
                storage = new FileStorage(file);
            }
            if (storage == null) continue;
            hashMap.put(object, storage);
        }
        object2 = new ArrayList();
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = (Storage)iterator.next();
            ((ArrayList)object2).add(object);
        }
        return object2;
    }

    public static void writeFile(Storage storage) throws IOException {
        Object object;
        int n = newAddedClasses.size();
        if (n <= 0) {
            return;
        }
        HashMap<SourceFile, ArrayList<Object>> hashMap = new HashMap<SourceFile, ArrayList<Object>>(n < 3 ? 3 : n);
        for (int i = 0; i < newAddedClasses.size(); ++i) {
            object = (ClassFileInfo)newAddedClasses.get(i);
            SourceFile sourceFile = ((ClassFileInfo)object).rcs.cd.ccd.sourceFile;
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(sourceFile);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(object);
            hashMap.put(sourceFile, arrayList);
        }
        newAddedClasses.clear();
        references.clear();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (SourceFile)iterator.next();
            DepInfo.addTopLevel(((SourceFile)object).storage, (ArrayList)hashMap.get(object));
        }
        DepInfo.write(storage);
    }

    private static void addTopLevel(Storage storage, ArrayList arrayList) {
        if (storage == null || arrayList == null) {
            return;
        }
        String string = storage.getPath();
        String string2 = DepInfo.fixKey(string);
        SourceFileInfo sourceFileInfo = (SourceFileInfo)sources.get(string2);
        if (sourceFileInfo != null) {
            for (int i = 0; i < sourceFileInfo.classFiles.size(); ++i) {
                ((ClassFileInfo)sourceFileInfo.classFiles.elementAt((int)i)).sfi = null;
            }
            sources.remove(string2);
        }
        sourceFileInfo = new SourceFileInfo(string, storage.modDate(), arrayList, classes);
        sources.put(string2, sourceFileInfo);
    }

    private static Storage findClass(ClassFileInfo classFileInfo, Options options) {
        Storage storage = null;
        String string = classFileInfo.className;
        string = string.replace('.', File.separatorChar) + ".class";
        if (options.destinationDir != null) {
            if (options.destinationFile == null) {
                File file = new File(options.destinationDir);
                if (!file.exists() && !file.mkdirs()) {
                    System.out.println("error: unable to create directory " + options.destinationDir);
                }
                options.destinationFile = new DirectoryStorage(file);
            }
            if ((storage = options.destinationFile.open(string)) != null) {
                return storage;
            }
        }
        if (options.classpath != null) {
            storage = options.findStorageOfClass(classFileInfo.className);
        }
        return storage;
    }

    private static int findUsedByAndDepSources(Storage storage, HashMap hashMap, Options options) {
        int n = 0;
        String string = DepInfo.fixKey(storage.getPath());
        SourceFileInfo sourceFileInfo = (SourceFileInfo)sources.get(string);
        if (sourceFileInfo != null) {
            Enumeration enumeration = classes.elements();
            while (enumeration.hasMoreElements()) {
                ClassFileInfo classFileInfo = (ClassFileInfo)enumeration.nextElement();
                if (classFileInfo.sfi == null || classFileInfo.depClasses == null) continue;
                for (int i = 0; i < classFileInfo.depClasses.size(); ++i) {
                    File file;
                    String string2;
                    ClassFileInfo classFileInfo2 = (ClassFileInfo)classFileInfo.depClasses.get(i);
                    if (classFileInfo.sfi != sourceFileInfo && classFileInfo2.sfi == sourceFileInfo) {
                        if (hashMap.put(DepInfo.fixKey(classFileInfo.sfi.fullName), classFileInfo.sfi.fullName) != null) continue;
                        ++n;
                        continue;
                    }
                    if (classFileInfo.sfi != sourceFileInfo || classFileInfo2.sfi == null || classFileInfo2.sfi == sourceFileInfo || hashMap.get(DepInfo.fixKey(string2 = classFileInfo2.sfi.fullName)) != null || !(file = new File(string2)).exists() || !DepInfo.needToMake(new FileStorage(file), options) || hashMap.put(DepInfo.fixKey(string2), string2) != null) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    private static boolean needToMake(Storage storage, Options options) {
        String string = DepInfo.fixKey(storage.getPath());
        SourceFileInfo sourceFileInfo = (SourceFileInfo)sources.get(string);
        if (sourceFileInfo != null) {
            long l = storage.modDate();
            for (int i = 0; i < sourceFileInfo.classFiles.size(); ++i) {
                ClassFileInfo classFileInfo = (ClassFileInfo)sourceFileInfo.classFiles.elementAt(i);
                long l2 = classFileInfo.modDate;
                if (l2 == -1L) {
                    Storage storage2 = DepInfo.findClass(classFileInfo, options);
                    if (storage2 == null) {
                        System.out.println("findClass: couldnt find: " + classFileInfo.className);
                        return true;
                    }
                    l2 = classFileInfo.modDate = storage2.modDate();
                }
                if (l2 >= l && l == sourceFileInfo.modDate) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static void clear() {
        classes.clear();
        sources.clear();
        newAddedClasses.clear();
        references.clear();
    }

    private static boolean upVersion(long l, long l2) {
        return l != 305419897L && l >= l2;
    }

    private static int readInt() {
        int n = (buffer[bufidx + 0] & 0xFF) << 24;
        n += (buffer[bufidx + 1] & 0xFF) << 16;
        n += (buffer[bufidx + 2] & 0xFF) << 8;
        n += buffer[bufidx + 3] & 0xFF;
        bufidx += 4;
        return n;
    }

    private static long readLong() {
        long l = ((long)buffer[bufidx + 0] & 0xFFL) << 56;
        l += ((long)buffer[bufidx + 1] & 0xFFL) << 48;
        l += ((long)buffer[bufidx + 2] & 0xFFL) << 40;
        l += ((long)buffer[bufidx + 3] & 0xFFL) << 32;
        l += ((long)buffer[bufidx + 4] & 0xFFL) << 24;
        l += ((long)buffer[bufidx + 5] & 0xFFL) << 16;
        l += ((long)buffer[bufidx + 6] & 0xFFL) << 8;
        l += (long)buffer[bufidx + 7] & 0xFFL;
        bufidx += 8;
        return l;
    }

    private static String readName() {
        int n = DepInfo.readInt();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = buffer[bufidx++];
        }
        return new String(byArray);
    }

    public static void read(Storage storage) throws IOException {
        int n;
        int n2;
        storage.open();
        buffer = storage.read();
        storage.close();
        bufidx = 0;
        int n3 = DepInfo.readInt();
        if (n3 != 305419897 && n3 != 0x9000200 && n3 != 0x9000500) {
            throw new IOException();
        }
        if (n3 != 305419897 && !storage.toString().equals(DepInfo.readName().toString()) && !rebaseCdi) {
            throw new IOException();
        }
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>(1003);
        int n4 = DepInfo.readInt();
        for (n2 = 0; n2 < n4; ++n2) {
            n = bufidx;
            ClassFileInfo classFileInfo = new ClassFileInfo(DepInfo.readName(), null, -1L);
            hashtable.put(new Integer(n), classFileInfo);
            classes.put(classFileInfo.className, classFileInfo);
            classFileInfo.pos = n;
        }
        n2 = DepInfo.readInt();
        for (n = 0; n < n2; ++n) {
            int n5 = bufidx;
            String string = DepInfo.readName();
            long l = DepInfo.upVersion(n3, 0x9000500L) ? DepInfo.readLong() : -1L;
            SourceFileInfo sourceFileInfo = new SourceFileInfo(string, l);
            sources.put(DepInfo.fixKey(sourceFileInfo.fullName), sourceFileInfo);
            hashtable.put(new Integer(n5), sourceFileInfo);
            sourceFileInfo.pos = n5;
        }
        while (n4-- > 0) {
            Integer n6 = new Integer(DepInfo.readInt());
            ClassFileInfo classFileInfo = (ClassFileInfo)hashtable.get(n6);
            classFileInfo.modDate = DepInfo.readLong();
            int n7 = DepInfo.readInt();
            classFileInfo.depClasses = new ArrayList(n7 >= 0 ? n7 : 0);
            while (n7-- > 0) {
                n6 = new Integer(DepInfo.readInt());
                if (n6 != 0) {
                    ClassFileInfo classFileInfo2 = (ClassFileInfo)hashtable.get(n6);
                    if (classFileInfo2 != null) {
                        classFileInfo.depClasses.add(classFileInfo2);
                        continue;
                    }
                    System.out.println("DepInfo error: " + classFileInfo.className + ": class not found at index " + n6);
                    continue;
                }
                System.out.println("DepInfo error: " + classFileInfo.className + ": dep class missing");
            }
        }
        while (n2-- > 0) {
            Integer n8 = new Integer(DepInfo.readInt());
            SourceFileInfo sourceFileInfo = (SourceFileInfo)hashtable.get(n8);
            int n9 = DepInfo.readInt();
            sourceFileInfo.classFiles = new Vector(n9);
            while (n9-- > 0) {
                n8 = new Integer(DepInfo.readInt());
                if (n8 != 0) {
                    ClassFileInfo classFileInfo = (ClassFileInfo)hashtable.get(n8);
                    if (classFileInfo != null) {
                        classFileInfo.sfi = sourceFileInfo;
                        sourceFileInfo.classFiles.addElement(classFileInfo);
                        continue;
                    }
                    System.out.println("DepInfo error: source file: " + sourceFileInfo.fullName + " class not found at index " + n8);
                    continue;
                }
                System.out.println("DepInfo error: " + sourceFileInfo.fullName + ": class file missing");
            }
        }
        hashtable.clear();
        if (bufidx != buffer.length) {
            throw new IOException();
        }
    }

    private static void writeInt(int n) {
        if (bufidx + 4 > buffer.length) {
            byte[] byArray = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, byArray, 0, buffer.length);
            buffer = byArray;
        }
        DepInfo.buffer[DepInfo.bufidx + 0] = (byte)(n >> 24 & 0xFF);
        DepInfo.buffer[DepInfo.bufidx + 1] = (byte)(n >> 16 & 0xFF);
        DepInfo.buffer[DepInfo.bufidx + 2] = (byte)(n >> 8 & 0xFF);
        DepInfo.buffer[DepInfo.bufidx + 3] = (byte)(n & 0xFF);
        bufidx += 4;
    }

    private static void writeLong(long l) {
        if (bufidx + 8 > buffer.length) {
            byte[] byArray = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, byArray, 0, buffer.length);
            buffer = byArray;
        }
        DepInfo.buffer[DepInfo.bufidx + 0] = (byte)(l >>> 56 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 1] = (byte)(l >>> 48 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 2] = (byte)(l >>> 40 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 3] = (byte)(l >>> 32 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 4] = (byte)(l >>> 24 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 5] = (byte)(l >>> 16 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 6] = (byte)(l >>> 8 & 0xFFL);
        DepInfo.buffer[DepInfo.bufidx + 7] = (byte)(l >>> 0 & 0xFFL);
        bufidx += 8;
    }

    private static void writeName(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        while (bufidx + 4 + n > buffer.length) {
            byte[] byArray2 = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, byArray2, 0, buffer.length);
            buffer = byArray2;
        }
        DepInfo.writeInt(n);
        for (int i = 0; i < n; ++i) {
            DepInfo.buffer[DepInfo.bufidx++] = byArray[i];
        }
    }

    private static boolean validate(Storage storage) throws IOException {
        try {
            DepInfo.clear();
            DepInfo.read(storage);
            return true;
        }
        catch (Throwable throwable) {
            storage.close();
            return false;
        }
    }

    public static void write(Storage storage) throws IOException {
        ClassFileInfo classFileInfo;
        int n;
        Object object;
        buffer = new byte[4096];
        bufidx = 0;
        DepInfo.writeInt(0x9000500);
        DepInfo.writeName(storage.toString());
        DepInfo.writeInt(classes.size());
        Enumeration enumeration = classes.elements();
        while (enumeration.hasMoreElements()) {
            object = (ClassFileInfo)enumeration.nextElement();
            ((ClassFileInfo)object).pos = bufidx;
            DepInfo.writeName(((ClassFileInfo)object).className);
        }
        DepInfo.writeInt(sources.size());
        enumeration = sources.elements();
        while (enumeration.hasMoreElements()) {
            object = (SourceFileInfo)enumeration.nextElement();
            ((SourceFileInfo)object).pos = bufidx;
            DepInfo.writeName(((SourceFileInfo)object).fullName);
            DepInfo.writeLong(((SourceFileInfo)object).modDate);
        }
        enumeration = classes.elements();
        while (enumeration.hasMoreElements()) {
            object = (ClassFileInfo)enumeration.nextElement();
            DepInfo.writeInt(((ClassFileInfo)object).pos);
            DepInfo.writeLong(((ClassFileInfo)object).modDate);
            DepInfo.writeInt(((ClassFileInfo)object).depClasses.size());
            for (n = 0; n < ((ClassFileInfo)object).depClasses.size(); ++n) {
                classFileInfo = (ClassFileInfo)((ClassFileInfo)object).depClasses.get(n);
                classFileInfo = (ClassFileInfo)classes.get(classFileInfo.className);
                DepInfo.writeInt(classFileInfo != null ? classFileInfo.pos : 0);
            }
        }
        enumeration = sources.elements();
        while (enumeration.hasMoreElements()) {
            object = (SourceFileInfo)enumeration.nextElement();
            DepInfo.writeInt(((SourceFileInfo)object).pos);
            DepInfo.writeInt(((SourceFileInfo)object).classFiles.size());
            for (n = 0; n < ((SourceFileInfo)object).classFiles.size(); ++n) {
                classFileInfo = (ClassFileInfo)((SourceFileInfo)object).classFiles.elementAt(n);
                classFileInfo = (ClassFileInfo)classes.get(classFileInfo.className);
                DepInfo.writeInt(classFileInfo != null ? classFileInfo.pos : 0);
            }
        }
        storage.write(buffer, 0, bufidx);
        storage.close();
        if (!$assertionsDisabled && !DepInfo.validate(storage)) {
            throw new AssertionError();
        }
        DepInfo.clear();
    }

    static {
        $assertionsDisabled = !DepInfo.class.desiredAssertionStatus();
        rebaseCdi = false;
        sources = new Hashtable(101);
        classes = new Hashtable(427);
        newAddedClasses = new ArrayList();
        references = new HashMap();
    }
}

