/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeSymbol;

final class DoStatement
extends LoopStatement {
    Expression condition;
    static final /* synthetic */ boolean $assertionsDisabled;

    DoStatement(StatementList statementList, int n, int n2, Expression expression, StatementList statementList2) {
        super(statementList, n, n2, (byte)13, statementList2);
        this.condition = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(switchLoopList, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.loopRec;
            StatementList statementList = this.bodyStatements;
            if (statementList != null) {
                statementList.resolveAndCheck(parser);
            }
            if (this.continueDefSet != null) {
                parser.defSet.and(this.continueDefSet);
            }
            Expression expression = this.condition.resolveAndCheck(parser);
            boolean bl = false;
            TypeSymbol typeSymbol = expression.getType();
            byte by = typeSymbol.typeKind;
            if (by != 2) {
                if (parser.options.sourceJDKVersion >= 150 && typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
                    expression = new AutoUnboxingExpression(expression, TypeSymbol.booleanSymbol);
                } else {
                    parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), "boolean");
                }
            } else if (expression.isConstantBooleanExpression()) {
                bl = expression.getConstantBooleanExpressionValue();
            }
            this.condition = expression;
            if (statementList != null) {
                if (bl && this.loopRec.breakSymbol == null && this.next != null && this.next.isCodeStatement()) {
                    parser.error(Message.errorUnreachableStatement, this.next.pos, false);
                }
            } else if (bl && this.next != null && this.next.isCodeStatement()) {
                parser.error(Message.errorUnreachableStatement, this.next.pos, false);
            }
            this.loopRec.insertLabels();
            if (expression.isLogicalExpression()) {
                parser.defSet = expression.getLogicalExpressionFalseDefSet();
            }
            if (this.resultDefSet != null) {
                if (bl) {
                    parser.defSet = this.resultDefSet;
                } else {
                    parser.defSet.and(this.resultDefSet);
                }
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
        }
        finally {
            parser.innerSwitchLoop = switchLoopList;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    boolean isBogusLoop() {
        return this.condition.isConstantBooleanExpression() && !this.condition.getConstantBooleanExpressionValue();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Label label = new Label();
        byteCodeGenerator.setLabel(label);
        SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
        StatementList statementList = this.bodyStatements;
        if (statementList != null) {
            statementList.generateByteCode(byteCodeGenerator);
        }
        byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression()) {
            if (expression.kind != 2) {
                expression.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (expression.getConstantBooleanExpressionValue()) {
                byteCodeGenerator.generateBranch_goto(label);
            }
        } else {
            expression.generateByteCodeBranch(byteCodeGenerator, label, false);
        }
    }

    boolean canReachNextStatement(boolean bl) {
        boolean bl2 = false;
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression()) {
            bl2 = expression.getConstantBooleanExpressionValue();
        }
        if (!$assertionsDisabled && this.loopRec == null) {
            throw new AssertionError();
        }
        if (this.loopRec.breakSymbol != null) {
            bl2 = false;
        }
        return !bl2;
    }

    static {
        $assertionsDisabled = !DoStatement.class.desiredAssertionStatus();
    }
}

