/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;

abstract class ElementValue {
    static final byte EV_NONE = 0;
    static final byte EV_DEFAULTVALUE = 1;
    static final byte EV_ARRAYELEMENT = 2;
    Identifier elementName;
    TypeSymbol typeSymbol;
    int pos;
    short nameIndex;
    byte tag;
    byte flags;

    ElementValue(Identifier identifier, int n, boolean bl, boolean bl2) {
        this.elementName = identifier;
        this.pos = n;
        if (bl) {
            this.flags = (byte)(this.flags | 1);
        }
        if (bl2) {
            this.flags = (byte)(this.flags | 2);
        }
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        if (annotation.annotationType.isErroneous()) {
            this.typeSymbol = TypeSymbol.errorSymbol;
        } else {
            RawClassSymbol rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
            MethodSymbol methodSymbol = (MethodSymbol)rawClassSymbol.classScope.lookupSpecificSymbolInScope(this.elementName, 8, true);
            if (methodSymbol == null) {
                this.typeSymbol = TypeSymbol.errorSymbol;
                parser.error(Message.errorNotFound, this.pos, rawClassSymbol.isErroneous(), Message.memberString + " " + this.elementName.toString(), rawClassSymbol.errorName());
            } else {
                this.typeSymbol = methodSymbol.resultType.resolveType(parser, this.pos, false, true);
                if ((this.flags & 2) != 0) {
                    this.typeSymbol = ((ArraySymbol)this.typeSymbol).baseType;
                }
            }
        }
        return this;
    }

    int getAttributeLength() {
        return (this.flags & 3) != 0 ? 1 : 3;
    }

    void write(ClassFileWriter classFileWriter) throws IOException {
        if ((this.flags & 3) != 0) {
            int n = classFileWriter.ensureWriteBufferCapacity(1);
            byte[] byArray = classFileWriter.writeBuffer;
            byArray[n] = this.tag;
            classFileWriter.writeBufferIndex = n + 1;
        } else {
            int n = classFileWriter.ensureWriteBufferCapacity(3);
            byte[] byArray = classFileWriter.writeBuffer;
            byArray[n + 2] = this.tag;
            byArray[n + 1] = (byte)this.nameIndex;
            byArray[n] = (byte)(this.nameIndex >> 8);
            classFileWriter.writeBufferIndex = n + 3;
        }
    }

    void generateConstantPoolEntries(ClassFileWriter classFileWriter, ConstantPool constantPool) {
        if ((this.flags & 3) == 0) {
            this.nameIndex = constantPool.enterConstantPoolUtf8(this.elementName.name);
        }
    }
}

