/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class EnhancedForStatement
extends LoopStatement {
    MethodVariableSymbol localVar;
    Expression expr;
    TypeSymbol elementType;
    private short arrayVar;
    private boolean prologueGenerated;
    static final /* synthetic */ boolean $assertionsDisabled;

    EnhancedForStatement(StatementList statementList, int n, int n2, MethodVariableSymbol methodVariableSymbol, Expression expression, StatementList statementList2) {
        super(statementList, n, n2, (byte)11, statementList2);
        this.localVar = methodVariableSymbol;
        this.expr = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(switchLoopList, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.loopRec;
            this.expr = this.expr.resolveAndCheck(parser);
            TypeSymbol typeSymbol = this.expr.getType();
            if ((typeSymbol.typeClass & 0xFFFFFFC0) == 0) {
                parser.error(Message.errorTypeNotAllowed, this.expr.pos, false, typeSymbol.errorName());
            } else if (!typeSymbol.isErroneous()) {
                TypeSymbol typeSymbol2 = this.localVar.type;
                if (typeSymbol.isClass()) {
                    ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
                    if (!classSymbol.implementsInterface(parser.javaLangIterableSymbol)) {
                        parser.error(Message.errorTypeNotAllowed, this.expr.pos, false, typeSymbol.errorName());
                        typeSymbol = typeSymbol2 = TypeSymbol.intSymbol;
                    } else {
                        classSymbol = classSymbol.getInterface(parser.javaLangIterableSymbol);
                        if (!$assertionsDisabled && classSymbol == null) {
                            throw new AssertionError();
                        }
                        if (!classSymbol.isParameterizedClass()) {
                            typeSymbol = parser.javaLangObjectPcs;
                        } else {
                            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol;
                            if (parameterizedClassSymbol.typeVariableList == null || parameterizedClassSymbol.typeVariableList.typeVariable == null) {
                                typeSymbol = parser.javaLangObjectPcs;
                            } else {
                                typeSymbol = parameterizedClassSymbol.typeVariableList.typeVariable.refSymbol;
                                if (typeSymbol.isTypeParameter()) {
                                    typeSymbol = ((TypeParameterSymbol)typeSymbol).bound;
                                }
                            }
                        }
                    }
                } else {
                    if (!$assertionsDisabled && !typeSymbol.isArrayType()) {
                        throw new AssertionError();
                    }
                    ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
                    typeSymbol = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                }
                this.elementType = typeSymbol;
                if (typeSymbol2.isPrimitiveType() && !typeSymbol2.isErroneous()) {
                    TypeSymbol typeSymbol3;
                    if (typeSymbol.isReferenceType() && (typeSymbol3 = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null) {
                        typeSymbol = typeSymbol3;
                    }
                    if (!(typeSymbol2 == typeSymbol || TypeSymbol.isWider(typeSymbol2.typeKind, typeSymbol.typeKind) && typeSymbol2 != TypeSymbol.charSymbol && typeSymbol2.isNumericType())) {
                        parser.error(Message.errorIncompatibleTypes, this.expr.pos, false, typeSymbol.errorName(), typeSymbol2.errorName());
                    }
                } else if (typeSymbol2.isReferenceType()) {
                    TypeSymbol typeSymbol4;
                    if (typeSymbol.isPrimitiveType() && (typeSymbol4 = BoxingExpression.getBoxedType(parser, typeSymbol)) != null) {
                        typeSymbol = typeSymbol4;
                    }
                    if (!typeSymbol.isReferenceType()) {
                        parser.error(Message.errorIncompatibleTypes, this.expr.pos, false, typeSymbol.errorName(), typeSymbol2.errorName());
                    } else {
                        ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol;
                        ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol2;
                        if (!referenceTypeSymbol.isAssignmentCompatible(parser, referenceTypeSymbol2)) {
                            parser.error(Message.errorIncompatibleTypes, this.expr.pos, false, typeSymbol.errorName(), typeSymbol2.errorName());
                        } else {
                            typeSymbol2.checkUncheckConversion(parser, this.pos, typeSymbol, false);
                        }
                    }
                }
            }
            BitSet bitSet = (BitSet)parser.defSet.clone();
            parser.defSet.set(parser.currentClassSymbol.cd.fieldCount + this.localVar.varStackIndex);
            if (this.bodyStatements != null) {
                this.bodyStatements.resolveAndCheck(parser);
            }
            this.loopRec.insertLabels();
            parser.defSet = bitSet;
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
        }
        finally {
            parser.innerSwitchLoop = switchLoopList;
        }
        ++parser.estimatedLineCount;
    }

    void generateByteCodePrologue(ByteCodeGenerator byteCodeGenerator) {
        this.prologueGenerated = true;
        TypeSymbol typeSymbol = this.expr.getType();
        if (typeSymbol.typeKind == 11) {
            short s = byteCodeGenerator.methodSymbol.localVarCount;
            byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
            this.arrayVar = s;
            byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
            this.expr.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.storeLocalVariable(typeSymbol, this.arrayVar);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!this.prologueGenerated) {
            this.generateByteCodePrologue(byteCodeGenerator);
        }
        TypeSymbol typeSymbol = this.localVar.type;
        TypeSymbol typeSymbol2 = this.expr.getType();
        short s = byteCodeGenerator.methodSymbol.localVarCount;
        byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
        short s2 = s;
        byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
        if (typeSymbol2.typeKind == 11) {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol2;
            byteCodeGenerator.generate_8((byte)3);
            byteCodeGenerator.incOpStackHeight(1);
            byteCodeGenerator.storeLocalVariable(TypeSymbol.intSymbol, s2);
            Label label = new Label();
            Label label2 = new Label();
            byteCodeGenerator.generateBranch_goto(label);
            byteCodeGenerator.setLabel(label2);
            SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
            byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
            byteCodeGenerator.loadLocalVariable(typeSymbol2, this.arrayVar);
            byteCodeGenerator.loadLocalVariable(TypeSymbol.intSymbol, s2);
            byteCodeGenerator.generate_8(ArrayExpression.aload_opcode[this.elementType.typeKind]);
            if (typeSymbol.isPrimitiveType() && this.elementType.isReferenceType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, this.elementType, typeSymbol);
            } else if (typeSymbol.isReferenceType() && this.elementType.isPrimitiveType()) {
                AutoBoxingExpression.generateByteCode(byteCodeGenerator, this.elementType, typeSymbol);
            }
            if ((this.elementType.typeClass & 0x28) == 0) {
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (typeSymbol.typeClass != this.elementType.typeClass) {
                byteCodeGenerator.generateWideningPrimitiveConversion(this.elementType.typeClass, typeSymbol.typeClass);
            }
            byteCodeGenerator.storeLocalVariable(typeSymbol, this.localVar.varStackIndex);
            int n = byteCodeGenerator.generateGetPC() & 0xFFFF;
            if (n < (this.localVar.startPC & 0xFFFF)) {
                this.localVar.startPC = (short)n;
            }
            if (this.bodyStatements != null) {
                this.bodyStatements.generateByteCode(byteCodeGenerator);
            }
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
            if (s2 <= 255) {
                byteCodeGenerator.generate_8_8_8((byte)-124, (byte)s2, (byte)1);
            } else {
                byteCodeGenerator.generate_8_8((byte)-60, (byte)-124);
                byteCodeGenerator.generate_16_16(s2, (short)1);
            }
            byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
            byteCodeGenerator.setLabel(label);
            byteCodeGenerator.loadLocalVariable(TypeSymbol.intSymbol, s2);
            byteCodeGenerator.loadLocalVariable(typeSymbol2, this.arrayVar);
            byteCodeGenerator.generate_8((byte)-66);
            byteCodeGenerator.generateBranch_if_icmplt(label2);
            byteCodeGenerator.decOpStackHeight(2);
        } else {
            short s3;
            this.expr.generateByteCode(byteCodeGenerator);
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol2;
            if (classSymbol.isInterface()) {
                s3 = byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(classSymbol.getInternalName(), Identifier.iteratorIdentifier.name, Identifier.javaUtilIteratorMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-71, s3);
                byteCodeGenerator.generate_8_8((byte)1, (byte)0);
            } else {
                s3 = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(classSymbol.getInternalName(), Identifier.iteratorIdentifier.name, Identifier.javaUtilIteratorMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-74, s3);
            }
            byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s2);
            Label label = new Label();
            Label label3 = new Label();
            byteCodeGenerator.generateBranch_goto(label);
            byteCodeGenerator.setLabel(label3);
            SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
            byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
            byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s2);
            s3 = byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(Identifier.javaUtilIteratorInternal.name, Identifier.nextIdentifier.name, Identifier.javaLangObjectMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-71, s3);
            byteCodeGenerator.generate_8_8((byte)1, (byte)0);
            s3 = byteCodeGenerator.constantPool.enterConstantPoolClass(this.elementType.getInternalName());
            byteCodeGenerator.generate_8_16((byte)-64, s3);
            if (typeSymbol.isPrimitiveType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, this.elementType, typeSymbol);
            }
            byteCodeGenerator.storeLocalVariable(typeSymbol, this.localVar.varStackIndex);
            int n = byteCodeGenerator.generateGetPC() & 0xFFFF;
            if (n < (this.localVar.startPC & 0xFFFF)) {
                this.localVar.startPC = (short)n;
            }
            if (this.bodyStatements != null) {
                this.bodyStatements.generateByteCode(byteCodeGenerator);
            }
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
            byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
            byteCodeGenerator.setLabel(label);
            byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, s2);
            s3 = byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(Identifier.javaUtilIteratorInternal.name, Identifier.hasNextIdentifier.name, Identifier.booleanMethodSignature.name);
            byteCodeGenerator.generate_8_16((byte)-71, s3);
            byteCodeGenerator.generate_8_8((byte)1, (byte)0);
            byteCodeGenerator.generateBranch_ifne(label3);
            byteCodeGenerator.decOpStackHeight(1);
        }
    }

    boolean canReachNextStatement(boolean bl) {
        return true;
    }

    static {
        $assertionsDisabled = !EnhancedForStatement.class.desiredAssertionStatus();
    }
}

