/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArrayElementValue;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassExpression;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.TypeSymbol;

final class ExpressionElementValue
extends ElementValue {
    Expression expr;
    private short constantValueIndex;
    private short typeIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ExpressionElementValue(Identifier identifier, Expression expression, int n, boolean bl, boolean bl2) {
        super(identifier, n, bl, bl2);
        this.expr = expression;
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        super.resolveAndCheck(parser, annotation);
        Expression expression = this.expr.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        if (expression == ErrorExpression.errorExpression || typeSymbol.isErroneous()) {
            return this;
        }
        if (typeSymbol.isEnum()) {
            if (!(expression instanceof FieldExpression)) {
                parser.error(Message.errorConstantRequired, expression.pos, false);
                return this;
            }
            FieldExpression fieldExpression = (FieldExpression)expression;
            FieldSymbol fieldSymbol = (FieldSymbol)fieldExpression.field;
            if ((fieldSymbol.access & 0x4000) == 0) {
                parser.error(Message.errorConstantRequired, expression.pos, false);
                return this;
            }
        } else if (expression.kind == 2) {
            if (this.expr instanceof FieldExpression && ((FieldExpression)this.expr).thisArgument != null) {
                parser.error(Message.errorConstantRequired, expression.pos, false);
                return this;
            }
        } else if (expression.kind != 48) {
            parser.error(Message.errorConstantRequired, expression.pos, false);
            return this;
        }
        this.expr = expression;
        ElementValue elementValue = this;
        if (this.typeSymbol.isArrayType()) {
            ArrayList<ExpressionElementValue> arrayList = new ArrayList<ExpressionElementValue>(1);
            arrayList.add(this);
            elementValue = new ArrayElementValue(this.elementName, arrayList, this.pos, (this.flags & 1) != 0, false);
            elementValue.typeSymbol = this.typeSymbol;
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.flags = (byte)(this.flags | 2);
            this.typeSymbol = ((ArraySymbol)this.typeSymbol).baseType;
        }
        if (!typeSymbol.equalTo(this.typeSymbol)) {
            if (typeSymbol.isNumericType() && this.typeSymbol.isNumericType()) {
                this.expr = this.expr.promoteType(parser, this.typeSymbol);
            } else {
                parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol.errorName(), this.typeSymbol.errorName());
            }
        }
        return elementValue;
    }

    int getAttributeLength() {
        return super.getAttributeLength() + (this.tag == 101 ? 4 : 2);
    }

    void generateConstantPoolEntries(ClassFileWriter classFileWriter, ConstantPool constantPool) {
        super.generateConstantPoolEntries(classFileWriter, constantPool);
        TypeSymbol typeSymbol = this.expr.getType();
        block0 : switch (typeSymbol.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 2: {
                int n = ((BooleanConstantExpression)this.expr).bval ? 1 : 0;
                this.constantValueIndex = constantPool.enterConstantPoolInteger(n);
                this.tag = (byte)90;
                break;
            }
            case 4: {
                int n = typeSymbol.typeKind == 4 ? ((CharConstantExpression)this.expr).cval & 0xFFFF : ((IntConstantExpression)this.expr).ival;
                this.constantValueIndex = constantPool.enterConstantPoolInteger(n);
                switch (typeSymbol.typeKind) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 3: {
                        this.tag = (byte)66;
                        break block0;
                    }
                    case 4: {
                        this.tag = (byte)67;
                        break block0;
                    }
                    case 5: {
                        this.tag = (byte)83;
                        break block0;
                    }
                    case 6: 
                }
                this.tag = (byte)73;
                break;
            }
            case 8: {
                this.constantValueIndex = constantPool.enterConstantPoolLong(((LongConstantExpression)this.expr).lval);
                this.tag = (byte)74;
                break;
            }
            case 16: {
                this.constantValueIndex = constantPool.enterConstantPoolFloat(((FloatConstantExpression)this.expr).fval);
                this.tag = (byte)70;
                break;
            }
            case 32: {
                this.constantValueIndex = constantPool.enterConstantPoolDouble(((DoubleConstantExpression)this.expr).dval);
                this.tag = (byte)68;
                break;
            }
            case 64: {
                if (typeSymbol.isEnum()) {
                    this.typeIndex = constantPool.enterConstantPoolUtf8(((FieldExpression)this.expr).getType().getSignature());
                    this.constantValueIndex = constantPool.enterConstantPoolUtf8(((FieldExpression)this.expr).field.identifier.name);
                    this.tag = (byte)101;
                    break;
                }
                if (typeSymbol.equalTo(classFileWriter.parser.javaLangClassSymbol)) {
                    this.constantValueIndex = constantPool.enterConstantPoolUtf8(((ClassExpression)this.expr).classType.getSignature());
                    this.tag = (byte)99;
                    break;
                }
                this.constantValueIndex = constantPool.enterConstantPoolUtf8(((StringConstantExpression)this.expr).sval);
                this.tag = (byte)115;
            }
        }
    }

    void write(ClassFileWriter classFileWriter) throws IOException {
        super.write(classFileWriter);
        if (this.tag == 101) {
            int n = classFileWriter.ensureWriteBufferCapacity(4);
            byte[] byArray = classFileWriter.writeBuffer;
            byArray[n + 3] = (byte)this.constantValueIndex;
            byArray[n + 2] = (byte)(this.constantValueIndex >> 8);
            byArray[n + 1] = (byte)this.typeIndex;
            byArray[n] = (byte)(this.typeIndex >> 8);
            classFileWriter.writeBufferIndex = n + 4;
        } else {
            int n = classFileWriter.ensureWriteBufferCapacity(2);
            byte[] byArray = classFileWriter.writeBuffer;
            byArray[n + 1] = (byte)this.constantValueIndex;
            byArray[n] = (byte)(this.constantValueIndex >> 8);
            classFileWriter.writeBufferIndex = n + 2;
        }
    }

    static {
        $assertionsDisabled = !ExpressionElementValue.class.desiredAssertionStatus();
    }
}

