/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArrayLengthExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.MemberExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class FieldExpression
extends MemberExpression {
    Symbol field;
    static final /* synthetic */ boolean $assertionsDisabled;

    FieldExpression(int n, Symbol symbol, Expression expression) {
        super((byte)1, n, expression);
        this.field = symbol;
    }

    short getAccess() {
        if (!$assertionsDisabled && (this.field.kind & 2) == 0) {
            throw new AssertionError();
        }
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        return fieldSymbol.access;
    }

    String errorName() {
        return this.field.errorName();
    }

    Expression constantFolding() {
        if (!$assertionsDisabled && (this.field.kind & 2) == 0) {
            throw new AssertionError();
        }
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        if ((fieldSymbol.flags & 2) != 0) {
            if (!$assertionsDisabled && fieldSymbol.initializer == null) {
                throw new AssertionError();
            }
            return fieldSymbol.initializer;
        }
        return this;
    }

    private FieldSymbol lookupInterfaceField(Parser parser, int n, ClassSymbol classSymbol, Identifier identifier) {
        FieldSymbol fieldSymbol = this.lookupInterfaceFieldInClass(parser, n, classSymbol, null, identifier);
        if (classSymbol.isTypeParameter()) {
            TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)classSymbol;
            ClassSymbolList classSymbolList = typeParameterSymbol.interfaceBounds;
            while (classSymbolList != null) {
                ClassSymbol classSymbol2 = classSymbolList.classSymbol;
                ClassScope classScope = classSymbol2.getClassScope();
                FieldSymbol fieldSymbol2 = (FieldSymbol)classScope.lookupSpecificSymbolInScope(identifier, 2, true);
                if (fieldSymbol2 != null && (fieldSymbol2.flags & 1) == 0) {
                    if (fieldSymbol != null && fieldSymbol != fieldSymbol2) {
                        parser.error(Message.errorAmbiguousReference, n, fieldSymbol.isErroneous() | fieldSymbol2.isErroneous(), identifier.toString(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName(), fieldSymbol2.errorName() + " " + Message.inString + " " + fieldSymbol2.definingClass.errorName());
                    }
                    fieldSymbol = fieldSymbol2;
                }
                fieldSymbol = this.lookupInterfaceFieldInClass(parser, n, classSymbol2, fieldSymbol, identifier);
                classSymbolList = classSymbolList.next;
            }
        }
        if (fieldSymbol == null && classSymbol.isInnerClass()) {
            fieldSymbol = this.lookupInterfaceField(parser, n, classSymbol.getOuterClass(), identifier);
        }
        return fieldSymbol;
    }

    private FieldSymbol lookupInterfaceFieldInClass(Parser parser, int n, ClassSymbol classSymbol, FieldSymbol fieldSymbol, Identifier identifier) {
        ClassSymbol classSymbol2 = classSymbol;
        do {
            classSymbol2 = (ClassSymbol)classSymbol2.resolveType(parser, classSymbol2.pos, false, false);
            ImplementationList implementationList = classSymbol2.getImplementationList();
            while (implementationList != null) {
                ClassSymbol classSymbol3 = implementationList.interfaceSymbol;
                ClassScope classScope = classSymbol3.getClassScope();
                FieldSymbol fieldSymbol2 = (FieldSymbol)classScope.lookupSpecificSymbolInScope(identifier, 2, true);
                if (fieldSymbol2 != null && (fieldSymbol2.flags & 1) == 0) {
                    if (fieldSymbol != null && fieldSymbol != fieldSymbol2) {
                        parser.error(Message.errorAmbiguousReference, n, fieldSymbol.isErroneous() | fieldSymbol2.isErroneous(), identifier.toString(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName(), fieldSymbol2.errorName() + " " + Message.inString + " " + fieldSymbol2.definingClass.errorName());
                    }
                    fieldSymbol = fieldSymbol2;
                }
                if (fieldSymbol == null && (fieldSymbol2 = this.lookupInterfaceField(parser, n, classSymbol3, identifier)) != null && (fieldSymbol2.flags & 1) == 0) {
                    if (fieldSymbol != null && fieldSymbol != fieldSymbol2) {
                        parser.error(Message.errorAmbiguousReference, n, fieldSymbol.isErroneous() | fieldSymbol2.isErroneous(), identifier.toString(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName(), fieldSymbol2.errorName() + " " + Message.inString + " " + fieldSymbol2.definingClass.errorName());
                    }
                    fieldSymbol = fieldSymbol2;
                }
                implementationList = implementationList.next;
            }
        } while ((classSymbol2 = classSymbol2.getSuperClassSymbol()) != null);
        return fieldSymbol;
    }

    private boolean interfaceFieldIsAmbigous(FieldSymbol fieldSymbol, FieldSymbol fieldSymbol2, ClassSymbol classSymbol) {
        if (fieldSymbol2 == null || fieldSymbol2 == fieldSymbol || fieldSymbol.definingClass.equalTo(classSymbol)) {
            return false;
        }
        RawClassSymbol rawClassSymbol = fieldSymbol2.definingClass;
        while (classSymbol != null && !classSymbol.equalTo(fieldSymbol.definingClass)) {
            ImplementationList implementationList = classSymbol.getImplementationList();
            while (implementationList != null) {
                ClassSymbol classSymbol2 = implementationList.interfaceSymbol;
                if (classSymbol2.equalTo(rawClassSymbol)) {
                    return true;
                }
                if (classSymbol2.implementsInterface(rawClassSymbol)) {
                    return true;
                }
                implementationList = implementationList.next;
            }
            classSymbol = classSymbol.getSuperClassSymbol();
        }
        return false;
    }

    private Symbol lookupFieldSymbol(Parser parser, ClassSymbol classSymbol, Identifier identifier) {
        MethodVariableSymbol methodVariableSymbol;
        FieldSymbol fieldSymbol = null;
        FieldSymbol fieldSymbol2 = (FieldSymbol)classSymbol.getClassScope().lookupSpecificSymbol(identifier, 2, true);
        if (fieldSymbol2 != null && (fieldSymbol2.flags & 0x20) != 0) {
            fieldSymbol2 = null;
        }
        if (fieldSymbol2 == null && classSymbol.isInnerClass() && (methodVariableSymbol = (MethodVariableSymbol)classSymbol.getClassScope().lookupSpecificSymbol(identifier, 64, false)) != null && (methodVariableSymbol.access & 0x10) != 0) {
            fieldSymbol2 = parser.getSyntheticFieldForLocalInInnerClass(methodVariableSymbol);
        }
        if (fieldSymbol2 == null) {
            fieldSymbol = this.lookupInterfaceField(parser, this.pos, classSymbol, identifier);
        } else if (!fieldSymbol2.definingClass.equalTo(classSymbol) && (fieldSymbol = this.lookupInterfaceField(parser, this.pos, classSymbol, identifier)) != null && !fieldSymbol2.isAccessible(parser.currentClassSymbol, classSymbol)) {
            fieldSymbol2 = fieldSymbol;
            fieldSymbol = null;
        }
        if (fieldSymbol2 == null) {
            fieldSymbol2 = fieldSymbol;
        } else if (this.interfaceFieldIsAmbigous(fieldSymbol2, fieldSymbol, classSymbol)) {
            parser.error(Message.errorAmbiguousReference, this.pos, fieldSymbol.isErroneous() | fieldSymbol2.isErroneous(), identifier.toString(), fieldSymbol2.errorName() + " " + Message.inString + " " + fieldSymbol2.definingClass.errorName(), fieldSymbol.errorName() + " " + Message.inString + " " + fieldSymbol.definingClass.errorName());
            return FieldSymbol.errorField;
        }
        return fieldSymbol2;
    }

    private boolean isConstantInstanceField(FieldSymbol fieldSymbol) {
        if (!$assertionsDisabled && (fieldSymbol.access & 8) != 0) {
            throw new AssertionError();
        }
        return (fieldSymbol.access & 0x10) != 0 && fieldSymbol.initializer != null && fieldSymbol.initializer.kind == 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expression _resolveAndCheck(Parser parser, boolean bl) {
        RawClassSymbol rawClassSymbol;
        FieldSymbol fieldSymbol;
        TypeSymbol typeSymbol;
        Expression expression;
        RawClassSymbol rawClassSymbol2;
        block67: {
            TypeSymbol typeSymbol2;
            ImportSymbol importSymbol;
            if (!(this.field instanceof UnresolvedSymbol)) {
                return this;
            }
            UnresolvedSymbol unresolvedSymbol = (UnresolvedSymbol)this.field;
            if (unresolvedSymbol.qualifierList == null) {
                rawClassSymbol2 = parser.currentClassSymbol;
            } else {
                if (!this.resolveQualifiedName(parser, unresolvedSymbol)) {
                    return ErrorExpression.errorExpression;
                }
                rawClassSymbol2 = null;
            }
            expression = this.thisArgument;
            if (expression != null) {
                typeSymbol = (expression = expression.resolveAndCheck(parser)).getType();
                if (typeSymbol.isPrimitiveType()) {
                    Error error = parser.error(Message.errorObjectRequired, expression.pos, typeSymbol.isErroneous(), typeSymbol.toString());
                    return new ErrorExpression(error);
                }
                if (typeSymbol.isArrayType()) {
                    if (unresolvedSymbol.identifier.equals(Identifier.lengthIdentifier)) {
                        typeSymbol = ((ArraySymbol)typeSymbol).baseType;
                        if (!typeSymbol.isClass()) return new ArrayLengthExpression(this.pos, expression);
                        if (((ClassSymbol)typeSymbol).isAccessible(parser.currentClassSymbol)) {
                            return new ArrayLengthExpression(this.pos, expression);
                        }
                    }
                    rawClassSymbol2 = parser.javaLangObjectSymbol;
                } else {
                    rawClassSymbol2 = ((ClassSymbol)typeSymbol).getClassSymbol();
                }
                this.thisArgument = expression;
            }
            if (this.qualification != null) {
                rawClassSymbol2 = this.qualification.getClassSymbol();
            }
            rawClassSymbol2.resolveType(parser, this.pos, true, true);
            if (rawClassSymbol2.isErroneous()) {
                return ErrorExpression.errorExpression;
            }
            fieldSymbol = (FieldSymbol)this.lookupFieldSymbol(parser, rawClassSymbol2, unresolvedSymbol.identifier);
            if (fieldSymbol == FieldSymbol.errorField) {
                return ErrorExpression.errorExpression;
            }
            if (fieldSymbol != null && rawClassSymbol2.isInnerClass()) {
                if (parser.currentClassSymbol.isAnonymousInnerClass() && parser.currentClassSymbol.isInnerClass(rawClassSymbol2) && expression != null && expression instanceof ThisExpression && ((ThisExpression)expression).outerClassSymbol != null) {
                    if ((parser.currentClassSymbol.access & 8) != 0 && (fieldSymbol.access & 8) == 0 && !this.isConstantInstanceField(fieldSymbol)) {
                        Error error = parser.error(Message.errorDynamicRef, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                } else if (!(fieldSymbol.definingClass.equalTo(rawClassSymbol2) || fieldSymbol.definingClass.isSuperclass(rawClassSymbol2) || rawClassSymbol2.implementsInterface(fieldSymbol.definingClass))) {
                    if (expression != null || this.qualification != null) {
                        fieldSymbol = null;
                    } else if ((rawClassSymbol2.access & 8) != 0 && (fieldSymbol.access & 8) == 0 && !this.isConstantInstanceField(fieldSymbol)) {
                        Error error = parser.error(Message.errorDynamicRef, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                } else if (!fieldSymbol.isAccessible(parser.currentClassSymbol, rawClassSymbol2) && (parser.currentClassSymbol.getTopLevelClass() != fieldSymbol.definingClass.getTopLevelClass() || fieldSymbol.definingClass.isSuperclass(rawClassSymbol2))) {
                    FieldSymbol fieldSymbol2;
                    rawClassSymbol = rawClassSymbol2.getOuterClass();
                    while (true) {
                        if ((fieldSymbol2 = (FieldSymbol)this.lookupFieldSymbol(parser, rawClassSymbol, unresolvedSymbol.identifier)) == FieldSymbol.errorField) {
                            return ErrorExpression.errorExpression;
                        }
                        if (fieldSymbol2 != null) {
                            if ((rawClassSymbol2.access & 8) == 0 || (fieldSymbol2.access & 8) != 0 || this.isConstantInstanceField(fieldSymbol2)) break;
                            fieldSymbol2 = null;
                            break;
                        }
                        if (!rawClassSymbol.isInnerClass()) break;
                        rawClassSymbol = rawClassSymbol.getOuterClass();
                    }
                    fieldSymbol = fieldSymbol2;
                }
            }
            if (parser.options.sourceJDKVersion >= 150 && fieldSymbol == null && this.qualification == null && expression == null && (importSymbol = parser.currentPackageScope.lookupImportSymbol(unresolvedSymbol.identifier, (byte)2)) != null) {
                Symbol symbol;
                importSymbol.used = true;
                Symbol symbol2 = importSymbol.importedSymbol;
                if (symbol2 instanceof FieldSymbol) {
                    fieldSymbol = (FieldSymbol)symbol2;
                }
                if ((importSymbol.flags & 1) == 0 && (symbol = importSymbol.importSymbolHidesOtherImport()) != null && symbol != symbol2) {
                    String string = symbol2.errorName();
                    if (symbol2 instanceof FieldSymbol) {
                        string = string + " " + Message.inString + " " + ((FieldSymbol)symbol2).definingClass.errorName();
                    }
                    String string2 = symbol.errorName();
                    if (symbol instanceof FieldSymbol) {
                        string2 = string2 + " " + Message.inString + " " + ((FieldSymbol)symbol).definingClass.errorName();
                    }
                    Error error = parser.error(Message.errorAmbiguousReference, this.pos, symbol2.isErroneous() | symbol.isErroneous(), rawClassSymbol2.errorName(), string, string2);
                    return new ErrorExpression(error);
                }
            }
            if (fieldSymbol == null) {
                Error error = parser.error(Message.errorNotFound, this.pos, rawClassSymbol2.isErroneous(), Message.fieldString + " " + unresolvedSymbol.identifier.toString(), Message.inString + " " + rawClassSymbol2.errorName());
                return new ErrorExpression(error);
            }
            if (unresolvedSymbol.qualifierList == null && (fieldSymbol.access & 8) != 0) {
                fieldSymbol.checkForAmbigousImport(parser, this.pos, parser.currentPackageScope, (short)2);
            }
            this.field = fieldSymbol;
            fieldSymbol.type = typeSymbol = fieldSymbol.type.resolveType(parser, this.pos, false, true);
            if (typeSymbol.containsTypeParameterDefinedBy(null)) {
                typeSymbol = typeSymbol.replaceTypeParameters(parser.currentClassSymbol, null, null, expression);
            }
            if (typeSymbol.isTypeParameter() && expression != null && (typeSymbol2 = expression.getType()).isParameterizedClass()) {
                ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)typeSymbol2;
                TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)typeSymbol;
                if (parameterizedClassSymbol.typeVariableList == null && typeParameterSymbol.definingSymbol != parameterizedClassSymbol.genericClassSymbol && typeParameterSymbol.definingSymbol != parser.currentClassSymbol && !parser.currentClassSymbol.isInnerClass((RawClassSymbol)typeParameterSymbol.definingSymbol)) {
                    typeSymbol = typeParameterSymbol.bound;
                }
            }
            this.setType(typeSymbol.resolveType(parser, this.pos, false, true));
            if (expression != null && expression instanceof SuperExpression) {
                rawClassSymbol2 = ((SuperExpression)expression).classSymbol;
            }
            if (!fieldSymbol.isAccessible(parser.currentClassSymbol, rawClassSymbol2)) {
                if (!fieldSymbol.definingClass.isInnerClass() && !parser.currentClassSymbol.isInnerClass()) {
                    Error error = parser.error(Message.errorAccessError, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName(), (fieldSymbol.access & 2) != 0 ? "private" : "protected", Message.inString + " " + fieldSymbol.definingClass.errorName());
                    return new ErrorExpression(error);
                }
                RawClassSymbol rawClassSymbol3 = parser.currentClassSymbol.getTopLevelClass();
                RawClassSymbol rawClassSymbol4 = fieldSymbol.definingClass.getTopLevelClass();
                boolean bl2 = ((fieldSymbol.definingClass.access | fieldSymbol.access) & 4) != 0;
                RawClassSymbol rawClassSymbol5 = parser.currentClassSymbol;
                RawClassSymbol rawClassSymbol6 = fieldSymbol.definingClass;
                while (true) {
                    if (bl2 && rawClassSymbol6.isSuperclass(rawClassSymbol5)) {
                        this.useAccessor = true;
                        break block67;
                    }
                    if (rawClassSymbol6 == rawClassSymbol5) {
                        this.useAccessor = true;
                        break block67;
                    }
                    if (rawClassSymbol6.isInnerClass()) {
                        rawClassSymbol6 = rawClassSymbol6.getOuterClass();
                        continue;
                    }
                    if (!rawClassSymbol5.isInnerClass()) break;
                    rawClassSymbol6 = fieldSymbol.definingClass;
                    rawClassSymbol5 = rawClassSymbol5.getOuterClass();
                }
                Error error = parser.error(Message.errorAccessError, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName(), !bl2 ? "private" : "protected", Message.inString + " " + fieldSymbol.definingClass.errorName());
                return new ErrorExpression(error);
            }
        }
        if (fieldSymbol.initializer != null && (fieldSymbol.flags & 4) == 0 && parser.currentFieldSymbol != null && fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) && expression == null) {
            Error error = parser.error(Message.errorIllegalForwardRef, this.pos, false);
            return new ErrorExpression(error);
        }
        if (parser.currentMethodSymbol != null && parser.currentMethodSymbol.definingClass.equalTo(fieldSymbol.definingClass) && (parser.currentMethodSymbol.isClassInitializer() && (fieldSymbol.access & 8) != 0 || parser.currentMethodSymbol.isDynamicInitializer() && (fieldSymbol.access & 8) == 0) && 0 <= fieldSymbol.pos && this.pos < fieldSymbol.pos && !bl && this.qualification == null && expression == null) {
            Error error = parser.error(Message.errorIllegalForwardRef, this.pos, false);
            return new ErrorExpression(error);
        }
        if ((fieldSymbol.isDeprecated() || fieldSymbol.definingClass.isDeprecated()) && (!fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) || parser.options.selfDeprecation)) {
            parser.warning(fieldSymbol, Message.warningIsDeprecated, this.pos, fieldSymbol.errorName());
        }
        if ((fieldSymbol.access & 8) == 0) {
            if (expression == null) {
                if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) == 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) == 0) {
                    if (this.qualification != null) {
                        Error error = parser.error(Message.errorStaticReference, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                    if (!bl && this.isConstantInstanceField(fieldSymbol) && (fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) || parser.currentClassSymbol.isInnerClass(fieldSymbol.definingClass))) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
                        Expression expression2 = ((ConstantExpression)fieldSymbol.initializer).copyConstantExpression();
                        if (!(expression2 instanceof NullConstantExpression)) return expression2;
                        ((NullConstantExpression)expression2).setTypeExempt(fieldSymbol.type);
                        return expression2;
                    }
                    expression = new ThisExpression(this.pos, parser.currentClassSymbol);
                    this.thisArgument = expression.resolveAndCheck(parser);
                } else {
                    Error error = parser.error(Message.errorDynamicRef, this.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    return new ErrorExpression(error);
                }
            }
        } else {
            if (expression != null) {
                parser.warning(fieldSymbol, Message.warningStaticAccessWithObject, this.pos, fieldSymbol.errorName());
            }
            if (!bl && (fieldSymbol.flags & 2) != 0) {
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
                Expression expression3 = fieldSymbol.initializer;
                typeSymbol = expression3.getType();
                switch (typeSymbol.typeClass) {
                    default: {
                        if (typeSymbol.equalTo(fieldSymbol.type)) return expression3.promoteType(parser, fieldSymbol.type);
                        return this;
                    }
                    case 2: 
                    case 8: 
                    case 16: 
                    case 32: {
                        expression3 = ((ConstantExpression)expression3).copyConstantExpression();
                        DepInfo.addReference(parser.currentClassSymbol, fieldSymbol.definingClass);
                        return expression3.promoteType(parser, fieldSymbol.type);
                    }
                    case 4: 
                }
                int n = typeSymbol.typeKind == 4 ? ((CharConstantExpression)expression3).cval : ((IntConstantExpression)expression3).ival;
                expression3 = fieldSymbol.type.typeKind == 4 ? new CharConstantExpression(this.pos, (char)n) : new IntConstantExpression(this.pos, TypeSymbol.intSymbol, n);
                DepInfo.addReference(parser.currentClassSymbol, fieldSymbol.definingClass);
                return expression3.promoteType(parser, fieldSymbol.type);
            }
        }
        if (fieldSymbol.isSynthetic()) return this;
        if (!(this.thisArgument instanceof ThisExpression)) return this;
        if (parser.currentClassSymbol.isAnonymousInnerClass()) {
            if ((parser.currentClassSymbol.flags & 4) == 0) {
                if (parser.thisInitialized) return this;
            }
            if (!(rawClassSymbol2 = ((ClassSymbol)this.thisArgument.getType()).getClassSymbol()).isInnerClass()) return this;
            rawClassSymbol = fieldSymbol.definingClass;
            if (((ThisExpression)expression).outerClassSymbol != null) {
                rawClassSymbol = (RawClassSymbol)((ThisExpression)expression).outerClassSymbol;
            }
            if (rawClassSymbol.equalTo(rawClassSymbol2)) return this;
            if (rawClassSymbol.isSuperclass(rawClassSymbol2)) {
                if (fieldSymbol.isAccessible(parser.currentClassSymbol, rawClassSymbol2)) return this;
            }
            if (rawClassSymbol.isInterface()) {
                if (rawClassSymbol2.implementsInterface(rawClassSymbol)) return this;
            }
            if (parser.options.sourceJDKVersion >= 150) {
                if (rawClassSymbol2.getClassSymbol().isInnerClass(rawClassSymbol)) return this;
            }
            Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
            return new ErrorExpression(error);
        }
        if (parser.thisInitialized) return this;
        if (((ThisExpression)this.thisArgument).outerClassSymbol != null) return this;
        if (!fieldSymbol.definingClass.equalTo(parser.currentClassSymbol)) {
            if (!fieldSymbol.definingClass.isSuperclass(parser.currentClassSymbol)) return this;
        }
        Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
        return new ErrorExpression(error);
    }

    private static FieldSymbol getFieldSymbol(Parser parser, Expression expression) {
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            FieldSymbol fieldSymbol = (FieldSymbol)fieldExpression.field;
            if (fieldSymbol.definingClass.equalTo(parser.currentClassSymbol) && (fieldExpression.thisArgument instanceof ThisExpression || (fieldSymbol.access & 8) != 0)) {
                return fieldSymbol;
            }
        }
        return null;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.thisArgument;
        Expression expression2 = this._resolveAndCheck(parser, false);
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, expression2);
        if (fieldSymbol != null) {
            int n = fieldSymbol.index;
            if (!(parser.suspendDataFlowChecking || parser.defSet.get(n) || expression instanceof ThisExpression)) {
                parser.error(Message.errorNotInitialized, this.pos, false, this.errorName());
            }
            parser.useSet.set(n);
        }
        if (expression2 instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression2;
            fieldSymbol = (FieldSymbol)fieldExpression.field;
            fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
        }
        return expression2;
    }

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        Expression expression = this._resolveAndCheck(parser, false);
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, expression);
        if (fieldSymbol != null) {
            int n = fieldSymbol.index;
            parser.defSet.set(n);
            parser.posSet.set(n);
        }
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            fieldSymbol = (FieldSymbol)fieldExpression.field;
            if (!parser.suspendDataFlowChecking && (fieldSymbol.access & 0x10) != 0) {
                parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
            }
            fieldSymbol.flags = (short)(fieldSymbol.flags | 0x2000);
        }
        return expression;
    }

    Expression resolveAndCheckWrite(Parser parser) {
        return this._resolveAndCheck(parser, true);
    }

    void markDefined(Parser parser) {
        FieldSymbol fieldSymbol = FieldExpression.getFieldSymbol(parser, this);
        if (fieldSymbol != null) {
            int n = fieldSymbol.index;
            if (!parser.suspendDataFlowChecking) {
                if ((fieldSymbol.access & 0x10) != 0 && (fieldSymbol.flags & 0x11) != 1) {
                    if (parser.defSet.get(n) || parser.posSet.get(n)) {
                        parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                    } else if (parser.innerSwitchLoop != null && parser.innerSwitchLoop.inLoop()) {
                        LoopStatement loopStatement = parser.innerSwitchLoop.getLoopStatement();
                        if (!$assertionsDisabled && loopStatement.bodyStatements.first == null) {
                            throw new AssertionError();
                        }
                        if (parser.currentStatement == loopStatement) {
                            if (!loopStatement.bodyStatements.last.isLoopExitStatement()) {
                                parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                            }
                        } else if (!parser.currentStatement.parent.last.isLoopExitStatement() && !parser.resolvingForCondition) {
                            loopStatement.possibleReinitialization(this.pos, fieldSymbol);
                        }
                    }
                }
            } else if ((fieldSymbol.access & 0x10) != 0) {
                if (parser.currentFieldSymbol != null && (fieldSymbol.flags & 1) == 0 && parser.defSet.get(n)) {
                    parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                } else if ((fieldSymbol.flags & 0x10) != 0 && this.pos != 0) {
                    parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
                }
            }
            parser.defSet.set(n);
            parser.posSet.set(n);
        } else if (!parser.suspendDataFlowChecking) {
            fieldSymbol = (FieldSymbol)this.field;
            if ((fieldSymbol.access & 0x10) != 0) {
                parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
            }
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TypeSymbol typeSymbol;
        short s;
        Expression expression;
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        RawClassSymbol rawClassSymbol = fieldSymbol.definingClass;
        Parser parser = byteCodeGenerator.parser;
        RawClassSymbol rawClassSymbol2 = parser.currentClassSymbol;
        if ((fieldSymbol.flags & 1) != 0 && rawClassSymbol.isInnerClass() && rawClassSymbol2.equalTo(rawClassSymbol) && parser.currentMethodSymbol.isConstructor()) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)rawClassSymbol;
            InnerClassSymbol.HiddenArgumentList hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
            while (hiddenArgumentList != null) {
                if (hiddenArgumentList.fieldSymbol == fieldSymbol) {
                    if (hiddenArgumentList.kind == 0 || hiddenArgumentList.kind == 1) {
                        byteCodeGenerator.loadLocalVariable(fieldSymbol.type, hiddenArgumentList.stackVarIndex);
                    } else {
                        if (!$assertionsDisabled && hiddenArgumentList.kind != 2) {
                            throw new AssertionError();
                        }
                        byteCodeGenerator.loadLocalVariable(fieldSymbol.type, (short)(parser.currentMethodSymbol.actualArgCount - hiddenArgumentList.stackVarIndex));
                    }
                    return;
                }
                hiddenArgumentList = hiddenArgumentList.next;
            }
        }
        if ((expression = this.thisArgument) != null) {
            rawClassSymbol = ((ClassSymbol)expression.getType()).getClassSymbol();
            if (rawClassSymbol.isInnerClass() && expression instanceof ThisExpression) {
                RawClassSymbol rawClassSymbol3 = fieldSymbol.definingClass;
                if (((ThisExpression)expression).outerClassSymbol != null) {
                    rawClassSymbol3 = (RawClassSymbol)((ThisExpression)expression).outerClassSymbol;
                }
                if (!(rawClassSymbol3.equalTo(rawClassSymbol) || rawClassSymbol3.isSuperclass(rawClassSymbol) && fieldSymbol.isAccessible(rawClassSymbol2, rawClassSymbol) || rawClassSymbol3.isInterface() && rawClassSymbol.implementsInterface(rawClassSymbol3))) {
                    if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor()) {
                        byteCodeGenerator.loadLocalVariable(rawClassSymbol, (short)0);
                    }
                    rawClassSymbol = byteCodeGenerator.generateOuterClassFieldAccessor(fieldSymbol.definingClass, rawClassSymbol, false);
                } else {
                    expression.generateByteCode(byteCodeGenerator);
                }
            } else {
                expression.generateByteCode(byteCodeGenerator);
            }
            if ((fieldSymbol.access & 8) != 0) {
                this.thisArgument = null;
            }
        } else if (this.qualification != null) {
            rawClassSymbol = this.qualification.getClassSymbol();
        }
        if (this.useAccessor) {
            MethodSymbol methodSymbol = byteCodeGenerator.generateReadAccessor(fieldSymbol);
            s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            byteCodeGenerator.generate_8_16((byte)-72, s);
            if ((fieldSymbol.access & 8) != 0) {
                if (expression != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        } else if ((fieldSymbol.access & 8) != 0 && (fieldSymbol.flags & 2) != 0) {
            if (expression != null) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            fieldSymbol.initializer.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.incOpStackHeight(1);
        } else {
            s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(rawClassSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.generate_8_16((byte)-76, s);
            } else {
                if (expression != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.generate_8_16((byte)-78, s);
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        TypeSymbol typeSymbol2 = this.getType();
        if ((typeSymbol2.typeClass & 0x28) != 0) {
            byteCodeGenerator.incOpStackHeight(1);
        }
        if (!typeSymbol2.equalTo(typeSymbol = fieldSymbol.type.eraseType())) {
            s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol2.getInternalName());
            byteCodeGenerator.generate_8_16((byte)-64, s);
        }
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(rawClassSymbol2, rawClassSymbol);
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean bl) {
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        RawClassSymbol rawClassSymbol = fieldSymbol.definingClass;
        RawClassSymbol rawClassSymbol2 = byteCodeGenerator.parser.currentClassSymbol;
        Expression expression = this.thisArgument;
        if (expression != null) {
            rawClassSymbol = ((ClassSymbol)expression.getType()).getClassSymbol();
            if ((fieldSymbol.access & 8) != 0) {
                this.thisArgument = null;
            }
            if (!byteCodeGenerator.methodSymbol.isConstructor() || !rawClassSymbol.isInnerClass() || fieldSymbol.definingClass.equalTo(rawClassSymbol) || fieldSymbol.definingClass.isSuperclass(rawClassSymbol)) {
                expression.generateByteCode(byteCodeGenerator);
            }
        } else if (this.qualification != null) {
            rawClassSymbol = this.qualification.getClassSymbol();
        }
        if (rawClassSymbol.isInnerClass() && !fieldSymbol.definingClass.equalTo(rawClassSymbol) && !fieldSymbol.definingClass.isSuperclass(rawClassSymbol)) {
            rawClassSymbol = byteCodeGenerator.generateOuterClassFieldAccessor(fieldSymbol.definingClass, rawClassSymbol, false);
        }
        if (this.useAccessor) {
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.generate_8(bl ? (byte)90 : 89);
                byteCodeGenerator.incOpStackHeight(1);
            }
            MethodSymbol methodSymbol = byteCodeGenerator.generateReadAccessor(fieldSymbol);
            short s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            byteCodeGenerator.generate_8_16((byte)-72, s);
            if ((fieldSymbol.access & 8) != 0) {
                if (expression != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        } else {
            short s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(rawClassSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.generate_8(bl ? (byte)90 : 89);
                byteCodeGenerator.generate_8_16((byte)-76, s);
                byteCodeGenerator.incOpStackHeight(1);
            } else {
                if (expression != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
                byteCodeGenerator.generate_8_16((byte)-78, s);
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        if ((this.getType().typeClass & 0x28) != 0) {
            byteCodeGenerator.incOpStackHeight(1);
        }
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(rawClassSymbol2, rawClassSymbol);
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        FieldSymbol fieldSymbol = (FieldSymbol)this.field;
        RawClassSymbol rawClassSymbol = fieldSymbol.definingClass;
        RawClassSymbol rawClassSymbol2 = byteCodeGenerator.parser.currentClassSymbol;
        if (this.thisArgument != null) {
            rawClassSymbol = ((ClassSymbol)this.thisArgument.getType()).getClassSymbol();
        } else if (this.qualification != null) {
            rawClassSymbol = this.qualification.getClassSymbol();
        }
        if (rawClassSymbol.isInnerClass() && !fieldSymbol.definingClass.equalTo(rawClassSymbol) && !fieldSymbol.definingClass.isSuperclass(rawClassSymbol)) {
            RawClassSymbol rawClassSymbol3 = fieldSymbol.definingClass;
            RawClassSymbol rawClassSymbol4 = rawClassSymbol;
            while (!rawClassSymbol3.equalTo(rawClassSymbol = rawClassSymbol4.getOuterClass()) && !rawClassSymbol3.isSuperclass(rawClassSymbol)) {
                rawClassSymbol4 = rawClassSymbol;
            }
        }
        if (this.useAccessor) {
            MethodSymbol methodSymbol = byteCodeGenerator.generateWriteAccessor(fieldSymbol);
            short s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol.definingClass.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            byteCodeGenerator.generate_8_16((byte)-72, s);
            if ((fieldSymbol.access & 8) == 0) {
                byteCodeGenerator.decOpStackHeight(1);
            } else if (this.thisArgument != null) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
        } else {
            short s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(rawClassSymbol.getInternalName(), fieldSymbol.identifier.name, fieldSymbol.getSignature());
            if ((fieldSymbol.access & 8) != 0) {
                byteCodeGenerator.generate_8_16((byte)-77, s);
                if (this.thisArgument != null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                }
            } else {
                byteCodeGenerator.generate_8_16((byte)-75, s);
                byteCodeGenerator.decOpStackHeight(1);
            }
        }
        byteCodeGenerator.decOpStackHeight(1);
        if ((this.getType().typeClass & 0x28) != 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(rawClassSymbol2, rawClassSymbol);
    }

    static {
        $assertionsDisabled = !FieldExpression.class.desiredAssertionStatus();
    }
}

