/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.VariableSymbol;

final class FieldSymbol
extends VariableSymbol {
    static final short FVSF_NONE = 0;
    static final short FVSF_SYNTHETIC = 1;
    static final short FVSF_CONSTANTVALUE = 2;
    static final short FVSF_INITIALIZER_CHECKED = 4;
    static final short FVSF_DEPRECATED = 8;
    static final short FVSF_FINALLOCAL = 16;
    static final short FVSF_THISDOLLARFIELD = 32;
    static final short FVSF_USED = 8192;
    static final short FVSF_POSSIBLYASSIGNED = 16384;
    static final short FVSF_DEFINITELYASSIGNED = Short.MIN_VALUE;
    static FieldSymbol errorField;
    FieldSymbol nextInClass;
    RawClassSymbol definingClass;
    Expression initializer;
    int index;
    short flags;

    private FieldSymbol() {
        super((byte)2, 0, null, null, 0, (short)0, null);
    }

    FieldSymbol(int n, RawClassSymbol rawClassSymbol, Identifier identifier, TypeSymbol typeSymbol, int n2, short s, Annotation annotation) {
        super((byte)2, n, identifier, typeSymbol, n2, s, annotation);
        this.definingClass = rawClassSymbol;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.definingClass.toString());
        stringBuffer.append('.');
        stringBuffer.append(this.identifier.toString());
        return stringBuffer.toString();
    }

    boolean isDeprecated() {
        return (this.flags & 8) != 0;
    }

    boolean isSynthetic() {
        return (this.flags & 1) != 0;
    }

    void deprecate() {
        this.flags = (short)(this.flags | 8);
    }

    String kindName() {
        return Message.fieldString;
    }

    boolean isErroneous() {
        return this.definingClass.isErroneous() || this.type.isErroneous();
    }

    String errorName() {
        if ((this.flags & 0x10) != 0) {
            String string = this.identifier.toString();
            return Message.variableString + " " + string.substring(string.lastIndexOf(Identifier.dollarCharacter) + 1);
        }
        return super.errorName();
    }

    boolean isAccessible(ClassSymbol classSymbol, ClassSymbol classSymbol2) {
        if (!classSymbol2.isAccessible(classSymbol)) {
            return false;
        }
        switch (this.access & 7) {
            case 2: {
                return this.definingClass.equalTo(classSymbol) && this.definingClass.equalTo(classSymbol2);
            }
            case 1: {
                return true;
            }
            case 4: {
                if (!this.definingClass.equalTo(classSymbol) && !this.definingClass.isSuperclass(classSymbol)) break;
                if ((this.access & 8) != 0) {
                    return true;
                }
                if (!classSymbol.equalTo(classSymbol2) && !classSymbol.isSuperclass(classSymbol2)) break;
                return true;
            }
        }
        return this.definingClass.inSamePackage(classSymbol);
    }

    byte getAnnotationTarget() {
        return 2;
    }

    static void initializeStatics() {
        errorField = new FieldSymbol();
    }

    static void releaseStatics() {
        errorField = null;
    }

    boolean involvesGenerics() {
        return this.type.involvesGenerics();
    }

    char[] getFieldSignature() {
        return this.type.getGenericSignature();
    }
}

