/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeSymbol;

final class ForStatement
extends LoopStatement {
    StatementList initStatements;
    Expression condition;
    StatementList updateStatements;
    static final /* synthetic */ boolean $assertionsDisabled;

    ForStatement(StatementList statementList, int n, int n2, Expression expression, StatementList statementList2, StatementList statementList3, StatementList statementList4) {
        super(statementList, n, n2, (byte)11, statementList3);
        if (expression == null) {
            expression = new BooleanConstantExpression(n, true);
        }
        this.initStatements = statementList2;
        this.condition = expression;
        this.updateStatements = statementList4;
        if (statementList2 != null) {
            statementList2.parent = this;
        }
        if (statementList4 != null) {
            statementList4.parent = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        StatementList statementList = this.initStatements;
        if (statementList != null) {
            statementList.resolveAndCheck(parser);
        }
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(switchLoopList, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            StatementList statementList2;
            parser.innerSwitchLoop = this.loopRec;
            StatementList statementList3 = this.bodyStatements;
            parser.resolvingForCondition = true;
            boolean bl = false;
            Expression expression = this.condition.resolveAndCheck(parser);
            parser.resolvingForCondition = false;
            TypeSymbol typeSymbol = expression.getType();
            byte by = typeSymbol.typeKind;
            if (by != 2) {
                if (parser.options.sourceJDKVersion >= 150 && typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
                    expression = new AutoUnboxingExpression(expression, TypeSymbol.booleanSymbol);
                } else {
                    parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), "boolean");
                }
            }
            if (expression.isConstantBooleanExpression()) {
                if (!expression.getConstantBooleanExpressionValue()) {
                    if (this.condition.kind == 2) {
                        parser.error(Message.errorUnreachableStatement, statementList3.first == null ? this.pos : statementList3.first.pos, false);
                    }
                } else {
                    bl = true;
                }
            } else {
                ++parser.estimatedLineCount;
            }
            BitSet bitSet = (BitSet)parser.defSet.clone();
            this.condition = expression;
            if (statementList3 != null) {
                if (expression.isLogicalExpression()) {
                    parser.defSet = expression.getLogicalExpressionTrueDefSet();
                }
                statementList3.resolveAndCheck(parser);
                if (bl && this.loopRec.breakSymbol == null && this.next != null && this.next.isCodeStatement()) {
                    parser.error(Message.errorUnreachableStatement, this.next.pos, false);
                }
            } else if (bl && this.next != null && this.next.isCodeStatement()) {
                parser.error(Message.errorUnreachableStatement, this.next.pos, false);
            }
            if (this.continueDefSet != null) {
                parser.defSet.and(this.continueDefSet);
            }
            if ((statementList2 = this.updateStatements) != null) {
                statementList2.resolveAndCheck(parser);
            }
            this.loopRec.insertLabels();
            if (this.resultDefSet != null) {
                if (bl) {
                    parser.defSet = this.resultDefSet;
                } else if (expression.isLogicalExpression()) {
                    parser.defSet = this.resultDefSet;
                    parser.defSet.and(expression.getLogicalExpressionFalseDefSet());
                } else {
                    parser.defSet = bitSet;
                }
            } else {
                parser.defSet = expression.isLogicalExpression() ? expression.getLogicalExpressionFalseDefSet() : bitSet;
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
        }
        finally {
            parser.innerSwitchLoop = switchLoopList;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        StatementList statementList;
        StatementList statementList2 = this.initStatements;
        if (statementList2 != null) {
            statementList2.generateByteCode(byteCodeGenerator);
        }
        Label label = new Label();
        Label label2 = new Label();
        byteCodeGenerator.generateBranch_goto(label);
        byteCodeGenerator.setLabel(label2);
        SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
        StatementList statementList3 = this.bodyStatements;
        if (statementList3 != null) {
            statementList3.generateByteCode(byteCodeGenerator);
        }
        if ((statementList = this.updateStatements) != null) {
            statementList.generateByteCode(byteCodeGenerator);
        }
        byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
        byteCodeGenerator.setLabel(label);
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression()) {
            if (expression.getConstantBooleanExpressionValue()) {
                byteCodeGenerator.generateBranch_goto(label2);
            }
        } else {
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(expression.pos));
            expression.generateByteCodeBranch(byteCodeGenerator, label2, false);
        }
    }

    boolean canReachNextStatement(boolean bl) {
        Expression expression = this.condition;
        boolean bl2 = false;
        if (expression.isConstantBooleanExpression()) {
            bl2 = expression.getConstantBooleanExpressionValue();
        }
        if (!$assertionsDisabled && this.loopRec == null) {
            throw new AssertionError();
        }
        if (this.loopRec.breakSymbol != null) {
            bl2 = false;
        }
        return !bl2;
    }

    static {
        $assertionsDisabled = !ForStatement.class.desiredAssertionStatus();
    }
}

