/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;

public class IdeLog
implements Log {
    private int nwarnings;
    private int nerrors;

    IdeLog() {
    }

    public void redirect(String string) {
    }

    public void finalize() {
        System.err.flush();
    }

    public void print(String string) {
        System.err.print(string);
        System.err.flush();
    }

    public void println(String string) {
        System.err.println(string);
        System.err.flush();
    }

    static String formatMessage(Storage storage, int n, ErrorInfo errorInfo, boolean bl) {
        if (n == 0) {
            String string = "";
            if (storage != null) {
                string = storage.toString() + ":1: ";
            }
            return (bl ? Message.warningString : Message.errorString) + " #" + errorInfo.getNumber() + ": " + errorInfo.getMessage();
        }
        int n2 = Scanner.positionToLine(n);
        int n3 = Scanner.positionToColumn(n);
        return storage.toString() + ":" + n2 + ": " + (bl ? Message.warningString : Message.errorString) + " #" + errorInfo.getNumber() + ": " + errorInfo.getMessage();
    }

    private void printMessage(Storage storage, int n, ErrorInfo errorInfo, boolean bl) {
        this.println(IdeLog.formatMessage(storage, n, errorInfo, bl));
    }

    public void printError(Storage storage, int n, ErrorInfo errorInfo) {
        ++this.nerrors;
        this.printMessage(storage, n, errorInfo, false);
    }

    public void printWarning(Storage storage, int n, ErrorInfo errorInfo) {
        ++this.nwarnings;
        this.printMessage(storage, n, errorInfo, true);
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }
}

