/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeSymbol;

final class IfStatement
extends Statement {
    Expression condition;
    StatementList thenStatements;

    IfStatement(StatementList statementList, int n, Expression expression, StatementList statementList2) {
        super(statementList, n, (byte)2);
        this.condition = expression;
        this.thenStatements = statementList2;
        statementList2.parent = this;
    }

    void resolveAndCheck(Parser parser) {
        Expression expression = this.condition.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeKind;
        if (by != 2) {
            if (parser.options.sourceJDKVersion >= 150 && typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
                expression = new AutoUnboxingExpression(expression, TypeSymbol.booleanSymbol);
            } else {
                parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), "boolean");
            }
        }
        this.condition = expression;
        BitSet bitSet = (BitSet)parser.defSet.clone();
        BitSet bitSet2 = (BitSet)parser.posSet.clone();
        if (expression.isLogicalExpression()) {
            parser.defSet = expression.getLogicalExpressionTrueDefSet();
        }
        boolean bl = parser.suspendDataFlowChecking;
        if (expression.isConstantBooleanExpression() && !expression.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        this.thenStatements.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = bl;
        if (expression.isConstantBooleanExpression()) {
            if (!expression.getConstantBooleanExpressionValue()) {
                parser.defSet = bitSet;
            }
        } else if (!this.thenStatements.canReachNextStatement(false)) {
            parser.defSet = bitSet;
            if (expression.isLogicalExpression()) {
                parser.defSet.or(expression.getLogicalExpressionFalseDefSet());
            }
            parser.posSet = bitSet2;
        } else if (expression.isLogicalExpression()) {
            parser.defSet.and(expression.getLogicalExpressionFalseDefSet());
        } else {
            parser.defSet = bitSet;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression()) {
            if (expression.kind != 2) {
                expression.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (expression.getConstantBooleanExpressionValue()) {
                this.thenStatements.generateByteCode(byteCodeGenerator);
            }
        } else {
            Label label = new Label();
            expression.generateByteCodeBranch(byteCodeGenerator, label, true);
            this.thenStatements.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.setLabel(label);
        }
    }

    boolean canReachNextStatement(boolean bl) {
        if (bl && this.condition.isConstantBooleanExpression() && this.condition.getConstantBooleanExpressionValue()) {
            return this.thenStatements.canReachNextStatement(bl);
        }
        return true;
    }
}

