/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;

final class ImportSymbol
extends Symbol {
    static final byte ISF_NONE = 0;
    static final byte ISF_EXPLICITIMPORT = 1;
    static final byte ISF_STATICIMPORT = 2;
    static final byte ISF_ONDEMANDIMPORT = 4;
    static final byte ISF_INNERONDEMANDIMPORT = 8;
    ImportDescriptor importDescriptor;
    Symbol importedSymbol;
    boolean used;
    byte flags;
    static final /* synthetic */ boolean $assertionsDisabled;

    ImportSymbol(int n, Symbol symbol, ImportDescriptor importDescriptor) {
        super((byte)(symbol.kind | 4), n, symbol.identifier);
        this.importDescriptor = importDescriptor;
        this.importedSymbol = symbol;
    }

    public String toString() {
        return this.importedSymbol.toString();
    }

    String errorName() {
        return this.importedSymbol.errorName();
    }

    char[] getSignature() {
        return this.importedSymbol.getSignature();
    }

    Symbol importSymbolHidesOtherImport() {
        Symbol symbol = this.nextHashed;
        while (symbol != null) {
            if (symbol.identifier == this.identifier && symbol.kind == this.kind) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    RawClassSymbol getImportSymbolClass() {
        switch (this.importedSymbol.kind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 32: {
                return (RawClassSymbol)this.importedSymbol;
            }
            case 2: {
                return ((FieldSymbol)this.importedSymbol).definingClass;
            }
            case 8: 
        }
        return ((MethodSymbol)this.importedSymbol).definingClass;
    }

    boolean resolveAndCheck(Parser parser, Scope scope) {
        RawClassSymbol rawClassSymbol;
        if (this.importedSymbol instanceof RawClassSymbol && !(rawClassSymbol = (RawClassSymbol)this.importedSymbol).isCompiled()) {
            ClassScope classScope = rawClassSymbol.classScope;
            if (classScope == null) {
                rawClassSymbol.loadType(parser, this.pos);
            }
            if ((rawClassSymbol.access & 1) == 0) {
                if (scope != null) {
                    Symbol[] symbolArray = parser.currentImportDeclartions;
                    int n = symbolArray.length;
                    for (int i = 0; i < n; ++i) {
                        int n2;
                        if (symbolArray[i] != this) continue;
                        Symbol[] symbolArray2 = new Symbol[--n];
                        for (n2 = 0; n2 < i; ++n2) {
                            symbolArray2[n2] = symbolArray[n2];
                        }
                        for (n2 = i; n2 < n; ++n2) {
                            symbolArray2[n2] = symbolArray[n2 + 1];
                        }
                        parser.currentImportDeclartions = symbolArray2;
                        scope.removeSymbol(this);
                        break;
                    }
                }
                this.importDescriptor.importSymbolList.remove(this);
                return false;
            }
            if (classScope == null) {
                this.importDescriptor.importInnerClasses(parser, rawClassSymbol, rawClassSymbol.pos);
            }
        }
        return true;
    }

    static {
        $assertionsDisabled = !ImportSymbol.class.desiredAssertionStatus();
    }
}

