/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class InstanceOfExpression
extends Expression {
    Expression instance;
    TypeSymbol ofType;

    InstanceOfExpression(int n, Expression expression, TypeSymbol typeSymbol) {
        super((byte)28, n);
        this.instance = expression;
        this.ofType = typeSymbol;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        this.instance = this.instance.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = this.instance.getType();
        this.ofType = typeSymbol = this.ofType.resolveType(parser, this.pos, true, true);
        if (typeSymbol2.isPrimitiveType()) {
            Error error = parser.error(Message.errorObjectOrArrayRequired, this.pos, typeSymbol2.isErroneous(), typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        if (typeSymbol.isPrimitiveType()) {
            Error error = parser.error(Message.errorObjectOrArrayRequired, this.pos, typeSymbol.isErroneous(), typeSymbol.errorName());
            return new ErrorExpression(error);
        }
        typeSymbol.resolveType(parser, this.pos, false, true);
        typeSymbol.checkDeprecated(parser, this.pos);
        ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol2;
        ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol;
        if (typeSymbol2.isParameterizedClass()) {
            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)typeSymbol2;
            if (parameterizedClassSymbol.typeVariableList != null) {
                referenceTypeSymbol = ParameterizedClassSymbol.getParameterizedClassSymbol(parameterizedClassSymbol.genericClassSymbol, null, parameterizedClassSymbol.outerClassSymbol);
            }
        }
        if (!referenceTypeSymbol.isCastCompatible(parser, referenceTypeSymbol2)) {
            Error error = parser.error(Message.errorCannotCompare, this.pos, typeSymbol2.isErroneous() | typeSymbol.isErroneous(), typeSymbol2.errorName(), typeSymbol.errorName());
            return new ErrorExpression(error);
        }
        if (!referenceTypeSymbol2.isReifiable()) {
            parser.error(Error.errorNoTypeParametersAllowed, this.pos, referenceTypeSymbol2.isErroneous(), referenceTypeSymbol2.errorName());
        } else if (referenceTypeSymbol2.isTypeParameter()) {
            parser.error(Error.errorIllegalTypeParameterOperator, this.pos, false, this.toString());
        }
        this.setType(TypeSymbol.booleanSymbol);
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.instance.generateByteCode(byteCodeGenerator);
        short s = byteCodeGenerator.constantPool.enterConstantPoolClass(this.ofType.getInternalName());
        byteCodeGenerator.generate_8_16((byte)-63, s);
        if (this.ofType.isClass()) {
            RawClassSymbol rawClassSymbol = ((ClassSymbol)this.ofType).getClassSymbol();
            byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(byteCodeGenerator.parser.currentClassSymbol, rawClassSymbol);
        }
    }

    public String toString() {
        return "instanceof";
    }
}

