/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntersectionType;
import oracle.ojc.compiler.MemberExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.NewExpression;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TryStatement;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class InvokeExpression
extends MemberExpression {
    public static final byte IM_INTERFACE = 0;
    public static final byte IM_SUPER = 1;
    public static final byte IM_CONSTRUCTOR = 2;
    public static final byte IM_VIRTUAL = 3;
    public static final byte IM_STATIC = 4;
    public static final byte IEF_NONE = 0;
    public static final byte IEF_THIS_CONSTR_CALL = 1;
    public static final byte IEF_SUPER_CONSTR_CALL = 2;
    public static final byte IEF_CONSTR_CALL = 3;
    public static final byte IEF_VARARG = 4;
    Symbol method;
    TypeVariableList typeArguments;
    ExpressionList arguments;
    byte argCount;
    byte flags;
    boolean resolvedArguments;
    static final /* synthetic */ boolean $assertionsDisabled;

    InvokeExpression(int n, Symbol symbol, TypeVariableList typeVariableList, Expression expression, ExpressionList expressionList) {
        super((byte)4, n, expression);
        this.method = symbol;
        this.typeArguments = typeVariableList;
        this.arguments = expressionList;
    }

    boolean takeAssignmentContext() {
        return true;
    }

    private static boolean isWideningReferenceConversion(Parser parser, TypeSymbol typeSymbol, TypeSymbol typeSymbol2, byte by) {
        if (typeSymbol == ReferenceTypeSymbol.nullTypeSymbol) {
            return true;
        }
        if (typeSymbol2 == parser.javaLangObjectPcs) {
            return true;
        }
        byte by2 = typeSymbol2.typeKind;
        byte by3 = typeSymbol.typeKind;
        if (by3 == 10 && by2 == 10) {
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol.resolveType(parser, 0, false, true);
            ClassSymbol classSymbol2 = (ClassSymbol)typeSymbol2.resolveType(parser, 0, false, true);
            if (typeSymbol2.isTypeParameter() && typeSymbol.containsTypeParameter((TypeParameterSymbol)typeSymbol2)) {
                return false;
            }
            if (classSymbol2.isInterface()) {
                return classSymbol.implementsInterface(classSymbol2);
            }
            return classSymbol2.isSuperclass(classSymbol);
        }
        if (by3 == 11 && by2 == 10) {
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol2;
            if (classSymbol.isInterface()) {
                return classSymbol.equalTo(parser.javaLangCloneableSymbol) || classSymbol.equalTo(parser.javaIoSerializableSymbol);
            }
            return classSymbol.equalTo(parser.javaLangObjectSymbol);
        }
        if (by3 == 11 && by2 == 11) {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            ArraySymbol arraySymbol2 = (ArraySymbol)typeSymbol2;
            TypeSymbol typeSymbol3 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
            TypeSymbol typeSymbol4 = ArraySymbol.getArrayType(arraySymbol2.baseType, arraySymbol2.dimension - 1);
            if (typeSymbol3.isPrimitiveType() || typeSymbol4.isPrimitiveType()) {
                return typeSymbol4 == typeSymbol3;
            }
            return InvokeExpression.isWideningReferenceConversion(parser, typeSymbol3, typeSymbol4, by);
        }
        return false;
    }

    private static boolean canConvertArgument(Parser parser, TypeSymbol typeSymbol, TypeSymbol typeSymbol2, byte by) {
        if (typeSymbol.equalTo(typeSymbol2)) {
            return true;
        }
        byte by2 = typeSymbol2.typeKind;
        byte by3 = typeSymbol.typeKind;
        if (typeSymbol2.isErroneous() || typeSymbol.isErroneous()) {
            return true;
        }
        if (by > 1) {
            TypeSymbol typeSymbol3;
            if (typeSymbol.isReferenceType() && typeSymbol2.isPrimitiveType()) {
                TypeSymbol typeSymbol4 = BoxingExpression.getPrimitiveType(parser, typeSymbol);
                if (typeSymbol4 != null) {
                    return InvokeExpression.canConvertArgument(parser, typeSymbol4, typeSymbol2, (byte)1);
                }
            } else if (typeSymbol.isPrimitiveType() && typeSymbol2.isReferenceType() && (typeSymbol3 = BoxingExpression.getBoxedType(parser, typeSymbol)) != null) {
                return InvokeExpression.canConvertArgument(parser, typeSymbol3, typeSymbol2, (byte)1);
            }
        }
        switch (by3) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 10: 
            case 11: {
                if (!typeSymbol2.isReferenceType()) {
                    return false;
                }
                return InvokeExpression.isWideningReferenceConversion(parser, typeSymbol, typeSymbol2, by);
            }
            case 1: 
            case 2: 
            case 9: {
                return false;
            }
            case 4: 
            case 5: {
                if ((typeSymbol2.typeClass & 0x38) != 0) {
                    return true;
                }
                return by2 == 6;
            }
            case 3: {
                if ((typeSymbol2.typeClass & 0x38) != 0) {
                    return true;
                }
                return by2 == 5 || by2 == 6;
            }
            case 6: {
                return (typeSymbol2.typeClass & 0x38) != 0;
            }
            case 7: {
                return (typeSymbol2.typeClass & 0x30) != 0;
            }
            case 8: 
        }
        return by2 == 9;
    }

    private static int compareArguments(Parser parser, TypeSymbol typeSymbol, TypeSymbol typeSymbol2, byte by) {
        if (typeSymbol2.equalTo(typeSymbol)) {
            return 1;
        }
        if (typeSymbol2.isClass() && typeSymbol.isClass()) {
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
            ClassSymbol classSymbol2 = (ClassSymbol)typeSymbol2;
            if (classSymbol.isInterface() && classSymbol2.getClassSymbol().implementsInterfaceDirectly(classSymbol)) {
                if (classSymbol.isParameterizedClass() && classSymbol2.isParameterizedClass()) {
                    ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol;
                    ParameterizedClassSymbol parameterizedClassSymbol2 = (ParameterizedClassSymbol)classSymbol2;
                    if (parameterizedClassSymbol.typeVariableList != null && parameterizedClassSymbol2.typeVariableList != null && !parameterizedClassSymbol.typeVariableList.equals(parameterizedClassSymbol2.typeVariableList)) {
                        return 0;
                    }
                }
                return 1;
            }
        }
        typeSymbol.resolveType(parser, 0, false, true);
        typeSymbol2.resolveType(parser, 0, false, true);
        if (InvokeExpression.canConvertArgument(parser, typeSymbol2, typeSymbol, by)) {
            if (!typeSymbol2.isNumericType() || by > 1 && (typeSymbol2.isPrimitiveType() && typeSymbol.isReferenceType() || typeSymbol2.isReferenceType() && typeSymbol.isPrimitiveType())) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private static TypeVariableSymbol computeLeastContainingTypeArgument(Parser parser, TypeVariableSymbol typeVariableSymbol, TypeVariableSymbol typeVariableSymbol2) {
        int n;
        ClassSymbol classSymbol;
        ClassSymbol classSymbol2;
        ClassSymbol classSymbol3 = (ClassSymbol)typeVariableSymbol.refSymbol;
        if (classSymbol3 == null) {
            classSymbol3 = parser.javaLangObjectPcs;
        }
        if ((classSymbol2 = (ClassSymbol)typeVariableSymbol2.refSymbol) == null) {
            classSymbol2 = parser.javaLangObjectPcs;
        }
        switch (typeVariableSymbol.typeVariableKind << 8 | typeVariableSymbol2.typeVariableKind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 257: {
                if (classSymbol3 == classSymbol2) {
                    return typeVariableSymbol;
                }
            }
            case 0: 
            case 1: 
            case 2: 
            case 256: 
            case 258: 
            case 512: 
            case 513: 
            case 514: {
                classSymbol = InvokeExpression.computeLeastUpperBound(parser, classSymbol3, classSymbol2);
                n = 2;
                break;
            }
            case 259: 
            case 769: 
            case 771: {
                ClassSymbol[] classSymbolArray = new ClassSymbol[]{classSymbol3, classSymbol2};
                classSymbol = InvokeExpression.computeInterSectionType(parser, classSymbolArray);
                n = 3;
                break;
            }
            case 3: 
            case 515: 
            case 768: 
            case 770: {
                if (classSymbol3 == classSymbol2) {
                    return typeVariableSymbol;
                }
                classSymbol = parser.javaLangObjectPcs;
                n = 2;
            }
        }
        if (classSymbol == null) {
            return null;
        }
        return new TypeVariableSymbol(0, (byte)n, classSymbol);
    }

    private static ClassSymbol computeLeastContainingInvocation(Parser parser, ClassSymbol classSymbol, ClassSymbol classSymbol2) {
        ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol;
        TypeVariableList typeVariableList = parameterizedClassSymbol.typeVariableList;
        if (typeVariableList == null) {
            return parameterizedClassSymbol;
        }
        ParameterizedClassSymbol parameterizedClassSymbol2 = (ParameterizedClassSymbol)classSymbol2;
        TypeVariableList typeVariableList2 = parameterizedClassSymbol2.typeVariableList;
        if (typeVariableList2 == null) {
            return parameterizedClassSymbol2;
        }
        TypeVariableList typeVariableList3 = null;
        TypeVariableList typeVariableList4 = null;
        while (typeVariableList != null) {
            TypeVariableSymbol typeVariableSymbol = InvokeExpression.computeLeastContainingTypeArgument(parser, typeVariableList.typeVariable, typeVariableList2.typeVariable);
            if (typeVariableSymbol == null) {
                return null;
            }
            TypeVariableList typeVariableList5 = new TypeVariableList(typeVariableSymbol);
            if (typeVariableList4 == null) {
                typeVariableList4 = typeVariableList3 = typeVariableList5;
            } else {
                typeVariableList3.next = typeVariableList5;
                typeVariableList3 = typeVariableList5;
            }
            typeVariableList = typeVariableList.next;
            typeVariableList2 = typeVariableList2.next;
        }
        return ParameterizedClassSymbol.getParameterizedClassSymbol(parameterizedClassSymbol.genericClassSymbol, typeVariableList4, null);
    }

    private static ClassSymbol computeLeastUpperBound(Parser parser, Set set, Set set2) {
        ClassSymbol classSymbol;
        ClassSymbol classSymbol2;
        int n;
        int n2;
        int n3 = n2 = set2.size();
        if (n2 == 0) {
            return null;
        }
        ClassSymbol[] classSymbolArray = set2.toArray(new ClassSymbol[n2]);
        for (n = 0; n < n2; ++n) {
            classSymbol2 = classSymbolArray[n];
            if (classSymbol2 == null) continue;
            for (int i = 0; i < n2; ++i) {
                if (n == i || (classSymbol = classSymbolArray[i]) == null) continue;
                if (classSymbol.isInterface()) {
                    if (!classSymbol2.implementsInterface(classSymbol)) continue;
                    classSymbolArray[i] = null;
                    --n3;
                    continue;
                }
                if (!classSymbol.isSuperclass(classSymbol2)) continue;
                classSymbolArray[i] = null;
                --n3;
            }
        }
        HashSet<ClassSymbol> hashSet = new HashSet<ClassSymbol>(n3);
        for (n = 0; n < n2; ++n) {
            classSymbol2 = classSymbolArray[n];
            if (classSymbol2 == null) continue;
            hashSet.add(classSymbol2);
        }
        ArrayList<ClassSymbol> arrayList = new ArrayList<ClassSymbol>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RawClassSymbol rawClassSymbol = (RawClassSymbol)iterator.next();
            Iterator iterator2 = set.iterator();
            ArrayList<ClassSymbol> arrayList2 = new ArrayList<ClassSymbol>();
            while (iterator2.hasNext()) {
                classSymbol2 = (ClassSymbol)iterator2.next();
                if (classSymbol2.getClassSymbol() != rawClassSymbol) continue;
                arrayList2.add(classSymbol2);
            }
            classSymbol2 = (ClassSymbol)arrayList2.get(0);
            n2 = arrayList2.size();
            for (n = 1; n < n2; ++n) {
                classSymbol = (ClassSymbol)arrayList2.get(n);
                if ((classSymbol2 = InvokeExpression.computeLeastContainingInvocation(parser, classSymbol2, classSymbol)) != null) continue;
                return null;
            }
            arrayList.add(classSymbol2);
        }
        return InvokeExpression.computeInterSectionType(parser, arrayList.toArray(new ClassSymbol[arrayList.size()]));
    }

    private static Set intersect(Set set, Set set2) {
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!set2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    static ClassSymbol computeLeastUpperBound(Parser parser, ClassSymbol classSymbol, ClassSymbol classSymbol2) {
        HashSet<ClassSymbol> hashSet = new HashSet<ClassSymbol>();
        hashSet.add(classSymbol);
        classSymbol.getSuperclasses(hashSet);
        hashSet.add(classSymbol2);
        classSymbol.getSuperclasses(hashSet);
        HashSet<RawClassSymbol> hashSet2 = new HashSet<RawClassSymbol>();
        hashSet2.add(classSymbol.getClassSymbol());
        classSymbol.getErasedSuperclasses(hashSet2);
        HashSet<RawClassSymbol> hashSet3 = new HashSet<RawClassSymbol>();
        hashSet3.add(classSymbol2.getClassSymbol());
        classSymbol2.getErasedSuperclasses(hashSet3);
        Set set = InvokeExpression.intersect(hashSet2, hashSet3);
        return InvokeExpression.computeLeastUpperBound(parser, hashSet, set);
    }

    private static ClassSymbol computeInterSectionType(Parser parser, ClassSymbol[] classSymbolArray) {
        ClassSymbol classSymbol = null;
        ImplementationList implementationList = null;
        for (int i = 0; i < classSymbolArray.length; ++i) {
            ImplementationList implementationList2;
            ClassSymbol classSymbol2 = classSymbolArray[i];
            if (classSymbol2.isTypeParameter()) {
                ClassSymbolList classSymbolList = ((TypeParameterSymbol)classSymbol2).interfaceBounds;
                while (classSymbolList != null) {
                    implementationList2 = new ImplementationList(classSymbolList.classSymbol);
                    implementationList2.next = implementationList;
                    implementationList = implementationList2;
                    classSymbolList = classSymbolList.next;
                }
                continue;
            }
            if (classSymbol2.isInterface()) {
                implementationList2 = new ImplementationList(classSymbol2);
                implementationList2.next = implementationList;
                implementationList = implementationList2;
                continue;
            }
            if (classSymbol == null) {
                classSymbol = classSymbol2;
                continue;
            }
            if (classSymbol == classSymbol2) continue;
            classSymbol = (ClassSymbol)InvokeExpression.findCommonSuperclass(parser, classSymbol, classSymbol2);
        }
        if (classSymbol == null) {
            if (implementationList == null) {
                return null;
            }
            classSymbol = parser.javaLangObjectPcs;
        } else if (implementationList == null) {
            return classSymbol;
        }
        return new IntersectionType(classSymbol, implementationList);
    }

    private boolean inferTypeParamtersFromInitialConstraints(Parser parser, MethodSymbol methodSymbol, TypeVariableList typeVariableList, InitialConstraint initialConstraint, boolean bl) {
        EqualityConstraint equalityConstraint = new EqualityConstraintAnchor();
        InitialConstraint initialConstraint2 = initialConstraint;
        while (initialConstraint2 != null) {
            EqualityConstraint equalityConstraint2 = initialConstraint2.getImpliedEqualityConstraint(parser);
            if (equalityConstraint2 != null) {
                EqualityConstraint equalityConstraint3 = equalityConstraint2;
                while (equalityConstraint3.next != null) {
                    equalityConstraint3 = equalityConstraint3.next;
                }
                equalityConstraint3.next = equalityConstraint;
                equalityConstraint = equalityConstraint2;
            }
            initialConstraint2 = initialConstraint2.next;
        }
        boolean bl2 = true;
        TypeParameterList typeParameterList = methodSymbol.typeParameterList;
        TypeVariableList typeVariableList2 = typeVariableList;
        while (typeParameterList != null) {
            TypeSymbol typeSymbol = equalityConstraint.findResolvedTypeParameter(typeParameterList.typeParameter, null);
            if (typeSymbol == null) {
                if (typeVariableList2.typeVariable.refSymbol == null) {
                    bl2 = false;
                }
            } else {
                typeVariableList2.typeVariable.refSymbol = typeSymbol;
                equalityConstraint.applyType(typeParameterList.typeParameter, typeVariableList2.typeVariable);
            }
            typeParameterList = typeParameterList.next;
            typeVariableList2 = typeVariableList2.next;
        }
        if (bl2) {
            return true;
        }
        bl2 = true;
        if (bl) {
            typeParameterList = methodSymbol.typeParameterList;
            typeVariableList2 = typeVariableList;
            while (typeParameterList != null) {
                if (typeVariableList2.typeVariable.refSymbol == null) {
                    int n;
                    HashSet hashSet = new HashSet();
                    equalityConstraint.getTypeIntersectionSet(hashSet, typeParameterList.typeParameter);
                    int n2 = n = hashSet.size();
                    if (n == 0) {
                        bl2 = false;
                    } else {
                        ClassSymbol classSymbol = InvokeExpression.computeInterSectionType(parser, hashSet.toArray(new ClassSymbol[n]));
                        if (classSymbol == null) {
                            bl2 = false;
                        } else {
                            typeVariableList2.typeVariable.refSymbol = classSymbol;
                            typeVariableList2.typeVariable.typeVariableKind = (byte)2;
                        }
                    }
                }
                typeParameterList = typeParameterList.next;
                typeVariableList2 = typeVariableList2.next;
            }
        } else {
            typeParameterList = methodSymbol.typeParameterList;
            typeVariableList2 = typeVariableList;
            while (typeParameterList != null) {
                if (typeVariableList2.typeVariable.refSymbol == null) {
                    HashSet hashSet = new HashSet();
                    equalityConstraint.computeSuperTypeSets(hashSet, typeParameterList.typeParameter);
                    HashSet hashSet2 = new HashSet();
                    equalityConstraint.computeErasedCanditiateSet(hashSet2, typeParameterList.typeParameter);
                    ClassSymbol classSymbol = InvokeExpression.computeLeastUpperBound(parser, hashSet, hashSet2);
                    if (classSymbol == null) {
                        bl2 = false;
                    } else {
                        typeVariableList2.typeVariable.refSymbol = classSymbol;
                        typeVariableList2.typeVariable.typeVariableKind = (byte)2;
                    }
                }
                typeParameterList = typeParameterList.next;
                typeVariableList2 = typeVariableList2.next;
            }
        }
        return bl2;
    }

    private TypeVariableList inferTypeParameters(Parser parser, MethodSymbol methodSymbol, ParameterizedClassSymbol parameterizedClassSymbol, ExpressionList expressionList, TypeSymbol typeSymbol, byte by) {
        TypeVariableList typeVariableList;
        InitialConstraint initialConstraint;
        InitialConstraint initialConstraint2 = null;
        TypeSymbol typeSymbol2 = null;
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        while (argumentVariableList != null) {
            ArgumentVariableSymbol argumentVariableSymbol = argumentVariableList.argSymbol;
            TypeSymbol typeSymbol3 = argumentVariableSymbol.type;
            if (typeSymbol3.isReferenceType() && (typeSymbol3 = this.applyTypeParameters(typeSymbol3, parameterizedClassSymbol, methodSymbol)).containsTypeParameterDefinedBy(methodSymbol)) {
                TypeSymbol typeSymbol4;
                if (by == 3 && (methodSymbol.access & 0x80) != 0 && argumentVariableList.next == null) {
                    if (expressionList == null) break;
                    if (typeSymbol2 != null) {
                        typeSymbol3 = typeSymbol2;
                    } else {
                        ArraySymbol arraySymbol = (ArraySymbol)typeSymbol3;
                        typeSymbol2 = typeSymbol3 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    }
                }
                if ((typeSymbol4 = expressionList.expr.getType()) != ReferenceTypeSymbol.nullTypeSymbol) {
                    block0 : switch (InvokeExpression.compareArguments(parser, typeSymbol3, typeSymbol4, by)) {
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        case -1: {
                            initialConstraint = new InitialConstraintActualConvertsIntoFormal(methodSymbol, typeSymbol3, typeSymbol4);
                            break;
                        }
                        case 1: {
                            initialConstraint = new InitialConstraintActualEqualsFormal(methodSymbol, typeSymbol3, typeSymbol4);
                            break;
                        }
                        case 0: {
                            switch (InvokeExpression.compareArguments(parser, typeSymbol4, typeSymbol3, by)) {
                                default: {
                                    if (!$assertionsDisabled) {
                                        throw new AssertionError();
                                    }
                                }
                                case -1: {
                                    initialConstraint = new InitialConstraintFormalConvertsIntoActual(methodSymbol, typeSymbol3, typeSymbol4);
                                    break block0;
                                }
                                case 0: 
                            }
                            return null;
                        }
                    }
                    initialConstraint.next = initialConstraint2;
                    initialConstraint2 = initialConstraint;
                }
            }
            argumentVariableList = typeSymbol2 == null ? argumentVariableList.next : argumentVariableList;
            expressionList = expressionList.next;
        }
        TypeVariableList typeVariableList2 = null;
        TypeVariableList typeVariableList3 = null;
        TypeParameterList typeParameterList = methodSymbol.typeParameterList;
        while (typeParameterList != null) {
            TypeVariableSymbol typeVariableSymbol = new TypeVariableSymbol(0, 1, null);
            typeVariableList = new TypeVariableList(typeVariableSymbol);
            if (typeVariableList3 == null) {
                typeVariableList3 = typeVariableList2 = typeVariableList;
            } else {
                typeVariableList2.next = typeVariableList;
                typeVariableList2 = typeVariableList;
            }
            typeParameterList = typeParameterList.next;
        }
        if (this.inferTypeParamtersFromInitialConstraints(parser, methodSymbol, typeVariableList3, initialConstraint2, false)) {
            return typeVariableList3;
        }
        TypeSymbol typeSymbol5 = methodSymbol.resultType;
        if (typeSymbol5.isClass() && (typeSymbol5 = this.applyTypeParameters(typeSymbol5, parameterizedClassSymbol, methodSymbol)).containsTypeParameterDefinedBy(methodSymbol)) {
            typeParameterList = methodSymbol.typeParameterList;
            typeVariableList = typeVariableList3;
            while (typeParameterList != null) {
                if (typeVariableList.typeVariable.refSymbol != null) {
                    typeSymbol5 = typeSymbol5.applyTypeVariable(typeParameterList.typeParameter, typeVariableList.typeVariable);
                }
                typeParameterList = typeParameterList.next;
                typeVariableList = typeVariableList.next;
            }
            if (typeSymbol5.containsTypeParameterDefinedBy(methodSymbol)) {
                if (typeSymbol == null) {
                    typeSymbol = parser.javaLangObjectPcs;
                }
                initialConstraint2 = new InitialConstraintFormalConvertsIntoActual(methodSymbol, typeSymbol5, typeSymbol);
                typeParameterList = methodSymbol.typeParameterList;
                typeVariableList = typeVariableList3;
                while (typeParameterList != null) {
                    TypeSymbol typeSymbol6 = typeParameterList.typeParameter.bound.applyTypeVariables(methodSymbol.typeParameterList, typeVariableList3);
                    initialConstraint = new InitialConstraintFormalConvertsIntoActual(methodSymbol, typeParameterList.typeParameter, typeSymbol6);
                    initialConstraint.next = initialConstraint2;
                    initialConstraint2 = initialConstraint;
                    typeParameterList = typeParameterList.next;
                    typeVariableList = typeVariableList.next;
                }
                if (this.inferTypeParamtersFromInitialConstraints(parser, methodSymbol, typeVariableList3, initialConstraint2, true)) {
                    return typeVariableList3;
                }
            }
        }
        typeVariableList = typeVariableList3;
        while (typeVariableList != null) {
            if (typeVariableList.typeVariable.refSymbol == null) {
                typeVariableList.typeVariable.refSymbol = parser.javaLangObjectPcs;
            }
            typeVariableList = typeVariableList.next;
        }
        return typeVariableList3;
    }

    private static boolean compareTypeParameters(Parser parser, TypeParameterList typeParameterList, TypeVariableList typeVariableList) {
        while (typeParameterList != null && typeVariableList != null) {
            if (!(typeParameterList.typeParameter.equalTo(typeVariableList.typeVariable.refSymbol) || typeParameterList.typeParameter.equalTo(parser.javaLangObjectPcs) && typeVariableList.typeVariable.refSymbol.isArrayType())) {
                return false;
            }
            typeParameterList = typeParameterList.next;
            typeVariableList = typeVariableList.next;
        }
        return typeParameterList == typeVariableList;
    }

    private TypeSymbol applyTypeParameters(TypeSymbol typeSymbol, ParameterizedClassSymbol parameterizedClassSymbol, MethodSymbol methodSymbol) {
        if (typeSymbol.containsTypeParameterDefinedBy(null)) {
            if (methodSymbol.typeParameterList != null) {
                typeSymbol = typeSymbol.applyTypeVariables(methodSymbol.typeParameterList, this.typeArguments);
            }
            if (parameterizedClassSymbol != null) {
                if (parameterizedClassSymbol.typeVariableList != null) {
                    typeSymbol = typeSymbol.applyTypeVariables(parameterizedClassSymbol.genericClassSymbol.cd.getTypeParameterList(), parameterizedClassSymbol.typeVariableList);
                } else if (parameterizedClassSymbol.isErasedType()) {
                    typeSymbol = typeSymbol.eraseType();
                }
            }
        }
        return typeSymbol;
    }

    private MethodMatchRecord findMatchingMethods(MethodMatchRecord methodMatchRecord, Parser parser, RawClassSymbol rawClassSymbol, MethodSymbol[] methodSymbolArray, int n, ExpressionList expressionList, TypeSymbol typeSymbol, byte by) {
        if (methodSymbolArray == null) {
            return methodMatchRecord;
        }
        boolean bl = true;
        Identifier identifier = this.method.identifier;
        for (int i = 0; i < methodSymbolArray.length; ++i) {
            TypeSymbol typeSymbol2;
            ExpressionList expressionList2;
            boolean bl2;
            MethodSymbol methodSymbol = methodSymbolArray[i];
            if (methodSymbol.identifier != identifier || methodSymbol.isBridgeMethod() || this.typeArguments != null && methodSymbol.typeParameterList == null) continue;
            bl = false;
            boolean bl3 = bl2 = (methodSymbol.access & 0x80) != 0;
            if (methodSymbol.argCount != n && (by != 3 || !bl2 || methodSymbol.argCount - 1 > n)) continue;
            ParameterizedClassSymbol parameterizedClassSymbol = null;
            if (methodSymbol.definingClass.cd.getTypeParameterList() != null) {
                TypeSymbol typeSymbol3;
                parameterizedClassSymbol = this.thisArgument != null ? ((typeSymbol3 = this.thisArgument.getType()).isParameterizedClass() ? (ParameterizedClassSymbol)typeSymbol3 : (typeSymbol3.isTypeParameter() ? (ParameterizedClassSymbol)((TypeParameterSymbol)typeSymbol3).bound : ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)typeSymbol3, null, null))) : ParameterizedClassSymbol.getParameterizedClassSymbol(rawClassSymbol, TypeVariableList.newTypeVariableList(rawClassSymbol.cd.getTypeParameterList()), null);
                parameterizedClassSymbol = InvokeExpression.getParameterizedSuperType(parameterizedClassSymbol, methodSymbol.definingClass);
            }
            TypeVariableList typeVariableList = null;
            if (methodSymbol.typeParameterList != null) {
                typeVariableList = this.typeArguments;
                if (typeVariableList == null && (typeVariableList = this.inferTypeParameters(parser, methodSymbol, parameterizedClassSymbol, expressionList, typeSymbol, by)) == null) continue;
                if (!InvokeExpression.compareTypeParameters(parser, methodSymbol.typeParameterList, typeVariableList)) {
                    expressionList2 = expressionList;
                    if (expressionList2 != null) {
                        ParameterizedClassSymbol parameterizedClassSymbol2;
                        while (!((typeSymbol2 = expressionList2.expr.getType()).isParameterizedClass() && (parameterizedClassSymbol2 = (ParameterizedClassSymbol)typeSymbol2).getClassSymbol().involvesGenerics() && parameterizedClassSymbol2.typeVariableList == null || (expressionList2 = expressionList2.next) == null)) {
                        }
                        if (expressionList2 == null) continue;
                    }
                    typeVariableList = null;
                }
                if (parameterizedClassSymbol != null && parameterizedClassSymbol.genericClassSymbol.isGenericType() && parameterizedClassSymbol.typeVariableList == null) {
                    typeVariableList = null;
                }
            }
            int n2 = 0;
            expressionList2 = expressionList;
            ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
            block12: while (argumentVariableList != null) {
                Expression expression;
                TypeSymbol typeSymbol4;
                ArgumentVariableSymbol argumentVariableSymbol;
                if (by == 3 && bl2 && argumentVariableList.next == null) {
                    argumentVariableSymbol = argumentVariableList.argSymbol;
                    ArraySymbol arraySymbol = (ArraySymbol)argumentVariableSymbol.type;
                    typeSymbol4 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    while (expressionList2 != null) {
                        expression = expressionList2.expr;
                        typeSymbol2 = expression.getType();
                        if (typeSymbol4.isTypeParameter()) {
                            if (typeSymbol2 != typeSymbol4 && typeSymbol2 != ReferenceTypeSymbol.nullTypeSymbol && ((TypeParameterSymbol)typeSymbol4).definingSymbol == parser.currentClassSymbol) {
                                break block12;
                            }
                        } else if (typeSymbol2.isTypeParameter()) {
                            typeSymbol2 = ((TypeParameterSymbol)typeSymbol2).bound;
                        }
                        switch (InvokeExpression.compareArguments(parser, typeSymbol4, typeSymbol2, by)) {
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                            }
                            case -1: {
                                ++n2;
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 0: {
                                break block12;
                            }
                        }
                        expressionList2 = expressionList2.next;
                    }
                } else {
                    argumentVariableSymbol = argumentVariableList.argSymbol;
                    typeSymbol4 = this.applyTypeParameters(argumentVariableSymbol.type, parameterizedClassSymbol, methodSymbol);
                    expression = expressionList2.expr;
                    typeSymbol2 = expression.getType();
                    if (typeSymbol4.isTypeParameter()) {
                        if (typeSymbol2 != typeSymbol4 && typeSymbol2 != ReferenceTypeSymbol.nullTypeSymbol && ((TypeParameterSymbol)typeSymbol4).definingSymbol == parser.currentClassSymbol) {
                            break;
                        }
                    } else if (typeSymbol2.isTypeParameter()) {
                        typeSymbol2 = ((TypeParameterSymbol)typeSymbol2).bound;
                    }
                    switch (InvokeExpression.compareArguments(parser, typeSymbol4, typeSymbol2, by)) {
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        case -1: {
                            ++n2;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 0: {
                            break block12;
                        }
                    }
                    expressionList2 = expressionList2.next;
                }
                argumentVariableList = argumentVariableList.next;
            }
            if (argumentVariableList != null) continue;
            MethodMatchRecord methodMatchRecord2 = new MethodMatchRecord(parameterizedClassSymbol, methodSymbol, typeVariableList, n2);
            methodMatchRecord2.next = methodMatchRecord;
            methodMatchRecord = methodMatchRecord2;
        }
        if (bl && methodMatchRecord == null && rawClassSymbol.isInnerClass() && identifier != Identifier.initializerIdentifier) {
            rawClassSymbol = ((InnerClassSymbol)rawClassSymbol).getOuterClass();
            methodSymbolArray = rawClassSymbol.getMethodTable(parser);
            methodMatchRecord = this.findMatchingMethods(methodMatchRecord, parser, rawClassSymbol, methodSymbolArray, n, expressionList, typeSymbol, by);
        }
        return methodMatchRecord;
    }

    private static int compareTypes(TypeSymbol typeSymbol, TypeSymbol typeSymbol2, TypeSymbol typeSymbol3) {
        if (typeSymbol.isTypeParameter()) {
            typeSymbol = ((TypeParameterSymbol)typeSymbol).bound;
        }
        if (typeSymbol2.isTypeParameter()) {
            typeSymbol2 = ((TypeParameterSymbol)typeSymbol2).bound;
        }
        if (typeSymbol3.isTypeParameter()) {
            typeSymbol3 = ((TypeParameterSymbol)typeSymbol3).bound;
        }
        if (typeSymbol2.equalTo(typeSymbol3)) {
            return 0;
        }
        if (typeSymbol.equalTo(typeSymbol3)) {
            return 1;
        }
        if (typeSymbol.isNumericType()) {
            if (TypeSymbol.isWider(typeSymbol3.typeKind, typeSymbol2.typeKind)) {
                return -1;
            }
            if (TypeSymbol.isWider(typeSymbol2.typeKind, typeSymbol3.typeKind)) {
                return 1;
            }
            return 0;
        }
        if (typeSymbol.isArrayType()) {
            if (typeSymbol3.isArrayType()) {
                ArraySymbol arraySymbol = (ArraySymbol)typeSymbol3;
                if (typeSymbol2.isArrayType()) {
                    ArraySymbol arraySymbol2 = (ArraySymbol)typeSymbol;
                    ArraySymbol arraySymbol3 = (ArraySymbol)typeSymbol2;
                    return InvokeExpression.compareTypes(arraySymbol2.baseType, arraySymbol3.baseType, arraySymbol.baseType);
                }
                return 1;
            }
            return -1;
        }
        if (typeSymbol2.isInterface()) {
            if (!typeSymbol3.isInterface()) {
                return 1;
            }
            if (((ClassSymbol)typeSymbol3).implementsInterface((ClassSymbol)typeSymbol2)) {
                return 1;
            }
            if (((ClassSymbol)typeSymbol2).implementsInterface((ClassSymbol)typeSymbol3)) {
                return -1;
            }
            return 0;
        }
        if (typeSymbol2.isClass()) {
            if (typeSymbol3.isArrayType()) {
                if (typeSymbol == ReferenceTypeSymbol.nullTypeSymbol && ((ClassSymbol)typeSymbol2).getSuperClassSymbol() != null) {
                    return 0;
                }
                return 1;
            }
            if (typeSymbol3.isClass() && ((ClassSymbol)typeSymbol2).isSuperclass((ClassSymbol)typeSymbol3)) {
                return 1;
            }
        }
        return -1;
    }

    private int compareMethods(ExpressionList expressionList, MethodMatchRecord methodMatchRecord, MethodMatchRecord methodMatchRecord2) {
        int n = 0;
        ArgumentVariableList argumentVariableList = methodMatchRecord.method.argumentList;
        ArgumentVariableList argumentVariableList2 = methodMatchRecord2.method.argumentList;
        while (argumentVariableList != null) {
            Expression expression = expressionList.expr;
            TypeSymbol typeSymbol = expression.getType();
            ArgumentVariableSymbol argumentVariableSymbol = argumentVariableList.argSymbol;
            TypeSymbol typeSymbol2 = this.applyTypeParameters(argumentVariableSymbol.type, methodMatchRecord.definingClass, methodMatchRecord.method);
            ArgumentVariableSymbol argumentVariableSymbol2 = argumentVariableList2.argSymbol;
            TypeSymbol typeSymbol3 = this.applyTypeParameters(argumentVariableSymbol2.type, methodMatchRecord2.definingClass, methodMatchRecord2.method);
            n += InvokeExpression.compareTypes(typeSymbol, typeSymbol2, typeSymbol3);
            argumentVariableList = argumentVariableList.next;
            argumentVariableList2 = argumentVariableList2.next;
            expressionList = expressionList.next;
        }
        return n;
    }

    private boolean isAccessible(Parser parser, RawClassSymbol rawClassSymbol, MethodSymbol methodSymbol, boolean bl) {
        block8: {
            RawClassSymbol rawClassSymbol2 = parser.currentClassSymbol;
            if (!(methodSymbol.isAccessible(rawClassSymbol2, rawClassSymbol) || this.thisArgument != null && this.thisArgument.getType().typeKind == 11)) {
                if (methodSymbol.definingClass.isInnerClass() || rawClassSymbol2.isInnerClass()) {
                    RawClassSymbol rawClassSymbol3 = rawClassSymbol2.getTopLevelClass();
                    RawClassSymbol rawClassSymbol4 = methodSymbol.definingClass.getTopLevelClass();
                    boolean bl2 = ((methodSymbol.definingClass.access | methodSymbol.access) & 4) != 0;
                    RawClassSymbol rawClassSymbol5 = rawClassSymbol2;
                    RawClassSymbol rawClassSymbol6 = methodSymbol.definingClass;
                    while (true) {
                        if (bl2 && !methodSymbol.isConstructor() && rawClassSymbol6.isSuperclass(rawClassSymbol5)) {
                            this.useAccessor = true;
                            break block8;
                        }
                        if (rawClassSymbol6 == rawClassSymbol5) {
                            this.useAccessor = true;
                            break block8;
                        }
                        if (rawClassSymbol6.isInnerClass()) {
                            rawClassSymbol6 = rawClassSymbol6.getOuterClass();
                            continue;
                        }
                        if (!rawClassSymbol5.isInnerClass()) break;
                        rawClassSymbol6 = methodSymbol.definingClass;
                        rawClassSymbol5 = rawClassSymbol5.getOuterClass();
                    }
                    if (bl) {
                        parser.error(Message.errorAccessError, this.pos, false, methodSymbol.errorName(), !bl2 ? "private" : "protected", Message.inString + " " + methodSymbol.definingClass.errorName());
                    }
                    return false;
                }
                if (bl) {
                    parser.error(Message.errorAccessError, this.pos, false, methodSymbol.errorName(), (methodSymbol.access & 2) != 0 ? "private" : "protected", Message.inString + " " + methodSymbol.definingClass.errorName());
                }
                return false;
            }
        }
        return true;
    }

    private Error errorNotFound(Parser parser, ClassSymbol classSymbol) {
        if (!classSymbol.isErroneous()) {
            String string = this.method.identifier == Identifier.initializerIdentifier ? Message.constructorString + " " + classSymbol.identifier.toString() : Message.methodString + " " + this.method.identifier.toString();
            string = string + ExpressionList.toFormalParamString(this.arguments);
            return parser.error(Message.errorNotFound, this.pos, false, string, Message.inString + " " + classSymbol.errorName());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser var1_1) {
        var35_2 = var1_1.assignmentContext;
        var1_1.assignmentContext = null;
        if (!(this.method instanceof UnresolvedSymbol)) {
            if ((this.flags & 3) != 0) {
                var1_1.thisInitialized = true;
            }
            return this;
        }
        var15_3 = (UnresolvedSymbol)this.method;
        if (var15_3.qualifierList == null) {
            var16_4 = var1_1.currentClassSymbol;
            var22_5 = var16_4.getMethodTable(var1_1);
        } else {
            if (!this.resolveQualifiedName(var1_1, var15_3)) {
                return ErrorExpression.errorExpression;
            }
            var22_5 = null;
            var16_4 = null;
        }
        var38_6 = false;
        var28_7 = this.thisArgument;
        if (var28_7 != null) {
            var30_8 = (var28_7 = var28_7.resolveAndCheck(var1_1)).getType();
            if (var30_8.isPrimitiveType()) {
                if (!var30_8.isErroneous()) {
                    var1_1.error(Message.errorObjectRequired, var28_7.pos, false, Message.methodString + " " + var15_3.errorName());
                }
                var38_6 = true;
            } else if (var30_8.isArrayType()) {
                var16_4 = var1_1.javaLangObjectSymbol;
                var22_5 = var16_4.getMethodTable(var1_1);
            } else if (var30_8.isTypeParameter()) {
                var16_4 = ((ClassSymbol)var30_8).getClassSymbol();
                var22_5 = ((TypeParameterSymbol)var30_8).getMethodTable(var1_1);
            } else {
                var16_4 = ((ClassSymbol)var30_8).getClassSymbol();
                var22_5 = var16_4.getMethodTable(var1_1);
            }
            this.thisArgument = var28_7;
        }
        if (this.qualification != null) {
            var16_4 = this.qualification.getClassSymbol();
            var22_5 = var16_4.getMethodTable(var1_1);
        }
        var14_9 = this.typeArguments;
        while (var14_9 != null) {
            var14_9.typeVariable = (TypeVariableSymbol)var14_9.typeVariable.resolveType(var1_1, this.pos, false, true);
            var14_9 = var14_9.next;
        }
        var43_10 = 0;
        var21_11 = this.arguments;
        while (var21_11 != null) {
            if (!this.resolvedArguments) {
                var21_11.expr = var21_11.expr.resolveAndCheck(var1_1);
            }
            if ((var33_12 = var21_11.expr.getType()).isErroneous()) {
                var38_6 = true;
            }
            ++var43_10;
            var21_11 = var21_11.next;
        }
        this.argCount = (byte)var43_10;
        if ((this.flags & 3) != 0) {
            var1_1.thisInitialized = true;
        }
        if (var38_6 || var16_4.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        var16_4.resolveType(var1_1, this.pos, true, true);
        if (var15_3.identifier == Identifier.initializerIdentifier && this.typeArguments != null && var16_4.cd.getTypeParameterList() != null && ((ParameterizedClassSymbol)var28_7.getType()).typeVariableList == null) {
            var36_13 = Message.constructorString + " " + var16_4.identifier.toString();
            var36_13 = var36_13 + ExpressionList.toFormalParamString(this.arguments);
            var37_14 = var1_1.error(Message.errorNotFound, this.pos, false, var36_13, Message.inString + " " + var16_4.errorName());
            return new ErrorExpression(var37_14);
        }
        var18_28 = var1_1.currentClassSymbol;
        var11_29 = null;
        var23_30 = null;
        var42_31 = (byte)(var1_1.options.sourceJDKVersion < 150 ? 1 : 3);
        var40_32 = false;
        var26_33 = null;
        block6: for (var41_34 = 1; var41_34 <= var42_31; var41_34 = (byte)(var41_34 + 1)) {
            var10_35 = this.findMatchingMethods(null, var1_1, var16_4, var22_5, var43_10, this.arguments, var35_2, var41_34);
            var45_43 = 0;
            var12_36 = var10_35;
            while (var12_36 != null) {
                ++var45_43;
                var12_36 = var12_36.next;
            }
            switch (var45_43) {
                default: {
                    var44_42 = var43_10;
                    var13_37 = null;
                    var12_36 = var10_35;
                    while (var12_36 != null) {
                        var17_38 = var16_4;
                        if (var28_7 != null && var28_7 instanceof SuperExpression) {
                            var17_38 = ((SuperExpression)var28_7).classSymbol;
                        }
                        if (this.isAccessible(var1_1, var17_38, var12_36.method, false) && (!var16_4.isInnerClass() || var12_36.method.definingClass.equalTo(var16_4) || var12_36.method.definingClass.isSuperclass(var16_4) || var16_4.implementsInterface(var12_36.method.definingClass) || var28_7 == null && this.qualification == null)) ** GOTO lbl97
                        --var45_43;
                        if (var13_37 == null) {
                            var10_35 = var12_36.next;
                        } else {
                            var13_37.next = var12_36.next;
                        }
                        ** GOTO lbl100
lbl97:
                        // 1 sources

                        if (var12_36.conversions < var44_42) {
                            var44_42 = var12_36.conversions;
                        }
                        var13_37 = var12_36;
lbl100:
                        // 3 sources

                        var12_36 = var12_36.next;
                    }
                    var11_29 = null;
                    var25_40 = null;
                    var24_39 = null;
                    var39_41 = false;
                    var12_36 = var10_35;
                    while (var12_36 != null) {
                        if (var12_36.conversions == var44_42) {
                            if (var11_29 == null) {
                                var11_29 = var12_36;
                            } else {
                                var46_44 = this.compareMethods(this.arguments, var11_29, var12_36);
                                if (var46_44 == 0) {
                                    var24_39 = var11_29.method;
                                    var25_40 = var12_36.method;
                                    if (var24_39 != var25_40) {
                                        var39_41 = true;
                                    }
                                } else if (var46_44 > 0) {
                                    var11_29 = var12_36;
                                    var39_41 = false;
                                }
                            }
                        }
                        var12_36 = var12_36.next;
                    }
                    if (var39_41) {
                        if (var41_34 < var42_31) continue block6;
                        var37_15 = var1_1.error(Message.errorAmbiguousReference, this.pos, false, var24_39.errorName(), var24_39.errorName() + " " + Message.inString + " " + var24_39.definingClass.errorName(), var25_40.errorName() + " " + Message.inString + " " + var25_40.definingClass.errorName());
                        return new ErrorExpression(var37_15);
                    }
                    if (var11_29 != null) {
                        if (var40_32) {
                            var26_33.used = true;
                        }
                        var23_30 = var11_29.method;
                        var23_30.flags = (short)(var23_30.flags | 16);
                        break block6;
                    }
                }
                case 0: {
                    if (var41_34 < var42_31) continue block6;
                    if (var1_1.options.sourceJDKVersion >= 150 && !var40_32 && (var26_33 = var1_1.currentPackageScope.lookupImportSymbol(var15_3.identifier, (byte)8)) != null) {
                        var40_32 = true;
                        var41_34 = 1;
                        var16_4 = var26_33.getImportSymbolClass();
                        var22_5 = var16_4.getMethodTable(var1_1);
                        continue block6;
                    }
                    var37_16 = this.errorNotFound(var1_1, var16_4);
                    return new ErrorExpression(var37_16);
                }
                case 1: {
                    if (var40_32) {
                        var26_33.used = true;
                    }
                    var11_29 = var10_35;
                    var23_30 = var11_29.method;
                    var23_30.flags = (short)(var23_30.flags | 16);
                    if (!(!var16_4.isInnerClass() || var23_30.definingClass.equalTo(var16_4) || var23_30.definingClass.isSuperclass(var16_4) || var16_4.implementsInterface(var23_30.definingClass) || var28_7 == null && this.qualification == null)) {
                        if (var41_34 < var42_31) continue block6;
                        var37_17 = this.errorNotFound(var1_1, var16_4);
                        return new ErrorExpression(var37_17);
                    }
                    if (var28_7 != null && var28_7 instanceof SuperExpression) {
                        var16_4 = ((SuperExpression)var28_7).classSymbol;
                    }
                    if (this.isAccessible(var1_1, var16_4, var23_30, true)) break block6;
                    return ErrorExpression.errorExpression;
                }
            }
        }
        if ((var23_30.access & 8) == 0) {
            if (var28_7 == null) {
                if (this.qualification != null) {
                    var37_18 = var1_1.error(Message.errorStaticReference, this.pos, false, var23_30.errorName());
                    return new ErrorExpression(var37_18);
                }
                if (!(var23_30.definingClass.equalTo(var1_1.currentClassSymbol) || var23_30.definingClass.isSuperclass(var1_1.currentClassSymbol) || var1_1.currentClassSymbol.implementsInterface(var23_30.definingClass) || (var1_1.currentClassSymbol.access & 8) == 0)) {
                    var37_19 = var1_1.error(Message.errorDynamicRef, this.pos, false, var23_30.errorName());
                    return new ErrorExpression(var37_19);
                }
                if (var1_1.currentMethodSymbol != null && (var1_1.currentMethodSymbol.access & 8) == 0 || var1_1.currentFieldSymbol != null && (var1_1.currentFieldSymbol.access & 8) == 0) {
                    var28_7 = new ThisExpression(this.pos, var1_1.currentClassSymbol);
                    this.thisArgument = var28_7.resolveAndCheck(var1_1);
                } else {
                    var37_20 = var1_1.error(Message.errorDynamicRef, this.pos, false, var23_30.errorName());
                    return new ErrorExpression(var37_20);
                }
            }
        } else if (var28_7 != null) {
            var1_1.warning(var23_30, Message.warningStaticAccessWithObject, this.pos, var23_30.errorName());
        }
        if (var28_7 != null && (var28_7.getType().typeClass & -128) != 0 && var23_30.definingClass.equalTo(var1_1.javaLangObjectSymbol) && var23_30.identifier == Identifier.finalizeIdentifier) {
            var37_21 = var1_1.error(Message.errorAccessError, this.pos, false, var23_30.errorName(), "protected", Message.inString + " " + var23_30.definingClass.errorName());
            return new ErrorExpression(var37_21);
        }
        var21_11 = this.arguments;
        if (var21_11 != null) {
            var7_45 = var23_30.argumentList;
            var3_46 = var11_29.definingClass;
            do {
                var6_47 = var7_45.argSymbol;
                if (var41_34 == 3 && (var23_30.access & 128) != 0 && var7_45.next == null) {
                    var27_48 = (ArraySymbol)var6_47.type;
                    var31_50 = ArraySymbol.getArrayType(var27_48.baseType, var27_48.dimension - 1);
                    this.flags = (byte)(this.flags | 4);
                } else {
                    var7_45 = var7_45.next;
                    var31_50 = var6_47.type;
                }
                var31_50 = this.applyTypeParameters(var31_50, var3_46, var23_30);
                var29_49 = var21_11.expr;
                var32_51 = var29_49.getType();
                var31_50.checkUncheckConversion(var1_1, var29_49.pos, var32_51, false);
                if (var32_51.equalTo(var31_50)) continue;
                var21_11.expr = var29_49.promoteType(var1_1, var31_50);
            } while ((var21_11 = var21_11.next) != null);
        }
        if (var28_7 != null && var28_7 instanceof SuperExpression && (var23_30.access & 1024) != 0) {
            var37_22 = var1_1.error(Message.errorAccessAbstract, this.pos, false, var23_30.errorName());
            return new ErrorExpression(var37_22);
        }
        if (!(!var23_30.isDeprecated() && !var23_30.definingClass.isDeprecated() || var23_30.isGenerated() || var23_30.definingClass.equalTo(var1_1.currentClassSymbol) && !var1_1.options.selfDeprecation)) {
            var1_1.warning(var23_30, Message.warningIsDeprecated, this.pos, var23_30.errorName());
        }
        if (var15_3.qualifierList == null && (var23_30.access & 8) != 0) {
            var23_30.checkForAmbigousImport(var1_1, this.pos, var1_1.currentPackageScope, (short)8);
        }
        this.method = var23_30;
        if (var23_30.isConstructor()) {
            if (var23_30 == var1_1.currentMethodSymbol && (var23_30.flags & 2) != 0 && var28_7 instanceof ThisExpression) {
                var1_1.error(Message.errorCyclicConstructors, this.pos, false, var23_30.errorName());
            }
            var30_8 = var28_7.getType();
            if (var23_30.definingClass.isAnonymousInnerClass()) {
                var23_30.definingClass.fixConstructors(var1_1);
            }
        } else {
            var30_8 = var23_30.resultType;
            if (var23_30.identifier == Identifier.cloneIdentifier) {
                if (var28_7 != null && var28_7.getType().typeKind == 11) {
                    var30_8 = var28_7.getType();
                }
            } else if (var23_30.identifier == Identifier.getClassIdentifier && var23_30.definingClass == var1_1.javaLangObjectSymbol && var1_1.options.sourceJDKVersion >= 150 && (var28_7 == null || var28_7.getType().isClass())) {
                var16_4 = var28_7 != null ? ((ClassSymbol)var28_7.getType()).getClassSymbol() : var18_28;
                var4_52 = ParameterizedClassSymbol.getParameterizedClassSymbol(var16_4, null, null);
                var30_8 = ParameterizedClassSymbol.getParameterizedClassSymbol(var1_1.javaLangClassSymbol, new TypeVariableList(new TypeVariableSymbol(0, 2, var4_52)), null);
            }
            if ((var30_8 = this.applyTypeParameters(var30_8, var11_29.definingClass, var23_30)).containsTypeParameterDefinedBy(null)) {
                var30_8 = var30_8.replaceTypeParameters(var1_1.currentClassSymbol, var23_30.typeParameterList, var11_29.typeArguments, var28_7);
            }
            if (var30_8.isTypeParameter() && var28_7 != null && (var34_53 = var28_7.getType()).isParameterizedClass()) {
                var4_52 = (ParameterizedClassSymbol)var34_53;
                var9_54 = (TypeParameterSymbol)var30_8;
                if (var4_52.typeVariableList == null) {
                    if (var9_54.definingSymbol instanceof MethodSymbol) {
                        if (var9_54.definingSymbol != var1_1.currentMethodSymbol) {
                            var30_8 = var9_54.bound;
                        }
                    } else if (var9_54.definingSymbol != var4_52.genericClassSymbol && var9_54.definingSymbol != var1_1.currentClassSymbol && !var1_1.currentClassSymbol.isInnerClass((RawClassSymbol)var9_54.definingSymbol)) {
                        var30_8 = var9_54.bound;
                    }
                }
            }
        }
        this.setType(var30_8.resolveType(var1_1, 0, false, true));
        if (var28_7 == null || var28_7.getType().typeKind != 11) {
            var5_55 = var23_30.throwsList;
            while (var5_55 != null) {
                var5_55.throwsType = var30_8 = var5_55.throwsType.resolveType(var1_1, this.pos, true, true);
                if (!var30_8.isErroneous()) {
                    if ((var30_8 = this.applyTypeParameters(var30_8, var11_29.definingClass, var23_30)).containsTypeParameterDefinedBy(null)) {
                        var30_8 = var30_8.replaceTypeParameters(var1_1.currentClassSymbol, var23_30.typeParameterList, var11_29.typeArguments, var28_7);
                    }
                    if (!(TryStatement.checkCatches(var1_1, var16_4 = ((ClassSymbol)var30_8).getClassSymbol()) || !var16_4.equalTo(var1_1.javaLangExceptionSymbol) && !var1_1.javaLangExceptionSymbol.isSuperclass(var16_4) || var16_4.equalTo(var1_1.javaLangRuntimeExceptionSymbol) || var1_1.javaLangRuntimeExceptionSymbol.isSuperclass(var16_4))) {
                        if (var1_1.currentClassSymbol.isAnonymousInnerClass() && (var1_1.currentMethodSymbol == null || var1_1.currentMethodSymbol.isConstructor() || var1_1.currentMethodSymbol == var1_1.currentClassSymbol.cd.ccd.dynamicInitializer)) {
                            var8_57 = (AnonymousClassSymbol)var1_1.currentClassSymbol;
                            if (!var8_57.constructorSymbol.checkThrowsList(var16_4)) {
                                var2_56 = new MethodSymbol.CompiledThrowsList(var16_4, 0);
                                var2_56.next = var8_57.constructorSymbol.throwsList;
                                var8_57.constructorSymbol.throwsList = var2_56;
                            }
                        } else if (var1_1.currentMethodSymbol == null || var1_1.currentMethodSymbol == var1_1.currentClassSymbol.cd.ccd.dynamicInitializer) {
                            var1_1.error(Message.errorUnreportedException, this.pos, false, var16_4.errorName());
                        } else if (!var1_1.currentMethodSymbol.checkThrowsList(var16_4)) {
                            var1_1.error(Message.errorUnreportedException, this.pos, false, var30_8.errorName());
                        }
                    }
                }
                var5_55 = var5_55.next;
            }
        }
        if (this.thisArgument instanceof ThisExpression) {
            if (var1_1.currentClassSymbol.isAnonymousInnerClass()) {
                if (((var1_1.currentClassSymbol.flags & 4) != 0 || !var1_1.thisInitialized) && (var16_4 = ((ClassSymbol)this.thisArgument.getType()).getClassSymbol()).isInnerClass()) {
                    var19_58 = var23_30.definingClass;
                    if (((ThisExpression)var28_7).outerClassSymbol != null) {
                        var19_58 = (RawClassSymbol)((ThisExpression)var28_7).outerClassSymbol;
                    }
                    if (!(var19_58.equalTo(var16_4) || var19_58.isSuperclass(var16_4) && var23_30.isAccessible(var1_1.currentClassSymbol, var16_4) || var19_58.isInterface() && var16_4.implementsInterface(var19_58) || var1_1.options.sourceJDKVersion >= 150 && var16_4.getClassSymbol().isInnerClass(var19_58))) {
                        var37_23 = var1_1.error(Message.errorReferenceBeforeSuper, this.pos, false);
                        return new ErrorExpression(var37_23);
                    }
                }
            } else if (!var1_1.thisInitialized && ((ThisExpression)this.thisArgument).outerClassSymbol == null && (var23_30.definingClass.equalTo(this.thisArgument.getType()) || var23_30.definingClass.isSuperclass(((ClassSymbol)this.thisArgument.getType()).getClassSymbol()))) {
                var37_24 = var1_1.error(Message.errorReferenceBeforeSuper, this.pos, false);
                return new ErrorExpression(var37_24);
            }
        }
        if ((this.flags & 2) != 0) {
            if (!InvokeExpression.$assertionsDisabled && !(this.thisArgument instanceof SuperExpression)) {
                throw new AssertionError();
            }
            var29_49 = ((SuperExpression)this.thisArgument).outerClassExpr;
            if (var29_49 != null) {
                if (!var23_30.definingClass.isNonStaticInnerClass()) {
                    var37_25 = var1_1.error(Message.errorIllegalQualifierNotInner, this.pos, false, var23_30.definingClass.errorName());
                    return new ErrorExpression(var37_25);
                }
                var19_58 = var23_30.definingClass.getOuterClass();
                if (!var19_58.equalTo(var16_4 = ((ClassSymbol)var29_49.getType()).getClassSymbol()) && !var19_58.isSuperclass(var16_4) || var16_4.equalTo(var1_1.currentClassSymbol)) {
                    var37_26 = var1_1.error(Message.errorIllegalQualifierNotInner, this.pos, false, var23_30.definingClass.errorName());
                    return new ErrorExpression(var37_26);
                }
            }
            var21_11 = this.arguments;
            while (var21_11 != null) {
                if (var21_11.expr.kind == 4 && ((InvokeExpression)var21_11.expr).method.identifier == Identifier.initializerIdentifier && (var33_12 = var21_11.expr.getType()) instanceof RawClassSymbol) {
                    var20_59 = (RawClassSymbol)var33_12;
                    if (var20_59.isAnonymousInnerClass()) {
                        var20_59.flags = (short)(var20_59.flags | 4);
                        var20_59 = var20_59.getSuperClassSymbol().getClassSymbol();
                    }
                    if (var20_59.isNonStaticInnerClass() && var20_59.isInnerClass(var18_28)) {
                        var37_27 = var1_1.error(Message.errorReferenceBeforeSuper, var21_11.expr.pos, false);
                        return new ErrorExpression(var37_27);
                    }
                }
                var21_11 = var21_11.next;
            }
        }
        return this;
    }

    private static boolean isExcludeClass(Options options, RawClassSymbol rawClassSymbol) {
        ArrayList arrayList = options.excludeClasses;
        if (arrayList != null) {
            String string = rawClassSymbol.toString();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!string.equals((String)arrayList.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte by;
        TypeSymbol typeSymbol;
        short s;
        TypeSymbol typeSymbol2;
        ArraySymbol arraySymbol;
        InnerClassSymbol.HiddenArgumentList hiddenArgumentList;
        InnerClassSymbol innerClassSymbol;
        MethodSymbol methodSymbol = (MethodSymbol)this.method;
        RawClassSymbol rawClassSymbol = methodSymbol.definingClass;
        Parser parser = byteCodeGenerator.parser;
        if (parser.options.excludeClasses != null && (methodSymbol.access & 8) != 0 && methodSymbol.resultType.typeKind == 1 && InvokeExpression.isExcludeClass(parser.options, rawClassSymbol)) {
            return;
        }
        boolean bl = byteCodeGenerator.doingStringConcatonation;
        byteCodeGenerator.doingStringConcatonation = false;
        boolean bl2 = methodSymbol.isConstructor();
        RawClassSymbol rawClassSymbol2 = parser.currentClassSymbol;
        if (this.thisArgument != null) {
            if (!bl2) {
                TypeSymbol typeSymbol3 = this.thisArgument.getType();
                if (this.thisArgument instanceof SuperExpression) {
                    rawClassSymbol = ((ClassSymbol)typeSymbol3).getClassSymbol();
                } else {
                    if (!typeSymbol3.isArrayType() && !typeSymbol3.isTypeParameter()) {
                        rawClassSymbol = ((ClassSymbol)typeSymbol3).getClassSymbol();
                    }
                    if (rawClassSymbol.isInterface() && !methodSymbol.definingClass.isInterface()) {
                        rawClassSymbol = methodSymbol.definingClass;
                    }
                }
            }
            if (rawClassSymbol.isNonStaticInnerClass() && this.thisArgument instanceof ThisExpression) {
                RawClassSymbol rawClassSymbol3 = methodSymbol.definingClass;
                if (((ThisExpression)this.thisArgument).outerClassSymbol != null) {
                    rawClassSymbol3 = (RawClassSymbol)((ThisExpression)this.thisArgument).outerClassSymbol;
                }
                if (!(rawClassSymbol3.equalTo(rawClassSymbol) || rawClassSymbol3.isSuperclass(rawClassSymbol) && methodSymbol.isAccessible(rawClassSymbol2, rawClassSymbol2) || rawClassSymbol3.isInterface() && rawClassSymbol.implementsInterface(rawClassSymbol3))) {
                    if (!parser.currentMethodSymbol.isConstructor()) {
                        byteCodeGenerator.loadLocalVariable(rawClassSymbol, (short)0);
                    }
                    rawClassSymbol = byteCodeGenerator.generateOuterClassFieldAccessor(methodSymbol.definingClass, rawClassSymbol, false);
                } else {
                    this.thisArgument.generateByteCode(byteCodeGenerator);
                }
            } else {
                this.thisArgument.generateByteCode(byteCodeGenerator);
            }
            if ((methodSymbol.access & 8) != 0) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
                this.thisArgument = null;
            }
        } else if (this.qualification != null) {
            rawClassSymbol = this.qualification.getClassSymbol();
        } else if ((methodSymbol.access & 8) != 0 && rawClassSymbol.isSuperclass(rawClassSymbol2)) {
            rawClassSymbol = rawClassSymbol2;
        }
        if (bl2 && methodSymbol.definingClass.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)methodSymbol.definingClass;
            if (!(this.thisArgument instanceof NewExpression || this.thisArgument instanceof SuperExpression && ((SuperExpression)this.thisArgument).outerClassExpr != null)) {
                if ((this.flags & 1) != 0) {
                    hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                    while (hiddenArgumentList != null) {
                        if (hiddenArgumentList.kind != 2) {
                            byteCodeGenerator.loadLocalVariable(hiddenArgumentList.type, hiddenArgumentList.stackVarIndex);
                        }
                        hiddenArgumentList = hiddenArgumentList.next;
                    }
                } else {
                    if (!$assertionsDisabled && (this.flags & 2) == 0) {
                        throw new AssertionError();
                    }
                    hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                    while (hiddenArgumentList != null) {
                        switch (hiddenArgumentList.kind) {
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                            }
                            case 2: {
                                break;
                            }
                            case 0: {
                                if (rawClassSymbol2.isAnonymousInnerClass()) {
                                    byteCodeGenerator.loadLocalVariable(innerClassSymbol, (short)((rawClassSymbol2.access & 8) == 0 ? 2 : 1));
                                    break;
                                }
                                if (rawClassSymbol2.isInnerClass() && !innerClassSymbol.equalTo(rawClassSymbol2) && !innerClassSymbol.isInnerClass(rawClassSymbol2) && !innerClassSymbol.getOuterClass().isSuperclass(rawClassSymbol2)) {
                                    byteCodeGenerator.generateOuterClassFieldAccessor(innerClassSymbol.getOuterClass(), rawClassSymbol2, false);
                                    break;
                                }
                                byteCodeGenerator.loadLocalVariable(innerClassSymbol, (short)0);
                            }
                        }
                        hiddenArgumentList = hiddenArgumentList.next;
                    }
                }
            }
        }
        int n = this.argCount & 0xFF;
        ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
        ExpressionList expressionList = this.arguments;
        while (expressionList != null) {
            if ((this.flags & 4) != 0 && argumentVariableList.next == null) {
                byteCodeGenerator.generateIntConst(n);
                arraySymbol = (ArraySymbol)argumentVariableList.argSymbol.type;
                typeSymbol2 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                if (typeSymbol2.isPrimitiveType()) {
                    byteCodeGenerator.generate_8_8((byte)-68, NewExpression.newArrayKind[typeSymbol2.typeKind]);
                } else {
                    s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol2.getInternalName());
                    byteCodeGenerator.generate_8_16((byte)-67, s);
                }
                byteCodeGenerator.incOpStackHeight(1);
                int n2 = 0;
                while (expressionList != null) {
                    byteCodeGenerator.generate_8((byte)89);
                    byteCodeGenerator.generateIntConst(n2++);
                    byteCodeGenerator.incOpStackHeight(2);
                    Expression expression = expressionList.expr;
                    expression.generateByteCode(byteCodeGenerator);
                    typeSymbol = expression.getType();
                    byteCodeGenerator.generate_8(ArrayExpression.astore_opcode[typeSymbol.typeKind]);
                    byteCodeGenerator.decOpStackHeight((typeSymbol.typeClass & 0x28) != 0 ? 4 : 3);
                    expressionList = expressionList.next;
                }
                argumentVariableList = null;
                break;
            }
            expressionList.expr.generateByteCode(byteCodeGenerator);
            argumentVariableList = argumentVariableList.next;
            expressionList = expressionList.next;
            --n;
        }
        if (argumentVariableList != null) {
            if (!$assertionsDisabled && (methodSymbol.access & 0x80) == 0) {
                throw new AssertionError();
            }
            byteCodeGenerator.generateIntConst(0);
            arraySymbol = (ArraySymbol)argumentVariableList.argSymbol.type;
            typeSymbol2 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
            if (typeSymbol2.isPrimitiveType()) {
                byteCodeGenerator.generate_8_8((byte)-68, NewExpression.newArrayKind[typeSymbol2.typeKind]);
            } else {
                s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol2.getInternalName());
                byteCodeGenerator.generate_8_16((byte)-67, s);
            }
            byteCodeGenerator.incOpStackHeight(1);
        }
        if (bl2 && methodSymbol.definingClass.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)methodSymbol.definingClass;
            if (this.thisArgument instanceof NewExpression || this.thisArgument instanceof SuperExpression && ((SuperExpression)this.thisArgument).outerClassExpr != null) {
                hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    if (hiddenArgumentList.kind == 2) {
                        byteCodeGenerator.loadLocalVariable(hiddenArgumentList.type, hiddenArgumentList.localVar.varStackIndex);
                    }
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            } else if ((this.flags & 1) != 0) {
                hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    if (hiddenArgumentList.kind == 2) {
                        byteCodeGenerator.loadLocalVariable(hiddenArgumentList.type, (short)(parser.currentMethodSymbol.actualArgCount - hiddenArgumentList.stackVarIndex));
                    }
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            } else {
                if (!$assertionsDisabled && (this.flags & 2) == 0) {
                    throw new AssertionError();
                }
                hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    if (hiddenArgumentList.kind == 2) {
                        if (!$assertionsDisabled && !rawClassSymbol2.isAnonymousInnerClass()) {
                            throw new AssertionError();
                        }
                        InnerClassSymbol.HiddenArgumentList hiddenArgumentList2 = ((InnerClassSymbol)rawClassSymbol2).hiddenArgumentList;
                        while (hiddenArgumentList2 != null) {
                            if (hiddenArgumentList.localVar == hiddenArgumentList2.localVar) {
                                byteCodeGenerator.loadLocalVariable(hiddenArgumentList.type, (short)(parser.currentMethodSymbol.actualArgCount - hiddenArgumentList2.stackVarIndex));
                                break;
                            }
                            hiddenArgumentList2 = hiddenArgumentList2.next;
                        }
                    }
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            }
        }
        if (this.thisArgument != null) {
            if (rawClassSymbol.isInterface()) {
                by = 0;
            } else if (bl2) {
                by = 2;
            } else if (this.thisArgument instanceof SuperExpression) {
                by = 1;
                if (((SuperExpression)this.thisArgument).outerClassSymbol != null) {
                    if (!$assertionsDisabled && !rawClassSymbol2.isInnerClass()) {
                        throw new AssertionError();
                    }
                    this.useAccessor = true;
                }
            } else {
                by = 3;
            }
        } else {
            by = 4;
        }
        if (this.useAccessor) {
            if (bl2) {
                MethodSymbol methodSymbol2 = byteCodeGenerator.generateConstructorAccessor(methodSymbol, rawClassSymbol2);
                s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol2.definingClass.getInternalName(), methodSymbol2.identifier.name, methodSymbol2.getSignature());
                byteCodeGenerator.generate_8_8_16((byte)1, (byte)-73, s);
                byteCodeGenerator.incOpStackHeight(1);
                byteCodeGenerator.decOpStackHeight(1);
            } else {
                MethodSymbol methodSymbol3 = byteCodeGenerator.generateMethodAccessor(methodSymbol, by);
                s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(methodSymbol3.definingClass.getInternalName(), methodSymbol3.identifier.name, methodSymbol3.getSignature());
                byteCodeGenerator.generate_8_16((byte)-72, s);
            }
        } else {
            s = rawClassSymbol.isInterface() ? byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(rawClassSymbol.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature()) : byteCodeGenerator.constantPool.enterConstantPoolMethodRef(rawClassSymbol.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            switch (by) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: {
                    byteCodeGenerator.generate_8_16((byte)-71, s);
                    byteCodeGenerator.generate_8_8((byte)methodSymbol.actualArgCount, (byte)0);
                    break;
                }
                case 1: 
                case 2: {
                    byteCodeGenerator.generate_8_16((byte)-73, s);
                    break;
                }
                case 3: {
                    byteCodeGenerator.generate_8_16((byte)-74, s);
                    break;
                }
                case 4: {
                    byteCodeGenerator.generate_8_16((byte)-72, s);
                }
            }
        }
        byteCodeGenerator.decOpStackHeight(methodSymbol.actualArgCount);
        typeSymbol = this.getType();
        switch (methodSymbol.resultType.typeKind) {
            case 10: 
            case 11: {
                TypeSymbol typeSymbol4;
                if (typeSymbol.typeKind != 1 && !typeSymbol.equalTo(typeSymbol4 = methodSymbol.resultType.eraseType())) {
                    s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
                    byteCodeGenerator.generate_8_16((byte)-64, s);
                }
            }
            default: {
                byteCodeGenerator.incOpStackHeight(1);
                break;
            }
            case 7: 
            case 9: {
                byteCodeGenerator.incOpStackHeight(2);
            }
            case 1: 
        }
        if (typeSymbol == TypeSymbol.voidSymbol) {
            switch (methodSymbol.resultType.typeKind) {
                default: {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 7: 
                case 9: {
                    byteCodeGenerator.generate_8((byte)88);
                    byteCodeGenerator.decOpStackHeight(2);
                }
                case 1: 
            }
        }
        byteCodeGenerator.doingStringConcatonation = bl;
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(rawClassSymbol2, rawClassSymbol);
    }

    static {
        $assertionsDisabled = !InvokeExpression.class.desiredAssertionStatus();
    }

    private static class EqualityConstraintExacttype
    extends EqualityConstraint {
        EqualityConstraintExacttype(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            super(typeParameterSymbol, typeSymbol);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            if (this.typeParameter != typeParameterSymbol) return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
            if (typeSymbol != null) {
                if (typeSymbol.equalTo(this.typeSymbol)) return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
                if (!typeSymbol.isClass() || !this.typeSymbol.isClass()) return TypeSymbol.errorSymbol;
                ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
                ClassSymbol classSymbol2 = (ClassSymbol)this.typeSymbol;
                if (classSymbol.isSuperclass(classSymbol2)) return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
                if (classSymbol2.isSuperclass(classSymbol)) {
                    typeSymbol = this.typeSymbol;
                    return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
                } else {
                    if (classSymbol2.implementsInterface(classSymbol)) return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
                    if (!classSymbol.implementsInterface(classSymbol2)) return TypeSymbol.errorSymbol;
                    typeSymbol = this.typeSymbol;
                }
                return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
            } else {
                typeSymbol = this.typeSymbol;
            }
            return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
        }
    }

    private static class EqualityConstraintSupertype
    extends EqualityConstraint {
        EqualityConstraintSupertype(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            super(typeParameterSymbol, typeSymbol);
        }

        void computeSuperTypeSets(Set set, TypeParameterSymbol typeParameterSymbol) {
            if (typeParameterSymbol == this.typeParameter) {
                ClassSymbol classSymbol = (ClassSymbol)this.typeSymbol;
                set.add(classSymbol);
                classSymbol.getSuperclasses(set);
            }
            this.next.computeSuperTypeSets(set, typeParameterSymbol);
        }

        void computeErasedCanditiateSet(Set set, TypeParameterSymbol typeParameterSymbol) {
            if (typeParameterSymbol == this.typeParameter) {
                ClassSymbol classSymbol = (ClassSymbol)this.typeSymbol;
                HashSet<RawClassSymbol> hashSet = new HashSet<RawClassSymbol>();
                hashSet.add(classSymbol.getClassSymbol());
                classSymbol.getErasedSuperclasses(hashSet);
                if (set.isEmpty()) {
                    set.addAll(hashSet);
                } else {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (hashSet.contains(e)) continue;
                        set.remove(e);
                    }
                }
            }
            this.next.computeErasedCanditiateSet(set, typeParameterSymbol);
        }
    }

    private static class EqualityConstraintSubtype
    extends EqualityConstraint {
        EqualityConstraintSubtype(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            super(typeParameterSymbol, typeSymbol);
        }

        void getTypeIntersectionSet(Set set, TypeParameterSymbol typeParameterSymbol) {
            if (this.typeParameter == typeParameterSymbol) {
                set.add(this.typeSymbol);
            }
            this.next.getTypeIntersectionSet(set, typeParameterSymbol);
        }
    }

    private static class EqualityConstraintAnchor
    extends EqualityConstraint {
        EqualityConstraintAnchor() {
            super(null, null);
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            return typeSymbol;
        }

        void applyType(TypeParameterSymbol typeParameterSymbol, TypeVariableSymbol typeVariableSymbol) {
        }

        void computeSuperTypeSets(Set set, TypeParameterSymbol typeParameterSymbol) {
        }

        void getTypeIntersectionSet(Set set, TypeParameterSymbol typeParameterSymbol) {
        }

        void computeErasedCanditiateSet(Set set, TypeParameterSymbol typeParameterSymbol) {
        }
    }

    private static abstract class EqualityConstraint {
        EqualityConstraint next;
        TypeParameterSymbol typeParameter;
        TypeSymbol typeSymbol;

        EqualityConstraint(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            this.typeParameter = typeParameterSymbol;
            this.typeSymbol = typeSymbol;
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol typeParameterSymbol, TypeSymbol typeSymbol) {
            return this.next.findResolvedTypeParameter(typeParameterSymbol, typeSymbol);
        }

        void computeSuperTypeSets(Set set, TypeParameterSymbol typeParameterSymbol) {
            this.next.computeSuperTypeSets(set, typeParameterSymbol);
        }

        void getTypeIntersectionSet(Set set, TypeParameterSymbol typeParameterSymbol) {
            this.next.getTypeIntersectionSet(set, typeParameterSymbol);
        }

        void applyType(TypeParameterSymbol typeParameterSymbol, TypeVariableSymbol typeVariableSymbol) {
            this.typeSymbol = this.typeSymbol.applyTypeVariable(typeParameterSymbol, typeVariableSymbol);
            this.next.applyType(typeParameterSymbol, typeVariableSymbol);
        }

        void computeErasedCanditiateSet(Set set, TypeParameterSymbol typeParameterSymbol) {
            this.next.computeErasedCanditiateSet(set, typeParameterSymbol);
        }
    }

    private static class InitialConstraintActualEqualsFormal
    extends InitialConstraint {
        InitialConstraintActualEqualsFormal(MethodSymbol methodSymbol, TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
            super(methodSymbol, typeSymbol, typeSymbol2);
        }

        EqualityConstraint getImpliedEqualityConstraint(Parser parser) {
            while (true) {
                if (this.formalArgType.isTypeParameter()) {
                    TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)this.formalArgType;
                    if (typeParameterSymbol.definingSymbol == this.methodSymbol) {
                        return new EqualityConstraintExacttype(typeParameterSymbol, this.actualArgType);
                    }
                }
                if (!this.formalArgType.isArrayType()) break;
                if (this.actualArgType.isArrayType()) {
                    this.formalArgType = ((ArraySymbol)this.formalArgType).baseType;
                    this.actualArgType = ((ArraySymbol)this.actualArgType).baseType;
                    continue;
                }
                if (!this.actualArgType.isTypeVariable()) break;
                TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)this.actualArgType;
                if (typeVariableSymbol.kind != 2 || !typeVariableSymbol.refSymbol.isArrayType()) break;
                this.formalArgType = ((ArraySymbol)this.formalArgType).baseType;
                this.actualArgType = ((ArraySymbol)typeVariableSymbol.refSymbol).baseType;
            }
            if (this.formalArgType.isParameterizedClass() && this.actualArgType.isClass()) {
                EqualityConstraint equalityConstraint = null;
                ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)this.formalArgType;
                ParameterizedClassSymbol parameterizedClassSymbol2 = MemberExpression.getParameterizedSuperType((ClassSymbol)this.actualArgType, parameterizedClassSymbol.genericClassSymbol);
                TypeVariableList typeVariableList = parameterizedClassSymbol.typeVariableList;
                TypeVariableList typeVariableList2 = parameterizedClassSymbol2.typeVariableList;
                while (true) {
                    if (typeVariableList == null || typeVariableList2 == null) {
                        return equalityConstraint;
                    }
                    if (!typeVariableList.typeVariable.containsTypeParameterDefinedBy(this.methodSymbol)) {
                        typeVariableList = typeVariableList.next;
                        typeVariableList2 = typeVariableList2.next;
                        continue;
                    }
                    TypeVariableSymbol typeVariableSymbol = typeVariableList.typeVariable;
                    TypeVariableSymbol typeVariableSymbol2 = typeVariableList2.typeVariable;
                    typeVariableList = typeVariableList.next;
                    typeVariableList2 = typeVariableList2.next;
                    if (typeVariableSymbol.typeVariableKind != typeVariableSymbol2.typeVariableKind) continue;
                    EqualityConstraint equalityConstraint2 = new InitialConstraintActualEqualsFormal(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                    equalityConstraint2.next = equalityConstraint;
                    equalityConstraint = equalityConstraint2;
                }
            }
            return null;
        }
    }

    private static class InitialConstraintFormalConvertsIntoActual
    extends InitialConstraint {
        InitialConstraintFormalConvertsIntoActual(MethodSymbol methodSymbol, TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
            super(methodSymbol, typeSymbol, typeSymbol2);
        }

        EqualityConstraint getImpliedEqualityConstraint(Parser parser) {
            while (true) {
                if (this.formalArgType.isTypeParameter()) {
                    TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)this.formalArgType;
                    if (typeParameterSymbol.definingSymbol == this.methodSymbol) {
                        return new EqualityConstraintSubtype(typeParameterSymbol, this.actualArgType);
                    }
                }
                if (!this.formalArgType.isArrayType()) break;
                if (this.actualArgType.isArrayType()) {
                    this.formalArgType = ((ArraySymbol)this.formalArgType).baseType;
                    this.actualArgType = ((ArraySymbol)this.actualArgType).baseType;
                    continue;
                }
                if (!this.actualArgType.isTypeVariable()) break;
                TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)this.actualArgType;
                if (typeVariableSymbol.kind != 2 || !typeVariableSymbol.refSymbol.isArrayType()) break;
                this.formalArgType = ((ArraySymbol)this.formalArgType).baseType;
                this.actualArgType = ((ArraySymbol)typeVariableSymbol.refSymbol).baseType;
            }
            if (this.formalArgType.isParameterizedClass() && this.actualArgType.isParameterizedClass()) {
                ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)this.actualArgType;
                ParameterizedClassSymbol parameterizedClassSymbol2 = MemberExpression.getParameterizedSuperType((ClassSymbol)this.formalArgType, parameterizedClassSymbol.genericClassSymbol);
                if (parameterizedClassSymbol2 == null) {
                    return null;
                }
                TypeVariableList typeVariableList = parameterizedClassSymbol2.typeVariableList;
                TypeVariableList typeVariableList2 = parameterizedClassSymbol.typeVariableList;
                EqualityConstraint equalityConstraint = null;
                block11: while (true) {
                    EqualityConstraint equalityConstraint2;
                    if (typeVariableList == null || typeVariableList2 == null) {
                        return equalityConstraint;
                    }
                    if (!typeVariableList.typeVariable.containsTypeParameterDefinedBy(this.methodSymbol)) {
                        typeVariableList = typeVariableList.next;
                        typeVariableList2 = typeVariableList2.next;
                        continue;
                    }
                    TypeVariableSymbol typeVariableSymbol = typeVariableList.typeVariable;
                    TypeVariableSymbol typeVariableSymbol2 = typeVariableList2.typeVariable;
                    typeVariableList = typeVariableList.next;
                    typeVariableList2 = typeVariableList2.next;
                    switch (typeVariableSymbol.typeVariableKind) {
                        default: {
                            continue block11;
                        }
                        case 1: {
                            switch (typeVariableSymbol2.typeVariableKind) {
                                default: {
                                    continue block11;
                                }
                                case 1: {
                                    equalityConstraint2 = new InitialConstraintActualEqualsFormal(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                                    equalityConstraint2.next = equalityConstraint;
                                    equalityConstraint = equalityConstraint2;
                                    continue block11;
                                }
                                case 2: {
                                    equalityConstraint2 = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                                    equalityConstraint2.next = equalityConstraint;
                                    equalityConstraint = equalityConstraint2;
                                    continue block11;
                                }
                                case 3: 
                            }
                            equalityConstraint2 = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                            equalityConstraint2.next = equalityConstraint;
                            equalityConstraint = equalityConstraint2;
                            continue block11;
                        }
                        case 2: {
                            if (typeVariableSymbol2.typeVariableKind != 2) continue block11;
                            equalityConstraint2 = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                            equalityConstraint2.next = equalityConstraint;
                            equalityConstraint = equalityConstraint2;
                            continue block11;
                        }
                        case 3: 
                    }
                    if (typeVariableSymbol2.typeVariableKind != 3) continue;
                    equalityConstraint2 = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                    equalityConstraint2.next = equalityConstraint;
                    equalityConstraint = equalityConstraint2;
                }
            }
            return null;
        }
    }

    private static class InitialConstraintActualConvertsIntoFormal
    extends InitialConstraint {
        InitialConstraintActualConvertsIntoFormal(MethodSymbol methodSymbol, TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
            super(methodSymbol, typeSymbol, typeSymbol2);
        }

        EqualityConstraint getImpliedEqualityConstraint(Parser parser) {
            while (true) {
                if (this.actualArgType.isPrimitiveType()) {
                    this.actualArgType = BoxingExpression.getBoxedType(parser, this.actualArgType);
                }
                if (this.formalArgType.isTypeParameter()) {
                    TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)this.formalArgType;
                    if (typeParameterSymbol.definingSymbol == this.methodSymbol) {
                        return new EqualityConstraintSupertype(typeParameterSymbol, this.actualArgType);
                    }
                }
                if (!this.formalArgType.isArrayType()) break;
                if (this.actualArgType.isArrayType()) {
                    this.formalArgType = ((ArraySymbol)this.formalArgType).baseType;
                    this.actualArgType = ((ArraySymbol)this.actualArgType).baseType;
                    continue;
                }
                if (!this.actualArgType.isTypeVariable()) break;
                TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)this.actualArgType;
                if (typeVariableSymbol.kind != 2 || !typeVariableSymbol.refSymbol.isArrayType()) break;
                this.formalArgType = ((ArraySymbol)this.formalArgType).baseType;
                this.actualArgType = ((ArraySymbol)typeVariableSymbol.refSymbol).baseType;
            }
            if (this.formalArgType.isParameterizedClass() && this.actualArgType.isClass()) {
                ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)this.formalArgType;
                ParameterizedClassSymbol parameterizedClassSymbol2 = MemberExpression.getParameterizedSuperType((ClassSymbol)this.actualArgType, parameterizedClassSymbol.genericClassSymbol);
                TypeVariableList typeVariableList = parameterizedClassSymbol.typeVariableList;
                TypeVariableList typeVariableList2 = parameterizedClassSymbol2.typeVariableList;
                EqualityConstraint equalityConstraint = null;
                block6: while (true) {
                    EqualityConstraint equalityConstraint2;
                    if (typeVariableList == null || typeVariableList2 == null) {
                        return equalityConstraint;
                    }
                    if (!typeVariableList.typeVariable.containsTypeParameterDefinedBy(this.methodSymbol)) {
                        typeVariableList = typeVariableList.next;
                        typeVariableList2 = typeVariableList2.next;
                        continue;
                    }
                    TypeVariableSymbol typeVariableSymbol = typeVariableList.typeVariable;
                    TypeVariableSymbol typeVariableSymbol2 = typeVariableList2.typeVariable;
                    typeVariableList = typeVariableList.next;
                    typeVariableList2 = typeVariableList2.next;
                    switch (typeVariableSymbol.typeVariableKind) {
                        default: {
                            continue block6;
                        }
                        case 1: {
                            if (typeVariableSymbol2.typeVariableKind != 1) continue block6;
                            equalityConstraint2 = new InitialConstraintActualEqualsFormal(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                            equalityConstraint2.next = equalityConstraint;
                            equalityConstraint = equalityConstraint2;
                            continue block6;
                        }
                        case 2: {
                            if (typeVariableSymbol2.typeVariableKind != 1 && typeVariableSymbol2.typeVariableKind != 2) continue block6;
                            equalityConstraint2 = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                            equalityConstraint2.next = equalityConstraint;
                            equalityConstraint = equalityConstraint2;
                            continue block6;
                        }
                        case 3: 
                    }
                    if (typeVariableSymbol2.typeVariableKind != 1 && typeVariableSymbol2.typeVariableKind != 3) continue;
                    equalityConstraint2 = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, typeVariableSymbol.refSymbol, typeVariableSymbol2.refSymbol).getImpliedEqualityConstraint(parser);
                    equalityConstraint2.next = equalityConstraint;
                    equalityConstraint = equalityConstraint2;
                }
            }
            return null;
        }
    }

    private static abstract class InitialConstraint {
        InitialConstraint next;
        MethodSymbol methodSymbol;
        TypeSymbol formalArgType;
        TypeSymbol actualArgType;

        InitialConstraint(MethodSymbol methodSymbol, TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
            this.methodSymbol = methodSymbol;
            this.formalArgType = typeSymbol;
            this.actualArgType = typeSymbol2;
        }

        abstract EqualityConstraint getImpliedEqualityConstraint(Parser var1);
    }

    private static class MethodMatchRecord {
        MethodMatchRecord next;
        ParameterizedClassSymbol definingClass;
        MethodSymbol method;
        TypeVariableList typeArguments;
        int conversions;

        MethodMatchRecord(ParameterizedClassSymbol parameterizedClassSymbol, MethodSymbol methodSymbol, TypeVariableList typeVariableList, int n) {
            this.definingClass = parameterizedClassSymbol;
            this.method = methodSymbol;
            this.typeArguments = typeVariableList;
            this.conversions = n;
        }
    }
}

