/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.EnhancedForStatement;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SymbolList;

final class LabeledStatement
extends Statement {
    SymbolList labelList;
    StatementList labeledStatements;
    LabelSymbol breakLabelSymbol;
    BitSet defSet;
    BitSet posSet;
    BitSet useSet;
    BitSet resultDefSet;
    BitSet resultPosSet;
    BitSet resultUseSet;

    LabeledStatement(StatementList statementList, int n, SymbolList symbolList, StatementList statementList2) {
        super(statementList, n, (byte)8);
        this.labelList = symbolList;
        this.labeledStatements = statementList2;
        statementList2.parent = this;
        SymbolList symbolList2 = symbolList;
        while (symbolList2 != null) {
            LabelSymbol labelSymbol = (LabelSymbol)symbolList2.symbol;
            labelSymbol.label = new Label();
            symbolList2 = symbolList2.next;
        }
    }

    void resolveAndCheck(Parser parser) {
        this.defSet = (BitSet)parser.defSet.clone();
        this.posSet = (BitSet)parser.posSet.clone();
        this.useSet = (BitSet)parser.useSet.clone();
        this.labeledStatements.resolveAndCheck(parser);
        if (this.resultDefSet != null) {
            parser.defSet.and(this.resultDefSet);
        }
        if (this.resultPosSet != null) {
            parser.posSet.or(this.resultPosSet);
        }
        if (this.resultUseSet != null) {
            parser.useSet.or(this.resultUseSet);
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    boolean canReachNextStatement(boolean bl) {
        if (this.breakLabelSymbol != null) {
            return true;
        }
        return this.labeledStatements.canReachNextStatement(bl);
    }

    private boolean foundLabel(LabelSymbol labelSymbol) {
        SymbolList symbolList = this.labelList;
        while (symbolList != null) {
            if (symbolList.symbol == labelSymbol) {
                return true;
            }
            symbolList = symbolList.next;
        }
        return false;
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (!this.foundLabel(labelSymbol)) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        }
        if (this.resultDefSet == null) {
            this.resultDefSet = (BitSet)parser.defSet.clone();
        } else {
            this.resultDefSet.and(parser.defSet);
        }
        if (this.resultPosSet == null) {
            this.resultPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.resultPosSet.or(parser.posSet);
        }
        if (this.resultUseSet == null) {
            this.resultUseSet = (BitSet)parser.useSet.clone();
        } else {
            this.resultUseSet.or(parser.useSet);
        }
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (!this.foundLabel(labelSymbol)) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.labeledStatements.first instanceof EnhancedForStatement) {
            EnhancedForStatement enhancedForStatement = (EnhancedForStatement)this.labeledStatements.first;
            enhancedForStatement.generateByteCodePrologue(byteCodeGenerator);
        }
        SymbolList symbolList = this.labelList;
        while (symbolList != null) {
            LabelSymbol labelSymbol = (LabelSymbol)symbolList.symbol;
            byteCodeGenerator.setLabel(labelSymbol.label);
            symbolList = symbolList.next;
        }
        this.labeledStatements.generateByteCode(byteCodeGenerator);
        if (this.breakLabelSymbol != null) {
            byteCodeGenerator.setLabel(this.breakLabelSymbol.label);
        }
    }
}

