/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.RelationalExpression;

final class LessOrEqualExpression
extends RelationalExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    LessOrEqualExpression(int n, Expression expression, Expression expression2) {
        super((byte)26, n, expression, expression2);
    }

    strictfp Expression foldExpression() {
        Expression expression = this.leftOperand;
        Expression expression2 = this.rightOperand;
        if (expression.kind == 2 && expression2.kind == 2) {
            switch (expression.getType().typeClass) {
                case 4: {
                    return new BooleanConstantExpression(this.pos, ((ConstantExpression)expression).getIntConstValue() <= ((ConstantExpression)expression2).getIntConstValue());
                }
                case 8: {
                    return new BooleanConstantExpression(this.pos, ((LongConstantExpression)expression).lval <= ((LongConstantExpression)expression2).lval);
                }
                case 16: {
                    return new BooleanConstantExpression(this.pos, ((FloatConstantExpression)expression).fval <= ((FloatConstantExpression)expression2).fval);
                }
                case 32: {
                    return new BooleanConstantExpression(this.pos, ((DoubleConstantExpression)expression).dval <= ((DoubleConstantExpression)expression2).dval);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte by;
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.leftOperand.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                by = -93;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-106);
                by = -99;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                by = -99;
                byteCodeGenerator.decOpStackHeight(3);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-104);
                by = -99;
                byteCodeGenerator.decOpStackHeight(3);
            }
        }
        byteCodeGenerator.generate_8_16(by, (short)7);
        byteCodeGenerator.generate_8((byte)4);
        byteCodeGenerator.generate_8_16((byte)-89, (short)4);
        byteCodeGenerator.generate_8((byte)3);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean bl) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.leftOperand.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                if (bl) {
                    byteCodeGenerator.generateBranch_if_icmpgt(label);
                } else {
                    byteCodeGenerator.generateBranch_if_icmple(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-106);
                if (bl) {
                    byteCodeGenerator.generateBranch_ifgt(label);
                } else {
                    byteCodeGenerator.generateBranch_ifle(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                if (bl) {
                    byteCodeGenerator.generateBranch_ifgt(label);
                } else {
                    byteCodeGenerator.generateBranch_ifle(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-104);
                if (bl) {
                    byteCodeGenerator.generateBranch_ifgt(label);
                } else {
                    byteCodeGenerator.generateBranch_ifle(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
            }
        }
    }

    public String toString() {
        return "<=";
    }

    static {
        $assertionsDisabled = !LessOrEqualExpression.class.desiredAssertionStatus();
    }
}

