/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LogicalBinaryExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

final class LogicalAndExpression
extends LogicalBinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    LogicalAndExpression(int n, Expression expression, Expression expression2) {
        super((byte)18, n, expression, expression2);
    }

    Expression foldExpression() {
        Expression expression = this.leftOperand;
        Expression expression2 = this.rightOperand;
        if (expression.kind == 2 && expression2.kind == 2) {
            return new BooleanConstantExpression(this.pos, ((BooleanConstantExpression)expression).bval & ((BooleanConstantExpression)expression2).bval);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.leftOperand;
        expression = expression.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        BitSet bitSet = (BitSet)parser.defSet.clone();
        boolean bl = parser.suspendDataFlowChecking;
        if (expression.isConstantBooleanExpression() && !expression.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        if (expression.isLogicalExpression()) {
            parser.defSet = (BitSet)expression.getLogicalExpressionTrueDefSet().clone();
        }
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression2.getType();
        parser.suspendDataFlowChecking = bl;
        TypeSymbol typeSymbol3 = TypeSymbol.booleanSymbol;
        this.setType(typeSymbol3);
        if (typeSymbol.typeKind != 2 || typeSymbol2.typeKind != 2) {
            if (parser.options.sourceJDKVersion >= 150 && (typeSymbol == TypeSymbol.booleanSymbol || typeSymbol.equalTo(parser.javaLangBooleanSymbol)) && (typeSymbol2 == TypeSymbol.booleanSymbol || typeSymbol2.equalTo(parser.javaLangBooleanSymbol))) {
                expression2 = expression2.promoteType(parser, TypeSymbol.booleanSymbol);
                expression = expression.promoteType(parser, TypeSymbol.booleanSymbol);
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous() | typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                return new ErrorExpression(error);
            }
        }
        if (expression.isLogicalExpression()) {
            this.trueDefSet = expression.getLogicalExpressionTrueDefSet();
            if (expression2.isLogicalExpression()) {
                this.trueDefSet.or(expression2.getLogicalExpressionTrueDefSet());
                this.trueDefSet.or(expression2.getLogicalExpressionFalseDefSet());
            } else {
                this.trueDefSet.or(parser.defSet);
            }
        } else {
            this.trueDefSet = (BitSet)parser.defSet.clone();
            if (expression2.isLogicalExpression()) {
                this.trueDefSet.or(expression2.getLogicalExpressionTrueDefSet());
            }
        }
        if (expression.isLogicalExpression()) {
            this.falseDefSet = expression.getLogicalExpressionFalseDefSet();
            if (expression2.isLogicalExpression()) {
                this.falseDefSet.and(expression.getLogicalExpressionTrueDefSet());
                this.falseDefSet.and(expression2.getLogicalExpressionFalseDefSet());
            } else {
                this.falseDefSet.and(parser.defSet);
            }
        } else {
            this.falseDefSet = (BitSet)bitSet.clone();
            if (expression2.isLogicalExpression()) {
                this.falseDefSet.and(expression2.getLogicalExpressionFalseDefSet());
            }
        }
        if (expression.isConstantBooleanExpression()) {
            if (expression.getConstantBooleanExpressionValue()) {
                return expression2;
            }
            parser.defSet = bitSet;
            return expression;
        }
        if (expression2.kind == 2 && ((BooleanConstantExpression)expression2).bval) {
            parser.defSet = bitSet;
            return expression;
        }
        parser.defSet = bitSet;
        this.rightOperand = expression2;
        this.leftOperand = expression;
        return this;
    }

    boolean isConstantBooleanExpression() {
        if (this.rightOperand.isConstantBooleanExpression()) {
            if (!this.rightOperand.getConstantBooleanExpressionValue()) {
                return true;
            }
            if (this.leftOperand.isConstantBooleanExpression() && this.leftOperand.getConstantBooleanExpressionValue()) {
                return true;
            }
        } else if (this.leftOperand.isConstantBooleanExpression() && !this.leftOperand.getConstantBooleanExpressionValue()) {
            return true;
        }
        return false;
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$assertionsDisabled && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        if (this.rightOperand.isConstantBooleanExpression() && !this.rightOperand.getConstantBooleanExpressionValue()) {
            return false;
        }
        return !this.leftOperand.isConstantBooleanExpression() || this.leftOperand.getConstantBooleanExpressionValue();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Label label = new Label();
        this.leftOperand.generateByteCodeBranch(byteCodeGenerator, label, true);
        this.rightOperand.generateByteCodeBranch(byteCodeGenerator, label, true);
        byteCodeGenerator.generate_8((byte)4);
        byteCodeGenerator.generate_8_16((byte)-89, (short)4);
        byteCodeGenerator.setLabel(label);
        byteCodeGenerator.generate_8((byte)3);
        byteCodeGenerator.incOpStackHeight(1);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean bl) {
        if (bl) {
            this.leftOperand.generateByteCodeBranch(byteCodeGenerator, label, true);
            this.rightOperand.generateByteCodeBranch(byteCodeGenerator, label, true);
        } else {
            Label label2 = new Label();
            this.leftOperand.generateByteCodeBranch(byteCodeGenerator, label2, true);
            this.rightOperand.generateByteCodeBranch(byteCodeGenerator, label, false);
            byteCodeGenerator.setLabel(label2);
        }
    }

    public String toString() {
        return "&&";
    }

    static {
        $assertionsDisabled = !LogicalAndExpression.class.desiredAssertionStatus();
    }
}

