/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class NumericBinaryExpression
extends BinaryExpression {
    NumericBinaryExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.leftOperand;
        expression = expression.resolveAndCheck(parser);
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        TypeSymbol typeSymbol2 = expression2.getType();
        TypeSymbol typeSymbol3 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol, typeSymbol2);
        this.setType(typeSymbol3);
        if (typeSymbol3.isErroneous()) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous() | typeSymbol2.isErroneous(), this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        this.leftOperand = expression.promoteType(parser, typeSymbol3);
        this.rightOperand = expression2.promoteType(parser, typeSymbol3);
        return this.foldExpression();
    }
}

