/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;
import oracle.ojc.storage.JarStorage;

public class Options {
    public static final int JDK_1_1_0 = 110;
    public static final int JDK_1_2_0 = 120;
    public static final int JDK_1_3_0 = 130;
    public static final int JDK_1_4_0 = 140;
    public static final int JDK_1_5_0 = 150;
    public Log log;
    public IdeEnv ideEnv;
    public int sourceJDKVersion;
    public int targetJDKVersion;
    boolean sourceTargetJDKDefault;
    int javaLangObjectJDKVersion;
    String fileSeparator;
    String pathSeparator;
    String prependBootClasspathStr;
    public String bootClasspathStr;
    String appendBootClasspathStr;
    String endorseddirsStr;
    String extdirsStr;
    public String classpathStr;
    public Storage[] classpathStorage;
    public String sourcepathStr;
    public Storage[] sourcepathStorage;
    Storage[] bootClasspath;
    Storage[] endorseddirs;
    Storage[] extdirs;
    Storage[] classpath;
    Storage[] sourcepath;
    String[] deployExtensions;
    public ArrayList excludeClasses;
    public Storage makeFile;
    public String destinationDir;
    Storage destinationFile;
    public String encoding;
    char[][] tagNameList;
    int messageLimit;
    int errorLimit;
    int warningLimit;
    boolean noCodeGeneration;
    boolean helpPrinted;
    public boolean verbose;
    boolean verbosepath;
    public boolean noquiet;
    public boolean lineNumbers;
    public boolean sourceFile;
    public boolean localVariables;
    public boolean codecoach;
    public boolean omitAssertions;
    public boolean selfDeprecation;
    boolean strictfpmethods;
    boolean elapsedTime;
    boolean noWarnings;
    boolean warnNonExistingPath;
    boolean warningsAreErrors;
    public boolean rebuild;
    public boolean generateClassesDespiteErrors;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Options(Log log) {
        this.log = log;
        this.sourceTargetJDKDefault = true;
        this.targetJDKVersion = 150;
        this.sourceJDKVersion = 150;
        this.fileSeparator = System.getProperty("file.separator");
        this.pathSeparator = System.getProperty("path.separator");
        this.encoding = Options.getEncoding("default");
        this.lineNumbers = true;
        this.sourceFile = true;
        this.messageLimit = 1000;
        this.warningLimit = Integer.MAX_VALUE;
        this.errorLimit = Integer.MAX_VALUE;
        this.warnNonExistingPath = true;
    }

    private void listFiles(ArrayList arrayList, Storage storage, String string, boolean bl) {
        ArrayList arrayList2 = storage.listStorage();
        if (arrayList2 != null) {
            int n;
            int n2 = n = arrayList2.size();
            while (--n2 >= 0) {
                Storage storage2 = (Storage)arrayList2.get(n2);
                String string2 = storage2.getName();
                if (string != null && !string2.endsWith(string)) continue;
                if (bl) {
                    arrayList.add(storage2);
                    continue;
                }
                string2 = string2.substring(0, string2.indexOf(46));
                arrayList.add(Identifier.getIdentifier(string2));
            }
        }
    }

    private ArrayList findInPackage(Storage[] storageArray, String string) {
        if (storageArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(20);
        for (int i = 0; i < storageArray.length; ++i) {
            this.listFiles(arrayList, storageArray[i], string, false);
        }
        return arrayList;
    }

    ArrayList findClassesInPackage(PackageSymbol packageSymbol) {
        return this.findInPackage(packageSymbol.classStorage, ".class");
    }

    ArrayList findSourcesInPackage(PackageSymbol packageSymbol) {
        return this.findInPackage(packageSymbol.sourceStorage, ".java");
    }

    ArrayList findSourcesInPackage(Parser parser, String string) {
        PackageSymbol packageSymbol = PackageSymbol.getPackageSymbol(parser, string);
        Storage[] storageArray = packageSymbol.sourceStorage;
        if (storageArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(20);
        for (int i = 0; i < storageArray.length; ++i) {
            this.listFiles(arrayList, storageArray[i], null, true);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    Storage findStorageOfClass(String string) {
        return null;
    }

    Storage findStorageOfClass(RawClassSymbol rawClassSymbol) {
        String string = new String(rawClassSymbol.getInternalName());
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? string + ".class" : string.substring(n + 1) + ".class";
        PackageScope packageScope = (PackageScope)rawClassSymbol.getPackageScope();
        PackageSymbol packageSymbol = packageScope.packageSymbol;
        Storage[] storageArray = packageSymbol == null ? this.classpath : packageSymbol.classStorage;
        if (storageArray == null) {
            return null;
        }
        for (int i = 0; i < storageArray.length; ++i) {
            Storage storage = storageArray[i].open(string2);
            if (storage == null) continue;
            return storage;
        }
        return null;
    }

    Storage findStorageOfSource(RawClassSymbol rawClassSymbol) {
        String string = new String(rawClassSymbol.getInternalName());
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? string + ".java" : string.substring(n + 1) + ".java";
        PackageScope packageScope = (PackageScope)rawClassSymbol.getPackageScope();
        PackageSymbol packageSymbol = packageScope.packageSymbol;
        Storage[] storageArray = packageSymbol == null ? this.sourcepath : packageSymbol.sourceStorage;
        if (storageArray == null) {
            return null;
        }
        for (int i = 0; i < storageArray.length; ++i) {
            Storage storage = storageArray[i].open(string2);
            if (storage == null) continue;
            return storage;
        }
        return null;
    }

    void findSourceStorageForPackage(PackageSymbol packageSymbol) {
        int n;
        ArrayList<Storage> arrayList = new ArrayList<Storage>();
        String string = packageSymbol.identifier.toString();
        PackageSymbol packageSymbol2 = packageSymbol.getOuterPackage();
        Storage[] storageArray = packageSymbol2 == null ? this.sourcepath : packageSymbol2.sourceStorage;
        if (storageArray != null) {
            for (int i = 0; i < storageArray.length; ++i) {
                Storage storage = storageArray[i].open(string);
                if (storage == null) continue;
                arrayList.add(storage);
            }
        }
        if ((n = arrayList.size()) > 0) {
            packageSymbol.sourceStorage = arrayList.toArray(new Storage[n]);
        }
    }

    void findClassStorageForPackage(PackageSymbol packageSymbol) {
        int n;
        ArrayList<Storage> arrayList = new ArrayList<Storage>();
        String string = packageSymbol.identifier.toString() + '/';
        PackageSymbol packageSymbol2 = packageSymbol.getOuterPackage();
        if (packageSymbol2 == null) {
            Storage storage;
            int n2;
            if (this.targetJDKVersion >= 120) {
                if (this.endorseddirs != null) {
                    for (n2 = 0; n2 < this.endorseddirs.length; ++n2) {
                        storage = this.endorseddirs[n2].open(string);
                        if (storage == null) continue;
                        arrayList.add(storage);
                    }
                }
                if (this.bootClasspath != null) {
                    for (n2 = 0; n2 < this.bootClasspath.length; ++n2) {
                        storage = this.bootClasspath[n2].open(string);
                        if (storage == null) continue;
                        arrayList.add(storage);
                    }
                }
            }
            if (this.extdirs != null) {
                for (n2 = 0; n2 < this.extdirs.length; ++n2) {
                    storage = this.extdirs[n2].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
            if (this.classpath != null) {
                for (n2 = 0; n2 < this.classpath.length; ++n2) {
                    storage = this.classpath[n2].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
            if (this.targetJDKVersion == 110 && this.bootClasspath != null) {
                for (n2 = 0; n2 < this.bootClasspath.length; ++n2) {
                    storage = this.bootClasspath[n2].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
        } else {
            Storage[] storageArray = packageSymbol2.classStorage;
            if (storageArray != null) {
                for (int i = 0; i < storageArray.length; ++i) {
                    Storage storage = storageArray[i].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
        }
        if ((n = arrayList.size()) > 0) {
            packageSymbol.classStorage = arrayList.toArray(new Storage[n]);
        }
    }

    public static String[] stringToArray(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (true) {
            ++n2;
            if ((n = string.indexOf(string2, n)) < 0) break;
            ++n;
        }
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        n2 = 0;
        while (true) {
            if ((n = string.indexOf(string2, n3)) < 0) break;
            stringArray[n2++] = string.substring(n3, n);
            n3 = n + 1;
        }
        stringArray[n2] = string.substring(n3);
        return stringArray;
    }

    Storage[] makeClassPath(String string, String string2, boolean bl, boolean bl2) {
        String[] stringArray = Options.stringToArray(string, this.pathSeparator);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        ArrayList<DirectoryStorage> arrayList = new ArrayList<DirectoryStorage>(n + 10);
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || string3.length() <= 0) continue;
            File file = new File(string3);
            if (!file.exists()) {
                if (!(bl & this.warnNonExistingPath)) continue;
                Warning warning = new Warning(null, Message.warningDirectoryDoesntExist, 0, string3, string2);
                this.log.println(Message.warningColonString + warning.message.getMessage());
                continue;
            }
            if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
                arrayList.add(new JarStorage(file));
                continue;
            }
            if (bl2) {
                if (!file.isDirectory()) continue;
                DirectoryStorage directoryStorage = new DirectoryStorage(file);
                ArrayList arrayList2 = directoryStorage.listStorage();
                int n2 = arrayList2.size();
                for (int j = 0; j < n2; ++j) {
                    String string4 = ((Storage)arrayList2.get(j)).getPath();
                    if (!string4.endsWith(".zip") && !string4.endsWith(".jar")) continue;
                    arrayList.add(new JarStorage(new File(string4)));
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            arrayList.add(new DirectoryStorage(file));
        }
        return arrayList.toArray(new Storage[arrayList.size()]);
    }

    public static String getEncoding(String string) {
        if (string == null || string.equals("null")) {
            return null;
        }
        if (string.equalsIgnoreCase("default")) {
            String string2 = System.getProperty("file.encoding", "8859_1");
            if (string2 != null && string2.equals("ISO8859_1")) {
                return null;
            }
            return string2;
        }
        return string;
    }

    static String JDKVersionToString(int n) {
        switch (n) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 110: {
                return "1.1";
            }
            case 120: {
                return "1.2";
            }
            case 130: {
                return "1.3";
            }
            case 140: {
                return "1.4";
            }
            case 150: 
        }
        return "1.5";
    }

    boolean checkSourceTargetVersions() {
        switch (this.sourceJDKVersion) {
            default: {
                return true;
            }
            case 140: 
            case 150: 
        }
        if (this.targetJDKVersion >= this.sourceJDKVersion) {
            return true;
        }
        Error error = new Error(null, Message.errorIncompatibleSourceTargetVersion, 0, Options.JDKVersionToString(this.targetJDKVersion), Options.JDKVersionToString(this.sourceJDKVersion));
        this.log.println(Message.errorColonString + error.message.getMessage());
        return false;
    }

    int parseOption(String[] stringArray, int n) {
        String string = stringArray[n];
        if (string.startsWith("-g")) {
            if (string.equals("-g")) {
                this.codecoach = true;
                this.localVariables = true;
            } else if (string.equals("-g:none")) {
                this.sourceFile = false;
                this.lineNumbers = false;
            } else {
                this.lineNumbers = string.indexOf("lines") > 0;
                this.sourceFile = string.indexOf("source") > 0;
                this.localVariables = string.indexOf("vars") > 0;
                this.codecoach = string.indexOf("codecoach") > 0;
            }
            return 1;
        }
        if (string.equals("-nowarn")) {
            this.noWarnings = true;
            this.warnNonExistingPath = false;
            Warning.disableAllWarnings();
            return 1;
        }
        if (string.equals("-verbose")) {
            this.verbose = true;
            this.verbosepath = true;
            return 1;
        }
        if (string.startsWith("-deprecation")) {
            if (string.endsWith(":self")) {
                this.selfDeprecation = true;
            }
            Warning.enableWarning(Message.warningIsDeprecated.getNumber());
            return 1;
        }
        if (string.equals("-classpath") || string.equals("-cp")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.classpathStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-sourcepath")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.sourcepathStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-bootclasspath") || string.equals("-sysclasspath")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.bootClasspathStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-extdirs")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.extdirsStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-endorseddirs")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.endorseddirsStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-d")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingDirectoryName, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.destinationDir = stringArray[n + 1];
            if (!this.destinationDir.endsWith(this.fileSeparator)) {
                this.destinationDir = this.destinationDir + this.fileSeparator;
            }
            return 2;
        }
        if (string.equals("-encoding")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingEncoding, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.encoding = Options.getEncoding(stringArray[n + 1]);
            return 2;
        }
        if (string.equals("-source")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            string = stringArray[n + 1];
            if (string.startsWith("1.1")) {
                this.sourceJDKVersion = 110;
            } else if (string.startsWith("1.2")) {
                this.sourceJDKVersion = 120;
            } else if (string.startsWith("1.3")) {
                this.sourceJDKVersion = 130;
            } else if (string.startsWith("1.4")) {
                this.targetJDKVersion = 140;
                this.sourceJDKVersion = 140;
            } else if (string.startsWith("1.5") || string.startsWith("5")) {
                this.targetJDKVersion = 150;
                this.sourceJDKVersion = 150;
            } else {
                Error error = new Error(null, Message.errorUnsupportedVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.sourceTargetJDKDefault = false;
            return 2;
        }
        if (string.equals("-target")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            string = stringArray[n + 1];
            if (string.startsWith("1.1")) {
                this.targetJDKVersion = 110;
            } else if (string.startsWith("1.2")) {
                this.targetJDKVersion = 120;
            } else if (string.startsWith("1.3")) {
                this.targetJDKVersion = 130;
            } else if (string.startsWith("1.4")) {
                this.targetJDKVersion = 140;
            } else if (string.startsWith("1.5") || string.startsWith("5")) {
                this.targetJDKVersion = 150;
            } else {
                Error error = new Error(null, Message.errorUnsupportedVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.sourceTargetJDKDefault = false;
            return 2;
        }
        if (string.equals("-version")) {
            this.helpPrinted = true;
            this.log.println("ojc 11.0.0 build 3736");
            return 1;
        }
        if (string.equals("-help") || string.equals("--help")) {
            this.helpPrinted = true;
            Compiler.standardUsage(this.log);
            return 1;
        }
        if (string.startsWith("-J-")) {
            return 1;
        }
        if (string.equals("-X")) {
            this.helpPrinted = true;
            Compiler.nonstandardUsage(this.log);
            return 1;
        }
        if (string.startsWith("-et")) {
            this.elapsedTime = true;
            return 1;
        }
        if (string.equals("-exclude")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingClassnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            if (this.excludeClasses == null) {
                this.excludeClasses = new ArrayList();
            }
            String[] stringArray2 = Options.stringToArray(stringArray[n + 1], File.pathSeparator);
            for (int i = 0; i < stringArray2.length; ++i) {
                this.excludeClasses.add(stringArray2[i]);
            }
            return 2;
        }
        if (string.equals("-make")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingFilename, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.makeFile = new FileStorage(new File(stringArray[n + 1]));
            return 2;
        }
        if (string.equals("-rebuild")) {
            this.rebuild = true;
            return 1;
        }
        if (string.equals("-obfuscate") || string.startsWith("-updateimports")) {
            Error error = new Error(null, Message.warningObsoleteCompilerOption, 0, string);
            this.log.println(Message.warningColonString + error.message.getMessage());
            return 1;
        }
        if (string.startsWith("-msglimit:")) {
            String string2 = string.substring(string.indexOf(58) + 1);
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < -1) {
                    throw new NumberFormatException();
                }
                if (n2 == -1) {
                    n2 = Integer.MAX_VALUE;
                }
                this.messageLimit = n2;
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, string2);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 1;
        }
        if (string.startsWith("-nowarn:")) {
            String string3 = string.substring(string.indexOf(58) + 1);
            try {
                Warning.disableWarning(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorWarningNumberExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 1;
        }
        if (string.equals("-O")) {
            return 1;
        }
        if (string.equals("-noquiet")) {
            this.noquiet = true;
            return 1;
        }
        if (string.equals("-nowrite")) {
            this.noCodeGeneration = true;
            return 1;
        }
        if (string.equals("-strictfp")) {
            this.strictfpmethods = true;
            return 1;
        }
        if (string.equals("-verbosepath")) {
            this.verbosepath = true;
            return 1;
        }
        if (string.equals("-warn")) {
            this.noWarnings = false;
            this.warnNonExistingPath = true;
            Warning.enableAllWarnings();
            return 1;
        }
        if (string.startsWith("-warn:")) {
            this.noWarnings = false;
            String string4 = string.substring(string.indexOf(58) + 1);
            try {
                Warning.enableWarning(Integer.parseInt(string4));
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorWarningNumberExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 1;
        }
        if (string.equals("-warningtag")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingTagList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            String[] stringArray3 = Options.stringToArray(stringArray[n + 1], ",");
            this.tagNameList = new char[stringArray3.length][];
            for (int i = 0; i < stringArray3.length; ++i) {
                this.tagNameList[i] = stringArray3[i].toCharArray();
            }
            return 2;
        }
        if (string.equals("-deploy")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorDeployExtensionsExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.deployExtensions = Options.stringToArray(stringArray[n + 1], this.pathSeparator);
            return 2;
        }
        if (string.equals("-Xomitasserts")) {
            this.omitAssertions = true;
            return 1;
        }
        if (string.equals("-Xwarnerror")) {
            this.warningsAreErrors = true;
            return 1;
        }
        if (string.equals("-Xhelp")) {
            this.helpPrinted = true;
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorOptionExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            Compiler.help(this.log, stringArray[n + 1]);
            return 2;
        }
        if (string.startsWith("-Djava.endorsed.dirs=")) {
            this.endorseddirsStr = string.substring(21);
            return 1;
        }
        if (string.startsWith("-Djava.ext.dirs=")) {
            this.extdirsStr = string.substring(16);
            return 1;
        }
        if (string.startsWith("-Xbootclasspath/:")) {
            this.bootClasspathStr = stringArray[n].substring(17);
            return 1;
        }
        if (string.startsWith("-Xbootclasspath/a:")) {
            this.appendBootClasspathStr = stringArray[n].substring(18);
            return 1;
        }
        if (string.startsWith("-Xbootclasspath/p:")) {
            this.prependBootClasspathStr = stringArray[n].substring(18);
            return 1;
        }
        if (string.startsWith("-Xlint")) {
            if (string.equals("-Xlint")) {
                this.warnNonExistingPath = true;
                Warning.enableWarning(Message.warningFallThrough.getNumber());
                Warning.enableWarning(Message.warningUnterminatedFinally.getNumber());
                Warning.enableWarning(Message.warningNoSerialVersionUID.getNumber());
                Warning.enableWarning(Message.warningUncheckedConversion.getNumber());
            } else if (string.equals("-Xlint:none")) {
                this.warnNonExistingPath = false;
                Warning.disableAllWarnings();
            } else if (string.equals("-Xlint:fallthrough")) {
                Warning.enableWarning(Message.warningFallThrough.getNumber());
            } else if (string.equals("-Xlint:-fallthrough")) {
                Warning.disableWarning(Message.warningFallThrough.getNumber());
            } else if (string.equals("-Xlint:finally")) {
                Warning.enableWarning(Message.warningUnterminatedFinally.getNumber());
            } else if (string.equals("-Xlint:-finally")) {
                Warning.disableWarning(Message.warningUnterminatedFinally.getNumber());
            } else if (string.equals("-Xlint:path")) {
                this.warnNonExistingPath = true;
            } else if (string.equals("-Xlint:-path")) {
                this.warnNonExistingPath = false;
            } else if (string.equals("-Xlint:serial")) {
                Warning.enableWarning(Message.warningNoSerialVersionUID.getNumber());
            } else if (string.equals("-Xlint:-serial")) {
                Warning.disableWarning(Message.warningNoSerialVersionUID.getNumber());
            } else if (string.equals("-Xlint:unchecked")) {
                Warning.enableWarning(Message.warningUncheckedConversion.getNumber());
            } else if (string.equals("-Xlint:-unchecked")) {
                Warning.disableWarning(Message.warningUncheckedConversion.getNumber());
            }
            return 1;
        }
        if (string.equals("-Xmaxerrors")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            String string5 = stringArray[n + 1];
            try {
                int n3 = Integer.parseInt(string5);
                if (n3 < -1) {
                    throw new NumberFormatException();
                }
                if (n3 == -1) {
                    n3 = Integer.MAX_VALUE;
                }
                this.errorLimit = n3;
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, string5);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 2;
        }
        if (string.equals("-Xmaxwarns")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            String string6 = stringArray[n + 1];
            try {
                int n4 = Integer.parseInt(string6);
                if (n4 < -1) {
                    throw new NumberFormatException();
                }
                if (n4 == -1) {
                    n4 = Integer.MAX_VALUE;
                }
                this.warningLimit = n4;
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, string6);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 2;
        }
        if (string.equals("-Xstdout")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingFilename, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.log.redirect(stringArray[n + 1]);
            return 2;
        }
        Error error = new Error(null, Message.errorUnknownCompilerOption, 0, string);
        this.log.println(Message.errorColonString + error.message.getMessage());
        return 0;
    }

    private static boolean printStoragePath(PrintStream printStream, Storage[] storageArray, String string, boolean bl) {
        int n = storageArray.length;
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                bl = true;
            } else {
                printStream.print(string);
            }
            printStream.print(storageArray[i].getCanonicalPath());
        }
        return bl;
    }

    void print(PrintStream printStream) {
        printStream.println("\tsource:         " + this.sourceJDKVersion);
        printStream.println("\ttarget:         " + this.targetJDKVersion);
        printStream.println();
        printStream.print("\tclasspath:        ");
        boolean bl = false;
        if (this.endorseddirs != null) {
            bl = Options.printStoragePath(printStream, this.endorseddirs, this.pathSeparator, bl);
        }
        if (this.bootClasspath != null) {
            bl = Options.printStoragePath(printStream, this.bootClasspath, this.pathSeparator, bl);
        }
        if (this.extdirs != null) {
            bl = Options.printStoragePath(printStream, this.extdirs, this.pathSeparator, bl);
        }
        if (this.classpath != null) {
            Options.printStoragePath(printStream, this.classpath, this.pathSeparator, bl);
        }
        printStream.println();
        printStream.print("\n\tsourcepath:       ");
        if (this.sourcepath != null) {
            Options.printStoragePath(printStream, this.sourcepath, "", false);
        }
        printStream.println();
        printStream.println("\n\tencoding:       " + this.encoding);
        printStream.println();
        printStream.print("\texcluded cls:  ");
        if (this.excludeClasses != null) {
            int n = this.excludeClasses.size();
            for (int i = 0; i < n; ++i) {
                printStream.println("\t" + (String)this.excludeClasses.get(i));
            }
        }
        printStream.println();
        printStream.println("\trebuild:        " + this.rebuild);
        printStream.println("\tnoCodeGen:      " + this.noCodeGeneration);
        printStream.println("\tlineNumbers:    " + this.lineNumbers);
        printStream.println("\tsourceFile:     " + this.sourceFile);
        printStream.println("\tlocalVars:      " + this.localVariables);
        printStream.println("\tcodecoach:      " + this.codecoach);
        printStream.println("\tomitAsserts:    " + this.omitAssertions);
    }

    static {
        $assertionsDisabled = !Options.class.desiredAssertionStatus();
    }
}

