/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;

final class PackageScope
extends StorageScope {
    private static final int PACKAGE_SYMBOLTABLE_SIZE = 64;
    StorageScope outerScope;
    PackageSymbol packageSymbol;
    private boolean readFromDisk;
    static final /* synthetic */ boolean $assertionsDisabled;

    PackageScope(Parser parser, StorageScope storageScope) {
        super((byte)1, 64, parser);
        if (!$assertionsDisabled && storageScope == null) {
            throw new AssertionError();
        }
        this.outerScope = storageScope;
    }

    void importPackage(ImportDescriptor importDescriptor, int n, boolean bl) {
        if (!this.readPackage() && bl) {
            this.parser.error(Message.errorDirectoryAccessError, n, false, this.packageSymbol.errorName());
        }
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        for (int i = 0; i < symbolArray.length; ++i) {
            Symbol symbol = symbolArray[i];
            while (symbol != null) {
                if ((symbol.kind & 0x24) == 32) {
                    ImportSymbol importSymbol;
                    RawClassSymbol rawClassSymbol = (RawClassSymbol)symbol;
                    if (bl) {
                        ImportSymbol importSymbol2 = this.parser.currentPackageScope.lookupImportSymbol(rawClassSymbol.identifier, (byte)32);
                        if (importSymbol2 != null) {
                            if (importSymbol2.importedSymbol == rawClassSymbol) {
                                this.parser.warning(null, Message.warningDuplicateImport, n, importSymbol2.errorName());
                            } else if ((importSymbol2.flags & 4) != 0) {
                                importSymbol = new ImportSymbol(0, rawClassSymbol, importDescriptor);
                                importSymbol.flags = (byte)(importSymbol.flags | 5);
                                importDescriptor.importSymbolList.add(importSymbol);
                                this.parser.currentPackageScope.enterSymbol(importSymbol);
                            }
                        } else if (this.parser.currentPackageScope.lookupSpecificSymbolInScope(rawClassSymbol.identifier, 32, false) == null) {
                            importSymbol = new ImportSymbol(0, rawClassSymbol, importDescriptor);
                            importSymbol.flags = (byte)(importSymbol.flags | 5);
                            importDescriptor.importSymbolList.add(importSymbol);
                            this.parser.currentPackageScope.enterSymbol(importSymbol);
                        }
                    } else {
                        importSymbol = new ImportSymbol(0, rawClassSymbol, importDescriptor);
                        importSymbol.flags = (byte)(importSymbol.flags | 4);
                        this.parser.currentPackageScope.enterSymbol(importSymbol);
                    }
                }
                symbol = symbol.nextHashed;
            }
        }
    }

    boolean readPackage() {
        RawClassSymbol rawClassSymbol;
        Identifier identifier;
        int n;
        if (this.readFromDisk) {
            return true;
        }
        this.readFromDisk = true;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList = this.parser.options.findClassesInPackage(this.packageSymbol);
        if (arrayList != null) {
            bl2 = true;
            n = arrayList.size();
            while (--n >= 0) {
                identifier = (Identifier)arrayList.get(n);
                if (this.lookupSymbolInScope(identifier, false) != null || identifier.toString().lastIndexOf(36) > 0) continue;
                rawClassSymbol = new RawClassSymbol(0, identifier, 1, null, null, false, false);
                this.enterSymbol(rawClassSymbol);
                bl = true;
            }
        }
        if (!bl && (arrayList = this.parser.options.findSourcesInPackage(this.packageSymbol)) != null) {
            bl2 = true;
            n = arrayList.size();
            while (--n >= 0) {
                identifier = (Identifier)arrayList.get(n);
                if (this.lookupSymbolInScope(identifier, false) != null) continue;
                rawClassSymbol = new RawClassSymbol(0, identifier, 1, null, null, false, false);
                this.enterSymbol(rawClassSymbol);
            }
        }
        return bl2;
    }

    Symbol lookupSymbol(Identifier identifier, boolean bl) {
        Symbol symbol = this.lookupSymbolInScope(identifier, bl);
        if (symbol != null) {
            return symbol;
        }
        return this.parser.globalScope.lookupSymbol(identifier, bl);
    }

    Symbol lookupSpecificSymbol(Identifier identifier, int n, boolean bl) {
        Symbol symbol = this.lookupSpecificSymbolInScope(identifier, n, bl);
        if (symbol != null) {
            return symbol;
        }
        return this.parser.globalScope.lookupSpecificSymbol(identifier, n, bl);
    }

    String errorName() {
        return this.packageSymbol.errorName();
    }

    boolean isSubScopeOf(Scope scope) {
        if (this == scope) {
            return true;
        }
        return this.outerScope.isSubScopeOf(scope);
    }

    Scope getOuterScope() {
        return this.outerScope;
    }

    static {
        $assertionsDisabled = !PackageScope.class.desiredAssertionStatus();
    }
}

