/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;

final class ParameterizedClassSymbol
extends ClassSymbol {
    private static ParameterizedClassSymbol[] discretePCSMap;
    private static int discretePCSMapCount;
    ParameterizedClassSymbol nextHashed;
    RawClassSymbol genericClassSymbol;
    TypeVariableList typeVariableList;
    ParameterizedClassSymbol outerClassSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ParameterizedClassSymbol(RawClassSymbol rawClassSymbol, TypeVariableList typeVariableList, ParameterizedClassSymbol parameterizedClassSymbol) {
        super(0, rawClassSymbol.identifier, (byte)10, rawClassSymbol.access, null);
        this.genericClassSymbol = rawClassSymbol;
        this.typeVariableList = typeVariableList;
        this.outerClassSymbol = parameterizedClassSymbol;
    }

    boolean isErroneous() {
        return (this.symbolFlags & 2) != 0;
    }

    String errorName() {
        if (this.isErroneous() || this.genericClassSymbol.isErroneous()) {
            return "";
        }
        return this.kindName() + " " + this.toString();
    }

    String kindName() {
        return this.genericClassSymbol.kindName();
    }

    protected void toString(StringBuffer stringBuffer) {
        if (this.outerClassSymbol != null) {
            this.outerClassSymbol.toString(stringBuffer);
            stringBuffer.append('.');
            stringBuffer.append(this.identifier.name);
        } else {
            this.genericClassSymbol.toString(stringBuffer);
        }
        TypeVariableList typeVariableList = this.typeVariableList;
        if (typeVariableList != null) {
            stringBuffer.append('<');
            while (true) {
                typeVariableList.typeVariable.toString(stringBuffer);
                typeVariableList = typeVariableList.next;
                if (typeVariableList == null) {
                    stringBuffer.append('>');
                    break;
                }
                stringBuffer.append(',');
            }
        }
    }

    char[] getInternalName() {
        return this.genericClassSymbol.getInternalName();
    }

    char[] getSignature() {
        return this.genericClassSymbol.getSignature();
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
        if (this == typeSymbol) {
            return true;
        }
        if (typeSymbol.isParameterizedClass()) {
            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)typeSymbol;
            if (this.genericClassSymbol != parameterizedClassSymbol.genericClassSymbol) {
                return false;
            }
            if (this == typeSymbol2 || typeSymbol == typeSymbol2) {
                return true;
            }
            if (this.typeVariableList == null || parameterizedClassSymbol.typeVariableList == null) {
                return true;
            }
            return parameterizedClassSymbol.typeVariableList.equals(this.typeVariableList, this);
        }
        if (typeSymbol.isRawClass()) {
            return this.genericClassSymbol == (RawClassSymbol)typeSymbol;
        }
        if (typeSymbol.isTypeParameter()) {
            TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)typeSymbol;
            if (this.equalTo(typeParameterSymbol.bound, typeSymbol2)) {
                return true;
            }
            if (this.containsTypeParameter(typeParameterSymbol)) {
                return false;
            }
            if (typeParameterSymbol.bound.isInterface()) {
                return this.implementsInterface(typeParameterSymbol.bound);
            }
            return typeParameterSymbol.bound.isSuperclass(this);
        }
        if (typeSymbol.isTypeVariable()) {
            TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)typeSymbol;
            ClassSymbol classSymbol = (ClassSymbol)typeVariableSymbol.refSymbol;
            switch (typeVariableSymbol.typeVariableKind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return this.equalTo(classSymbol, typeSymbol2);
                }
                case 2: {
                    if (this.equalTo(classSymbol, typeSymbol2)) {
                        return true;
                    }
                    if (classSymbol.isInterface()) {
                        return this.implementsInterface(classSymbol);
                    }
                    return classSymbol.isSuperclass(this);
                }
                case 3: 
            }
            if (this.equalTo(classSymbol, typeSymbol2)) {
                return true;
            }
            if (this.isInterface()) {
                return classSymbol.implementsInterface(this);
            }
            return this.isSuperclass(classSymbol);
        }
        if (typeSymbol.isIntersectionType()) {
            return typeSymbol.equalTo(this, typeSymbol2);
        }
        return false;
    }

    TypeSymbol resolveType(Parser parser, int n, boolean bl, boolean bl2) {
        this.genericClassSymbol = (RawClassSymbol)this.genericClassSymbol.resolveType(parser, n, bl, bl2);
        return this;
    }

    boolean isAccessible(ClassSymbol classSymbol) {
        if (!this.genericClassSymbol.isAccessible(classSymbol)) {
            return false;
        }
        if (this.typeVariableList != null) {
            return this.typeVariableList.isAccessible(classSymbol);
        }
        return true;
    }

    boolean isAnnotation() {
        return this.genericClassSymbol.isAnnotation();
    }

    boolean isEnum() {
        return this.genericClassSymbol.isEnum();
    }

    boolean isInterface() {
        return this.genericClassSymbol.isInterface();
    }

    boolean isInnerClass() {
        return this.genericClassSymbol.isInnerClass();
    }

    boolean isStaticInnerClass() {
        return this.genericClassSymbol.isStaticInnerClass();
    }

    boolean isNonStaticInnerClass() {
        return this.genericClassSymbol.isNonStaticInnerClass();
    }

    boolean isParameterizedClass() {
        return true;
    }

    boolean isErasedType() {
        return this.typeVariableList == null && this.genericClassSymbol.cd.getTypeParameterList() != null;
    }

    boolean isReifiable() {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            if (typeVariableList.typeVariable.typeVariableKind != 0) {
                return false;
            }
            typeVariableList = typeVariableList.next;
        }
        return true;
    }

    boolean involvesGenerics() {
        return this.typeVariableList != null;
    }

    char[] getGenericSignature() {
        TypeVariableList typeVariableList;
        StringBuffer stringBuffer;
        char[] cArray;
        if (this.outerClassSymbol != null) {
            cArray = this.outerClassSymbol.getGenericSignature();
            stringBuffer = new StringBuffer();
            if (this.outerClassSymbol.typeVariableList != null) {
                stringBuffer.append(cArray, 0, cArray.length - 1);
            } else {
                stringBuffer.append(cArray);
            }
            stringBuffer.append('.');
            stringBuffer.append(this.identifier.name);
            typeVariableList = this.typeVariableList;
            if (typeVariableList == null) {
                return stringBuffer.toString().toCharArray();
            }
        } else {
            cArray = this.genericClassSymbol.getGenericSignature();
            typeVariableList = this.typeVariableList;
            if (typeVariableList == null) {
                return cArray;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, 0, cArray.length - 1);
        }
        stringBuffer.append('<');
        do {
            if (typeVariableList.typeVariable.involvesGenerics()) {
                stringBuffer.append(typeVariableList.typeVariable.getGenericSignature());
                continue;
            }
            stringBuffer.append(typeVariableList.typeVariable.getSignature());
        } while ((typeVariableList = typeVariableList.next) != null);
        stringBuffer.append(">;");
        return stringBuffer.toString().toCharArray();
    }

    boolean involvesTypeParameter() {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            if (typeVariableList.typeVariable.involvesTypeParameter()) {
                return true;
            }
            typeVariableList = typeVariableList.next;
        }
        return false;
    }

    boolean containsTypeParameterDefinedBy(Symbol symbol) {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            if (typeVariableList.typeVariable.containsTypeParameterDefinedBy(symbol)) {
                return true;
            }
            typeVariableList = typeVariableList.next;
        }
        return false;
    }

    boolean containsTypeParameter(TypeParameterSymbol typeParameterSymbol) {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            if (typeVariableList.typeVariable.containsTypeParameter(typeParameterSymbol)) {
                return true;
            }
            typeVariableList = typeVariableList.next;
        }
        return false;
    }

    void getTypeParameterSymbol(ArrayList arrayList) {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            typeVariableList.typeVariable.getTypeParameterSymbol(arrayList);
            typeVariableList = typeVariableList.next;
        }
    }

    void changeScope(Scope scope) {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            typeVariableList.typeVariable.changeScope(scope);
            typeVariableList = typeVariableList.next;
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList typeParameterList) {
        boolean bl = false;
        TypeVariableList typeVariableList = null;
        TypeVariableList typeVariableList2 = null;
        TypeVariableList typeVariableList3 = this.typeVariableList;
        while (typeVariableList3 != null) {
            TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)typeVariableList3.typeVariable.replaceUnresolvedTypeParameters(typeParameterList);
            TypeVariableList typeVariableList4 = new TypeVariableList(typeVariableSymbol);
            if (typeVariableList2 == null) {
                typeVariableList2 = typeVariableList = typeVariableList4;
            } else {
                typeVariableList.next = typeVariableList4;
                typeVariableList = typeVariableList4;
            }
            bl |= typeVariableSymbol != typeVariableList3.typeVariable;
            typeVariableList3 = typeVariableList3.next;
        }
        if (bl) {
            return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, typeVariableList2, this.outerClassSymbol);
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList typeParameterList) {
        boolean bl = false;
        TypeVariableList typeVariableList = null;
        TypeVariableList typeVariableList2 = null;
        TypeVariableList typeVariableList3 = this.typeVariableList;
        while (typeVariableList3 != null) {
            TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)typeVariableList3.typeVariable.replaceTypeParameters(typeParameterList);
            TypeVariableList typeVariableList4 = new TypeVariableList(typeVariableSymbol);
            if (typeVariableList2 == null) {
                typeVariableList2 = typeVariableList = typeVariableList4;
            } else {
                typeVariableList.next = typeVariableList4;
                typeVariableList = typeVariableList4;
            }
            bl |= typeVariableSymbol != typeVariableList3.typeVariable;
            typeVariableList3 = typeVariableList3.next;
        }
        if (bl) {
            return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, typeVariableList2, this.outerClassSymbol);
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList typeParameterList, TypeVariableList typeVariableList, boolean bl) {
        boolean bl2 = false;
        TypeVariableList typeVariableList2 = null;
        TypeVariableList typeVariableList3 = null;
        TypeVariableList typeVariableList4 = this.typeVariableList;
        while (typeVariableList4 != null) {
            TypeVariableSymbol typeVariableSymbol = (TypeVariableSymbol)typeVariableList4.typeVariable.applyTypeVariables(typeParameterList, typeVariableList, false);
            TypeVariableList typeVariableList5 = new TypeVariableList(typeVariableSymbol);
            if (typeVariableList3 == null) {
                typeVariableList3 = typeVariableList2 = typeVariableList5;
            } else {
                typeVariableList2.next = typeVariableList5;
                typeVariableList2 = typeVariableList5;
            }
            bl2 |= typeVariableSymbol != typeVariableList4.typeVariable;
            typeVariableList4 = typeVariableList4.next;
        }
        if (bl2) {
            return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, typeVariableList3, this.outerClassSymbol);
        }
        return this;
    }

    TypeSymbol eraseType() {
        return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, null, this.outerClassSymbol);
    }

    RawClassSymbol getClassSymbol() {
        return this.genericClassSymbol.getClassSymbol();
    }

    ClassSymbol getSuperClassSymbol() {
        ClassSymbol classSymbol = this.genericClassSymbol.getSuperClassSymbol();
        if (classSymbol == null || !classSymbol.containsTypeParameterDefinedBy(null)) {
            return classSymbol;
        }
        return (ClassSymbol)classSymbol.applyTypeVariables(this.genericClassSymbol.cd.getTypeParameterList(), this.typeVariableList);
    }

    ImplementationList getImplementationList() {
        ImplementationList implementationList;
        ImplementationList implementationList2 = implementationList = this.genericClassSymbol.getImplementationList();
        while (implementationList2 != null && !implementationList2.interfaceSymbol.containsTypeParameterDefinedBy(null)) {
            implementationList2 = implementationList2.next;
        }
        if (implementationList2 == null) {
            return implementationList;
        }
        ImplementationList implementationList3 = null;
        implementationList2 = null;
        do {
            ClassSymbol classSymbol = this.typeVariableList == null ? ParameterizedClassSymbol.getParameterizedClassSymbol(implementationList.interfaceSymbol.getClassSymbol(), null, null) : (ClassSymbol)implementationList.interfaceSymbol.applyTypeVariables(this.genericClassSymbol.cd.getTypeParameterList(), this.typeVariableList);
            ImplementationList implementationList4 = new ImplementationList(classSymbol);
            if (implementationList2 == null) {
                implementationList2 = implementationList3 = implementationList4;
                continue;
            }
            implementationList3.next = implementationList4;
            implementationList3 = implementationList4;
        } while ((implementationList = implementationList.next) != null);
        return implementationList2;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol rawClassSymbol) {
        TypeVariableList typeVariableList = this.typeVariableList;
        while (typeVariableList != null) {
            TypeSymbol typeSymbol = typeVariableList.typeVariable.refSymbol;
            if (typeSymbol != null && typeSymbol.isReferenceType()) {
                ClassSymbol classSymbol;
                if (typeSymbol.isArrayType()) {
                    ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
                    if (!arraySymbol.baseType.isClass()) {
                        return;
                    }
                    classSymbol = (ClassSymbol)arraySymbol.baseType;
                } else {
                    classSymbol = (ClassSymbol)typeSymbol;
                }
                if (classSymbol != null && !classSymbol.isTypeParameter()) {
                    constantPool.checkForOutOfPackageInnerClass(rawClassSymbol, classSymbol.getClassSymbol());
                    classSymbol.checkForOutOfPackageInnerClasses(constantPool, rawClassSymbol);
                }
            }
            typeVariableList = typeVariableList.next;
        }
    }

    static void initializeStatics() {
        discretePCSMap = new ParameterizedClassSymbol[1024];
        discretePCSMapCount = 0;
    }

    static void releaseStatics() {
        discretePCSMap = null;
    }

    private static int rehashParameterizedClassSymbols() {
        int n = discretePCSMapCount;
        ParameterizedClassSymbol[] parameterizedClassSymbolArray = discretePCSMap;
        int n2 = parameterizedClassSymbolArray.length;
        int n3 = n2 << 1;
        ParameterizedClassSymbol[] parameterizedClassSymbolArray2 = new ParameterizedClassSymbol[n3];
        for (int i = 0; i < n2; ++i) {
            ParameterizedClassSymbol parameterizedClassSymbol;
            ParameterizedClassSymbol parameterizedClassSymbol2 = parameterizedClassSymbolArray[i];
            if (parameterizedClassSymbol2 == null) continue;
            do {
                --n;
                parameterizedClassSymbol = parameterizedClassSymbol2.nextHashed;
                int n4 = parameterizedClassSymbol2.identifier.hash & n3 - 1;
                parameterizedClassSymbol2.nextHashed = parameterizedClassSymbolArray2[n4];
                parameterizedClassSymbolArray2[n4] = parameterizedClassSymbol2;
            } while ((parameterizedClassSymbol2 = parameterizedClassSymbol) != null);
            if (n == 0) break;
        }
        discretePCSMap = parameterizedClassSymbolArray2;
        return n3;
    }

    static ParameterizedClassSymbol getParameterizedClassSymbol(RawClassSymbol rawClassSymbol, TypeVariableList typeVariableList, ParameterizedClassSymbol parameterizedClassSymbol) {
        int n = discretePCSMap.length;
        int n2 = discretePCSMapCount;
        if (n < 0x200000 && n2 > n - (n >> 2)) {
            n = ParameterizedClassSymbol.rehashParameterizedClassSymbols();
        }
        int n3 = rawClassSymbol.identifier.hash;
        ParameterizedClassSymbol parameterizedClassSymbol2 = discretePCSMap[n3 & n - 1];
        while (parameterizedClassSymbol2 != null) {
            if (parameterizedClassSymbol2.genericClassSymbol == rawClassSymbol && parameterizedClassSymbol2.outerClassSymbol == parameterizedClassSymbol) {
                if (parameterizedClassSymbol2.typeVariableList == typeVariableList) {
                    return parameterizedClassSymbol2;
                }
                TypeVariableList typeVariableList2 = parameterizedClassSymbol2.typeVariableList;
                TypeVariableList typeVariableList3 = typeVariableList;
                while (typeVariableList2 != null && typeVariableList3 != null) {
                    TypeVariableSymbol typeVariableSymbol = typeVariableList2.typeVariable;
                    TypeVariableSymbol typeVariableSymbol2 = typeVariableList3.typeVariable;
                    if (typeVariableSymbol.typeVariableKind != typeVariableSymbol2.typeVariableKind || typeVariableSymbol.refSymbol != typeVariableSymbol2.refSymbol) break;
                    typeVariableList2 = typeVariableList2.next;
                    typeVariableList3 = typeVariableList3.next;
                }
                if (typeVariableList2 == typeVariableList3) {
                    return parameterizedClassSymbol2;
                }
            }
            parameterizedClassSymbol2 = parameterizedClassSymbol2.nextHashed;
        }
        parameterizedClassSymbol2 = new ParameterizedClassSymbol(rawClassSymbol, typeVariableList, parameterizedClassSymbol);
        parameterizedClassSymbol2.nextHashed = discretePCSMap[n3 &= n - 1];
        ParameterizedClassSymbol.discretePCSMap[n3] = parameterizedClassSymbol2;
        discretePCSMapCount = n2 + 1;
        return parameterizedClassSymbol2;
    }

    static void updateAccessOfExistingParameterizedClasses(RawClassSymbol rawClassSymbol) {
        int n = rawClassSymbol.identifier.hash;
        ParameterizedClassSymbol parameterizedClassSymbol = discretePCSMap[n & discretePCSMap.length - 1];
        while (parameterizedClassSymbol != null) {
            if (parameterizedClassSymbol.genericClassSymbol == rawClassSymbol) {
                parameterizedClassSymbol.access = rawClassSymbol.access;
            }
            parameterizedClassSymbol = parameterizedClassSymbol.nextHashed;
        }
    }

    void checkBounds(Parser parser, int n, TypeSymbol typeSymbol) {
        if (typeSymbol.isParameterizedClass() && !typeSymbol.isErroneous()) {
            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)typeSymbol;
            TypeVariableList typeVariableList = this.typeVariableList;
            TypeVariableList typeVariableList2 = parameterizedClassSymbol.typeVariableList;
            while (true) {
                if (typeVariableList == null) {
                    return;
                }
                if (typeVariableList2 == null) {
                    parser.error(Message.errorTypeParameterOutOfBounds, n, false, parameterizedClassSymbol.errorName());
                    return;
                }
                TypeVariableSymbol typeVariableSymbol = typeVariableList.typeVariable;
                TypeVariableSymbol typeVariableSymbol2 = typeVariableList2.typeVariable;
                switch (typeVariableSymbol.typeVariableKind) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 0: {
                        break;
                    }
                    case 3: {
                        if (typeVariableSymbol2.equalTo(typeVariableSymbol)) break;
                        if (typeVariableSymbol.refSymbol.isInterface()) {
                            if (((ClassSymbol)typeVariableSymbol2.refSymbol).implementsInterface((ClassSymbol)typeVariableSymbol.refSymbol)) break;
                            parser.error(Message.errorTypeParameterOutOfBounds, n, false, parameterizedClassSymbol.errorName());
                            break;
                        }
                        if (((ClassSymbol)typeVariableSymbol2.refSymbol).isSuperclass((ClassSymbol)typeVariableSymbol.refSymbol)) break;
                        parser.error(Message.errorTypeParameterOutOfBounds, n, false, parameterizedClassSymbol.errorName());
                        break;
                    }
                    case 2: {
                        if (typeVariableSymbol2.equalTo(typeVariableSymbol)) break;
                        if (typeVariableSymbol.refSymbol.isInterface()) {
                            if (((ClassSymbol)typeVariableSymbol.refSymbol).implementsInterface((ClassSymbol)typeVariableSymbol2.refSymbol)) break;
                            parser.error(Message.errorTypeParameterOutOfBounds, n, false, parameterizedClassSymbol.errorName());
                            break;
                        }
                        if (((ClassSymbol)typeVariableSymbol.refSymbol).isSuperclass((ClassSymbol)typeVariableSymbol2.refSymbol)) break;
                        parser.error(Message.errorTypeParameterOutOfBounds, n, false, parameterizedClassSymbol.errorName());
                    }
                }
                if (typeVariableSymbol.isParameterizedClass()) {
                    ((ParameterizedClassSymbol)typeVariableSymbol.refSymbol).checkBounds(parser, n, typeVariableSymbol2.refSymbol);
                }
                typeVariableList = typeVariableList.next;
                typeVariableList2 = typeVariableList2.next;
            }
        }
        parser.error(Message.errorTypeParameterOutOfBounds, n, typeSymbol.isErroneous(), typeSymbol.errorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkActualTypeParameters(Parser parser, int n) {
        TypeVariableList typeVariableList;
        if (!this.isErroneous() && (typeVariableList = this.typeVariableList) != null) {
            TypeParameterList typeParameterList;
            TypeSymbol typeSymbol;
            do {
                TypeParameterSymbol typeParameterSymbol;
                if ((typeSymbol = typeVariableList.typeVariable.refSymbol) == null) continue;
                try {
                    typeVariableList.typeVariable.refSymbol = null;
                    typeSymbol = typeSymbol.resolveType(parser, n, false, true);
                }
                finally {
                    typeVariableList.typeVariable.refSymbol = typeSymbol;
                }
                if (typeSymbol.isErroneous()) {
                    this.symbolFlags = (byte)(this.symbolFlags | 2);
                }
                if (!typeSymbol.isTypeParameter() || (typeParameterSymbol = (TypeParameterSymbol)typeSymbol).isMethodTypeParameter() || !parser.isInStaticContext(typeParameterSymbol)) continue;
                parser.error(Message.errorUndefinedThis, n, typeParameterSymbol.isErroneous(), typeParameterSymbol.errorName());
            } while ((typeVariableList = typeVariableList.next) != null);
            RawClassSymbol rawClassSymbol = this.getClassSymbol();
            TypeParameterList typeParameterList2 = typeParameterList = rawClassSymbol.cd.getTypeParameterList();
            typeVariableList = this.typeVariableList;
            do {
                if (typeParameterList == null) {
                    parser.error(Message.errorTooManyTypeParameters, n, false, this.errorName());
                    continue;
                }
                typeSymbol = typeVariableList.typeVariable.refSymbol;
                if (typeSymbol != null && rawClassSymbol.isCompiled() && !parser.suspendTypeBoundsChecking) {
                    typeParameterList.typeParameter.checkBounds(parser, typeVariableList.typeVariable.pos, typeSymbol, typeParameterList2, this.typeVariableList);
                }
                typeParameterList = typeParameterList.next;
            } while ((typeVariableList = typeVariableList.next) != null);
            if (typeParameterList != null) {
                parser.error(Message.errorMissingTypeParameters, n, false, this.errorName());
            }
        }
    }

    TypeSymbol getTypeVariable(TypeParameterSymbol typeParameterSymbol) {
        TypeVariableList typeVariableList = this.typeVariableList;
        if (typeVariableList == null) {
            return null;
        }
        TypeParameterList typeParameterList = this.getClassSymbol().cd.getTypeParameterList();
        while (typeParameterList.typeParameter != typeParameterSymbol) {
            typeParameterList = typeParameterList.next;
            typeVariableList = typeVariableList.next;
        }
        return typeVariableList.typeVariable.refSymbol;
    }

    static {
        $assertionsDisabled = !ParameterizedClassSymbol.class.desiredAssertionStatus();
    }
}

