/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AppendStringExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.NumericBinaryExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.TypeSymbol;

final class PlusExpression
extends NumericBinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    PlusExpression(int n, Expression expression, Expression expression2) {
        super((byte)33, n, expression, expression2);
    }

    strictfp Expression foldExpression() {
        Expression expression = this.leftOperand;
        Expression expression2 = this.rightOperand;
        if (expression2.kind == 2) {
            TypeSymbol typeSymbol = this.getType();
            byte by = typeSymbol.typeClass;
            if (expression.kind == 2) {
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 4: {
                        return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)expression).getIntConstValue() + ((ConstantExpression)expression2).getIntConstValue());
                    }
                    case 8: {
                        return new LongConstantExpression(this.pos, ((LongConstantExpression)expression).lval + ((LongConstantExpression)expression2).lval);
                    }
                    case 16: {
                        return new FloatConstantExpression(this.pos, ((FloatConstantExpression)expression).fval + ((FloatConstantExpression)expression2).fval);
                    }
                    case 32: 
                }
                return new DoubleConstantExpression(this.pos, ((DoubleConstantExpression)expression).dval + ((DoubleConstantExpression)expression2).dval);
            }
            if (by == 4 && ((ConstantExpression)expression2).getIntConstValue() == 0) {
                return expression;
            }
        } else if (expression2.kind == 51 && expression.kind == 51) {
            AppendStringExpression appendStringExpression = (AppendStringExpression)expression;
            AppendStringExpression appendStringExpression2 = (AppendStringExpression)expression2;
            if (appendStringExpression2.expr instanceof StringConstantExpression && appendStringExpression.expr instanceof StringConstantExpression) {
                StringConstantExpression stringConstantExpression = (StringConstantExpression)appendStringExpression.expr;
                StringConstantExpression stringConstantExpression2 = (StringConstantExpression)appendStringExpression2.expr;
                int n = stringConstantExpression.sval.length + stringConstantExpression2.sval.length;
                char[] cArray = new char[n];
                System.arraycopy(stringConstantExpression.sval, 0, cArray, 0, stringConstantExpression.sval.length);
                System.arraycopy(stringConstantExpression2.sval, 0, cArray, stringConstantExpression.sval.length, stringConstantExpression2.sval.length);
                return new StringConstantExpression(this.pos, this.getType(), cArray);
            }
        }
        return this;
    }

    strictfp Expression resolveAndCheck(Parser parser) {
        Expression expression = this.leftOperand;
        expression = expression.resolveAndCheck(parser);
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        if (typeSymbol.isErroneous()) {
            return expression;
        }
        TypeSymbol typeSymbol2 = expression2.getType();
        if (typeSymbol2.isErroneous()) {
            return expression2;
        }
        RawClassSymbol rawClassSymbol = parser.javaLangStringSymbol;
        if (typeSymbol.equalTo(rawClassSymbol) || typeSymbol2.equalTo(rawClassSymbol)) {
            if (expression.kind != 51) {
                expression = new AppendStringExpression(parser, expression);
            }
            this.leftOperand = expression;
            if (expression2.kind != 51) {
                expression2 = new AppendStringExpression(parser, expression2);
            }
            this.rightOperand = expression2;
            this.setType(rawClassSymbol);
        } else {
            TypeSymbol typeSymbol3 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol, typeSymbol2);
            this.setType(typeSymbol3);
            if (typeSymbol3.isErroneous()) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous() | typeSymbol2.isErroneous(), this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                return new ErrorExpression(error);
            }
            this.leftOperand = expression.promoteType(parser, typeSymbol3);
            this.rightOperand = expression2.promoteType(parser, typeSymbol3);
        }
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte by = this.getType().typeClass;
        if (by == 64) {
            ConstantPool constantPool = byteCodeGenerator.constantPool;
            if (byteCodeGenerator.doingStringConcatonation) {
                this.leftOperand.generateByteCode(byteCodeGenerator);
                this.rightOperand.generateByteCode(byteCodeGenerator);
            } else {
                boolean bl = byteCodeGenerator.doingStringConcatonation;
                byteCodeGenerator.doingStringConcatonation = true;
                char[] cArray = byteCodeGenerator.parser.options.targetJDKVersion < 150 ? Identifier.javaLangStringBufferInternal.name : Identifier.javaLangStringBuilderInternal.name;
                short s = constantPool.enterConstantPoolClass(cArray);
                byteCodeGenerator.generate_8_16((byte)-69, s);
                byteCodeGenerator.generate_8((byte)89);
                byteCodeGenerator.incOpStackHeight(2);
                s = constantPool.enterConstantPoolMethodRef(cArray, Identifier.initializerIdentifier.name, Identifier.voidMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-73, s);
                byteCodeGenerator.decOpStackHeight(1);
                this.leftOperand.generateByteCode(byteCodeGenerator);
                this.rightOperand.generateByteCode(byteCodeGenerator);
                s = constantPool.enterConstantPoolMethodRef(cArray, Identifier.toStringIdentifier.name, Identifier.javaLangStringMethodSignature.name);
                byteCodeGenerator.generate_8_16((byte)-74, s);
                byteCodeGenerator.doingStringConcatonation = bl;
            }
        } else {
            this.leftOperand.generateByteCode(byteCodeGenerator);
            this.rightOperand.generateByteCode(byteCodeGenerator);
            switch (by) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    byteCodeGenerator.generate_8((byte)96);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8((byte)97);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
                case 16: {
                    byteCodeGenerator.generate_8((byte)98);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 32: {
                    byteCodeGenerator.generate_8((byte)99);
                    byteCodeGenerator.decOpStackHeight(2);
                }
            }
        }
    }

    public String toString() {
        return "+";
    }

    static {
        $assertionsDisabled = !PlusExpression.class.desiredAssertionStatus();
    }
}

