/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassFileReader;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.DynamicInitializationStatement;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.LocalScope;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.NewSourceException;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;

class RawClassSymbol
extends ClassSymbol {
    static RawClassSymbol errorClass;
    static final short CSF_NONE = 0;
    static final short CSF_ASSERTIONS = 1;
    static final short CSF_CONSTANTVALUES = 2;
    static final short CSF_ANONYMOUS_THIS_NOT_INITIALIZED = 4;
    static final short CSF_CLASSLOADERMETHOD = 8;
    static final short CSF_ERRORFLAGGED = 16;
    static final short CSF_COMPILED = 32;
    static final short CSF_RESOLVED = 64;
    static final short CSF_LOCALCLASS = 128;
    static final short CSF_SYNTHETIC = 256;
    static final short CSF_DEPRECATED = 512;
    static final short CSF_IMPLEMENTSINTERFACES = 1024;
    static final short CSF_SERIALIZABLE = 2048;
    static final short CSF_ANNOTATION_USED = 4096;
    static final short CSF_SPECIAL_ANNOTATION = 8192;
    static final short CSF_INVOLVES_GENERICS = 16384;
    ClassSymbol superClass;
    private ImplementationList implementationList;
    ClassScope classScope;
    ClassData cd;
    short flags;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RawClassSymbol() {
        super(0, Identifier.getIdentifier("1"), (byte)10, (short)1, null);
        this.flags = (short)(this.flags | 0x10);
        this.classScope = new ClassScope(this, null, null);
        this.cd = new ClassData();
        this.cd.internalName = new char[0];
    }

    RawClassSymbol(int n, Identifier identifier, short s, TypeParameterList typeParameterList, Annotation annotation, boolean bl, boolean bl2) {
        super(n, identifier, (byte)10, s, annotation);
        if (!bl2) {
            if ((s & 0x2000) != 0) {
                this.cd = new AnnotationClassData();
            } else if (typeParameterList != null) {
                this.cd = new GenericClassData(typeParameterList);
                this.flags = (short)(this.flags | 0x4000);
            } else {
                this.cd = new ClassData();
            }
            if (bl) {
                this.cd.ccd = new CompiledClassData();
            }
        }
    }

    boolean isSynthetic() {
        return (this.flags & 0x100) != 0;
    }

    boolean isDeprecated() {
        return (this.flags & 0x200) != 0;
    }

    void deprecate() {
        this.flags = (short)(this.flags | 0x200);
    }

    boolean isErroneous() {
        return (this.flags & 0x10) != 0;
    }

    String errorName() {
        if (this.scope == null) {
            return "";
        }
        return this.kindName() + " " + this.toString();
    }

    String kindName() {
        if (this.isAnnotation()) {
            return Message.annotationString;
        }
        if (this.isInterface()) {
            return Message.interfaceString;
        }
        if (this.isEnum()) {
            return Message.enumString;
        }
        return Message.classString;
    }

    char[] getInternalName() {
        if (this.cd.internalName == null) {
            char[] cArray = this.getClassName();
            Scope scope = this.getPackageScope();
            if (scope.kind == 1) {
                PackageScope packageScope = (PackageScope)scope;
                PackageSymbol packageSymbol = packageScope.packageSymbol;
                if (packageSymbol != null) {
                    char[] cArray2 = packageSymbol.getSignature();
                    int n = cArray2.length + 1 + cArray.length;
                    this.cd.internalName = new char[n];
                    System.arraycopy(cArray2, 0, this.cd.internalName, 0, cArray2.length);
                    this.cd.internalName[cArray2.length] = 47;
                    System.arraycopy(cArray, 0, this.cd.internalName, cArray2.length + 1, cArray.length);
                } else {
                    this.cd.internalName = cArray;
                }
            } else {
                this.cd.internalName = cArray;
            }
        }
        return this.cd.internalName;
    }

    char[] getSignature() {
        if (this.cd.signature == null) {
            char[] cArray = this.getInternalName();
            int n = 1 + cArray.length + 1;
            this.cd.signature = new char[n];
            this.cd.signature[0] = 76;
            System.arraycopy(cArray, 0, this.cd.signature, 1, cArray.length);
            this.cd.signature[cArray.length + 1] = 59;
        }
        return this.cd.signature;
    }

    Annotation getAnnotations() {
        return this.annotation;
    }

    byte getAnnotationTarget() {
        if (this.isAnnotation()) {
            return 65;
        }
        return 1;
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
        if (!(typeSymbol instanceof ClassSymbol)) {
            return false;
        }
        RawClassSymbol rawClassSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
        return this == rawClassSymbol;
    }

    boolean isCompiled() {
        return (this.flags & 0x20) != 0;
    }

    boolean isRawClass() {
        return true;
    }

    boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    boolean isLocalInnerClass() {
        return (this.flags & 0x80) != 0;
    }

    boolean isGenericType() {
        return this.cd instanceof GenericClassData;
    }

    boolean involvesGenerics() {
        return (this.flags & 0x4000) != 0;
    }

    TypeSymbol resolveType(Parser parser, int n, boolean bl, boolean bl2) {
        if ((this.flags & 0x50) == 0) {
            if ((this.flags & 0x20) == 0) {
                this.loadType(parser, n);
            } else {
                this.flags = (short)(this.flags | 0x40);
                if (this.superClass != null && !this.superClass.equalTo(parser.javaLangObjectSymbol) && this.isInterface() != this.superClass.isInterface()) {
                    parser.error(Message.errorNoInterfaceAllowed, this.cd.ccd.tpos, false);
                }
                if (this.superClass != null && (this.superClass.access & 0x10) != 0) {
                    parser.error(Message.errorFinalCannotBeInherited, this.cd.ccd.tpos, this.superClass.isErroneous(), this.superClass.errorName());
                }
            }
        }
        return this;
    }

    protected void toString(StringBuffer stringBuffer) {
        Scope scope = this.getPackageScope();
        if (scope.kind == 1) {
            PackageScope packageScope = (PackageScope)scope;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            if (packageSymbol != null) {
                packageSymbol.toString(stringBuffer);
                stringBuffer.append('.');
            }
        }
        stringBuffer.append(this.getClassName());
    }

    boolean isAccessible(ClassSymbol classSymbol) {
        if (this.equalTo(classSymbol)) {
            return true;
        }
        switch (this.access & 7) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
            case 4: {
                if (!this.isSuperclass(classSymbol)) break;
                return true;
            }
        }
        return this.inSamePackage(classSymbol);
    }

    RawClassSymbol getClassSymbol() {
        return this;
    }

    ClassSymbol getSuperClassSymbol() {
        return this.superClass;
    }

    ClassSymbol getInterface(RawClassSymbol rawClassSymbol) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    ImplementationList getImplementationList() {
        return this.implementationList;
    }

    RawClassSymbol getOuterClass() {
        if (!$assertionsDisabled && !this.isInnerClass()) {
            throw new AssertionError();
        }
        if (this.scope.kind == 2) {
            return ((ClassScope)this.scope).classSymbol;
        }
        if (!$assertionsDisabled && this.scope.kind < 3) {
            throw new AssertionError();
        }
        Scope scope = this.scope;
        do {
            scope = scope.getOuterScope();
        } while (scope.kind >= 3);
        if (!$assertionsDisabled && scope.kind != 2) {
            throw new AssertionError();
        }
        return ((ClassScope)scope).classSymbol;
    }

    RawClassSymbol getTopLevelClass() {
        RawClassSymbol rawClassSymbol = this;
        while (rawClassSymbol.isInnerClass()) {
            rawClassSymbol = rawClassSymbol.getOuterClass();
        }
        return rawClassSymbol;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol rawClassSymbol) {
        TypeParameterList typeParameterList = this.cd.getTypeParameterList();
        while (typeParameterList != null) {
            typeParameterList.typeParameter.checkForOutOfPackageInnerClasses(constantPool, rawClassSymbol);
            typeParameterList = typeParameterList.next;
        }
    }

    static void initializeStatics() {
        errorClass = new RawClassSymbol();
    }

    static void releaseStatics() {
        errorClass = null;
    }

    boolean hasCompiledSuperclasses() {
        RawClassSymbol rawClassSymbol = this;
        while (rawClassSymbol.superClass != null) {
            rawClassSymbol = rawClassSymbol.superClass.getClassSymbol();
            if ((rawClassSymbol.flags & 0x20) == 0) continue;
            return true;
        }
        return false;
    }

    void propagateInterfaceFlagsFromSuperclasses() {
        if ((this.flags & 0x20) == 0 && this.superClass != null) {
            RawClassSymbol rawClassSymbol = this.getSuperClassSymbol().getClassSymbol();
            rawClassSymbol.propagateInterfaceFlagsFromSuperclasses();
            this.flags = (short)(this.flags | rawClassSymbol.flags & 0xC00);
        }
    }

    void setImplementationList(ImplementationList implementationList) {
        this.implementationList = implementationList;
    }

    void addField(FieldSymbol fieldSymbol) {
        if (!$assertionsDisabled && this.cd == null) {
            throw new AssertionError();
        }
        fieldSymbol.nextInClass = this.cd.fieldList;
        this.cd.fieldList = fieldSymbol;
        short s = this.cd.fieldCount;
        this.cd.fieldCount = (short)(s + 1);
        fieldSymbol.index = s;
    }

    void addInnerClass(ClassSymbol classSymbol) {
        if (!$assertionsDisabled && this.cd == null) {
            throw new AssertionError();
        }
        TypeSymbolList typeSymbolList = new TypeSymbolList(classSymbol);
        typeSymbolList.next = this.cd.innerClassList;
        this.cd.innerClassList = typeSymbolList;
    }

    void checkDeprecated(Parser parser, int n) {
        if (this.isDeprecated() && this != parser.currentClassSymbol) {
            parser.warning(this, Message.warningIsDeprecated, n, this.errorName());
        }
    }

    MethodSymbol[] getMethodTable(Parser parser) {
        MethodSymbol[] methodSymbolArray = this.cd.methodTable;
        if (methodSymbolArray == null) {
            if ((this.flags & 0x20) != 0) {
                return null;
            }
            this.buildMethodTable(parser);
            methodSymbolArray = this.cd.methodTable;
        }
        return methodSymbolArray;
    }

    void buildMethodTable(Parser parser) {
        if (this.cd.methodTable == null) {
            MethodSymbol methodSymbol;
            if ((this.flags & 0x60) == 0) {
                this.loadType(parser, 0);
            }
            if (!this.isCompiled()) {
                boolean bl = parser.suspendStaticContextChecking;
                parser.suspendStaticContextChecking = true;
                this.resolveTypeParameters(parser);
                methodSymbol = this.cd.methodList;
                while (methodSymbol != null) {
                    methodSymbol.resolveTypeParameters(parser);
                    TypeSymbol typeSymbol = methodSymbol.resultType;
                    if (typeSymbol.isUnresolvedType()) {
                        methodSymbol.resultType = typeSymbol = typeSymbol.resolveType(parser, 0, false, true);
                    }
                    ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
                    while (argumentVariableList != null) {
                        ArgumentVariableSymbol argumentVariableSymbol = argumentVariableList.argSymbol;
                        typeSymbol = argumentVariableSymbol.type;
                        if (typeSymbol.isUnresolvedType()) {
                            argumentVariableSymbol.type = typeSymbol = typeSymbol.resolveType(parser, 0, false, true);
                        }
                        argumentVariableList = argumentVariableList.next;
                    }
                    MethodSymbol.ThrowsList throwsList = methodSymbol.throwsList;
                    while (throwsList != null) {
                        typeSymbol = throwsList.throwsType;
                        if (typeSymbol.isUnresolvedType()) {
                            throwsList.throwsType = typeSymbol.resolveType(parser, 0, false, true);
                        }
                        throwsList = throwsList.next;
                    }
                    methodSymbol = methodSymbol.nextInClass;
                }
                parser.suspendStaticContextChecking = bl;
            }
            int n = this.cd.methodCount;
            if (this.superClass != null) {
                n += this.superClass.getClassSymbol().cd.methodCount;
            }
            ArrayList<MethodSymbol> arrayList = new ArrayList<MethodSymbol>(n);
            methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                arrayList.add(methodSymbol);
                methodSymbol = methodSymbol.nextInClass;
            }
            if (this.isInterface()) {
                if (this.implementationList != null) {
                    ImplementationList implementationList = this.implementationList;
                    while (implementationList != null) {
                        this.mergeIntoMethodTable(parser, arrayList, (ParameterizedClassSymbol)implementationList.interfaceSymbol);
                        implementationList = implementationList.next;
                    }
                } else {
                    if (!$assertionsDisabled && this.superClass == null) {
                        throw new AssertionError();
                    }
                    this.mergeIntoMethodTable(parser, arrayList, (ParameterizedClassSymbol)this.superClass);
                }
            } else {
                boolean bl = false;
                if (this.superClass != null) {
                    bl |= this.mergeIntoMethodTable(parser, arrayList, (ParameterizedClassSymbol)this.superClass);
                }
                ImplementationList implementationList = this.implementationList;
                while (implementationList != null) {
                    ClassSymbol classSymbol = implementationList.interfaceSymbol;
                    bl |= this.mergeIntoMethodTable(parser, arrayList, (ParameterizedClassSymbol)classSymbol);
                    if (((ParameterizedClassSymbol)classSymbol).typeVariableList != null) {
                        bl |= true;
                    }
                    implementationList = implementationList.next;
                }
                if (parser.options.sourceJDKVersion < 150) {
                    bl = false;
                } else if (!bl) {
                    for (ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)this.superClass; parameterizedClassSymbol != null; parameterizedClassSymbol = (ParameterizedClassSymbol)parameterizedClassSymbol.getSuperClassSymbol()) {
                        if (parameterizedClassSymbol.typeVariableList == null) continue;
                        bl = true;
                        break;
                    }
                }
                if (this.isCompiled() && bl) {
                    this.addBridgeMethods(parser);
                }
            }
            this.cd.methodTable = arrayList.toArray(new MethodSymbol[arrayList.size()]);
        }
    }

    void fixConstructors(Parser parser) {
        if (this.cd.ccd.dynamicInitializer == null) {
            return;
        }
        MethodSymbol methodSymbol = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        while (methodSymbol != null) {
            if ((methodSymbol.flags & 2) == 0) {
                StatementList statementList = methodSymbol.cmd.statementList;
                if (statementList == null) {
                    methodSymbol.cmd.statementList = statementList = new StatementList();
                }
                DynamicInitializationStatement dynamicInitializationStatement = new DynamicInitializationStatement(statementList);
                ((Statement)dynamicInitializationStatement).resolveAndCheck(parser);
                if (statementList.first == null) {
                    statementList.add(dynamicInitializationStatement);
                } else if (methodSymbol.definingClass.superClass != null) {
                    statementList.first.insertAfter(dynamicInitializationStatement);
                } else {
                    statementList.first.insertBefore(dynamicInitializationStatement);
                }
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
    }

    void pruneUnresolvedClassSymbols(Parser parser) {
        ImplementationList implementationList;
        Object object = parser.saveResolutionState(this);
        if (this.superClass instanceof UnresolvedClassSymbol) {
            parser.error(Error.errorNotFound, this.cd.ccd.tpos, false, this.superClass.errorName(), "");
            this.superClass = parser.javaLangObjectPcs;
        }
        if ((implementationList = this.getImplementationList()) != null) {
            ImplementationList implementationList2 = implementationList;
            ImplementationList implementationList3 = null;
            do {
                if (implementationList.interfaceSymbol instanceof UnresolvedClassSymbol) {
                    parser.error(Error.errorNotFound, this.cd.ccd.tpos, false, implementationList.interfaceSymbol.errorName(), "");
                    if (implementationList3 == null) {
                        implementationList2 = implementationList.next;
                        continue;
                    }
                    implementationList3.next = implementationList.next;
                    continue;
                }
                implementationList3 = implementationList;
            } while ((implementationList = implementationList.next) != null);
            this.setImplementationList(implementationList2);
        }
        TypeParameterList typeParameterList = this.cd.getTypeParameterList();
        while (typeParameterList != null) {
            if (typeParameterList.typeParameter.bound instanceof UnresolvedClassSymbol) {
                parser.error(Error.errorNotFound, typeParameterList.typeParameter.boundPos, false, typeParameterList.typeParameter.bound.errorName(), "");
                typeParameterList.typeParameter.bound = parser.javaLangObjectPcs;
            }
            typeParameterList = typeParameterList.next;
        }
        TypeSymbolList typeSymbolList = this.cd.innerClassList;
        while (typeSymbolList != null) {
            ((RawClassSymbol)typeSymbolList.typeSymbol).pruneUnresolvedClassSymbols(parser);
            typeSymbolList = typeSymbolList.next;
        }
        parser.restoreResolutionState(object);
    }

    int resolveSuperClass(Parser parser, boolean bl) {
        if (this.superClass != null) {
            try {
                TypeSymbol typeSymbol = this.superClass.resolveType(parser, this.superClass.pos, bl, true);
                if (typeSymbol.isErroneous()) {
                    typeSymbol = parser.javaLangObjectPcs;
                }
                this.superClass = (ClassSymbol)typeSymbol;
                if (this.superClass.getClassSymbol() == parser.javaLangEnumSymbol) {
                    if (!this.isEnum()) {
                        parser.error(Message.errorExtendingEnum, this.cd.ccd.tpos, false);
                    }
                } else if ((this.superClass.access & 0x10) != 0) {
                    parser.error(Message.errorFinalCannotBeInherited, this.cd.ccd.tpos, this.superClass.isErroneous(), this.superClass.errorName());
                } else if (this.superClass.isTypeParameter()) {
                    parser.error(Message.errorFinalTypeParameter, this.cd.ccd.tpos, false);
                } else if (this.isStaticInnerClass() && this.superClass.isNonStaticInnerClass()) {
                    parser.error(Message.errorUndefinedThis, this.cd.ccd.tpos, this.superClass.isErroneous(), this.superClass.errorName());
                }
                if (this.superClass.isDeprecated() && !this.isDeprecated()) {
                    parser.warning(this, Message.warningOverridesDeprecated, this.pos, this.superClass.errorName(), Message.classString);
                }
                if (this.isGenericType() && parser.javaLangThrowableSymbol.isSuperclass(this)) {
                    parser.error(Message.errorGenericExtendingThrowable, this.cd.ccd.tpos, false);
                }
                if (this.superClass.isGenericType()) {
                    this.flags = (short)(this.flags | 0x4000);
                }
                this.flags = (short)(this.flags | this.superClass.getClassSymbol().flags & 0x400);
            }
            catch (UnresolvedSuperClassException unresolvedSuperClassException) {
                return 1;
            }
        }
        return 0;
    }

    private void checkComplexCyclicInheritance(Parser parser, InnerClassSymbol innerClassSymbol) {
        if (!this.isErroneous()) {
            ClassSymbol classSymbol = this;
            if (innerClassSymbol.isInterface()) {
                block0: do {
                    ImplementationList implementationList = classSymbol.getImplementationList();
                    while (implementationList != null) {
                        if (innerClassSymbol.equalTo(implementationList.interfaceSymbol)) {
                            parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                            continue block0;
                        }
                        implementationList = implementationList.next;
                    }
                } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
            } else {
                do {
                    RawClassSymbol rawClassSymbol;
                    if (innerClassSymbol.equalTo(classSymbol) || innerClassSymbol.isSuperclass(classSymbol)) {
                        parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                        break;
                    }
                    if (!classSymbol.isInnerClass() || !innerClassSymbol.equalTo(rawClassSymbol = classSymbol.getOuterClass()) && !innerClassSymbol.isSuperclass(rawClassSymbol)) continue;
                    parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                    break;
                } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
            }
        }
    }

    int resolveInterfaces(Parser parser) {
        int n = 0;
        ImplementationList implementationList = this.implementationList;
        if (implementationList != null) {
            this.flags = (short)(this.flags | 0x400);
            ImplementationList implementationList2 = null;
            do {
                try {
                    TypeSymbol typeSymbol = implementationList.interfaceSymbol.resolveType(parser, 0, true, true);
                    if (typeSymbol.isErroneous()) {
                        typeSymbol = TypeSymbol.errorSymbol;
                    }
                    if (!(typeSymbol instanceof ClassSymbol)) {
                        if (implementationList2 == null) {
                            this.implementationList = implementationList.next;
                            continue;
                        }
                        implementationList2.next = implementationList.next;
                        continue;
                    }
                    if (typeSymbol.equalTo(parser.javaIoSerializableSymbol)) {
                        this.flags = (short)(this.flags | 0x800);
                    }
                    implementationList.interfaceSymbol = (ClassSymbol)typeSymbol;
                    ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
                    if (classSymbol.isDeprecated() && !this.isDeprecated()) {
                        parser.warning(this, Message.warningOverridesDeprecated, this.pos, classSymbol.errorName(), Message.implementedString, Message.classString);
                    }
                    if (classSymbol.isGenericType()) {
                        this.flags = (short)(this.flags | 0x4000);
                    }
                    implementationList2 = implementationList;
                }
                catch (UnresolvedSuperClassException unresolvedSuperClassException) {
                    ++n;
                }
            } while ((implementationList = implementationList.next) != null);
        }
        return n;
    }

    int resolveTypeParameters(Parser parser) {
        TypeParameterList typeParameterList = this.cd.getTypeParameterList();
        if (typeParameterList != null) {
            return typeParameterList.resolve(parser);
        }
        return 0;
    }

    int resolveInnerClasses(Parser parser) {
        int n = 0;
        TypeSymbolList typeSymbolList = this.cd.innerClassList;
        while (typeSymbolList != null) {
            TypeSymbol typeSymbol = typeSymbolList.typeSymbol;
            if (!typeSymbol.isAnonymousInnerClass()) {
                RawClassSymbol rawClassSymbol = (RawClassSymbol)typeSymbol.resolveType(parser, 0, true, true);
                Object object = parser.saveResolutionState(rawClassSymbol);
                n += rawClassSymbol.resolveSuperClass(parser, false);
                n += rawClassSymbol.resolveInterfaces(parser);
                n += rawClassSymbol.resolveTypeParameters(parser);
                n += rawClassSymbol.resolveInnerClasses(parser);
                typeSymbolList.typeSymbol = rawClassSymbol;
                parser.restoreResolutionState(object);
            }
            typeSymbolList = typeSymbolList.next;
        }
        return n;
    }

    void checkInnerClasses(Parser parser) {
        TypeSymbolList typeSymbolList = this.cd.innerClassList;
        while (typeSymbolList != null) {
            TypeSymbol typeSymbol = typeSymbolList.typeSymbol;
            if (!typeSymbol.isAnonymousInnerClass()) {
                this.checkComplexCyclicInheritance(parser, (InnerClassSymbol)typeSymbol);
            }
            typeSymbolList = typeSymbolList.next;
        }
    }

    void resolveFields(Parser parser) {
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            parser.currentFieldSymbol = fieldSymbol;
            fieldSymbol.type = fieldSymbol.type.resolveType(parser, fieldSymbol.tpos, true, true);
            fieldSymbol = fieldSymbol.nextInClass;
        }
        parser.currentFieldSymbol = null;
        if (!(this.isEnum() || this.isAnonymousInnerClass() || !this.isSerializable() || (fieldSymbol = (FieldSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.serialVersionUIDIdentifier, 2, false)) != null && (fieldSymbol.access & 0x18) == 24 && fieldSymbol.type == TypeSymbol.longSymbol)) {
            parser.warning(this, Message.warningNoSerialVersionUID, this.pos, this.errorName());
        }
    }

    void resolveMethods(Parser parser) {
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            TypeSymbol typeSymbol;
            parser.currentMethodSymbol = methodSymbol;
            TypeParameterList typeParameterList = methodSymbol.typeParameterList;
            if (typeParameterList != null) {
                methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                do {
                    if ((typeSymbol = typeParameterList.typeParameter.resolveType(parser, 0, true, true)).isErroneous()) {
                        typeParameterList.typeParameter.bound = parser.javaLangObjectPcs;
                        typeParameterList.typeParameter.interfaceBounds = null;
                        continue;
                    }
                    typeParameterList.typeParameter = (TypeParameterSymbol)typeSymbol;
                } while ((typeParameterList = typeParameterList.next) != null);
            }
            MethodSymbol.ThrowsList throwsList = methodSymbol.throwsList;
            while (throwsList != null) {
                typeSymbol = throwsList.throwsType.resolveType(parser, throwsList.getPos(), true, true);
                if (typeSymbol.involvesGenerics()) {
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                }
                throwsList.throwsType = typeSymbol;
                throwsList = throwsList.next;
            }
            methodSymbol.resultType = typeSymbol = methodSymbol.resultType.resolveType(parser, methodSymbol.tpos, false, true);
            if (typeSymbol.involvesGenerics()) {
                methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
            }
            if (methodSymbol.actualArgCount > 255) {
                parser.error(Error.errorTooManyParameters, methodSymbol.pos, methodSymbol.isErroneous(), methodSymbol.errorName());
            }
            for (int i = 0; i < methodSymbol.localVarCount; ++i) {
                RawClassSymbol rawClassSymbol;
                RawClassSymbol rawClassSymbol2;
                MethodVariableSymbol methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
                if (methodVariableSymbol == null) continue;
                methodVariableSymbol.type = typeSymbol = methodVariableSymbol.type.resolveType(parser, methodVariableSymbol.tpos, false, true);
                if (i < methodSymbol.actualArgCount && typeSymbol.involvesGenerics()) {
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                }
                if (typeSymbol.isArrayType()) {
                    typeSymbol = ((ArraySymbol)typeSymbol).baseType;
                }
                if (!typeSymbol.isClass() || typeSymbol.isAccessible(this) || (typeSymbol.isInnerClass() || this.isInnerClass()) && ((rawClassSymbol2 = this.getTopLevelClass()) == (rawClassSymbol = ((ClassSymbol)typeSymbol).getTopLevelClass()) || (this.access & 4) != 0 && rawClassSymbol.isSuperclass(rawClassSymbol2))) continue;
                parser.error(Message.errorAccessError, methodVariableSymbol.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), (typeSymbol.access & 2) != 0 ? "private" : "protected", Message.inString + " " + this.errorName());
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        parser.currentMethodSymbol = null;
    }

    void checkInterfaces(Parser parser, int n) {
        for (ClassSymbol classSymbol = this; classSymbol != null; classSymbol = ((ClassSymbol)classSymbol).getSuperClassSymbol()) {
            ImplementationList implementationList = ((ClassSymbol)classSymbol).getImplementationList();
            while (implementationList != null) {
                ClassSymbol classSymbol2 = implementationList.interfaceSymbol;
                if (classSymbol2 instanceof UnresolvedClassSymbol) {
                    implementationList.interfaceSymbol = classSymbol2 = (ClassSymbol)classSymbol2.resolveType(parser, 0, true, true);
                }
                if (!classSymbol2.isErroneous()) {
                    RawClassSymbol rawClassSymbol = classSymbol2.getClassSymbol();
                    ImplementationList implementationList2 = implementationList.next;
                    while (implementationList2 != null) {
                        if (rawClassSymbol.equalTo(implementationList2.interfaceSymbol.getClassSymbol())) {
                            parser.error(Message.errorRepeatedInheritance, n, false, rawClassSymbol.errorName());
                        }
                        implementationList2 = implementationList2.next;
                    }
                    if (!rawClassSymbol.isInterface()) {
                        parser.error(Message.errorNotInterface, n, false, rawClassSymbol.errorName());
                    }
                    rawClassSymbol.checkInterfaces(parser, n);
                }
                implementationList = implementationList.next;
            }
        }
    }

    void addInheritedInterfaceMethods(Parser parser) {
        if (!$assertionsDisabled && (this.access & 0x400) == 0) {
            throw new AssertionError();
        }
        int n = this.cd.methodTable.length;
        while (--n >= 0) {
            MethodSymbol methodSymbol = this.cd.methodTable[n];
            if ((methodSymbol.access & 0x400) == 0 || this == methodSymbol.definingClass || !methodSymbol.definingClass.isInterface()) continue;
            MethodSymbol methodSymbol2 = new MethodSymbol(0, this, methodSymbol.identifier, methodSymbol.resultType, 0, methodSymbol.access, null, true);
            methodSymbol2.argumentList = methodSymbol.argumentList;
            methodSymbol2.argCount = methodSymbol.argCount;
            methodSymbol2.localVarCount = methodSymbol2.actualArgCount = methodSymbol.actualArgCount;
            n = methodSymbol2.localVarCount;
            while (--n >= 0) {
                methodSymbol2.cmd.localVariables.add(null);
            }
            methodSymbol2.nextInClass = this.cd.methodList;
            this.cd.methodList = methodSymbol2;
        }
    }

    void checkImplementationsOfAbstractMethods(Parser parser) {
        boolean bl = false;
        ClassSymbol classSymbol = this.getSuperClassSymbol();
        if (classSymbol != null && (classSymbol.access & 0x400) != 0) {
            bl = true;
        }
        int n = this.cd.methodTable.length;
        while (--n >= 0) {
            MethodSymbol methodSymbol = this.cd.methodTable[n];
            if ((methodSymbol.access & 0x400) == 0 || methodSymbol.definingClass != this && !this.implementsInterfaceDirectlyIndirectly(methodSymbol.definingClass) && !bl) continue;
            parser.error(Message.errorShouldBeAbstract, this.pos, methodSymbol.isErroneous(), this.errorName(), methodSymbol.errorName(), methodSymbol.definingClass.errorName());
            break;
        }
    }

    void loadType(Parser parser, int n) {
        this.loadType(parser, n, parser.currentClassSymbol);
    }

    void loadType(Parser parser, int n, ClassSymbol classSymbol) {
        if (this.classScope == null && (this.flags & 0x10) == 0) {
            Storage storage;
            boolean bl = parser.suspendStaticContextChecking;
            parser.suspendStaticContextChecking = true;
            ClassFileReader.readClassFile(parser, n, this);
            parser.suspendStaticContextChecking = bl;
            if (this.classScope == null && (storage = parser.options.findStorageOfSource(this)) != null && parser.addSourceFile(storage)) {
                throw new NewSourceException();
            }
            if (this.classScope == null) {
                this.flags = (short)(this.flags | 0x10);
                String string = "";
                if (classSymbol != null && !classSymbol.isErroneous()) {
                    string = Message.inString + " " + classSymbol.errorName();
                }
                parser.error(Message.errorNotFound, n, false, this.identifier.toString(), string);
                this.classScope = new ClassScope(this, this.scope, parser);
                this.superClass = parser.javaLangObjectPcs;
                this.access = (short)(this.access | 1);
                this.cd.methodTable = new MethodSymbol[0];
            }
        }
    }

    void resolveFieldInitializers(Parser parser) {
        short s;
        ArrayList<FieldSymbol> arrayList = new ArrayList<FieldSymbol>();
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (fieldSymbol.initializer != null) {
                arrayList.add(fieldSymbol);
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        parser.suspendDataFlowChecking = true;
        int n = arrayList.size();
        parser.defSet = new BitSet(n);
        parser.posSet = new BitSet(n);
        parser.useSet = new BitSet(n);
        int n2 = n;
        while (--n2 >= 0) {
            fieldSymbol = (FieldSymbol)arrayList.get(n2);
            if (!$assertionsDisabled && fieldSymbol.initializer == null) {
                throw new AssertionError();
            }
            s = fieldSymbol.access;
            if ((s & 8) == 0) continue;
            parser.currentFieldSymbol = fieldSymbol;
            if (fieldSymbol.initializer.takeAssignmentContext()) {
                parser.assignmentContext = fieldSymbol.type;
            }
            Expression expression = fieldSymbol.initializer.resolveAndCheck(parser);
            if ((s & 0x10) != 0 && expression.kind == 2 && ((expression.getType().typeClass & 0xFFFFFFC0) == 0 || expression instanceof StringConstantExpression && fieldSymbol.type.equalTo(parser.javaLangStringSymbol))) {
                this.flags = (short)(this.flags | 2);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 2);
            }
            fieldSymbol.initializer = expression;
            fieldSymbol.flags = (short)(fieldSymbol.flags | 4);
        }
        n2 = n;
        while (--n2 >= 0) {
            fieldSymbol = (FieldSymbol)arrayList.get(n2);
            s = fieldSymbol.access;
            if ((s & 8) != 0) continue;
            parser.currentFieldSymbol = fieldSymbol;
            if (fieldSymbol.initializer.takeAssignmentContext()) {
                parser.assignmentContext = fieldSymbol.type;
            }
            fieldSymbol.initializer = fieldSymbol.initializer.resolveAndCheck(parser);
            fieldSymbol.flags = (short)(fieldSymbol.flags | 4);
        }
        parser.suspendDataFlowChecking = false;
        parser.defSet = null;
        parser.posSet = null;
        parser.useSet = null;
        parser.currentStatement = null;
        parser.currentFieldSymbol = null;
    }

    boolean findConstantFields() {
        boolean bl = false;
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            short s;
            Expression expression = fieldSymbol.initializer;
            if (expression != null && ((s = fieldSymbol.access) & 8) != 0 && (fieldSymbol.flags & 2) == 0 && (expression = expression.constantFolding()) != fieldSymbol.initializer) {
                if ((s & 0x10) != 0 && expression.kind == 2 && ((expression.getType().typeClass & 0xFFFFFFC0) == 0 || expression instanceof StringConstantExpression)) {
                    this.flags = (short)(this.flags | 2);
                    fieldSymbol.flags = (short)(fieldSymbol.flags | 2);
                    bl = true;
                }
                fieldSymbol.initializer = expression;
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    void assignFieldInitializers(Parser var1_1) {
        var4_2 = this.cd.fieldList;
        while (var4_2 != null) {
            block3: {
                block4: {
                    var5_5 = var4_2.initializer;
                    if (var5_5 == null) break block3;
                    var6_6 = var4_2.type;
                    var7_7 = var5_5.getType();
                    if (!var7_7.isErroneous() && !var6_6.isErroneous()) break block4;
                    var4_2.initializer = null;
                    break block3;
                }
                if (!var6_6.isReferenceType() || !var7_7.isReferenceType()) ** GOTO lbl20
                var3_4 = (ReferenceTypeSymbol)var7_7;
                var2_3 = (ReferenceTypeSymbol)var6_6;
                if (!var3_4.isAssignmentCompatible(var1_1, var2_3)) {
                    var1_1.error(Message.errorIncompatibleTypes, var5_5.pos, false, var7_7.errorName(), var6_6.errorName());
                    var4_2.initializer = null;
                } else {
                    var6_6.checkUncheckConversion(var1_1, var5_5.pos, var7_7, false);
lbl20:
                    // 2 sources

                    var1_1.currentFieldSymbol = var4_2;
                    var4_2.initializer = var5_5.promoteType(var1_1, var6_6);
                }
            }
            var4_2 = var4_2.nextInClass;
        }
        var1_1.currentFieldSymbol = null;
    }

    void resolveMethodBodies(Parser parser) {
        long l = System.currentTimeMillis();
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (!methodSymbol.isConstructor()) {
                methodSymbol.resolveMethod(parser);
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        if ((this.access & 0x200) == 0) {
            methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                if (methodSymbol.isConstructor() && (this.isEnum() || !this.isAnonymousInnerClass())) {
                    methodSymbol.resolveMethod(parser);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
        }
        if (!this.isAnonymousInnerClass()) {
            this.fixConstructors(parser);
        }
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (!fieldSymbol.isSynthetic()) {
                if ((fieldSymbol.access & 0x10) != 0 && (fieldSymbol.flags & Short.MIN_VALUE) == 0) {
                    if ((fieldSymbol.access & 8) != 0) {
                        parser.error(Message.errorNotInitialized, fieldSymbol.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    } else if ((fieldSymbol.flags & 0x4000) != 0) {
                        parser.error(Message.errorNotInitialized, fieldSymbol.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    }
                }
                if ((fieldSymbol.access & 8) != 0 && (fieldSymbol.flags & 2) == 0 && !this.isEnum() && !this.isInterface() && (this.isNonStaticInnerClass() || this.isLocalInnerClass())) {
                    parser.error(Message.errorInnerCannotHaveStatics, fieldSymbol.pos, false);
                }
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        methodSymbol = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        while (methodSymbol != null) {
            if ((methodSymbol.flags & 2) != 0) {
                ExpressionStatement expressionStatement;
                StatementList statementList;
                MethodSymbol methodSymbol2 = methodSymbol;
                while ((statementList = methodSymbol2.cmd.statementList) != null && (expressionStatement = (ExpressionStatement)statementList.first) != null) {
                    InvokeExpression invokeExpression = (InvokeExpression)expressionStatement.expr;
                    methodSymbol2 = (MethodSymbol)invokeExpression.method;
                    if (methodSymbol2 == null || (methodSymbol2.flags & 2) == 0) break;
                    if (methodSymbol2 != methodSymbol) continue;
                    parser.error(Error.errorCyclicConstructors, methodSymbol.pos, false, methodSymbol.errorName());
                    break;
                }
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
        if (!this.isInterface() && (this.isNonStaticInnerClass() || this.isLocalInnerClass())) {
            TypeSymbolList typeSymbolList = this.cd.innerClassList;
            while (typeSymbolList != null) {
                if ((typeSymbolList.typeSymbol.access & 8) != 0 && !typeSymbolList.typeSymbol.isSynthetic()) {
                    parser.error(Message.errorInnerCannotHaveStatics, typeSymbolList.typeSymbol.pos, false);
                }
                typeSymbolList = typeSymbolList.next;
            }
        }
        if (parser.options.verbose) {
            parser.options.log.println("[" + Message.resolvingString + " " + this.toString() + " " + (System.currentTimeMillis() - l) + "ms ]");
        }
    }

    private static boolean isValidElementType(Parser parser, TypeSymbol typeSymbol) {
        if (typeSymbol.isArrayType()) {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            if (arraySymbol.dimension > 1) {
                return false;
            }
            typeSymbol = arraySymbol.baseType;
        }
        return typeSymbol.isNumericType() || typeSymbol.typeKind == 2 || typeSymbol.equalTo(parser.javaLangStringSymbol) || typeSymbol.equalTo(parser.javaLangClassSymbol) || (typeSymbol.access & 0x6000) != 0;
    }

    void resolveAnnotationTypes(Parser parser) {
        if (this.annotation != null) {
            this.annotation.resolveAnnotationType(parser, this);
        }
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            Annotation annotation = methodSymbol.getAnnotations();
            if (annotation != null) {
                annotation.resolveAnnotationType(parser, methodSymbol);
                for (int i = 0; i < methodSymbol.localVarCount; ++i) {
                    MethodVariableSymbol methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
                    if (methodVariableSymbol == null || methodVariableSymbol.annotation == null) continue;
                    methodVariableSymbol.annotation.resolveAnnotationType(parser, methodVariableSymbol);
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x40);
                }
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (fieldSymbol.annotation != null) {
                fieldSymbol.annotation.resolveAnnotationType(parser, fieldSymbol);
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
    }

    void resolveAnnotations(Parser parser) {
        parser.suspendDataFlowChecking = true;
        short s = this.cd.fieldCount;
        parser.defSet = new BitSet(s);
        parser.posSet = new BitSet(s);
        parser.useSet = new BitSet(s);
        if (this.annotation != null) {
            this.annotation.resolveAndCheck(parser, this);
        }
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            Annotation annotation;
            TypeSymbol typeSymbol;
            if (this.isAnnotation() && !methodSymbol.isClassInitializer() && !RawClassSymbol.isValidElementType(parser, typeSymbol = methodSymbol.resultType)) {
                parser.error(Message.errorTypeNotAllowed, methodSymbol.tpos, typeSymbol.isErroneous(), typeSymbol.errorName());
            }
            if ((annotation = methodSymbol.getAnnotations()) != null) {
                annotation.resolveAndCheck(parser, methodSymbol);
            }
            for (int i = 0; i < methodSymbol.localVarCount; ++i) {
                MethodVariableSymbol methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
                if (methodVariableSymbol == null || methodVariableSymbol.annotation == null) continue;
                methodVariableSymbol.annotation.resolveAndCheck(parser, methodVariableSymbol);
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (fieldSymbol.annotation != null) {
                fieldSymbol.annotation.resolveAndCheck(parser, fieldSymbol);
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        parser.suspendDataFlowChecking = false;
        parser.defSet = null;
        parser.posSet = null;
        parser.useSet = null;
    }

    private MethodSymbol findMethod(Identifier identifier, ArgumentVariableList argumentVariableList) {
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (!methodSymbol.isSynthetic() && methodSymbol.compareMethod(identifier, argumentVariableList, null)) {
                return methodSymbol;
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        return null;
    }

    private boolean findBridgeMethod(MethodSymbol methodSymbol) {
        MethodSymbol methodSymbol2 = this.cd.methodList;
        while (methodSymbol2 != null) {
            if (methodSymbol2.isBridgeMethod() && methodSymbol2.compareMethod(methodSymbol.identifier, methodSymbol.argumentList, methodSymbol.resultType)) {
                return true;
            }
            methodSymbol2 = methodSymbol2.nextInClass;
        }
        return false;
    }

    private void checkForAndCreateBridgeMethod(MethodSymbol methodSymbol, TypeParameterList typeParameterList, TypeVariableList typeVariableList) {
        ArgumentVariableList argumentVariableList;
        if ((methodSymbol.access & 8) != 0 || methodSymbol.isConstructor() || methodSymbol.isGenerated() || methodSymbol.isSynthetic()) {
            return;
        }
        if (typeVariableList == null) {
            argumentVariableList = methodSymbol.argumentList;
        } else {
            boolean bl = false;
            TypeSymbol typeSymbol = methodSymbol.resultType;
            if (typeSymbol.containsTypeParameterDefinedBy(null)) {
                bl = true;
            }
            ArgumentVariableList argumentVariableList2 = null;
            argumentVariableList = null;
            short s = 1;
            ArgumentVariableList argumentVariableList3 = methodSymbol.argumentList;
            while (argumentVariableList3 != null) {
                TypeSymbol typeSymbol2 = argumentVariableList3.argSymbol.type;
                if (typeSymbol2.containsTypeParameterDefinedBy(null)) {
                    typeSymbol2 = typeSymbol2.applyTypeVariables(typeParameterList, typeVariableList);
                    bl = true;
                }
                short s2 = s;
                s = (short)(s + 1);
                ArgumentVariableList argumentVariableList4 = new ArgumentVariableList(new ArgumentVariableSymbol(0, null, null, typeSymbol2, 0, 0, null, s2));
                if (argumentVariableList == null) {
                    argumentVariableList = argumentVariableList2 = argumentVariableList4;
                } else {
                    argumentVariableList2.next = argumentVariableList4;
                    argumentVariableList2 = argumentVariableList4;
                }
                argumentVariableList3 = argumentVariableList3.next;
            }
            if (!bl) {
                return;
            }
        }
        MethodSymbol methodSymbol2 = this.findMethod(methodSymbol.identifier, argumentVariableList);
        if (methodSymbol2 != null && !Identifier.compare(methodSymbol2.getSignature(), methodSymbol.getSignature()) && !this.findBridgeMethod(methodSymbol)) {
            MethodSymbol methodSymbol3 = new MethodSymbol(0, this, methodSymbol.identifier, methodSymbol.resultType, 0, (short)(methodSymbol.access & 0xFFFFFAFF | 0x40 | 0x1000), null, true);
            methodSymbol3.argumentList = methodSymbol.argumentList;
            methodSymbol3.argCount = methodSymbol.argCount;
            methodSymbol3.localVarCount = methodSymbol3.actualArgCount = methodSymbol.actualArgCount;
            methodSymbol3.flags = (short)(methodSymbol3.flags | 1);
            methodSymbol3.throwsList = MethodSymbol.ThrowsList.copyIntoCompiledThrowsList(methodSymbol.throwsList);
            short s = methodSymbol3.localVarCount;
            while ((s = (short)(s - 1)) >= 0) {
                methodSymbol3.cmd.localVariables.add(null);
            }
            methodSymbol3.annotation = methodSymbol2;
            methodSymbol3.nextInClass = this.cd.methodList;
            this.cd.methodList = methodSymbol3;
        }
    }

    private void addBridgeMethodsToClass(Parser parser, ParameterizedClassSymbol parameterizedClassSymbol) {
        TypeParameterList typeParameterList = parameterizedClassSymbol.genericClassSymbol.cd.getTypeParameterList();
        TypeVariableList typeVariableList = parameterizedClassSymbol.typeVariableList;
        MethodSymbol methodSymbol = parameterizedClassSymbol.genericClassSymbol.cd.methodList;
        while (methodSymbol != null) {
            this.checkForAndCreateBridgeMethod(methodSymbol, typeParameterList, typeVariableList);
            methodSymbol = methodSymbol.nextInClass;
        }
    }

    private void addBridgeMethodsToInterface(Parser parser, ClassSymbol classSymbol) {
        ImplementationList implementationList = classSymbol.getImplementationList();
        while (implementationList != null) {
            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)implementationList.interfaceSymbol;
            this.addBridgeMethodsToClass(parser, parameterizedClassSymbol);
            this.addBridgeMethodsToInterface(parser, parameterizedClassSymbol);
            implementationList = implementationList.next;
        }
    }

    private void addBridgeMethods(Parser parser) {
        if (this.isInterface() || this.isEnum()) {
            return;
        }
        for (ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)this.superClass; parameterizedClassSymbol != null; parameterizedClassSymbol = (ParameterizedClassSymbol)parameterizedClassSymbol.getSuperClassSymbol()) {
            this.addBridgeMethodsToClass(parser, parameterizedClassSymbol);
            this.addBridgeMethodsToInterface(parser, parameterizedClassSymbol);
        }
        this.addBridgeMethodsToInterface(parser, this);
    }

    void checkPrivateFieldAndMethodUsage(Parser parser) {
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if ((fieldSymbol.access & 2) != 0 && (fieldSymbol.flags & 0x2000) == 0 && !fieldSymbol.isSynthetic() && fieldSymbol.identifier != Identifier.serialVersionUIDIdentifier) {
                parser.warning(fieldSymbol, Message.warningVariableNeverUsed, fieldSymbol.pos, fieldSymbol.errorName());
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (!((methodSymbol.access & 2) == 0 || (methodSymbol.flags & 0x10) != 0 || methodSymbol.isSynthetic() || methodSymbol.isConstructor() || methodSymbol.isClassInitializer())) {
                parser.warning(methodSymbol, Message.warningMethodNeverCalled, methodSymbol.pos, methodSymbol.errorName());
            }
            methodSymbol = methodSymbol.nextInClass;
        }
    }

    private MethodSymbol findGeneratedMethod(Identifier identifier) {
        MethodSymbol methodSymbol = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(identifier, 8, true);
        if (!$assertionsDisabled && methodSymbol == null) {
            throw new AssertionError();
        }
        while ((methodSymbol.flags & 0x20) == 0) {
            methodSymbol = methodSymbol.nextWithSameName;
            if (!$assertionsDisabled && methodSymbol == null) {
                throw new AssertionError();
            }
        }
        return methodSymbol;
    }

    void generateCode(Parser parser) {
        long l = System.currentTimeMillis();
        if (this.cd.ccd.constantPool == null) {
            this.cd.ccd.constantPool = new ConstantPool(parser);
        }
        ByteCodeGenerator byteCodeGenerator = null;
        MethodSymbol methodSymbol = null;
        try {
            if ((this.flags & 8) != 0) {
                this.cd.ccd.classLoaderMethod = methodSymbol = this.getClassLoaderMethod(parser);
                byteCodeGenerator = new ByteCodeGenerator(parser, methodSymbol);
                byteCodeGenerator.generateClassDollarMethod();
                byteCodeGenerator.finish();
            }
            if (this.isEnum() && !this.isAnonymousInnerClass()) {
                byteCodeGenerator = new ByteCodeGenerator(parser, this.findGeneratedMethod(Identifier.valuesIdentifier));
                byteCodeGenerator.generateEnumValuesMethod();
                byteCodeGenerator.finish();
                byteCodeGenerator = new ByteCodeGenerator(parser, this.findGeneratedMethod(Identifier.valueOfIdentifier));
                byteCodeGenerator.generateEnumValueOfMethod();
                byteCodeGenerator.finish();
            }
            methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                if (methodSymbol.isBridgeMethod()) {
                    byteCodeGenerator = new ByteCodeGenerator(parser, methodSymbol);
                    byteCodeGenerator.generateBridgeMethod((MethodSymbol)methodSymbol.annotation);
                    byteCodeGenerator.finish();
                } else {
                    byteCodeGenerator = null;
                    methodSymbol.generateMethod(parser);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
        }
        catch (RuntimeException runtimeException) {
            parser.stateAtInternalError = new Parser.ResolutionState();
            parser.stateAtInternalError.currentClassSymbol = this;
            parser.stateAtInternalError.currentMethodSymbol = methodSymbol;
            parser.stateAtInternalError.currentStatement = parser.currentStatement;
            parser.stateAtInternalError.sourceFile = this.cd.ccd.sourceFile;
            throw runtimeException;
        }
        if (parser.options.verbose) {
            parser.options.log.println("[" + Message.generatingString + " " + this.toString() + " " + (System.currentTimeMillis() - l) + "ms ]");
        }
    }

    void generateClass(Parser parser) {
        long l = System.currentTimeMillis();
        Options options = parser.options;
        try {
            String string;
            int n;
            String string2;
            Storage storage;
            if (options.destinationDir != null) {
                if (options.destinationFile == null) {
                    File file = new File(options.destinationDir);
                    if (!file.exists() && !file.mkdirs()) {
                        parser.error(Message.errorUnableToCreateOutputDir, 0, false, options.destinationDir);
                    }
                    options.destinationFile = new DirectoryStorage(file);
                }
                storage = options.destinationFile;
                string2 = new String(this.getInternalName());
                int n2 = 0;
                while ((n = string2.indexOf(47, n2)) >= 0) {
                    String string3 = string2.substring(n2, n);
                    storage = storage.createDir(string3);
                    n2 = n + 1;
                }
                string2 = string2.substring(n2);
            } else {
                String string4 = this.cd.ccd.sourceFile.getCanonicalPath();
                n = string4.lastIndexOf(options.fileSeparator);
                if (!$assertionsDisabled && n < 0) {
                    throw new AssertionError();
                }
                storage = new DirectoryStorage(new File(string4.substring(0, n)));
                string2 = new String(this.getClassName());
            }
            String string5 = this.cd.ccd.sourceFile.getCanonicalPath();
            n = string5.lastIndexOf(options.fileSeparator);
            if (n >= 0) {
                string5 = string5.substring(n + 1);
            }
            storage = storage.create(string2 + ".class");
            ClassFileWriter classFileWriter = new ClassFileWriter(parser, this, storage, parser.writeBuffer);
            classFileWriter.createClassFile(string5);
            storage.close();
            if (parser.options.makeFile != null) {
                DepInfo.addClassDate(this, storage.modDate());
            }
            ++parser.classFileCount;
            if (options.ideEnv != null && !options.ideEnv.authorizeWriting(storage, string = new String(this.getInternalName()).replace('/', '.').replace('+', '$'), null, 0, 0)) {
                throw new RuntimeException("user aborted");
            }
            if (options.verbose) {
                options.log.println("[" + Message.writingString + " " + storage.getCanonicalPath() + " " + (System.currentTimeMillis() - l) + "ms ]");
            }
        }
        catch (IOException iOException) {
            parser.error(Message.errorWriteError, 0, false, this.errorName());
        }
    }

    MethodSymbol getClassInitializer() {
        MethodSymbol methodSymbol = this.cd.ccd.classInitializer;
        if (methodSymbol == null) {
            short s = 8;
            if ((this.access & 0x800) != 0) {
                s = (short)(s | 0x800);
            }
            methodSymbol = new MethodSymbol(0, this, Identifier.classInitializerIdentifier, voidSymbol, 0, s, null, true);
            methodSymbol.cmd.statementList = new StatementList();
            methodSymbol.nextInClass = this.cd.methodList;
            this.cd.methodList = methodSymbol;
            this.cd.ccd.classInitializer = methodSymbol;
        }
        return methodSymbol;
    }

    MethodSymbol getDynamicInitializer() {
        MethodSymbol methodSymbol = this.cd.ccd.dynamicInitializer;
        if (methodSymbol == null) {
            short s = 0;
            if ((this.access & 0x800) != 0) {
                s = (short)(s | 0x800);
            }
            methodSymbol = new MethodSymbol(0, this, Identifier.dynamicInitializerIdentifier, voidSymbol, 0, s, null, true);
            methodSymbol.cmd.statementList = new StatementList();
            methodSymbol.flags = (short)(methodSymbol.flags | 1);
            methodSymbol.localVarCount = 1;
            methodSymbol.actualArgCount = 1;
            methodSymbol.cmd.localVariables.add(null);
            methodSymbol.nextInClass = this.cd.methodList;
            this.cd.methodList = methodSymbol;
            this.cd.ccd.dynamicInitializer = methodSymbol;
        }
        return methodSymbol;
    }

    private Identifier getSyntheticName(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (--n >= 0) {
            stringBuffer.append(Identifier.dollarCharacter);
        }
        stringBuffer.append(string);
        return Identifier.getIdentifier(stringBuffer.toString());
    }

    private MethodSymbol getClassLoaderMethod(Parser parser) {
        Identifier identifier;
        RawClassSymbol rawClassSymbol;
        if (this.isInterface()) {
            AnonymousClassSymbol anonymousClassSymbol = new AnonymousClassSymbol(0, 25);
            anonymousClassSymbol.superClass = parser.javaLangObjectPcs;
            anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x20);
            anonymousClassSymbol.cd.ccd.sourceFile = this.cd.ccd.sourceFile;
            anonymousClassSymbol.scope = this.classScope;
            anonymousClassSymbol.classScope = new ClassScope(anonymousClassSymbol, this.classScope, parser);
            anonymousClassSymbol.cd.ccd.constantPool = new ConstantPool(parser);
            if (parser.options.targetJDKVersion >= 150) {
                anonymousClassSymbol.access = (short)(anonymousClassSymbol.access | 0x1000);
            } else {
                anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x100);
            }
            parser.classSymbolList.add(anonymousClassSymbol);
            TypeSymbolList typeSymbolList = new TypeSymbolList(anonymousClassSymbol);
            typeSymbolList.next = this.cd.innerClassList;
            this.cd.innerClassList = typeSymbolList;
            rawClassSymbol = anonymousClassSymbol;
        } else {
            rawClassSymbol = this;
        }
        int n = 0;
        while (this.classScope.lookupSpecificSymbolInScope(identifier = this.getSyntheticName("class$", n), 8, true) != null) {
            ++n;
        }
        MethodSymbol methodSymbol = new MethodSymbol(0, rawClassSymbol, identifier, parser.javaLangClassSymbol, 0, 8, null, true);
        methodSymbol.flags = (short)(methodSymbol.flags | 0x21);
        methodSymbol.addArgument(parser.javaLangStringSymbol);
        methodSymbol.nextInClass = rawClassSymbol.cd.methodList;
        rawClassSymbol.cd.methodList = methodSymbol;
        return methodSymbol;
    }

    FieldSymbol getClassFieldSymbol(Parser parser, String string) {
        int n = 0;
        while (true) {
            Identifier identifier;
            FieldSymbol fieldSymbol;
            if ((fieldSymbol = (FieldSymbol)this.classScope.lookupSpecificSymbolInScope(identifier = this.getSyntheticName(string, n), 2, true)) == null) {
                fieldSymbol = new FieldSymbol(0, this, identifier, (TypeSymbol)parser.javaLangClassPcs, 0, 10, null);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0xFFFFA001);
                this.addField(fieldSymbol);
                this.classScope.enterSymbol(fieldSymbol);
                return fieldSymbol;
            }
            if ((fieldSymbol.flags & 1) != 0) {
                return fieldSymbol;
            }
            ++n;
        }
    }

    private int getClassNumber(RawClassSymbol rawClassSymbol) {
        if (!$assertionsDisabled && rawClassSymbol.cd.innerClassList == null) {
            throw new AssertionError();
        }
        int n = 0;
        TypeSymbolList typeSymbolList = rawClassSymbol.cd.innerClassList;
        while (typeSymbolList != null) {
            if (typeSymbolList.typeSymbol.identifier == this.identifier) {
                ++n;
            }
            if (this.equalTo(typeSymbolList.typeSymbol)) {
                return n;
            }
            typeSymbolList = typeSymbolList.next;
        }
        return 0;
    }

    char[] getClassName() {
        if (!this.isInnerClass()) {
            return this.identifier.name;
        }
        if (this.scope.kind == 2 && !this.isAnonymousInnerClass()) {
            ClassScope classScope = (ClassScope)this.scope;
            char[] cArray = classScope.classSymbol.getClassName();
            int n = cArray.length + 1 + this.identifier.name.length;
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray2[cArray.length] = 36;
            System.arraycopy(this.identifier.name, 0, cArray2, cArray.length + 1, this.identifier.name.length);
            return cArray2;
        }
        Scope scope = this.scope;
        while (scope.kind >= 3) {
            scope = scope.getOuterScope();
        }
        ClassScope classScope = (ClassScope)scope;
        RawClassSymbol rawClassSymbol = classScope.classSymbol;
        String string = Integer.toString(this.getClassNumber(rawClassSymbol));
        int n = string.length();
        char[] cArray = rawClassSymbol.getClassName();
        int n2 = cArray.length + 1 + n + this.identifier.name.length;
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        int n3 = cArray.length;
        cArray3[n3++] = Identifier.dollarCharacter;
        System.arraycopy(string.toCharArray(), 0, cArray3, n3, n);
        System.arraycopy(this.identifier.name, 0, cArray3, n3 += n, this.identifier.name.length);
        return cArray3;
    }

    void detectCyclicInheritance(Parser parser) {
        if (this.superClass != null) {
            ClassSymbol classSymbol;
            ClassSymbol classSymbol2 = classSymbol = this;
            while ((classSymbol2 = classSymbol2.getSuperClassSymbol()) != null && (classSymbol = classSymbol.getSuperClassSymbol()) != null) {
                this.flags = (short)(this.flags | classSymbol.getClassSymbol().flags & 0xC00);
                if ((classSymbol = classSymbol.getSuperClassSymbol()) == null) break;
                this.flags = (short)(this.flags | classSymbol.getClassSymbol().flags & 0xC00);
                if (!classSymbol2.equalTo(classSymbol)) continue;
                parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                this.superClass = parser.javaLangObjectPcs;
                break;
            }
        }
        ImplementationList implementationList = null;
        ImplementationList implementationList2 = this.implementationList;
        while (implementationList2 != null) {
            ClassSymbol classSymbol = implementationList2.interfaceSymbol;
            if (this.equalTo(classSymbol) || ((TypeSymbol)classSymbol).isClass() && classSymbol.implementsInterface(this)) {
                parser.error(Message.errorCyclicInheritance, this.pos, this.isErroneous(), this.errorName());
                if (implementationList == null) {
                    this.implementationList = implementationList2.next;
                } else {
                    implementationList = implementationList2.next;
                }
            }
            implementationList = implementationList2;
            implementationList2 = implementationList2.next;
        }
    }

    void detectCyclicElementTypes(Parser parser) {
        if (this.isAnnotation()) {
            this.flags = (short)(this.flags | 0x1000);
            MethodSymbol methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                RawClassSymbol rawClassSymbol;
                if (methodSymbol.resultType.isClass() && (rawClassSymbol = ((ClassSymbol)methodSymbol.resultType).getClassSymbol()).isAnnotation()) {
                    if ((rawClassSymbol.flags & 0x1000) != 0) {
                        parser.error(Message.errorCyclicAnnotation, methodSymbol.tpos, false, methodSymbol.identifier.toString());
                    } else {
                        rawClassSymbol.detectCyclicElementTypes(parser);
                    }
                }
                methodSymbol = methodSymbol.nextInClass;
            }
            this.flags = (short)(this.flags & 0xFFFFEFFF);
        }
    }

    boolean implementsInterfaceDirectly(ClassSymbol classSymbol) {
        ImplementationList implementationList = this.implementationList;
        while (implementationList != null) {
            if (classSymbol.equalTo(implementationList.interfaceSymbol)) {
                return true;
            }
            implementationList = implementationList.next;
        }
        return false;
    }

    boolean implementsInterfaceDirectlyIndirectly(ClassSymbol classSymbol) {
        ImplementationList implementationList = this.implementationList;
        while (implementationList != null) {
            if (classSymbol.equalTo(implementationList.interfaceSymbol) || implementationList.interfaceSymbol.getClassSymbol().implementsInterfaceDirectlyIndirectly(classSymbol)) {
                return true;
            }
            implementationList = implementationList.next;
        }
        return false;
    }

    boolean isInnerClass(MethodSymbol methodSymbol) {
        if (this.isInnerClass()) {
            Scope scope = this.scope;
            do {
                if (scope.kind == 2) {
                    scope = scope.getOuterScope();
                    continue;
                }
                if (scope.kind == 3 && ((MethodScope)scope).methodSymbol == methodSymbol) {
                    return true;
                }
                scope = scope.getOuterScope();
            } while (scope.kind >= 2);
        }
        return false;
    }

    boolean isInnerClass(ClassSymbol classSymbol) {
        if (this.isInnerClass()) {
            Scope scope = this.scope;
            ClassScope classScope = classSymbol.getClassScope();
            do {
                if (scope == classScope) {
                    return true;
                }
                scope = scope.getOuterScope();
            } while (scope.kind >= 2);
        }
        return false;
    }

    ClassSymbol getTopLevelClass(MethodSymbol methodSymbol) {
        if (!$assertionsDisabled && !this.isInnerClass()) {
            throw new AssertionError();
        }
        RawClassSymbol rawClassSymbol = this;
        Scope scope = this.scope;
        block5: while (true) {
            switch (scope.kind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return null;
                }
                case 2: {
                    ClassScope classScope = (ClassScope)scope;
                    rawClassSymbol = classScope.classSymbol;
                    scope = classScope.outerScope;
                    continue block5;
                }
                case 4: {
                    scope = ((LocalScope)scope).outerScope;
                    continue block5;
                }
                case 3: 
            }
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.methodSymbol == methodSymbol) {
                return rawClassSymbol;
            }
            scope = methodScope.outerScope;
        }
    }

    int findInnerClassDepth() {
        int n = 0;
        Scope scope = this.scope;
        if (scope.kind == 2) {
            while (true) {
                ClassScope classScope = (ClassScope)scope;
                if ((classScope.classSymbol.access & 8) != 0) break;
                scope = classScope.outerScope;
                if (scope.kind != 2) break;
                ++n;
            }
        }
        return n;
    }

    Scope getPackageScope() {
        Scope scope = this.scope;
        while (true) {
            if (scope.kind == 2) {
                scope = ((ClassScope)scope).outerScope;
                continue;
            }
            if (scope.kind < 3) break;
            scope = ((LocalScope)scope).outerScope;
        }
        return scope;
    }

    boolean inSamePackage(ClassSymbol classSymbol) {
        return this.getPackageScope() == classSymbol.getClassSymbol().getPackageScope();
    }

    boolean isSerializable() {
        return (this.flags & 0x800) != 0;
    }

    Symbol lookupSpecificSymbolInClass(Parser parser, Identifier identifier, int n, boolean bl) {
        return this.lookupSpecificSymbolInClass(parser, identifier, n, bl, false);
    }

    private Symbol lookupSpecificSymbolInClass(Parser parser, Identifier identifier, int n, boolean bl, boolean bl2) {
        RawClassSymbol rawClassSymbol;
        TypeSymbol typeSymbol;
        Symbol symbol;
        RawClassSymbol rawClassSymbol2 = this;
        block3: while (true) {
            if (rawClassSymbol2.classScope == null) {
                rawClassSymbol2.loadType(parser, 0);
            }
            if ((symbol = rawClassSymbol2.classScope.lookupSpecificSymbolInScope(identifier, n, true)) != null) {
                switch (n) {
                    default: {
                        break block3;
                    }
                    case 32: {
                        typeSymbol = (TypeSymbol)symbol;
                        if (typeSymbol.isTypeParameter()) {
                            TypeParameterSymbol typeParameterSymbol = (TypeParameterSymbol)typeSymbol;
                            if (typeParameterSymbol.definingSymbol != this && (!(typeParameterSymbol.definingSymbol instanceof ClassSymbol) || !(rawClassSymbol = (RawClassSymbol)typeParameterSymbol.definingSymbol).isInnerClass(this))) break;
                            break block3;
                        }
                        typeSymbol.resolveType(parser, typeSymbol.pos, false, true);
                        if (typeSymbol.isAccessible(this)) break block3;
                    }
                }
            }
            if (rawClassSymbol2.superClass == null) break;
            if (rawClassSymbol2.superClass instanceof UnresolvedClassSymbol) {
                if (parser.errorFound && rawClassSymbol2.isAnonymousInnerClass() && (rawClassSymbol2.flags & 0x40) == 0) {
                    ((AnonymousClassSymbol)rawClassSymbol2).completeAnonymousClass(parser);
                    if (rawClassSymbol2.superClass instanceof UnresolvedClassSymbol) {
                        throw new UnresolvedSuperClassException();
                    }
                } else {
                    throw new UnresolvedSuperClassException();
                }
            }
            rawClassSymbol2 = rawClassSymbol2.superClass.getClassSymbol();
        }
        if (symbol == null) {
            rawClassSymbol2 = this;
            block4: while (true) {
                ImplementationList implementationList = rawClassSymbol2.implementationList;
                while (implementationList != null) {
                    ClassSymbol classSymbol = implementationList.interfaceSymbol;
                    if (classSymbol instanceof UnresolvedClassSymbol) {
                        throw new UnresolvedSuperClassException();
                    }
                    if ((!rawClassSymbol2.isInnerClass(classSymbol) || !bl2) && (symbol = classSymbol.getClassSymbol().lookupSpecificSymbolInClass(parser, identifier, n, bl, true)) != null) break block4;
                    implementationList = implementationList.next;
                }
                if (rawClassSymbol2.superClass == null) break;
                rawClassSymbol2 = rawClassSymbol2.superClass.getClassSymbol();
            }
        }
        if (bl && symbol == null) {
            rawClassSymbol2 = this;
            block6: while (true) {
                TypeSymbolList typeSymbolList = rawClassSymbol2.cd.innerClassList;
                while (typeSymbolList != null) {
                    typeSymbol = typeSymbolList.typeSymbol;
                    if (!this.equalTo(typeSymbol) && typeSymbol.isClass() && !typeSymbol.isAnonymousInnerClass() && !rawClassSymbol2.isSuperclass(rawClassSymbol = ((ClassSymbol)typeSymbol).getClassSymbol()) && (symbol = rawClassSymbol.lookupSpecificSymbolInClass(parser, identifier, n, bl, bl2)) != null) break block6;
                    typeSymbolList = typeSymbolList.next;
                }
                if (rawClassSymbol2.superClass == null) break;
                rawClassSymbol2 = rawClassSymbol2.superClass.getClassSymbol();
            }
        }
        return symbol;
    }

    RawClassSymbol lookupInnerClassByName(Identifier identifier) {
        RawClassSymbol rawClassSymbol = this;
        while (true) {
            TypeSymbolList typeSymbolList = rawClassSymbol.cd.innerClassList;
            while (typeSymbolList != null) {
                if (typeSymbolList.typeSymbol.identifier == identifier) {
                    return (RawClassSymbol)typeSymbolList.typeSymbol;
                }
                typeSymbolList = typeSymbolList.next;
            }
            if (rawClassSymbol.superClass == null) break;
            rawClassSymbol = rawClassSymbol.superClass.getClassSymbol();
        }
        rawClassSymbol = this;
        while (true) {
            ImplementationList implementationList = rawClassSymbol.implementationList;
            while (implementationList != null) {
                RawClassSymbol rawClassSymbol2 = implementationList.interfaceSymbol.getClassSymbol().lookupInnerClassByName(identifier);
                if (rawClassSymbol2 != null) {
                    return rawClassSymbol2;
                }
                implementationList = implementationList.next;
            }
            if (rawClassSymbol.superClass == null) break;
            rawClassSymbol = rawClassSymbol.superClass.getClassSymbol();
        }
        return null;
    }

    boolean checkForTypeAmbiguity(Parser parser, RawClassSymbol rawClassSymbol) {
        ImportSymbol importSymbol;
        ImportSymbol importSymbol2;
        RawClassSymbol rawClassSymbol2;
        boolean bl = false;
        RawClassSymbol rawClassSymbol3 = this;
        block0: while (true) {
            TypeSymbolList typeSymbolList = rawClassSymbol3.cd.innerClassList;
            while (typeSymbolList != null) {
                if (typeSymbolList.typeSymbol.identifier == rawClassSymbol.identifier) {
                    if (rawClassSymbol.equalTo(typeSymbolList.typeSymbol) || !(rawClassSymbol2 = (RawClassSymbol)typeSymbolList.typeSymbol).isAccessible(this)) break block0;
                    parser.error(Message.errorAmbiguousReference, this.pos, rawClassSymbol.isErroneous() | rawClassSymbol2.isErroneous(), rawClassSymbol.errorName(), rawClassSymbol.errorName() + " " + Message.inString + " " + rawClassSymbol.scope.errorName(), rawClassSymbol2.errorName() + " " + Message.inString + " " + rawClassSymbol2.scope.errorName());
                    bl = true;
                    break block0;
                }
                typeSymbolList = typeSymbolList.next;
            }
            ImplementationList implementationList = rawClassSymbol3.implementationList;
            while (implementationList != null) {
                bl |= implementationList.interfaceSymbol.getClassSymbol().checkForTypeAmbiguity(parser, rawClassSymbol);
                implementationList = implementationList.next;
            }
            if (bl) {
                return true;
            }
            if (rawClassSymbol3.superClass == null) break;
            rawClassSymbol3 = rawClassSymbol3.superClass.getClassSymbol();
        }
        if ((importSymbol2 = parser.currentPackageScope.lookupImportSymbol(rawClassSymbol.identifier, (byte)32)) != null && (importSymbol2.flags & 1) == 0 && (importSymbol = (ImportSymbol)importSymbol2.importSymbolHidesOtherImport()) != null && !(rawClassSymbol2 = (RawClassSymbol)importSymbol.importedSymbol).equalTo(rawClassSymbol)) {
            parser.error(Message.errorAmbiguousReference, this.pos, rawClassSymbol.isErroneous() | rawClassSymbol2.isErroneous(), rawClassSymbol.errorName(), rawClassSymbol.errorName() + " " + Message.inString + " " + parser.currentPackageScope.errorName(), rawClassSymbol2.errorName() + " " + Message.inString + " " + rawClassSymbol2.scope.errorName());
            return true;
        }
        return false;
    }

    void checkSyntheticFieldsInInnerClass(Parser parser, MethodVariableSymbol methodVariableSymbol, int n) {
        TypeSymbolList typeSymbolList = this.cd.innerClassList;
        while (typeSymbolList != null) {
            InnerClassSymbol innerClassSymbol = (InnerClassSymbol)typeSymbolList.typeSymbol;
            if (innerClassSymbol.pos < n && innerClassSymbol.isInnerClass(parser.currentMethodSymbol) && innerClassSymbol.scope.isSubScopeOf(methodVariableSymbol.scope) && parser.lookupSyntheticFieldForLocalInInnerClass(innerClassSymbol, methodVariableSymbol) != null) {
                parser.error(Message.errorNotInitialized, innerClassSymbol.pos, methodVariableSymbol.isErroneous(), methodVariableSymbol.errorName());
            }
            innerClassSymbol.checkSyntheticFieldsInInnerClass(parser, methodVariableSymbol, n);
            typeSymbolList = typeSymbolList.next;
        }
    }

    char[] getClassSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        TypeParameterList typeParameterList = this.cd.getTypeParameterList();
        if (typeParameterList != null) {
            typeParameterList.getSignature(stringBuffer);
        }
        stringBuffer.append(this.superClass.getGenericSignature());
        ImplementationList implementationList = this.implementationList;
        while (implementationList != null) {
            stringBuffer.append(implementationList.interfaceSymbol.getGenericSignature());
            implementationList = implementationList.next;
        }
        return stringBuffer.toString().toCharArray();
    }

    static {
        $assertionsDisabled = !RawClassSymbol.class.desiredAssertionStatus();
    }

    static final class GenericClassData
    extends ClassData {
        TypeParameterList typeParameterList;

        GenericClassData(TypeParameterList typeParameterList) {
            this.typeParameterList = typeParameterList;
        }

        GenericClassData(ClassData classData) {
            this.copy(classData);
        }

        TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }
    }

    static final class AnnotationClassData
    extends ClassData {
        static final byte RETENTION_SOURCE = 0;
        static final byte RETENTION_CLASS = 1;
        static final byte RETENTION_RUNTIME = 2;
        static final byte TARGET_NONE = 0;
        static final byte TARGET_TYPE = 1;
        static final byte TARGET_FIELD = 2;
        static final byte TARGET_METHOD = 4;
        static final byte TARGET_PARAMETER = 8;
        static final byte TARGET_CONSTRUCTOR = 16;
        static final byte TARGET_LOCAL_VARIABLE = 32;
        static final byte TARGET_ANNOTATION_TYPE = 64;
        static final byte TARGET_PACKAGE = -128;
        static final byte TARGET_ANY = -1;
        byte retention = 1;
        byte target = (byte)-1;

        AnnotationClassData() {
        }

        byte getAnnotationRetention() {
            return this.retention;
        }

        byte getAnnotationTarget() {
            return this.target;
        }
    }

    static class ClassData {
        CompiledClassData ccd;
        TypeSymbolList innerClassList;
        MethodSymbol methodList;
        FieldSymbol fieldList;
        short methodCount;
        short fieldCount;
        MethodSymbol[] methodTable;
        char[] internalName;
        char[] signature;
        static final /* synthetic */ boolean $assertionsDisabled;

        ClassData() {
        }

        byte getAnnotationRetention() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        byte getAnnotationTarget() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return -1;
        }

        TypeParameterList getTypeParameterList() {
            return null;
        }

        void copy(ClassData classData) {
            this.ccd = classData.ccd;
            this.innerClassList = classData.innerClassList;
            this.methodList = classData.methodList;
            this.fieldList = classData.fieldList;
            this.methodCount = classData.methodCount;
            this.fieldCount = classData.fieldCount;
            this.methodTable = classData.methodTable;
            this.internalName = classData.internalName;
            this.signature = classData.signature;
        }

        static {
            $assertionsDisabled = !(class$oracle$ojc$compiler$RawClassSymbol == null ? (class$oracle$ojc$compiler$RawClassSymbol = RawClassSymbol.class$("oracle.ojc.compiler.RawClassSymbol")) : class$oracle$ojc$compiler$RawClassSymbol).desiredAssertionStatus();
        }
    }

    static final class CompiledClassData {
        int tpos;
        ConstantPool constantPool;
        SourceFile sourceFile;
        MethodSymbol classInitializer;
        MethodSymbol dynamicInitializer;
        MethodSymbol classLoaderMethod;

        CompiledClassData() {
        }
    }
}

