/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class ReturnStatement
extends Statement {
    Expression returnExpr;
    static final /* synthetic */ boolean $assertionsDisabled;

    ReturnStatement(StatementList statementList, int n, Expression expression) {
        super(statementList, n, (byte)14);
        this.returnExpr = expression;
    }

    /*
     * Enabled aggressive block sorting
     */
    void resolveAndCheck(Parser parser) {
        if (parser.innerTrySync != null) {
            parser.innerTrySync.resolveAndCheck(parser);
        }
        TypeSymbol typeSymbol = parser.currentMethodSymbol.resultType;
        Expression expression = this.returnExpr;
        if (typeSymbol == TypeSymbol.voidSymbol) {
            if (expression != null) {
                parser.error(Message.errorReturnFromVoid, expression.pos, false);
            }
        } else {
            block29: {
                if (expression == null) {
                    parser.error(Message.errorMissingReturnValue, this.pos, false);
                    return;
                }
                if (expression.takeAssignmentContext()) {
                    parser.assignmentContext = typeSymbol;
                }
                expression = expression.resolveAndCheck(parser);
                TypeSymbol typeSymbol2 = expression.getType();
                if (!typeSymbol.isErroneous() && !typeSymbol2.isErroneous()) {
                    if ((typeSymbol.typeClass & 0xFFFFFFC0) != 0) {
                        if ((typeSymbol2.typeClass & 0xFFFFFFC0) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isPrimitiveType() && BoxingExpression.getPrimitiveType(parser, typeSymbol) != null) {
                                expression = expression.promoteType(parser, typeSymbol);
                                break block29;
                            } else {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return;
                            }
                        }
                        ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol;
                        ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol2;
                        if (referenceTypeSymbol.isTypeParameter()) {
                            if (referenceTypeSymbol2 != referenceTypeSymbol && referenceTypeSymbol2 != ReferenceTypeSymbol.nullTypeSymbol) {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return;
                            }
                        } else if (referenceTypeSymbol2.isTypeParameter()) {
                            referenceTypeSymbol2 = ((TypeParameterSymbol)referenceTypeSymbol2).bound;
                        }
                        if (!referenceTypeSymbol2.isAssignmentCompatible(parser, referenceTypeSymbol)) {
                            parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                            return;
                        }
                        typeSymbol.checkUncheckConversion(parser, this.pos, typeSymbol2, false);
                        expression = expression.promoteType(parser, typeSymbol);
                    } else if ((typeSymbol.typeClass & 2) != 0) {
                        if ((typeSymbol2.typeClass & 2) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && BoxingExpression.getPrimitiveType(parser, typeSymbol2) != null) {
                                expression = expression.promoteType(parser, typeSymbol);
                            } else {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return;
                            }
                        }
                    } else {
                        if ((typeSymbol2.typeClass & 0xFFFFFFC2) != 0) {
                            if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && BoxingExpression.getPrimitiveType(parser, typeSymbol2) != null) {
                                expression = expression.promoteType(parser, typeSymbol);
                            } else {
                                parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                                return;
                            }
                        }
                        expression = expression.promoteType(parser, typeSymbol);
                    }
                }
            }
            this.returnExpr = expression;
        }
        ++parser.estimatedLineCount;
        this.parent.updateDefUseSetsAfterReturn(parser);
        if (!parser.suspendDataFlowChecking) {
            if (parser.exitDefSet == null) {
                parser.exitDefSet = (BitSet)parser.defSet.clone();
            } else {
                parser.exitDefSet.or(parser.defSet);
            }
        }
        this.setLastStatement();
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.returnExpr;
        if (expression == null) {
            if (byteCodeGenerator.parser.innerTrySync != null) {
                byteCodeGenerator.parser.innerTrySync.generateByteCode(byteCodeGenerator);
            }
            byteCodeGenerator.generateLineNumber(byteCodeGenerator.methodSymbol.cmd.lastLine);
            byteCodeGenerator.generate_8((byte)-79);
        } else {
            expression.generateByteCode(byteCodeGenerator);
            TypeSymbol typeSymbol = expression.getType();
            if (byteCodeGenerator.parser.innerTrySync != null) {
                short s = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
                short s2 = s;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                if ((typeSymbol.typeClass & 0x28) != 0) {
                    byteCodeGenerator.methodSymbol.localVarCount = (short)(byteCodeGenerator.methodSymbol.localVarCount + 1);
                    byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                }
                byteCodeGenerator.storeLocalVariable(typeSymbol, s2);
                byteCodeGenerator.parser.innerTrySync.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.loadLocalVariable(typeSymbol, s2);
            }
            byteCodeGenerator.generateLineNumber(byteCodeGenerator.methodSymbol.cmd.lastLine);
            switch (typeSymbol.typeClass) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case -128: 
                case 64: {
                    byteCodeGenerator.generate_8((byte)-80);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 2: 
                case 4: {
                    byteCodeGenerator.generate_8((byte)-84);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8((byte)-83);
                    byteCodeGenerator.decOpStackHeight(2);
                    break;
                }
                case 16: {
                    byteCodeGenerator.generate_8((byte)-82);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 32: {
                    byteCodeGenerator.generate_8((byte)-81);
                    byteCodeGenerator.decOpStackHeight(2);
                }
            }
        }
    }

    boolean isLoopExitStatement() {
        return true;
    }

    boolean canReachNextStatement(boolean bl) {
        return false;
    }

    static {
        $assertionsDisabled = !ReturnStatement.class.desiredAssertionStatus();
    }
}

