/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.KeywordTable;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Token;
import oracle.ojc.compiler.Warning;

public final class Scanner {
    static final int SCANNER_EOF = 64;
    static boolean[] _isOctDigit;
    static boolean[] _isHexDigit;
    static boolean[] _isDigit;
    static boolean[] _isWhitespace;
    static int[] _hexDigitValue;
    char[] scanBuffer;
    private int scanPosition;
    private int scanLine;
    private int scanLineStart;
    private int scanBufferLength;
    private int lineInc;
    Parser parser;
    Token token;
    KeywordTable keywordTable;
    int sourceJDKVersion;
    boolean warnedAssert;
    boolean warnedEnum;
    byte prevPrevTokenKind;
    byte prevTokenKind;
    int prevScanPosition;
    private static final byte STATE_DEFAULT = -1;
    private static final byte STATE_OFF = 0;
    private static final byte STATE_ON = 1;
    private static char[] codecoachTag;
    private static char[] disableTag;
    private static char[] enableTag;
    private static char[] nextlineTag;
    private static char[] deprecatedTag;
    private static char[] lineinfoTag;
    private static char[] warningTag;
    private static char[] onTag;
    private static char[] offTag;
    private static char[] defaultTag;
    private static char[] filenameTag;
    private static char[] userCodeTag;
    private static char[] translatedCodeTag;
    private static char[] generatedCodeTag;
    static final /* synthetic */ boolean $assertionsDisabled;

    Scanner(Parser parser, byte[] byArray, int n, String string, int n2) {
        this.parser = parser;
        this.keywordTable = parser.keywordTable;
        this.sourceJDKVersion = parser.options.sourceJDKVersion;
        this.convertByteBuffer2Unicode(byArray, n, string);
        this.token = new Token();
        this.scanLine = 1;
        this.lineInc = 1;
        this.prevTokenKind = (byte)109;
        this.prevPrevTokenKind = (byte)109;
        parser.deprecatedFlag = false;
    }

    private static boolean isASCII(char c) {
        return c <= '\u00ff';
    }

    private static boolean isOctDigit(char c) {
        return _isOctDigit[c];
    }

    static boolean isHexDigit(char c) {
        return _isHexDigit[c];
    }

    private static boolean isDigit(char c) {
        return _isDigit[c];
    }

    private static boolean isWhitespace(char c) {
        return _isWhitespace[c];
    }

    static int hexDigitValue(char c) {
        return _hexDigitValue[c];
    }

    private static int octDigitValue(char c) {
        return c - 48;
    }

    private static int digitValue(char c) {
        return c - 48;
    }

    private void convertByteBuffer2Unicode(byte[] byArray, int n, String string) {
        int n2;
        int n3;
        char[] cArray;
        char[] cArray2;
        if (string != null) {
            Charset charset = Charset.forName(string);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
            CharBuffer charBuffer = CharBuffer.allocate((int)((float)n * charsetDecoder.maxCharsPerByte()));
            charsetDecoder.decode(byteBuffer, charBuffer, true);
            cArray2 = charBuffer.array();
            this.scanBuffer = cArray2;
            cArray = cArray2;
            n3 = charBuffer.position();
            if (n3 + 1 >= cArray.length) {
                this.scanBuffer = new char[n3 + 1];
                System.arraycopy(cArray2, 0, this.scanBuffer, 0, n3);
                cArray2 = this.scanBuffer;
                cArray = this.scanBuffer;
            }
        } else {
            n3 = n;
            this.scanBuffer = new char[n3 + 1];
            cArray = this.scanBuffer;
            cArray2 = this.scanBuffer;
            for (n2 = 0; n2 < n; ++n2) {
                cArray2[n2] = (char)(byArray[n2] & 0xFF);
            }
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        block6: for (n2 = 0; n2 < n3; ++n2) {
            char c = cArray2[n2];
            switch (c) {
                case '\\': {
                    if (n2 + 1 < n3 && cArray2[n2 + 1] == '\\') {
                        ++n2;
                        cArray[n6++] = 92;
                        cArray[n6++] = 92;
                        continue block6;
                    }
                    int n7 = 0;
                    while (true) {
                        if (n2 + n7 + 1 < n3 && cArray2[n2 + n7 + 1] != 'u') {
                            cArray[n6++] = 92;
                            continue block6;
                        }
                        if (n2 + n7 + 2 >= n3 || cArray2[n2 + n7 + 2] != 'u') break;
                        ++n7;
                    }
                    if (n2 + n7 + 5 < n3 && Scanner.isHexDigit(cArray2[n2 + n7 + 5]) && Scanner.isHexDigit(cArray2[n2 + n7 + 4]) && Scanner.isHexDigit(cArray2[n2 + n7 + 3]) && Scanner.isHexDigit(cArray2[n2 + n7 + 2])) {
                        c = (char)(Scanner.hexDigitValue(cArray2[n2 + n7 + 2]) << 12);
                        c = (char)(c | (char)(Scanner.hexDigitValue(cArray2[n2 + n7 + 3]) << 8));
                        c = (char)(c | (char)(Scanner.hexDigitValue(cArray2[n2 + n7 + 4]) << 4));
                        c = (char)(c | (char)Scanner.hexDigitValue(cArray2[n2 + n7 + 5]));
                        n2 += n7 + 5;
                        cArray[n6++] = c;
                        continue block6;
                    }
                    this.parser.error(Message.errorInvalidEscapeChar, n4 << 16 | n6 - n5 & 0xFFFF, false);
                    cArray[n6++] = 92;
                    continue block6;
                }
                case '\ufffd': {
                    this.parser.warning(null, Message.warningMalformedInput, n4 << 16 | n6 - n5 & 0xFFFF);
                    cArray[n6++] = 32;
                    continue block6;
                }
                case '\n': {
                    ++n4;
                    n5 = n6 + 1;
                }
                default: {
                    cArray[n6++] = c;
                }
            }
        }
        if (n6 == 0 || cArray[n6 - 1] != '@') {
            cArray[n6++] = 64;
        }
        this.scanBufferLength = n6;
    }

    public static int positionToLine(int n) {
        return n >>> 16;
    }

    public static int positionToColumn(int n) {
        return n & 0xFFFF;
    }

    public static int lineColumnToPosition(int n, int n2) {
        return n << 16 | n2 & 0xFFFF;
    }

    private int scanPosToLineColumnPos(int n) {
        return this.scanLine << 16 | n - this.scanLineStart & 0xFFFF;
    }

    private int parseCodecoachTag(char[] cArray, int n) {
        int n2;
        byte by;
        if (Identifier.compare(cArray, n, enableTag, 0, enableTag.length)) {
            by = 1;
            n += enableTag.length;
        } else if (Identifier.compare(cArray, n, disableTag, 0, disableTag.length)) {
            by = 0;
            n += disableTag.length;
        } else if (Identifier.compare(cArray, n, defaultTag, 0, defaultTag.length)) {
            by = -1;
            n += defaultTag.length;
        } else {
            this.parser.warning(null, Message.warningInvalidCodeCoachTag, this.scanPosToLineColumnPos(this.scanPosition));
            return n;
        }
        char c = cArray[n++];
        if (!Scanner.isWhitespace(c)) {
            this.parser.warning(null, Message.warningInvalidCodeCoachTag, this.scanPosToLineColumnPos(this.scanPosition));
            return n - 1;
        }
        while (Scanner.isWhitespace(c = cArray[n])) {
            ++n;
        }
        if (Identifier.compare(cArray, n, nextlineTag, 0, nextlineTag.length)) {
            this.parser.sourceFile.addCodecoachPragma(this.parser, this.scanLine, (byte)3, Identifier.getIdentifier("nextline"));
            return n + nextlineTag.length;
        }
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        while ((n2 = Identifier.hashIdentifierMap[c = cArray[n]]) != 0) {
            n5 += n2;
            ++n;
        }
        n4 = n - n3;
        if (n4 == 0) {
            this.parser.warning(null, Message.warningInvalidCodeCoachTag, this.scanPosToLineColumnPos(this.scanPosition));
            return n;
        }
        this.parser.sourceFile.addCodecoachPragma(this.parser, this.scanLine, by, Identifier.getIdentifier(cArray, n3, n4, n5));
        return n;
    }

    private int parseWarningTag(char[] cArray, int n) {
        int n2;
        if (Identifier.compare(cArray, n, onTag, 0, onTag.length)) {
            n2 = 1;
            n += onTag.length;
        } else if (Identifier.compare(cArray, n, offTag, 0, offTag.length)) {
            n2 = 0;
            n += offTag.length;
        } else if (Identifier.compare(cArray, n, defaultTag, 0, defaultTag.length)) {
            n2 = -1;
            n += defaultTag.length;
        } else {
            this.parser.warning(null, Message.warningInvalidWarningTag, this.scanPosToLineColumnPos(this.scanPosition));
            return n;
        }
        int n3 = 0;
        if (cArray[n] == ':') {
            char c;
            ++n;
            while (Scanner.isDigit(c = cArray[n])) {
                n3 = n3 * 10 + (c - 48);
                ++n;
            }
            if (n3 == 0) {
                this.parser.warning(null, Message.warningInvalidWarningTag, this.scanPosToLineColumnPos(this.scanPosition));
                return n;
            }
        }
        switch (n2) {
            default: {
                if (n3 > 0) {
                    Warning.defaultWarning(n3);
                    break;
                }
                Warning.defaultAllWarnings();
                break;
            }
            case 1: {
                if (n3 > 0) {
                    Warning.enableWarning(n3);
                    break;
                }
                Warning.enableAllWarnings();
                break;
            }
            case 0: {
                if (n3 > 0) {
                    Warning.disableWarning(n3);
                    break;
                }
                Warning.disableAllWarnings();
            }
        }
        return n;
    }

    private int parseLineinfoFilename(char[] cArray, int n) {
        String string;
        int n2;
        int n3 = n;
        char c = cArray[n++];
        while (c != '@' && c != '\n' && c != '\r' && c != '*') {
            c = cArray[n++];
        }
        if (n3 == --n) {
            return n3;
        }
        String string2 = new String(cArray, n3, n - n3).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (string2.indexOf(File.separatorChar) == -1 && (string2.length() > 2 && string2.charAt(1) != ':' || string2.length() <= 2) && (n2 = (string = this.parser.sourceFile.getCanonicalPath()).lastIndexOf(File.separatorChar)) != -1) {
            string2 = string.substring(0, n2 + 1) + string2;
        }
        if (!(string2.endsWith(".jsp") || string2.endsWith(".jspx") || string2.endsWith(".jsa"))) {
            c = '\u0000';
            for (int i = string2.length() - 1; i >= 0 && (c = string2.charAt(i)) != File.separatorChar && c != ':' && c != '.'; --i) {
            }
            if (c != '.') {
                string2 = string2 + ".sqlj";
            }
        }
        if (n + 1 < this.scanBufferLength && cArray[n] == '*' && cArray[n + 1] == '/') {
            this.parser.sourceFile.canonicalPath = string2;
        }
        return n;
    }

    private int parseLineinfoTag(char[] cArray, int n) {
        int n2 = this.lineInc;
        int n3 = this.scanLine;
        if (Identifier.compare(cArray, n, filenameTag, 0, filenameTag.length)) {
            n = this.parseLineinfoFilename(cArray, n + filenameTag.length);
        } else if (Identifier.compare(cArray, n, userCodeTag, 0, userCodeTag.length)) {
            n += userCodeTag.length;
            n2 = 1;
        } else if (Identifier.compare(cArray, n, generatedCodeTag, 0, generatedCodeTag.length)) {
            n += generatedCodeTag.length;
            n3 = 1;
            n2 = 0;
        } else if (Identifier.compare(cArray, n, translatedCodeTag, 0, translatedCodeTag.length)) {
            n += translatedCodeTag.length;
            n2 = 0;
        } else {
            int[] nArray = new int[]{0, 0};
            char c = cArray[n++];
            for (int i = 0; i < 2; ++i) {
                if (!Scanner.isDigit(c)) {
                    return n - 1;
                }
                do {
                    nArray[i] = nArray[i] * 10 + (c - 48);
                } while (Scanner.isDigit(c = cArray[n++]));
                if (i != 0) continue;
                if (c != '^') {
                    return n - 1;
                }
                c = cArray[n++];
            }
            n = c == '^' ? this.parseLineinfoFilename(cArray, n) : --n;
            n3 = nArray[0];
        }
        if (n + 1 < this.scanBufferLength && cArray[n] == '*' && cArray[n + 1] == '/') {
            this.lineInc = n2;
            this.scanLine = n3;
        }
        return n;
    }

    private int parseJavaDocComment(char[] cArray, int n) {
        char[][] cArray2;
        if (Identifier.compare(cArray, n, deprecatedTag, 0, deprecatedTag.length)) {
            n += deprecatedTag.length;
            this.parser.deprecatedFlag = true;
        }
        if ((cArray2 = this.parser.options.tagNameList) != null) {
            for (int i = 0; i < cArray2.length; ++i) {
                char[] cArray3 = cArray2[i];
                if (!Identifier.compare(cArray, n, cArray3, 0, cArray3.length)) continue;
                this.parser.warning(null, Message.warningWarningTagFound, this.scanPosToLineColumnPos(n), new String(cArray3));
                break;
            }
        }
        return n;
    }

    private void skipLineComment() {
        char c;
        char[] cArray = this.scanBuffer;
        int n = this.scanPosition;
        if ((c = cArray[n++]) == '@' && n < this.scanBufferLength) {
            if (Identifier.compare(cArray, n, warningTag, 0, warningTag.length)) {
                n = this.parseWarningTag(cArray, n + warningTag.length);
            } else if (Identifier.compare(cArray, n, codecoachTag, 0, codecoachTag.length)) {
                n = this.parseCodecoachTag(cArray, n + codecoachTag.length);
            }
            c = cArray[n++];
        }
        while (true) {
            switch (c) {
                default: {
                    break;
                }
                case '@': {
                    if (n != this.scanBufferLength) break;
                    this.scanPosition = n - 1;
                    return;
                }
                case '\r': {
                    c = cArray[n];
                    if (c == '\n') {
                        ++n;
                    }
                }
                case '\n': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = this.scanPosition = n;
                    return;
                }
            }
            c = cArray[n++];
        }
    }

    private void skipTraditionalComment(int n) {
        char c;
        int n2 = this.scanPosToLineColumnPos(n - 2);
        boolean bl = false;
        char[] cArray = this.scanBuffer;
        if ((c = cArray[n++]) == '@' && n < this.scanBufferLength) {
            if (Identifier.compare(cArray, n, warningTag, 0, warningTag.length)) {
                n = this.parseWarningTag(cArray, n + warningTag.length);
            } else if (Identifier.compare(cArray, n, codecoachTag, 0, codecoachTag.length)) {
                n = this.parseCodecoachTag(cArray, n);
            } else if (Identifier.compare(cArray, n, lineinfoTag, 0, lineinfoTag.length)) {
                n = this.parseLineinfoTag(cArray, n + lineinfoTag.length);
            }
            c = cArray[n++];
        } else if (c == '*') {
            bl = true;
        }
        block6: while (true) {
            switch (c) {
                default: {
                    break;
                }
                case '@': {
                    if (n == this.scanBufferLength) {
                        this.parser.error(Message.errorUnclosedComment, n2, false);
                        this.scanPosition = n - 1;
                        return;
                    }
                    if (!bl) break;
                    n = this.parseJavaDocComment(cArray, n);
                    break;
                }
                case '\r': {
                    c = cArray[n];
                    if (c == '\n') {
                        // empty if block
                    }
                }
                case '\n': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = ++n;
                    break;
                }
                case '*': {
                    if ((c = cArray[n++]) != '/') continue block6;
                    this.scanPosition = n;
                    return;
                }
            }
            c = cArray[n++];
        }
    }

    private boolean isFloatValueZeroDotZero(int n, int n2) {
        char[] cArray = this.scanBuffer;
        while (n <= n2) {
            char c;
            if ((c = cArray[n++]) == '.' || !Scanner.isDigit(c) || Scanner.digitValue(c) == 0) continue;
            return false;
        }
        return true;
    }

    private strictfp byte scanFloatingPointConstant(int n, int n2) {
        char c;
        char[] cArray = this.scanBuffer;
        if ((c = cArray[n2++]) == '.') {
            while (Scanner.isDigit(c = cArray[n2++])) {
            }
        }
        int n3 = n2 - 1;
        if (c == 'e' || c == 'E') {
            if ((c = cArray[n2++]) == '+' || c == '-') {
                c = cArray[n2++];
            }
            while (Scanner.isDigit(c)) {
                c = cArray[n2++];
            }
        }
        if (c == 'f' || c == 'F') {
            String string = new String(cArray, n, n2 - n);
            try {
                this.token.fval = Float.parseFloat(string);
                if (this.token.fval == 0.0f && !this.isFloatValueZeroDotZero(n, n3)) {
                    this.parser.error(Message.errorNumericUnderflow, this.scanPosToLineColumnPos(n), false);
                } else if (this.token.fval == Float.POSITIVE_INFINITY) {
                    this.parser.error(Message.errorNumericOverflow, this.scanPosToLineColumnPos(n), false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.parser.error(Message.errorMalformedFloating, this.scanPosToLineColumnPos(n), false);
            }
            this.scanPosition = n2;
            return 15;
        }
        if (c != 'd' && c != 'D') {
            --n2;
        }
        String string = new String(cArray, n, n2 - n);
        try {
            this.token.dval = Double.parseDouble(string);
            if (this.token.dval == 0.0 && !this.isFloatValueZeroDotZero(n, n3)) {
                this.parser.error(Message.errorNumericUnderflow, this.scanPosToLineColumnPos(n), false);
            } else if (this.token.dval == Double.POSITIVE_INFINITY) {
                this.parser.error(Message.errorNumericOverflow, this.scanPosToLineColumnPos(n), false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parser.error(Message.errorMalformedFloating, this.scanPosToLineColumnPos(n), false);
        }
        this.scanPosition = n2;
        return 16;
    }

    private strictfp byte scanHexFloatingPointConstant(int n, int n2) {
        char c;
        char[] cArray = this.scanBuffer;
        if ((c = cArray[n2++]) == '.') {
            while (Scanner.isHexDigit(c = cArray[n2++])) {
            }
        }
        int n3 = n2 - 1;
        if (c == 'p' || c == 'P') {
            if ((c = cArray[n2++]) == '+' || c == '-') {
                c = cArray[n2++];
            }
            while (Scanner.isDigit(c)) {
                c = cArray[n2++];
            }
        }
        if (c == 'f' || c == 'F') {
            String string = new String(cArray, n, n2 - n);
            try {
                this.token.fval = Float.parseFloat(string);
                if (this.token.fval == 0.0f && !this.isFloatValueZeroDotZero(n, n3)) {
                    this.parser.error(Message.errorNumericUnderflow, this.scanPosToLineColumnPos(n), false);
                } else if (this.token.fval == Float.POSITIVE_INFINITY) {
                    this.parser.error(Message.errorNumericOverflow, this.scanPosToLineColumnPos(n), false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.parser.error(Message.errorMalformedFloating, this.scanPosToLineColumnPos(n), false);
            }
            this.scanPosition = n2;
            return 15;
        }
        if (c != 'd' && c != 'D') {
            --n2;
        }
        String string = new String(cArray, n, n2 - n);
        try {
            this.token.dval = Double.parseDouble(string);
            if (this.token.dval == 0.0 && !this.isFloatValueZeroDotZero(n, n3)) {
                this.parser.error(Message.errorNumericUnderflow, this.scanPosToLineColumnPos(n), false);
            } else if (this.token.dval == Double.POSITIVE_INFINITY) {
                this.parser.error(Message.errorNumericOverflow, this.scanPosToLineColumnPos(n), false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.parser.error(Message.errorMalformedFloating, this.scanPosToLineColumnPos(n), false);
        }
        this.scanPosition = n2;
        return 16;
    }

    private byte scanHexConstant() {
        char c;
        char[] cArray = this.scanBuffer;
        int n = this.scanPosition;
        if (!$assertionsDisabled && cArray[n - 1] != 'x' && cArray[n - 1] != 'X') {
            throw new AssertionError();
        }
        if (!Scanner.isASCII(c = cArray[n++]) || !Scanner.isHexDigit(c)) {
            if (c == '.' && this.parser.options.sourceJDKVersion >= 150) {
                return this.scanHexFloatingPointConstant(this.scanPosition - 2, n - 1);
            }
            this.parser.error(Message.errorMalformedInteger, this.scanPosToLineColumnPos(n - 1), false);
            c = cArray[n++];
            if (!Scanner.isASCII(c) || !Scanner.isHexDigit(c)) {
                this.token.ival = 0;
                this.scanPosition = n - 2;
                return 13;
            }
        }
        long l = Scanner.hexDigitValue(c);
        int n2 = 1;
        while (Scanner.isASCII(c = cArray[n++]) && Scanner.isHexDigit(c)) {
            l = l * 16L + (long)Scanner.hexDigitValue(c);
            if (n2++ != 16) continue;
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
        }
        switch (c) {
            case '.': 
            case 'P': 
            case 'p': {
                if (this.parser.options.sourceJDKVersion >= 150) {
                    return this.scanHexFloatingPointConstant(this.scanPosition - 2, n - 1);
                }
            }
            default: {
                --n;
                if (0L <= l && l <= 0xFFFFFFFFL) {
                    this.scanPosition = n;
                    this.token.ival = (int)l;
                    return 13;
                }
                this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            }
            case 'L': 
            case 'l': 
        }
        this.scanPosition = n;
        this.token.lval = l;
        return 14;
    }

    private byte scanOctConstant() {
        char c;
        char[] cArray = this.scanBuffer;
        int n = this.scanPosition;
        if (!$assertionsDisabled && cArray[n - 1] != '0') {
            throw new AssertionError();
        }
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        while (Scanner.isASCII(c = cArray[n++]) && Scanner.isOctDigit(c)) {
            if (l < 0L && !bl) {
                bl = true;
                this.parser.error(Message.errorIntegerTooLarge, this.scanPosToLineColumnPos(this.scanPosition), false);
            }
            l3 = Scanner.octDigitValue(c);
            l = l * 8L + l3;
            l2 = l * 10L + l3;
        }
        switch (c) {
            default: {
                break;
            }
            case 'F': 
            case 'f': {
                this.scanPosition = n;
                this.token.fval = l2;
                return 15;
            }
            case 'D': 
            case 'd': {
                this.scanPosition = n;
                this.token.dval = l2;
                return 15;
            }
            case '.': 
            case 'E': 
            case 'e': {
                return this.scanFloatingPointConstant(this.scanPosition - 1, n - 1);
            }
        }
        if (c != 'l' && c != 'L') {
            if (0L <= l && l <= 0xFFFFFFFFL) {
                this.scanPosition = n - 1;
                this.token.ival = (int)l;
                return 13;
            }
            if (!bl) {
                this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            }
            this.scanPosition = n - 1;
        } else {
            this.scanPosition = n;
        }
        this.token.lval = l;
        return 14;
    }

    private byte scanNumericConstant() {
        char c;
        char[] cArray = this.scanBuffer;
        int n = this.scanPosition - 1;
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        while (Scanner.isASCII(c = cArray[n++]) && Scanner.isDigit(c)) {
            l2 = l;
            if (((l = l * 10L + (long)Scanner.digitValue(c)) >= l2 || l == Long.MIN_VALUE) && l2 >= 0L) continue;
            while (Scanner.isASCII(c = cArray[n++]) && Scanner.isDigit(c)) {
            }
            switch (c) {
                case '.': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return this.scanFloatingPointConstant(this.scanPosition - 1, n - 1);
                }
            }
            if (bl) break;
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            bl = true;
            break;
        }
        boolean bl2 = false;
        switch (c) {
            default: {
                break;
            }
            case 'L': 
            case 'l': {
                bl2 = true;
                break;
            }
            case 'F': 
            case 'f': {
                this.scanPosition = n;
                this.token.fval = l;
                return 15;
            }
            case 'D': 
            case 'd': {
                this.scanPosition = n;
                this.token.dval = l;
                return 16;
            }
            case '.': 
            case 'E': 
            case 'e': {
                return this.scanFloatingPointConstant(this.scanPosition - 1, n - 1);
            }
        }
        if (0L <= l && l <= 0xFFFFFFFFL && !bl2) {
            this.scanPosition = n - 1;
            this.token.ival = (int)l;
            if ((int)l < 0) {
                if (l == 0x80000000L) {
                    if (this.prevTokenKind != 97 || Token.isIdentifierOrNumeralToken(this.prevPrevTokenKind)) {
                        this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
                    }
                } else {
                    this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
                }
            }
            return 13;
        }
        if (!bl2) {
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
            this.scanPosition = n - 1;
        } else {
            this.scanPosition = n;
        }
        this.token.lval = l;
        if (l == Long.MIN_VALUE && (this.prevTokenKind != 97 || Token.isIdentifierOrNumeralToken(this.prevPrevTokenKind))) {
            this.parser.error(Message.errorIntegerTooLarge, this.token.pos, false);
        }
        return 14;
    }

    private char scanEscapeSequence() {
        char[] cArray = this.scanBuffer;
        int n = this.scanPosition;
        if (!$assertionsDisabled && cArray[n - 1] != '\\') {
            throw new AssertionError();
        }
        char c = cArray[n++];
        switch (c) {
            case '@': {
                if (n == this.scanBufferLength) {
                    this.scanPosition = n - 1;
                }
            }
            default: {
                this.parser.error(Message.errorInvalidEscapeChar, this.scanPosToLineColumnPos(n - 1), false);
                this.scanPosition = n;
                return '\u0000';
            }
            case '\"': 
            case '\'': 
            case '\\': {
                this.scanPosition = n;
                return c;
            }
            case 'b': {
                this.scanPosition = n;
                return '\b';
            }
            case 't': {
                this.scanPosition = n;
                return '\t';
            }
            case 'n': {
                this.scanPosition = n;
                return '\n';
            }
            case 'f': {
                this.scanPosition = n;
                return '\f';
            }
            case 'r': {
                this.scanPosition = n;
                return '\r';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
        }
        int n2 = c - 48;
        char c2 = cArray[n];
        if (!Scanner.isASCII(c2) || !Scanner.isOctDigit(c2)) {
            this.scanPosition = n;
            return (char)n2;
        }
        n2 = n2 * 8 + Scanner.octDigitValue(c2);
        if (!Scanner.isASCII(c2 = cArray[++n]) || !Scanner.isOctDigit(c2) || c > '3') {
            this.scanPosition = n;
            return (char)n2;
        }
        n2 = n2 * 8 + Scanner.octDigitValue(c2);
        this.scanPosition = n + 1;
        return (char)n2;
    }

    private void scanCharacterConstant() {
        char[] cArray = this.scanBuffer;
        int n = this.scanPosition;
        if (!$assertionsDisabled && cArray[n - 1] != '\'') {
            throw new AssertionError();
        }
        char c = cArray[n++];
        switch (c) {
            case '@': {
                if (n == this.scanBufferLength) {
                    this.token.cval = '\u0000';
                    this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                    this.scanPosition = n - 1;
                    return;
                }
            }
            default: {
                this.token.cval = c;
                break;
            }
            case '\n': 
            case '\r': {
                this.scanLine += this.lineInc;
                this.scanLineStart = this.scanPosition = n;
                this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                this.token.cval = '\u0000';
                return;
            }
            case '\'': {
                this.parser.error(Message.errorEmptyCharLiteral, this.token.pos, false);
                this.scanPosition = n;
                return;
            }
            case '\\': {
                c = cArray[n];
                this.scanPosition = n;
                this.token.cval = this.scanEscapeSequence();
                n = this.scanPosition;
            }
        }
        c = cArray[n];
        if (c != '\'') {
            this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
        } else {
            ++n;
        }
        this.scanPosition = n;
    }

    private void scanStringConstant() {
        int n;
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this.scanBuffer;
        int n4 = n = this.scanPosition;
        if (!$assertionsDisabled && cArray[n - 1] != '\"') {
            throw new AssertionError();
        }
        block6: while (true) {
            char c = cArray[n++];
            switch (c) {
                case '@': {
                    if (n == this.scanBufferLength) {
                        this.scanPosition = n - 1;
                        this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                        this.token.sval = new char[0];
                        return;
                    }
                }
                default: {
                    ++n3;
                    ++n2;
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = this.scanPosition = n;
                    this.parser.error(Message.errorUnclosedCharLiteral, this.token.pos, false);
                    this.token.sval = new char[0];
                    return;
                }
                case '\"': {
                    this.scanPosition = n;
                    this.token.sval = new char[n3];
                    if (stringBuffer == null) {
                        System.arraycopy(cArray, n4, this.token.sval, 0, n2);
                    } else {
                        stringBuffer.append(cArray, n4, n2);
                        stringBuffer.getChars(0, n3, this.token.sval, 0);
                    }
                    return;
                }
                case '\\': 
            }
            c = cArray[n];
            this.scanPosition = n;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n2 + 80);
            }
            stringBuffer.append(cArray, n4, n2);
            int n5 = n - 1;
            char c2 = this.scanEscapeSequence();
            if (c == 'u' && (c2 == '\r' || c2 == '\n')) {
                this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(n5), false);
            }
            stringBuffer.append(c2);
            ++n3;
            n2 = 0;
            n4 = n = this.scanPosition;
        }
    }

    private static boolean isUTF32JavaIdentifier(boolean bl, char c, char c2) {
        Class[] classArray = new Class[]{Character.TYPE, Character.TYPE};
        Object[] objectArray = new Object[]{new Character(c), new Character(c2)};
        try {
            Method method = Character.class.getMethod("isSurrogatePair", classArray);
            Boolean bl2 = (Boolean)method.invoke(null, objectArray);
            if (!bl2.booleanValue()) {
                return false;
            }
            method = Character.class.getMethod("toCodePoint", classArray);
            Integer n = (Integer)method.invoke(null, objectArray);
            method = Character.class.getMethod(bl ? "isJavaIdentifierStart" : "isJavaIdentifierPart", Integer.TYPE);
            bl2 = (Boolean)method.invoke(null, n);
            if (!bl2.booleanValue()) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    private void scanIdentifier() {
        int n;
        char[] cArray = this.scanBuffer;
        int n2 = n = this.scanPosition;
        int n3 = 0;
        boolean bl = true;
        while (true) {
            char c;
            int n4;
            if ((n4 = Identifier.hashIdentifierMap[c = cArray[n++]]) == 0) {
                if (c == '@' || this.parser.options.sourceJDKVersion < 150 || !Scanner.isUTF32JavaIdentifier(bl, c, cArray[n])) break;
                n3 += c;
                n3 += cArray[n++];
            } else {
                n3 += n4;
            }
            bl = false;
        }
        this.scanPosition = n - 1;
        this.token.id = Identifier.getIdentifier(cArray, n2, this.scanPosition - n2, n3);
    }

    byte scan() {
        int n;
        char[] cArray = this.scanBuffer;
        int n2 = this.scanPosition;
        this.token.prevEndPos = this.scanPosToLineColumnPos(n2);
        this.prevScanPosition = n2;
        this.prevPrevTokenKind = this.prevTokenKind;
        this.prevTokenKind = this.token.kind;
        block79: while (true) {
            char c = cArray[n2++];
            while (Scanner.isASCII(c) && Scanner.isWhitespace(c)) {
                c = cArray[n2++];
            }
            this.token.pos = this.scanPosToLineColumnPos(n2 - 1);
            switch (c) {
                default: {
                    if (Character.isJavaIdentifierStart(c) || this.parser.options.sourceJDKVersion >= 150 && Scanner.isUTF32JavaIdentifier(true, c, cArray[n2])) {
                        this.scanPosition = n2 - 1;
                        this.scanIdentifier();
                        this.token.kind = 10;
                        byte by = 10;
                        return by;
                    }
                    this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(n2 - 1), false);
                    continue block79;
                }
                case '\u001a': {
                    if (n2 + 1 == this.scanBufferLength) continue block79;
                    this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(n2 - 1), false);
                    continue block79;
                }
                case '\r': {
                    c = cArray[n2];
                    if (c == '\n') {
                        // empty if block
                    }
                }
                case '\n': {
                    this.scanLine += this.lineInc;
                    this.scanLineStart = ++n2;
                    continue block79;
                }
                case '@': {
                    if (n2 == this.scanBufferLength) {
                        n = 9;
                        break block79;
                    }
                    if (this.parser.options.sourceJDKVersion < 150) {
                        this.parser.error(Message.errorIllegalCharacter, this.scanPosToLineColumnPos(n2 - 1), false);
                        continue block79;
                    }
                    n = 107;
                    break block79;
                }
                case ',': {
                    n = 62;
                    break block79;
                }
                case ';': {
                    n = 63;
                    break block79;
                }
                case '(': {
                    n = 101;
                    break block79;
                }
                case ')': {
                    n = 102;
                    break block79;
                }
                case '[': {
                    n = 76;
                    break block79;
                }
                case ']': {
                    n = 77;
                    break block79;
                }
                case '{': {
                    n = 80;
                    break block79;
                }
                case '}': {
                    n = 81;
                    break block79;
                }
                case '?': {
                    n = 78;
                    break block79;
                }
                case ':': {
                    n = 79;
                    break block79;
                }
                case '~': {
                    n = 106;
                    break block79;
                }
                case '!': {
                    c = cArray[n2];
                    if (c == '=') {
                        ++n2;
                        n = 88;
                        break block79;
                    }
                    n = 105;
                    break block79;
                }
                case '=': {
                    c = cArray[n2];
                    if (c == '=') {
                        ++n2;
                        n = 87;
                        break block79;
                    }
                    n = 64;
                    break block79;
                }
                case '*': {
                    c = cArray[n2];
                    if (c == '=') {
                        ++n2;
                        n = 67;
                        break block79;
                    }
                    n = 98;
                    break block79;
                }
                case '^': {
                    c = cArray[n2];
                    if (c == '=') {
                        ++n2;
                        n = 71;
                        break block79;
                    }
                    n = 86;
                    break block79;
                }
                case '%': {
                    c = cArray[n2];
                    if (c == '=') {
                        ++n2;
                        n = 72;
                        break block79;
                    }
                    n = 100;
                    break block79;
                }
                case '+': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 96;
                            break block79;
                        }
                        case '+': {
                            ++n2;
                            n = 103;
                            break block79;
                        }
                        case '=': 
                    }
                    ++n2;
                    n = 65;
                    break block79;
                }
                case '-': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 97;
                            break block79;
                        }
                        case '-': {
                            ++n2;
                            n = 104;
                            break block79;
                        }
                        case '=': 
                    }
                    ++n2;
                    n = 66;
                    break block79;
                }
                case '&': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 84;
                            break block79;
                        }
                        case '&': {
                            ++n2;
                            n = 82;
                            break block79;
                        }
                        case '=': 
                    }
                    ++n2;
                    n = 69;
                    break block79;
                }
                case '|': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 85;
                            break block79;
                        }
                        case '|': {
                            ++n2;
                            n = 83;
                            break block79;
                        }
                        case '=': 
                    }
                    ++n2;
                    n = 70;
                    break block79;
                }
                case '<': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 89;
                            break block79;
                        }
                        case '=': {
                            ++n2;
                            n = 91;
                            break block79;
                        }
                        case '<': 
                    }
                    c = cArray[++n2];
                    if (c == '=') {
                        ++n2;
                        n = 73;
                        break block79;
                    }
                    n = 93;
                    break block79;
                }
                case '>': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 90;
                            break block79;
                        }
                        case '=': {
                            ++n2;
                            n = 92;
                            break block79;
                        }
                        case '>': 
                    }
                    c = cArray[++n2];
                    switch (c) {
                        default: {
                            n = 94;
                            break block79;
                        }
                        case '=': {
                            ++n2;
                            n = 74;
                            break block79;
                        }
                        case '>': 
                    }
                    c = cArray[++n2];
                    if (c == '=') {
                        ++n2;
                        n = 75;
                        break block79;
                    }
                    n = 95;
                    break block79;
                }
                case '/': {
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            n = 99;
                            break block79;
                        }
                        case '=': {
                            ++n2;
                            n = 68;
                            break block79;
                        }
                        case '/': {
                            this.scanPosition = n2 + 1;
                            this.skipLineComment();
                            n2 = this.scanPosition;
                            continue block79;
                        }
                        case '*': 
                    }
                    this.skipTraditionalComment(n2 + 1);
                    n2 = this.scanPosition;
                    continue block79;
                }
                case '\"': {
                    this.scanPosition = n2;
                    this.scanStringConstant();
                    this.token.kind = 12;
                    byte by = 12;
                    return by;
                }
                case '\'': {
                    this.scanPosition = n2;
                    this.scanCharacterConstant();
                    this.token.kind = 11;
                    byte by = 11;
                    return by;
                }
                case '.': {
                    c = cArray[n2];
                    if (Scanner.isASCII(c) && Scanner.isDigit(c)) {
                        byte by;
                        this.token.kind = by = this.scanFloatingPointConstant(--n2, n2);
                        return by;
                    }
                    if (c == '.' && cArray[n2 + 1] == '.') {
                        n2 += 2;
                        n = 108;
                        break block79;
                    }
                    n = 61;
                    break block79;
                }
                case '0': {
                    byte by;
                    c = cArray[n2];
                    switch (c) {
                        default: {
                            if (Scanner.isASCII(c) && Scanner.isOctDigit(c)) {
                                byte by2;
                                this.scanPosition = n2;
                                this.token.kind = by2 = this.scanOctConstant();
                                return by2;
                            }
                            this.token.ival = 0;
                            n = 13;
                            break block79;
                        }
                        case 'D': 
                        case 'd': {
                            this.token.dval = 0.0;
                            n = 16;
                            ++n2;
                            break block79;
                        }
                        case '.': 
                        case 'E': 
                        case 'e': {
                            byte by3;
                            this.token.kind = by3 = this.scanFloatingPointConstant(n2 - 1, n2);
                            return by3;
                        }
                        case 'F': 
                        case 'f': {
                            this.token.fval = 0.0f;
                            n = 15;
                            ++n2;
                            break block79;
                        }
                        case 'L': 
                        case 'l': {
                            this.token.lval = 0L;
                            n = 14;
                            ++n2;
                            break block79;
                        }
                        case 'X': 
                        case 'x': 
                    }
                    this.scanPosition = n2 + 1;
                    this.token.kind = by = this.scanHexConstant();
                    return by;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    byte by;
                    this.scanPosition = n2;
                    this.token.kind = by = this.scanNumericConstant();
                    return by;
                }
                case '$': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int n3 = Identifier.hashIdentifierMap[c];
                    int n4 = n2 - 1;
                    c = cArray[n2++];
                    int n5 = Identifier.hashIdentifierMap[c];
                    if (n5 != 0) {
                        n3 += n5;
                        if ((n5 = Identifier.hashIdentifierMap[c = cArray[n2++]]) != 0) {
                            n3 += n5;
                            if ((n5 = Identifier.hashIdentifierMap[c = cArray[n2++]]) != 0) {
                                n3 += n5;
                                if ((n5 = Identifier.hashIdentifierMap[c = cArray[n2++]]) != 0) {
                                    n3 += n5;
                                    if ((n5 = Identifier.hashIdentifierMap[c = cArray[n2++]]) != 0) {
                                        n3 += n5;
                                        if ((n5 = Identifier.hashIdentifierMap[c = cArray[n2++]]) != 0) {
                                            n3 += n5;
                                            if ((n5 = Identifier.hashIdentifierMap[c = cArray[n2++]]) != 0) {
                                                n3 += n5;
                                                c = cArray[n2++];
                                                while ((n5 = Identifier.hashIdentifierMap[c]) != 0) {
                                                    n3 += n5;
                                                    c = cArray[n2++];
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (c > '\u00ff' && this.parser.options.sourceJDKVersion >= 150 && Scanner.isUTF32JavaIdentifier(false, c, cArray[n2])) {
                        this.scanPosition = n4;
                        this.scanIdentifier();
                        this.token.kind = (byte)10;
                        return 10;
                    }
                    n = 10;
                    int n6 = --n2 - n4;
                    this.token.id = Identifier.getIdentifier(cArray, n4, n6, n3);
                    if (2 > n6 || n6 > 12) break block79;
                    n = this.keywordTable.lookupKeyword(this.token.id);
                    switch (n) {
                        default: {
                            break block79;
                        }
                        case 17: {
                            if (this.sourceJDKVersion >= 140) break block79;
                            n = 10;
                            if (this.warnedAssert) break block79;
                            this.warnedAssert = true;
                            this.parser.warning(null, Message.warningKeywordShouldNotBeUsed, this.scanPosToLineColumnPos(n4), "assert", "1.4");
                            break block79;
                        }
                        case 28: {
                            if (this.sourceJDKVersion >= 150) break block79;
                            n = 10;
                            if (this.warnedEnum) break block79;
                            this.warnedEnum = true;
                            this.parser.warning(null, Message.warningKeywordShouldNotBeUsed, this.scanPosToLineColumnPos(n4), "enum", "1.5");
                            break block79;
                        }
                    }
                }
            }
            break;
        }
        this.scanPosition = n2;
        this.token.kind = (byte)n;
        return (byte)n;
    }

    byte scanAhead() {
        byte by = this.prevPrevTokenKind;
        byte by2 = this.prevTokenKind;
        int n = this.prevScanPosition;
        int n2 = this.token.prevEndPos;
        byte by3 = this.scan();
        this.prevTokenKind = by;
        this.token.kind = by2;
        this.scanPosition = n;
        this.scanLine = Scanner.positionToLine(n2);
        this.scanLineStart = this.scanPosition - Scanner.positionToColumn(n2);
        this.scan();
        return by3;
    }

    Object saveScannerState() {
        SavedScannerState savedScannerState = new SavedScannerState();
        savedScannerState.scanPosition = this.scanPosition;
        savedScannerState.scanLine = this.scanLine;
        savedScannerState.scanLineStart = this.scanLineStart;
        savedScannerState.lineInc = this.lineInc;
        savedScannerState.token = new Token();
        savedScannerState.token.copy(this.token);
        savedScannerState.prevPrevTokenKind = this.prevPrevTokenKind;
        savedScannerState.prevTokenKind = this.prevTokenKind;
        savedScannerState.prevScanPosition = this.prevScanPosition;
        return savedScannerState;
    }

    void restoreScannerState(Object object) {
        SavedScannerState savedScannerState = (SavedScannerState)object;
        this.scanPosition = savedScannerState.scanPosition;
        this.scanLine = savedScannerState.scanLine;
        this.scanLineStart = savedScannerState.scanLineStart;
        this.lineInc = savedScannerState.lineInc;
        this.token.copy(savedScannerState.token);
        this.prevPrevTokenKind = savedScannerState.prevPrevTokenKind;
        this.prevTokenKind = savedScannerState.prevTokenKind;
        this.prevScanPosition = savedScannerState.prevScanPosition;
    }

    static {
        int n;
        $assertionsDisabled = !Scanner.class.desiredAssertionStatus();
        _isOctDigit = new boolean[256];
        _isHexDigit = new boolean[256];
        _isDigit = new boolean[256];
        _isWhitespace = new boolean[256];
        _hexDigitValue = new int[256];
        for (n = 48; n <= 55; ++n) {
            Scanner._isHexDigit[n] = true;
            Scanner._isDigit[n] = true;
            Scanner._isOctDigit[n] = true;
            Scanner._hexDigitValue[n] = n - 48;
        }
        Scanner._isHexDigit[56] = true;
        Scanner._isDigit[56] = true;
        Scanner._hexDigitValue[56] = 8;
        Scanner._isHexDigit[57] = true;
        Scanner._isDigit[57] = true;
        Scanner._hexDigitValue[57] = 9;
        for (n = 97; n <= 102; ++n) {
            Scanner._isHexDigit[n] = true;
            Scanner._hexDigitValue[n] = n - 97 + 10;
        }
        for (n = 65; n <= 70; ++n) {
            Scanner._isHexDigit[n] = true;
            Scanner._hexDigitValue[n] = n - 65 + 10;
        }
        Scanner._isWhitespace[12] = true;
        Scanner._isWhitespace[9] = true;
        Scanner._isWhitespace[32] = true;
        codecoachTag = new char[]{'c', 'o', 'd', 'e', 'c', 'o', 'a', 'c', 'h', ':'};
        disableTag = new char[]{'d', 'i', 's', 'a', 'b', 'l', 'e'};
        enableTag = new char[]{'e', 'n', 'a', 'b', 'l', 'e'};
        nextlineTag = new char[]{'n', 'e', 'x', 't', 'l', 'i', 'n', 'e'};
        deprecatedTag = new char[]{'d', 'e', 'p', 'r', 'e', 'c', 'a', 't', 'e', 'd'};
        lineinfoTag = new char[]{'l', 'i', 'n', 'e', 'i', 'n', 'f', 'o', ':'};
        warningTag = new char[]{'w', 'a', 'r', 'n', 'i', 'n', 'g', ':'};
        onTag = new char[]{'o', 'n'};
        offTag = new char[]{'o', 'f', 'f'};
        defaultTag = new char[]{'d', 'e', 'f', 'a', 'u', 'l', 't'};
        filenameTag = new char[]{'f', 'i', 'l', 'e', 'n', 'a', 'm', 'e', '='};
        userCodeTag = new char[]{'u', 's', 'e', 'r', '-', 'c', 'o', 'd', 'e'};
        translatedCodeTag = new char[]{'t', 'r', 'a', 'n', 's', 'l', 'a', 't', 'e', 'd', '-', 'c', 'o', 'd', 'e'};
        generatedCodeTag = new char[]{'g', 'e', 'n', 'e', 'r', 'a', 't', 'e', 'd', '-', 'c', 'o', 'd', 'e'};
    }

    private static class SavedScannerState {
        int scanPosition;
        int scanLine;
        int scanLineStart;
        int lineInc;
        Token token;
        byte prevPrevTokenKind;
        byte prevTokenKind;
        int prevScanPosition;

        private SavedScannerState() {
        }
    }
}

