/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeSymbol;

final class SuperExpression
extends ThisExpression {
    Expression outerClassExpr;
    static final /* synthetic */ boolean $assertionsDisabled;

    SuperExpression(int n, RawClassSymbol rawClassSymbol, Expression expression) {
        super(n, rawClassSymbol);
        this.outerClassExpr = expression;
    }

    Expression resolveAndCheck(Parser parser) {
        if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0) {
            Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "super");
            return new ErrorExpression(error);
        }
        if (this.outerClassSymbol != null) {
            if (!$assertionsDisabled && this.outerClassExpr != null) {
                throw new AssertionError();
            }
            TypeSymbol typeSymbol = this.outerClassSymbol.resolveType(parser, this.pos, true, true);
            if (typeSymbol.typeKind != 10) {
                Error error = parser.error(Message.errorObjectRequired, this.pos, typeSymbol.isErroneous(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
            this.outerClassSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
            if (!this.classSymbol.isNonStaticInnerClass()) {
                Error error = parser.error(Message.errorIllegalQualifierNotInner, this.pos, false, this.classSymbol.errorName());
                return new ErrorExpression(error);
            }
            if (this.classSymbol.equalTo(this.outerClassSymbol)) {
                this.outerClassSymbol = null;
                this.setType(this.classSymbol.getSuperClassSymbol());
            } else {
                if (!this.classSymbol.isInnerClass((RawClassSymbol)this.outerClassSymbol)) {
                    Error error = parser.error(Message.errorIllegalQualifierNotInner, this.pos, false, this.outerClassSymbol.errorName());
                    return new ErrorExpression(error);
                }
                RawClassSymbol rawClassSymbol = this.classSymbol;
                while (rawClassSymbol.equalTo(this.outerClassSymbol) && rawClassSymbol.isInnerClass()) {
                    if ((rawClassSymbol.access & 8) != 0) {
                        Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "this");
                        return new ErrorExpression(error);
                    }
                    rawClassSymbol = rawClassSymbol.getOuterClass();
                }
                this.setType(((RawClassSymbol)this.outerClassSymbol).getSuperClassSymbol());
            }
        } else {
            if (this.outerClassExpr != null) {
                this.outerClassExpr = this.outerClassExpr.resolveAndCheck(parser);
            }
            if (this.classSymbol.getSuperClassSymbol() == null) {
                Error error = parser.error(Message.errorNoSuperclass, this.pos, false);
                return new ErrorExpression(error);
            }
            this.setType(this.classSymbol.getSuperClassSymbol());
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor() || this.outerClassSymbol == null) {
            byteCodeGenerator.loadLocalVariable(this.getType(), (short)0);
        }
        if (this.outerClassSymbol != null) {
            byteCodeGenerator.generateOuterClassFieldAccessor((RawClassSymbol)this.outerClassSymbol, this.classSymbol, true);
        } else if (this.outerClassExpr != null) {
            this.outerClassExpr.generateByteCode(byteCodeGenerator);
        }
    }

    static {
        $assertionsDisabled = !SuperExpression.class.desiredAssertionStatus();
    }
}

