/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TryStatement;
import oracle.ojc.compiler.TypeSymbol;

final class ThrowStatement
extends Statement {
    Expression throwExpr;

    ThrowStatement(StatementList statementList, int n, Expression expression) {
        super(statementList, n, (byte)16);
        this.throwExpr = expression;
    }

    private boolean checkConstructorThrowsLists(RawClassSymbol rawClassSymbol, ClassSymbol classSymbol) {
        MethodSymbol methodSymbol = (MethodSymbol)rawClassSymbol.classScope.lookupSymbolInScope(Identifier.initializerIdentifier, false);
        while (methodSymbol != null) {
            if (!methodSymbol.checkThrowsList(classSymbol)) {
                return false;
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
        return true;
    }

    void resolveAndCheck(Parser parser) {
        ClassSymbol classSymbol;
        Expression expression = this.throwExpr.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeKind;
        if (by != 10) {
            parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), parser.javaLangThrowableSymbol.errorName());
            classSymbol = parser.javaLangThrowableSymbol;
        } else if (expression instanceof NullConstantExpression) {
            classSymbol = parser.javaLangNullPointerExceptionSymbol;
        } else {
            classSymbol = (ClassSymbol)typeSymbol;
            if (!classSymbol.isErroneous()) {
                if (!classSymbol.equalTo(parser.javaLangThrowableSymbol) && !parser.javaLangThrowableSymbol.isSuperclass(classSymbol)) {
                    parser.error(Message.errorIncompatibleTypes, expression.pos, false, classSymbol.errorName(), parser.javaLangThrowableSymbol.errorName());
                }
                if (!(TryStatement.checkCatches(parser, classSymbol) || !parser.javaLangExceptionSymbol.equalTo(classSymbol) && !parser.javaLangExceptionSymbol.isSuperclass(classSymbol) || parser.javaLangRuntimeExceptionSymbol.equalTo(classSymbol) || parser.javaLangRuntimeExceptionSymbol.isSuperclass(classSymbol))) {
                    if (parser.currentMethodSymbol.identifier == Identifier.dynamicInitializerIdentifier) {
                        if (!this.checkConstructorThrowsLists(parser.currentClassSymbol, classSymbol)) {
                            parser.error(Message.errorUnreportedException, expression.pos, false, classSymbol.errorName());
                        }
                    } else if (!parser.currentMethodSymbol.checkThrowsList(classSymbol)) {
                        parser.error(Message.errorUnreportedException, expression.pos, false, classSymbol.errorName());
                    }
                }
            }
        }
        this.throwExpr = expression;
        this.parent.updateDefUseSetsAfterThrow(parser, classSymbol);
        if (!parser.suspendDataFlowChecking) {
            if (parser.exitDefSet == null) {
                parser.exitDefSet = (BitSet)parser.defSet.clone();
            } else {
                parser.exitDefSet.or(parser.defSet);
            }
        }
        this.setLastStatement();
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.throwExpr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8((byte)-65);
        byteCodeGenerator.decOpStackHeight(1);
    }

    boolean isLoopExitStatement() {
        return true;
    }

    boolean canReachNextStatement(boolean bl) {
        return false;
    }
}

