/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.TryStatement;

final class TrySyncList {
    TrySyncList outerTrySync;
    TryStatement tryStmt;
    SynchronizedStatement syncStmt;
    static final /* synthetic */ boolean $assertionsDisabled;

    TrySyncList(TrySyncList trySyncList, TryStatement tryStatement, SynchronizedStatement synchronizedStatement) {
        this.outerTrySync = trySyncList;
        this.tryStmt = tryStatement;
        this.syncStmt = synchronizedStatement;
    }

    void resolveAndCheck(Parser parser) {
        TrySyncList trySyncList = this;
        while (trySyncList != null) {
            if (trySyncList.syncStmt == null) {
                TryStatement tryStatement = trySyncList.tryStmt;
                if (!$assertionsDisabled && tryStatement == null) {
                    throw new AssertionError();
                }
                if (tryStatement.finallyBody != null && parser.options.targetJDKVersion >= 150) {
                    ++tryStatement.finalliesNeeded;
                }
            }
            trySyncList = trySyncList.outerTrySync;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TrySyncList trySyncList = this;
        while (trySyncList != null) {
            if (trySyncList.syncStmt != null) {
                byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, trySyncList.syncStmt.localVar);
                byteCodeGenerator.generate_8((byte)-61);
                byteCodeGenerator.decOpStackHeight(1);
            } else {
                TryStatement tryStatement = trySyncList.tryStmt;
                if (!$assertionsDisabled && tryStatement == null) {
                    throw new AssertionError();
                }
                if (tryStatement.finallyBody != null) {
                    if (byteCodeGenerator.parser.options.targetJDKVersion < 150) {
                        if (tryStatement.finallyLabel == null) {
                            tryStatement.finallyLabel = new Label();
                        }
                        byteCodeGenerator.generateBranch_jsr(tryStatement.finallyLabel);
                    } else if (!tryStatement.generating) {
                        tryStatement.generating = true;
                        tryStatement.finallyBody.generateByteCode(byteCodeGenerator);
                        tryStatement.generating = false;
                    }
                }
            }
            trySyncList = trySyncList.outerTrySync;
        }
    }

    static {
        $assertionsDisabled = !TrySyncList.class.desiredAssertionStatus();
    }
}

