/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.TypeSymbol;

final class WhileStatement
extends LoopStatement {
    Expression condition;
    static final /* synthetic */ boolean $assertionsDisabled;

    WhileStatement(StatementList statementList, int n, int n2, Expression expression, StatementList statementList2) {
        super(statementList, n, n2, (byte)12, statementList2);
        this.condition = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchLoopList = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(switchLoopList, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.loopRec;
            Expression expression = this.condition;
            expression = expression.resolveAndCheck(parser);
            TypeSymbol typeSymbol = expression.getType();
            byte by = typeSymbol.typeKind;
            if (by != 2) {
                if (parser.options.sourceJDKVersion >= 150 && typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
                    expression = new AutoUnboxingExpression(expression, TypeSymbol.booleanSymbol);
                } else {
                    parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), "boolean");
                }
            }
            BitSet bitSet = (BitSet)parser.defSet.clone();
            StatementList statementList = this.bodyStatements;
            boolean bl = false;
            if (expression.isConstantBooleanExpression()) {
                if (!expression.getConstantBooleanExpressionValue()) {
                    if (this.condition.kind == 2) {
                        parser.error(Message.errorUnreachableStatement, statementList.first == null ? this.pos : statementList.first.pos, false);
                    }
                } else {
                    bl = true;
                }
            }
            this.condition = expression;
            if (statementList != null) {
                if (expression.isLogicalExpression()) {
                    parser.defSet = expression.getLogicalExpressionTrueDefSet();
                }
                statementList.resolveAndCheck(parser);
                if (bl && this.loopRec.breakSymbol == null && this.next != null && this.next.isCodeStatement()) {
                    parser.error(Message.errorUnreachableStatement, this.next.pos, false);
                }
            } else if (bl && this.next != null && this.next.isCodeStatement()) {
                parser.error(Message.errorUnreachableStatement, this.next.pos, false);
            }
            this.loopRec.insertLabels();
            if (this.resultDefSet != null) {
                if (bl) {
                    parser.defSet = this.resultDefSet;
                } else if (expression.isLogicalExpression()) {
                    parser.defSet = this.resultDefSet;
                    parser.defSet.and(expression.getLogicalExpressionFalseDefSet());
                } else {
                    parser.defSet = bitSet;
                }
            } else {
                parser.defSet = expression.isLogicalExpression() ? expression.getLogicalExpressionFalseDefSet() : bitSet;
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
        }
        finally {
            parser.innerSwitchLoop = switchLoopList;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        ++parser.estimatedLineCount;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression() && !expression.getConstantBooleanExpressionValue()) {
            return;
        }
        Label label = new Label();
        Label label2 = new Label();
        if (!expression.isConstantBooleanExpression()) {
            byteCodeGenerator.generateBranch_goto(label);
        }
        byteCodeGenerator.setLabel(label2);
        SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
        StatementList statementList = this.bodyStatements;
        if (statementList != null) {
            statementList.generateByteCode(byteCodeGenerator);
        }
        if (this.pos != 0) {
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
        }
        byteCodeGenerator.parser.innerSwitchLoop = switchLoopList;
        byteCodeGenerator.setLabel(label);
        if (expression.isConstantBooleanExpression()) {
            if (expression.kind != 2) {
                expression.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            byteCodeGenerator.generateBranch_goto(label2);
        } else {
            expression.generateByteCodeBranch(byteCodeGenerator, label2, false);
        }
    }

    boolean canReachNextStatement(boolean bl) {
        boolean bl2 = false;
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression()) {
            bl2 = expression.getConstantBooleanExpressionValue();
        }
        if (!$assertionsDisabled && this.loopRec == null) {
            throw new AssertionError();
        }
        if (this.loopRec.breakSymbol != null) {
            bl2 = false;
        }
        return !bl2;
    }

    static {
        $assertionsDisabled = !WhileStatement.class.desiredAssertionStatus();
    }
}

