/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ojc.interfaces.Storage;

abstract class AbstractStorage
implements Storage {
    File file;
    long lastModified = -1L;
    private HashMap properties = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractStorage(AbstractStorage abstractStorage, String string) {
        if (abstractStorage != null) {
            this.file = new File(abstractStorage.file, string);
        }
    }

    AbstractStorage(File file) {
        this.file = file;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isInJar() {
        return false;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getCanonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long modDate() {
        if (this.lastModified == -1L && this.file != null) {
            this.lastModified = this.file.lastModified();
        }
        return this.lastModified;
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public void open() throws IOException {
    }

    public Storage open(String string) {
        return null;
    }

    public Storage create(String string) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Storage createDir(String string) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public int size() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public byte[] read() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public String[] list() {
        ArrayList arrayList = this.listStorage();
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Storage storage = (Storage)arrayList.get(i);
            stringArray[i] = storage.getName();
        }
        return stringArray;
    }

    public ArrayList listStorage() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void close() {
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    static {
        $assertionsDisabled = !AbstractStorage.class.desiredAssertionStatus();
    }
}

