/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ojc.storage.AbstractStorage;

public final class FileStorage
extends AbstractStorage {
    FileInputStream in;
    FileOutputStream out;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileStorage(AbstractStorage abstractStorage, String string) {
        super(abstractStorage, string);
    }

    public FileStorage(File file) {
        super(file);
    }

    public void open() throws IOException {
        this.in = new FileInputStream(this.file);
    }

    public int size() throws IOException {
        if (!($assertionsDisabled || this.out == null && this.in != null)) {
            throw new AssertionError();
        }
        return this.in.available();
    }

    public byte[] read() throws IOException {
        if (!($assertionsDisabled || this.out == null && this.in != null)) {
            throw new AssertionError();
        }
        int n = this.in.available();
        byte[] byArray = new byte[n];
        int n2 = this.in.read(byArray, 0, n);
        if (n2 != n) {
            throw new IOException("incomplete read");
        }
        return byArray;
    }

    public int read(byte[] byArray) throws IOException {
        if (!($assertionsDisabled || this.out == null && this.in != null)) {
            throw new AssertionError();
        }
        int n = this.in.available();
        int n2 = n < byArray.length ? n : byArray.length;
        int n3 = this.in.read(byArray, 0, n2);
        if (n3 != n2) {
            throw new IOException("incomplete read");
        }
        return n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!$assertionsDisabled && this.in != null) {
            throw new AssertionError();
        }
        if (this.out == null) {
            this.out = new FileOutputStream(this.file);
        }
        this.out.write(byArray, n, n2);
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        $assertionsDisabled = !FileStorage.class.desiredAssertionStatus();
    }
}

