/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.ds.db;

import java.sql.Connection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.insight.InsightableDatabase;
import oracle.jdeveloper.cm.dt.JdbcConnectionFactory;

public abstract class DatabaseFactory
extends oracle.javatools.db.DatabaseFactory {
    protected abstract InsightableDatabase createInsightableDatabaseImpl(Database var1) throws DBException;

    protected Connection createNewConnectionImpl(Database database) throws DBException {
        String string = database.getConnectionName();
        if (ModelUtil.hasLength((String)string)) {
            try {
                Connection connection = DatabaseFactory.getConnection(string);
                if (connection != null) {
                    Connection connection2 = connection;
                    return connection2;
                }
            }
            catch (CMException cMException) {
                Exception exception = cMException.unwrap();
                throw new DBException(exception == null ? cMException : exception);
            }
        }
        return super.createNewConnectionImpl(database);
    }

    public static final Database createDatabase(Connection connection) throws CMException {
        return DatabaseFactory.createDatabase(null, connection);
    }

    public static final Database createDatabase(String string) throws CMException {
        return DatabaseFactory.createDatabase(string, null);
    }

    public static final Database createDatabase(String string, Connection connection) throws CMException {
        try {
            if (connection == null) {
                connection = DatabaseFactory.getConnection(string);
            }
            Database database = DatabaseFactory.findOrCreateDatabase((String)string, (Connection)connection);
            return database;
        }
        catch (DBException dBException) {
            throw new CMException((Exception)((Object)dBException));
        }
    }

    public static final InsightableDatabase createInsightableDatabase(Database database) throws DBException {
        for (DBObjectProviderFactory dBObjectProviderFactory : DatabaseFactory.factories()) {
            InsightableDatabase insightableDatabase;
            if (!(dBObjectProviderFactory instanceof DatabaseFactory) || (insightableDatabase = ((DatabaseFactory)dBObjectProviderFactory).createInsightableDatabaseImpl(database)) == null) continue;
            return insightableDatabase;
        }
        return null;
    }

    public static final Connection getConnection(String string) throws CMException {
        return JdbcConnectionFactory.getInstance().createConnection(string);
    }
}

