/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt;

import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.ProfileIDs;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionCanceledException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionBrowsable;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowserFactory;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.profiler.ProfilerAPI;

public class ConnectionNode
extends Node
implements Refreshable,
Comparable,
ConnectionBrowsable {
    private boolean _isConnected;
    private String _connectionName;
    private ConnectionBrowser connectionBrowser;
    private ConnectionDescriptor _desc;
    private Map _clientProperties;

    void $init$() {
        this._isConnected = false;
        this._connectionName = null;
        this.connectionBrowser = null;
        this._desc = null;
        this._clientProperties = null;
    }

    public ConnectionNode() {
        this(null);
    }

    public ConnectionNode(URL uRL) {
        this.$init$();
        this.setURL(uRL);
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.CLOSEABLE | ElementAttributes.NAVIGABLE);
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public String getLongLabel() {
        return this.getURL().getPath();
    }

    public Icon getIcon() {
        return ConnectionArb.getIcon(2);
    }

    public String getToolTipText() {
        return this.getURL().toString();
    }

    public boolean isDirty() {
        return false;
    }

    public void markDirty(boolean bl) {
    }

    public void refresh() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.ensureOpen();
    }

    public int compareTo(Object object) {
        ConnectionNode connectionNode = (ConnectionNode)object;
        return this._connectionName.compareTo(connectionNode._connectionName);
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        ConnectionBrowser connectionBrowser = this.getConnectionBrowser();
        if (connectionBrowser == null) {
            try {
                this.open();
            }
            catch (IOException iOException) {
                this.reportOpenException(iOException);
            }
            connectionBrowser = this.getConnectionBrowser();
        }
        return connectionBrowser == null ? Collections.EMPTY_LIST.iterator() : connectionBrowser.getChildren();
    }

    protected void openImpl() throws IOException {
        int n = -1;
        if (ProfileIDs.PROFILE_OPENCONNNODE) {
            n = ProfilerAPI.startEvent((int)3405);
        }
        long l = System.currentTimeMillis();
        ConnectionBrowser connectionBrowser = ConnectionBrowserFactory.getInstance().getConnectionBrowser(this);
        if (connectionBrowser != null) {
            try {
                try {
                    NodeOpen nodeOpen = new NodeOpen(this, connectionBrowser);
                    nodeOpen.start(this.isOpenThreaded());
                    if (nodeOpen.isCanceled()) {
                        throw new ExceptionWrapper((Exception)new ConnectionCanceledException(), null);
                    }
                }
                catch (ProgressException progressException) {
                    Exception exception = (Exception)progressException.getCause();
                    IOException iOException = exception instanceof IOException ? (IOException)exception : new ExceptionWrapper(exception, null);
                    throw iOException;
                }
            }
            finally {
                if (!this.isConnected()) {
                    this._cleanupClose();
                }
            }
        }
        if (ProfileIDs.PROFILE_OPENCONNNODE) {
            ProfilerAPI.endEvent((int)n, (String)this._connectionName);
        }
    }

    protected void closeImpl() throws IOException {
        this._cleanupClose();
    }

    protected void saveImpl() throws IOException {
    }

    public boolean isReadOnly() {
        return true;
    }

    public long getTimestamp() {
        return 0L;
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    private void setConnectionName(String string) {
        if (ModelUtil.areDifferent((Object)string, (Object)this._connectionName)) {
            this._connectionName = string;
            URL uRL = CmUtil.newCmURL(string);
            this.setURL(uRL);
        }
    }

    public void setConnectionDescriptor(ConnectionDescriptor connectionDescriptor) {
        if (ModelUtil.areDifferent((Object)connectionDescriptor, (Object)this._desc)) {
            this._desc = connectionDescriptor;
            this.setConnectionName(this._desc.getConnectionName());
        }
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this._desc;
    }

    public ConnectionBrowser getConnectionBrowser() {
        return this.connectionBrowser;
    }

    public void setConnectionBrowser(ConnectionBrowser connectionBrowser) {
        this.connectionBrowser = connectionBrowser;
    }

    public boolean isConnected() {
        return this._isConnected;
    }

    public void setConnected(boolean bl) {
        if (bl != this._isConnected) {
            this._isConnected = bl;
        }
    }

    public Object getClientProperty(Object object) {
        return this._clientProperties != null ? this._clientProperties.get(object) : null;
    }

    public synchronized void putClientProperty(Object object, Object object2) {
        if (this._clientProperties == null) {
            this._clientProperties = new HashMap();
        }
        this._clientProperties.put(object, object2);
    }

    protected boolean isOpenThreaded() {
        return false;
    }

    private void _cleanupClose() {
        ConnectionBrowser connectionBrowser = this.getConnectionBrowser();
        if (connectionBrowser != null) {
            connectionBrowser.closeConnectionBrowser();
        }
        this.setConnectionBrowser(null);
        this.setConnected(false);
    }

    protected void reportOpenException(Exception exception) {
        Exception exception2;
        if (exception instanceof ExceptionWrapper) {
            exception = (Exception)exception.getCause();
        }
        if (!((exception2 = exception) instanceof ConnectionCanceledException)) {
            IdeUtil.runNow((Runnable)new ExceptionDialogRunnable(this.getConnectionName(), exception2));
        }
        UpdateMessage.fireObjectClosed((Subject)this);
    }

    private static class NodeOpen
    extends ProgressRunnable {
        ConnectionNode _node;
        ConnectionBrowser _browser;
        private boolean _canceled;

        NodeOpen(ConnectionNode connectionNode, ConnectionBrowser connectionBrowser) {
            this._node = connectionNode;
            this._browser = connectionBrowser;
            this.setTitle(ConnectionArb.getString(452));
            this.setMessage(ConnectionArb.format(453, this._node.getShortLabel()));
        }

        protected Object doWork() throws CMException {
            this._browser.openConnectionBrowser(this._node);
            return this;
        }

        protected void finish(Object object) {
            if (object != null) {
                this._node.setConnectionBrowser(this._browser);
                this._node.setConnected(true);
            }
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    private static class ExceptionWrapper
    extends IOException {
        private ExceptionWrapper(Exception exception) {
            this.initCause(exception);
        }

        ExceptionWrapper(Exception exception, 1 var2_2) {
            this(exception);
        }

        public final class 1 {
        }
    }

    private static class ExceptionDialogRunnable
    implements Runnable {
        Exception _ex;
        String _connName;

        ExceptionDialogRunnable(String string, Exception exception) {
            while (exception instanceof CMException) {
                CMException cMException = (CMException)((Object)exception);
                if (!cMException.isWrapper()) break;
                exception = cMException.unwrap();
            }
            this._ex = exception;
            this._connName = string;
        }

        public void run() {
            String string = ConnectionArb.getString(454);
            Frame frame = IdeUtil.getMainWindow();
            if (this._ex instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(frame, string, (SQLException)this._ex);
            } else {
                String string2 = this._ex instanceof CMException ? ConnectionArb.format(31, this._connName, this._ex.getLocalizedMessage()) : this._ex.getLocalizedMessage();
                ExceptionDialog.showExceptionDialog((Window)frame, (Exception)this._ex, (String)string, (String)string2);
            }
        }
    }
}

