/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.net.JDevCmURLFileSystemHelper;

public abstract class DatabaseEditorNode
extends Node {
    private Database _db;
    private static Map _protocols = new HashMap();

    public static boolean isDatabaseEditorNodeURL(URL uRL) {
        return uRL != null && DatabaseEditorNode.isDatabaseEditorProtocol(uRL.getProtocol());
    }

    public static boolean isDatabaseEditorProtocol(String string) {
        return _protocols.containsKey(string);
    }

    public static void registerProtocol(String string, Class clazz) {
        if (clazz == null || !DatabaseEditorNode.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The nodeClass must be a subclass of DatabaseEditorNode");
        }
        _protocols.put(string, clazz);
        URLFileSystem.registerHelper((String)string, (URLFileSystemHelper)JDevCmURLFileSystemHelper.getInstance());
    }

    public static String getConnectionName(URL uRL) {
        return uRL != null ? uRL.getPath() : null;
    }

    public static final DatabaseEditorNode findOrCreateNode(URL uRL) {
        String string;
        Class clazz;
        DatabaseEditorNode databaseEditorNode = null;
        if (uRL != null && (clazz = (Class)_protocols.get(string = uRL.getProtocol())) != null) {
            try {
                databaseEditorNode = (DatabaseEditorNode)NodeFactory.findOrCreate((Class)clazz, (URL)uRL);
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return databaseEditorNode;
    }

    protected DatabaseEditorNode() {
    }

    public String getConnectionName() {
        return DatabaseEditorNode.getConnectionName(this.getURL());
    }

    public Database getDatabase() {
        if (this._db == null) {
            this.ensureOpen();
        }
        return this._db;
    }

    private void _cleanupClose() {
        if (this._db != null) {
            try {
                try {
                    this._db.close();
                }
                catch (Exception exception) {}
            }
            finally {
                this._db = null;
            }
        }
    }

    protected void closeImpl() throws IOException {
        this._cleanupClose();
        super.closeImpl();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        if (this._db == null) {
            try {
                String string = this.getConnectionName();
                1 var2_2 = new 1(this, string);
                var2_2.setMessage(ConnectionArb.format(453, string));
                var2_2.setTitle(ConnectionArb.getString(452));
                var2_2.start(true);
            }
            catch (ProgressException progressException) {
                this._cleanupClose();
                Throwable throwable = progressException.getCause();
                if (throwable instanceof CMException && ((CMException)throwable).isWrapper()) {
                    throwable = ((CMException)throwable).unwrap();
                }
                if (throwable instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), ConnectionArb.getString(454), (SQLException)throwable);
                }
                ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)throwable);
            }
        }
    }

    public long getTimestamp() {
        return -1;
    }

    static void wa$_db(DatabaseEditorNode databaseEditorNode, Database database) {
        databaseEditorNode._db = database;
    }

    public final class 1
    extends ProgressRunnable {
        private final /* synthetic */ String v$connName;
        final /* synthetic */ DatabaseEditorNode this$0;

        protected Object doWork() throws CMException {
            return DatabaseFactory.createDatabase(this.v$connName);
        }

        protected void finish(Object object) {
            if (object instanceof Database) {
                DatabaseEditorNode.wa$_db(this.this$0, (Database)object);
            }
        }

        public 1(DatabaseEditorNode databaseEditorNode, String string) {
            this.v$connName = string;
            this.this$0 = databaseEditorNode;
        }
    }
}

