/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.addin;

import java.awt.Component;
import java.sql.Connection;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ViewSelectionEvent;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.DatabaseEditorNode;

public abstract class AbstractConnectionEditor
extends Editor {
    private Database _db;
    private DatabaseEditorNode _node;

    public void open() {
        DatabaseEditorNode databaseEditorNode = this.getDatabaseNode();
        if (databaseEditorNode != null) {
            this._db = databaseEditorNode.getDatabase();
        }
        if (this._db == null) {
            throw new OpenAbortedException();
        }
    }

    public void close() {
        super.close();
        if (this._db != null) {
            this._db = null;
        }
    }

    public abstract Component getGUI();

    public abstract void update(Object var1, UpdateMessage var2);

    public final Database getDatabase() {
        return this._db;
    }

    public final DatabaseEditorNode getDatabaseNode() {
        return this._node;
    }

    public final Connection getConnection() {
        return this._db != null ? this._db.getConnection() : null;
    }

    protected Element[] getSelectionFromUI() {
        Element[] elementArray;
        if (this._node != null) {
            Element[] elementArray2 = new Element[1];
            elementArray = elementArray2;
            elementArray2[0] = this._node;
        } else {
            elementArray = ViewSelectionEvent.EMPTY_SELECTION;
        }
        return elementArray;
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        Context context2 = this.getContext();
        if (context2 != null) {
            Node node = context2.getNode();
            this._node = node instanceof DatabaseEditorNode ? (DatabaseEditorNode)node : null;
            this.updateSelection();
        }
    }

    public Object getEditorAttribute(String string) {
        if ("menu_id".equals(string)) {
            return ConnectionArb.getString(19);
        }
        return super.getEditorAttribute(string);
    }
}

