/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideri.util.Product;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.Filterable;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;

public final class JdbcNodeOverlayClient {
    private static final int OVERLAY_BATCH_SIZE = 10;
    private static final String INFO_TYPE_ID = "jdbcNodeInfoType";
    private static IconOverlayTracker _tracker;

    public static final IconOverlayTracker getTracker() {
        JdbcNodeOverlayClient.initializeOverlays();
        return _tracker;
    }

    private JdbcNodeOverlayClient() {
    }

    static synchronized void initializeOverlays() {
        if (_tracker == null) {
            _tracker = new NodeOverlayTracker(null);
        }
    }

    private static final class NodeOverlayTracker
    extends IconOverlayTracker {
        private static final Object INVALID_OVERLAY_INFORMATION = new IconOverlay(ConnectionArb.getIcon(489), null, null);
        private static final Object FILTER_OVERLAY_INFORMATION = new IconOverlay(ConnectionArb.getIcon(490), null, null);
        private static final Object PUB_SYN_OVERLAY_INFORMATION = new IconOverlay(ConnectionArb.getIcon(491), null, null);

        private NodeOverlayTracker() {
            super(JdbcNodeOverlayClient.INFO_TYPE_ID, IconOverlayCache.getInstance(), 10);
        }

        protected boolean isControlled(Element element) {
            return element instanceof DatabaseNode || element instanceof DatabaseConnectionNode || !Product.isRaptor() && element instanceof CBBaseFolder;
        }

        protected IconOverlay[] getOverlays(Element[] elementArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>(elementArray.length);
            int n = 0;
            while (n < elementArray.length) {
                Element element = elementArray[n];
                Object object = null;
                if (element instanceof DatabaseNode) {
                    Node node;
                    URL uRL;
                    DatabaseNode databaseNode = (DatabaseNode)element;
                    if (!databaseNode.isValid()) {
                        object = INVALID_OVERLAY_INFORMATION;
                    } else if ("SYNONYM".equals(databaseNode.getObjectType()) && "PUBLIC".equals(CmUtil.getSchema(uRL = (node = databaseNode.getNode()).getURL()))) {
                        object = PUB_SYN_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof Filterable && ((Filterable)element).isFiltered()) {
                    object = FILTER_OVERLAY_INFORMATION;
                }
                arrayList.add(object);
                ++n;
            }
            return arrayList.toArray(new IconOverlay[0]);
        }

        NodeOverlayTracker(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

