/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.j2ee;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.ObjectName;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.browser.j2ee.DeployedObjectNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.Jsr77Exception;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagedObjectNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagementAccess;
import oracle.jdeveloper.cm.dt.browser.j2ee.ServerNode;

public class ApplicationNode
extends DeployedObjectNode {
    private boolean _undeployable;

    public void init(ObjectName objectName, ManagementAccess managementAccess) throws Jsr77Exception {
        super.init(objectName, managementAccess);
        try {
            Object object = managementAccess.getAttribute(this.getServerName(), "defaultApplication");
            this._undeployable = ModelUtil.areDifferent((Object)object, (Object)objectName);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            this._undeployable = true;
        }
        catch (JMException jMException) {
            throw new Jsr77Exception(jMException);
        }
        catch (IOException iOException) {
            throw new Jsr77Exception(iOException);
        }
    }

    protected List getChildList() throws Jsr77Exception {
        ArrayList<ManagedObjectNode> arrayList = new ArrayList<ManagedObjectNode>();
        arrayList.addAll(this.createChildList("modules"));
        try {
            ServerNode serverNode;
            ObjectName objectName = this.getServerName();
            String string = this.getObjectName().getKeyProperty("name");
            if (string != null && (serverNode = (ServerNode)this.findNode(objectName)) != null) {
                ObjectName[] objectNameArray = serverNode.getResources();
                int n = 0;
                while (n < objectNameArray.length) {
                    ManagedObjectNode managedObjectNode;
                    if (objectNameArray[n] != null && string.equals(objectNameArray[n].getKeyProperty("J2EEApplication")) && !"JCAResource".equals(objectNameArray[n].getKeyProperty("j2eeType")) && (managedObjectNode = this.findOrCreateNode(objectNameArray[n])) != null) {
                        arrayList.add(managedObjectNode);
                    }
                    ++n;
                }
            }
        }
        catch (Jsr77Exception jsr77Exception) {
            // empty catch block
        }
        return arrayList;
    }

    protected ModuleType getModuleType() {
        return ModuleType.EAR;
    }

    protected boolean canUndeploy() {
        return this._undeployable;
    }
}

