/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.j2ee;

import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.SwingUtilities;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.browser.j2ee.DeploymentActionCallback;
import oracle.jdeveloper.cm.dt.browser.j2ee.DeploymentProgressMonitor;
import oracle.jdeveloper.cm.dt.browser.j2ee.InvokeException;
import oracle.jdeveloper.cm.dt.browser.j2ee.Jsr77Exception;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagedObjectFolder;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagedObjectNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagementAccess;
import oracle.jdeveloper.cm.dt.browser.j2ee.ServerNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.StateManageableObject;

public abstract class DeployedObjectNode
extends ManagedObjectFolder {
    private DeploymentManager _mgr;
    private Target _target;
    private TargetModuleID _id;
    private int _state;

    void $init$() {
        this._state = -1;
    }

    public String getDeploymentDescriptor() throws Jsr77Exception {
        return (String)this.getAttributeValue("deploymentDescriptor");
    }

    public ObjectName getServerName() throws Jsr77Exception {
        return this.getObjectNameValue("server");
    }

    protected StateManageableObject createStateManageableObject() {
        if (this._mgr != null) {
            return new ModuleStateManagement(null);
        }
        return super.createStateManageableObject();
    }

    public void init(ObjectName objectName, ManagementAccess managementAccess) throws Jsr77Exception {
        super.init(objectName, managementAccess);
        this._mgr = managementAccess.getDeploymentManager();
        this._target = this.findTarget();
        if (this._target != null) {
            try {
                this._id = this.findID(this._mgr.getAvailableModules(this.getModuleType(), new Target[]{this._target}));
                this.refreshState();
            }
            catch (TargetException targetException) {
                // empty catch block
            }
        }
    }

    public void refresh() {
        super.refresh();
        try {
            this.refreshState();
        }
        catch (InvokeException invokeException) {
            // empty catch block
        }
    }

    public Target getTarget() {
        return this._target;
    }

    public TargetModuleID getModuleID() {
        return this._id;
    }

    protected abstract ModuleType getModuleType();

    protected boolean canUndeploy() {
        return true;
    }

    private Target findTarget() {
        Target target = null;
        ObjectName objectName = this.getObjectName();
        String string = objectName.getKeyProperty("J2EEServer");
        if (string != null) {
            Target[] targetArray = this._mgr.getTargets();
            int n = 0;
            while (n < targetArray.length) {
                String string2 = targetArray[n].getName();
                if (string.equals(string2)) {
                    target = targetArray[n];
                    break;
                }
                try {
                    ObjectName objectName2 = new ObjectName(string2);
                    if (string.equals(objectName2.getKeyProperty("name"))) {
                        target = targetArray[n];
                        break;
                    }
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return target;
    }

    private TargetModuleID findID(TargetModuleID[] targetModuleIDArray) {
        TargetModuleID targetModuleID = null;
        if (targetModuleIDArray != null) {
            ObjectName objectName = this.getObjectName();
            int n = 0;
            while (n < targetModuleIDArray.length) {
                block5: {
                    String string = targetModuleIDArray[n].getModuleID();
                    try {
                        ObjectName objectName2 = new ObjectName(string);
                        if (objectName2.equals(objectName)) {
                            targetModuleID = targetModuleIDArray[n];
                        }
                        break block5;
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        if (!ModelUtil.areEqual((Object)objectName.getKeyProperty("name"), (Object)string)) break block5;
                        targetModuleID = targetModuleIDArray[n];
                    }
                    break;
                }
                ++n;
            }
        }
        return targetModuleID;
    }

    private void refreshState() throws InvokeException {
        block8: {
            if (this._id != null) {
                this._state = -1;
                try {
                    TargetModuleID[] targetModuleIDArray = this._mgr.getRunningModules(this.getModuleType(), new Target[]{this._target});
                    if (targetModuleIDArray != null) {
                        int n = 0;
                        while (n < targetModuleIDArray.length) {
                            if (this._id.equals(targetModuleIDArray[n])) {
                                this._state = 1;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (this._state != -1 || (targetModuleIDArray = this._mgr.getNonRunningModules(this.getModuleType(), new Target[]{this._target})) == null) break block8;
                    int n = 0;
                    while (n < targetModuleIDArray.length) {
                        if (this._id.equals(targetModuleIDArray[n])) {
                            this._state = 3;
                            break;
                        }
                        ++n;
                    }
                }
                catch (TargetException targetException) {
                    throw new InvokeException((Exception)((Object)targetException));
                }
            }
        }
    }

    public DeployedObjectNode() {
        this.$init$();
    }

    static DeploymentManager ra$_mgr(DeployedObjectNode deployedObjectNode) {
        return deployedObjectNode._mgr;
    }

    static TargetModuleID ra$_id(DeployedObjectNode deployedObjectNode) {
        return deployedObjectNode._id;
    }

    static int ra$_state(DeployedObjectNode deployedObjectNode) {
        return deployedObjectNode._state;
    }

    static void mav$refreshState(DeployedObjectNode deployedObjectNode) {
        deployedObjectNode.refreshState();
    }

    private class ModuleStateManagement
    extends ManagedObjectNode.StateManageableDelegate {
        public int getState() {
            return DeployedObjectNode.ra$_id(DeployedObjectNode.this) != null ? DeployedObjectNode.ra$_state(DeployedObjectNode.this) : super.getState();
        }

        public long getStartTime() {
            return super.getStartTime();
        }

        public void start() throws InvokeException {
            if (DeployedObjectNode.ra$_mgr(DeployedObjectNode.this) != null) {
                DeploymentProgressMonitor.invokeDeploymentAction(CommandType.START, DeployedObjectNode.this, DeployedObjectNode.ra$_mgr(DeployedObjectNode.this), new StartStopCallback(null));
            } else {
                super.start();
            }
        }

        public void startRecursive() throws InvokeException {
            if (DeployedObjectNode.ra$_mgr(DeployedObjectNode.this) != null) {
                DeploymentProgressMonitor.invokeDeploymentAction(CommandType.START, DeployedObjectNode.this, DeployedObjectNode.ra$_mgr(DeployedObjectNode.this), new StartStopCallback(null));
            } else {
                super.startRecursive();
            }
        }

        public void stop() throws InvokeException {
            if (DeployedObjectNode.ra$_mgr(DeployedObjectNode.this) != null) {
                DeploymentProgressMonitor.invokeDeploymentAction(CommandType.STOP, DeployedObjectNode.this, DeployedObjectNode.ra$_mgr(DeployedObjectNode.this), new StartStopCallback(null));
            } else {
                super.stop();
            }
        }

        public boolean canUndeploy() {
            return DeployedObjectNode.this.canUndeploy();
        }

        public void undeploy() throws Jsr77Exception {
            if (DeployedObjectNode.ra$_mgr(DeployedObjectNode.this) != null) {
                DeploymentProgressMonitor.invokeDeploymentAction(CommandType.UNDEPLOY, DeployedObjectNode.this, DeployedObjectNode.ra$_mgr(DeployedObjectNode.this), new UndeployCallback(DeployedObjectNode.this.getServerName(), null));
            } else {
                super.undeploy();
            }
        }

        private ModuleStateManagement() {
            super(DeployedObjectNode.this);
        }

        ModuleStateManagement(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class UndeployCallback
    implements DeploymentActionCallback {
        private ObjectName _server;

        private UndeployCallback(ObjectName objectName) {
            this._server = objectName;
        }

        public void actionSucceeded(CommandType commandType, DeployedObjectNode deployedObjectNode) {
            try {
                if (deployedObjectNode.isOpen()) {
                    ManagedObjectFolder.recursiveClose(deployedObjectNode, true);
                }
                ServerNode serverNode = (ServerNode)deployedObjectNode.findNode(this._server);
                serverNode.remove((Element)deployedObjectNode);
                SwingUtilities.invokeLater(new 1(this, serverNode, deployedObjectNode));
            }
            catch (Jsr77Exception jsr77Exception) {
                // empty catch block
            }
        }

        public void actionFailed(CommandType commandType, DeployedObjectNode deployedObjectNode) {
        }

        UndeployCallback(ObjectName objectName, 1 var2_2) {
            this(objectName);
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ ServerNode v$server;
            private final /* synthetic */ DeployedObjectNode v$node;
            final /* synthetic */ UndeployCallback this$0;

            public void run() {
                UpdateMessage.fireChildRemoved((Subject)this.v$server, (Element)this.v$node);
            }

            public 1(UndeployCallback undeployCallback, ServerNode serverNode, DeployedObjectNode deployedObjectNode) {
                this.v$node = deployedObjectNode;
                this.v$server = serverNode;
                this.this$0 = undeployCallback;
            }
        }
    }

    private static class StartStopCallback
    implements DeploymentActionCallback {
        public void actionSucceeded(CommandType commandType, DeployedObjectNode deployedObjectNode) {
            try {
                DeployedObjectNode.mav$refreshState(deployedObjectNode);
            }
            catch (Jsr77Exception jsr77Exception) {
                // empty catch block
            }
        }

        public void actionFailed(CommandType commandType, DeployedObjectNode deployedObjectNode) {
        }

        private StartStopCallback() {
        }

        StartStopCallback(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

