/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.j2ee;

import java.awt.Component;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.j2ee.DeployedObjectNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.DeploymentActionCallback;

public class DeploymentProgressMonitor
implements ProgressListener {
    private IndeterminateProgressMonitor _monitor;
    private JScrollPane _detailPane;
    private Document _detailDoc;
    private ProgressObject _progress;
    private CommandType _command;
    private DeployedObjectNode _node;
    private DeploymentManager _mgr;
    private DeploymentActionCallback _callback;

    public static void invokeDeploymentAction(CommandType commandType, DeployedObjectNode deployedObjectNode, DeploymentManager deploymentManager) {
        DeploymentProgressMonitor.invokeDeploymentAction(commandType, deployedObjectNode, deploymentManager, null);
    }

    public static void invokeDeploymentAction(CommandType commandType, DeployedObjectNode deployedObjectNode, DeploymentManager deploymentManager, DeploymentActionCallback deploymentActionCallback) {
        DeploymentProgressMonitor deploymentProgressMonitor = new DeploymentProgressMonitor(commandType, deployedObjectNode, deploymentManager, deploymentActionCallback);
        deploymentProgressMonitor.start();
    }

    private DeploymentProgressMonitor(CommandType commandType, DeployedObjectNode deployedObjectNode, DeploymentManager deploymentManager, DeploymentActionCallback deploymentActionCallback) {
        this._command = commandType;
        this._mgr = deploymentManager;
        this._node = deployedObjectNode;
        this._callback = deploymentActionCallback;
        String string = deployedObjectNode.getShortLabel();
        String string2 = null;
        String string3 = null;
        if (CommandType.START.equals((Object)commandType)) {
            string2 = ConnectionArb.getString(615);
            string3 = ConnectionArb.format(616, string);
        } else if (CommandType.STOP.equals((Object)commandType)) {
            string2 = ConnectionArb.getString(617);
            string3 = ConnectionArb.format(618, string);
        } else if (CommandType.UNDEPLOY.equals((Object)commandType)) {
            string2 = ConnectionArb.getString(619);
            string3 = ConnectionArb.format(620, string);
        }
        this._monitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), string2, (Object)string3, null);
        this._detailPane = new JScrollPane();
        this._detailPane.setVerticalScrollBarPolicy(20);
        this._detailPane.setHorizontalScrollBarPolicy(30);
        JTextArea jTextArea = new JTextArea();
        this._detailDoc = jTextArea.getDocument();
        this._detailPane.getViewport().add(jTextArea);
        this._monitor.setDetailContent((Component)this._detailPane);
        this._monitor.setCloseOnFinish(false);
    }

    public void start() {
        if (CommandType.START.equals((Object)this._command)) {
            this._progress = this._mgr.start(new TargetModuleID[]{this._node.getModuleID()});
        } else if (CommandType.STOP.equals((Object)this._command)) {
            this._progress = this._mgr.stop(new TargetModuleID[]{this._node.getModuleID()});
        } else if (CommandType.UNDEPLOY.equals((Object)this._command)) {
            this._progress = this._mgr.undeploy(new TargetModuleID[]{this._node.getModuleID()});
        }
        if (this._progress != null) {
            this._monitor.setCancellable(this._progress.isCancelSupported());
            this._progress.addProgressListener((ProgressListener)this);
            1 var1_1 = new 1();
            Thread thread = new Thread((Runnable)var1_1, "DeployThread");
            thread.start();
        }
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        DeploymentStatus deploymentStatus = progressEvent.getDeploymentStatus();
        String string = deploymentStatus.getMessage();
        this._monitor.getPanel().setNote(string);
        int n = this._detailDoc.getLength();
        try {
            this._detailDoc.insertString(n, string + "\n", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        StateType stateType = deploymentStatus.getState();
        if (StateType.COMPLETED.equals((Object)stateType)) {
            this._monitor.finish();
            if (this._callback != null) {
                this._callback.actionSucceeded(deploymentStatus.getCommand(), this._node);
            }
        } else if (StateType.FAILED.equals((Object)stateType)) {
            this._monitor.finish();
            if (this._callback != null) {
                this._callback.actionFailed(deploymentStatus.getCommand(), this._node);
            }
        }
    }

    static IndeterminateProgressMonitor ra$_monitor(DeploymentProgressMonitor deploymentProgressMonitor) {
        return deploymentProgressMonitor._monitor;
    }

    public final class 1
    implements Runnable {
        public void run() {
            DeploymentProgressMonitor.ra$_monitor(DeploymentProgressMonitor.this).start();
        }
    }
}

